
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Fortran -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; hadr5n15.f --- 
c;; Author          : Friedrich Jegerlehner
c;; Created On      : Sun Dec 14 13:39:30 2014
c;; Last Modified By: Friedrich Jegerlehner
c;; Last Modified On: Fri Dec 30 03:02:54 2016
c;; RCS: $Id$
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; Copyright (C) 2014 Friedrich Jegerlehner
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; 
       subroutine hadr5n(e,st2,der,errder,deg,errdeg)
c Provides real part of 5 flavor hadronic contribution to photon vacuum polarization
c single precision HADR5 ; double precision DHADR5
c ******************************************************************
c *                                                                *
c *      subroutine for the evaluation of the light hadron         *
c *           contributions to Delta_r  and  Delta_g               *
c *                    using fits to the                           *
c *          QED vacuum polarization from e^+ e^- data             *
c *                                                                *
c *    F. Jegerlehner, Institut fr Physik                         *
c *                    Humboldt-Universitt zu Berlin              *
c *                    Newtonstrae 15, D-12489 Berlin, Germany    *
c *    E-mail: fjeger@physik.hu-berlin.de                          *
c *    Phone :   +49-3375 500 277                                  *
c *                                                                *
c *    Reference: F. Jegerlehner, Z. Phys. C32 (1986) 195          *
c *               H. Burkhardt et al., Z. Phys. C42 (1989) 497     *
c *               S. Eidelman, F. Jegerlehner, Z. Phys. C (1995)   *
c *               F. Jegerlehner,                                  *
c *                    Nucl.Phys.Proc.Suppl.131:213-222,2004       *
c *                    Nucl.Phys.Proc.Suppl.162:22-32,2006         *
c *                    Nucl.Phys.Proc.Suppl.181-182:135-140,2008   *
c *                                                                *
c ******************************************************************
c       VERSION: 27/12/2016
c
C  Notation: E energy ( momentum transfer ): E>0 timelike , E<0 spacelike
c      sin2ell=0.23153 ! pm 0.00016 LEPEEWG Phys Rep 427 (2006) 257
C            st2 is sin^2(Theta); st2=0.23153 is the reference value
C  the routine returns the hadronic contribution of 5 flavors (u,d,s,c,b)
C                 to   DER=Delta_r with hadronic error ERRDER
C                and   DEG=Delta_g with hadronic error ERRDEG
C  The effective value of the fine structure constant alphaQED at energy
C  E is alphaQED(E)=alphaQED(0)/(1-Delta_r) ,similarly for the SU(2)
C  coupling alphaSU2(E)=alphaSU2(0)/(1-Delta_g), where Delta_r(g) is the
C  sum of leptonic, hadronic contributions (top to be added).
C
      IMPLICIT NONE
      INTEGER NA,NB,NC,IJ,I,ini
      PARAMETER(NA=979,NB=2174,NC=200)
      real e,st2,der,errder,deg,errdeg,fac
      real dal(2),dg2(2)
      REAL ETA(NA),DAT(NA,2),DGT(NA,2),DGT3(NA,2)
      REAL ESA(NB),DAS(NB,2),DGS(NB,2),DGS3(NB,2)
      REAL EMA(NC),DAM(NC,2),DGM(NC,2),DGM3(NC,2)
      REAL XXX(NC),YGG(NC,2),Y3G(NC,2)
      COMMON /DATM16/EMA,DAM,DGM,DGM3
      COMMON /DATT16/ETA,DAT,DGT,DGT3
      COMMON /DATS16/ESA,DAS,DGS,DGS3
      COMMON /DATH16/XXX,YGG,Y3G
      data ini/0/
C initialize data

      call dalhad_spacelike16

      call dalhad_timelike16

      call dalhad_timelike1h16

c boundaries of data sets
c space-like and unphysical region  -1.0000E+03 - 0.27599999D0 (ETA,DAT)
c time-like R data range 0.28207018D0 - 38.29000000D0          (ESA,DAS)
c time-like1 pQCD range 1.3005E+01 - 2.0000E+04                (EMA,DAM)
c 2 pion threshold at 0.27914....
      fac=0.23153d0/st2
      if (e.eq.0.0) then
        der=0.0
        errder=0.0
        deg=0.0
        errdeg=0.0
        return
c first bridge cracks between regions
      else if ((e.ge.XXX(NC)).and.(e.lt.ETA(1))) then
        DO I=1,2
        dal(i)=YGG(NC,I)
     &    +(DAT(1,I)-YGG(NC,I))/(ETA(1)-XXX(NC))*(E-XXX(NC))
        dg2(i)=Y3G(NC,I)
     &    +(DAT(1,I)-Y3G(NC,I))/(ETA(1)-XXX(NC))*(E-XXX(NC))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.ge.ETA(NA)).and.(e.lt.ESA(1))) then
        DO I=1,2
        dal(i)=DAT(NA,I)
     &    +(DAS(1,I)-DAT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        dg2(i)=DGT(NA,I)
     &    +(DGS(1,I)-DGT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.ETA(NA)).and.(e.ge.ETA(1))) then
        ij=NA
        do while (ETA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAT(IJ,I)
     &    +(DAT(IJ+1,I)-DAT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        dg2(i)=DGT(IJ,I)
     &    +(DGT(IJ+1,I)-DGT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.EMA(NC)).and.(e.ge.EMA(1))) then
        ij=NC
        do while (EMA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAM(IJ,I)
     &    +(DAM(IJ+1,I)-DAM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        dg2(i)=DGM(IJ,I)
     &    +(DGM(IJ+1,I)-DGM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.ESA(NB)).and.(e.ge.ESA(1))) then
        if ((e.gt.3.96).and.(e.lt.4.52).and.(ini.eq.0)) then
c           write (*,*) ' ******************************************'
c           write (*,*) ' * Note: fluctuations in the Psi(4,5,6)   *'
c           write (*,*) ' * region are because we are using the    *'
c           write (*,*) ' * CB and BES data without any smoothing  *'
c           write (*,*) ' *********** FJ@HU Berlin *****************'
           ini=1
        endif
        ij=NB
        do while (ESA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=DAS(IJ,I)
     &    +(DAS(IJ+1,I)-DAS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        dg2(i)=DGS(IJ,I)
     &    +(DGS(IJ+1,I)-DGS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else if ((e.lt.XXX(NC)).and.(e.ge.XXX(1))) then
        ij=NC
        do while (XXX(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,2
        dal(i)=YGG(IJ,I)
     &    +(YGG(IJ+1,I)-YGG(IJ,I))/(XXX(IJ+1)-XXX(IJ))*(E-XXX(IJ))
        dg2(i)=Y3G(IJ,I)
     &    +(Y3G(IJ+1,I)-Y3G(IJ,I))/(XXX(IJ+1)-XXX(IJ))*(E-XXX(IJ))
        ENDDO
        der=dal(1)
        errder=dal(2)
        deg=dg2(1)*fac
        errdeg=dg2(2)*fac
        return
      else 
         if (ini.le.10) then
            write(*,*) ' out of range! e=',e
            ini=ini+1
            if (ini.eq.10) write(*,*) ' Warning: continuing anyway ...'
         endif
      endif
      return
      end

       subroutine dhadr5n(de,dst2,dder,derrder,ddeg,derrdeg)
c **********************************************************************
c *    F. Jegerlehner, University of Silesia, PL-40007 Katowice, Poland *
c **********************************************************************
c Converts hadr5n15 to double precision variables in dhadr5n15
c
       implicit none
       real *8 de,dst2,dder,ddeg,derrder,derrdeg
       real    se,sst2,sder,sdeg,serrder,serrdeg
       se  =sngl(de)
       sst2=sngl(dst2)
       call hadr5n(se,sst2,sder,serrder,sdeg,serrdeg)
       dder   =dble(sder)
       ddeg   =dble(sdeg)
       derrder=dble(serrder)
       derrdeg=dble(serrdeg)
       return
       end

c      ++++ dalhadslow16 ++++  

c updated dec 2016
       subroutine dalhad_timelike16
       IMPLICIT NONE
       INTEGER NB,I,J
       PARAMETER(NB=2174)
       REAL ESA(NB),DAS(NB,2),DGS(NB,2)
       COMMON /DATS16/ESA,DAS,DGS
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 04:28:23 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN:  1, Ismooth: 0, IGS: 0, DSET:     , iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (ESA  (I), I=   1, 100) /
     &   0.28207018D0, 0.28800000D0, 0.29400000D0, 0.30000000D0,
     &   0.30600000D0, 0.30900000D0, 0.31500000D0, 0.32600000D0,
     &   0.33100000D0, 0.33600000D0, 0.34100000D0, 0.34600000D0,
     &   0.35200000D0, 0.35600000D0, 0.36100000D0, 0.36600000D0,
     &   0.37100000D0, 0.37600000D0, 0.38000000D0, 0.38500000D0,
     &   0.38900000D0, 0.39400000D0, 0.39800000D0, 0.40300000D0,
     &   0.40700000D0, 0.41100000D0, 0.41600000D0, 0.41871100D0,
     &   0.42000000D0, 0.42400000D0, 0.42800000D0, 0.43200000D0,
     &   0.43600000D0, 0.44000000D0, 0.44400000D0, 0.44800000D0,
     &   0.45200000D0, 0.45600000D0, 0.46000000D0, 0.46400000D0,
     &   0.46700000D0, 0.47100000D0, 0.47500000D0, 0.47800000D0,
     &   0.48200000D0, 0.48600000D0, 0.48900000D0, 0.49300000D0,
     &   0.49600000D0, 0.50000000D0, 0.52000000D0, 0.54000000D0,
     &   0.56600000D0, 0.59200000D0, 0.60000000D0, 0.60200000D0,
     &   0.60800000D0, 0.61600000D0, 0.62400000D0, 0.63200000D0,
     &   0.64000000D0, 0.64300000D0, 0.64800000D0, 0.65600000D0,
     &   0.66300000D0, 0.67100000D0, 0.67800000D0, 0.68600000D0,
     &   0.68800000D0, 0.69300000D0, 0.69600000D0, 0.70000000D0,
     &   0.70700000D0, 0.71400000D0, 0.72100000D0, 0.72800000D0,
     &   0.73500000D0, 0.74200000D0, 0.74800000D0, 0.75000000D0,
     &   0.75500000D0, 0.75744000D0, 0.76007300D0, 0.76207300D0,
     &   0.76507300D0, 0.76851700D0, 0.77060500D0, 0.77205400D0,
     &   0.77314300D0, 0.77400300D0, 0.77470900D0, 0.77530500D0,
     &   0.77582000D0, 0.77627100D0, 0.77667300D0, 0.77726600D0,
     &   0.77746600D0, 0.77766900D0, 0.77795100D0, 0.77821500D0/
       DATA  (ESA  (I), I= 101, 200) /
     &   0.77846300D0, 0.77869800D0, 0.77892200D0, 0.77913700D0,
     &   0.77934400D0, 0.77954500D0, 0.77974200D0, 0.77993500D0,
     &   0.78012700D0, 0.78031800D0, 0.78051000D0, 0.78070600D0,
     &   0.78090800D0, 0.78112100D0, 0.78135100D0, 0.78161200D0,
     &   0.78193600D0, 0.78268000D0, 0.78341500D0, 0.78373400D0,
     &   0.78399100D0, 0.78421700D0, 0.78442600D0, 0.78462500D0,
     &   0.78481700D0, 0.78500500D0, 0.78519100D0, 0.78537800D0,
     &   0.78556600D0, 0.78575600D0, 0.78595100D0, 0.78615100D0,
     &   0.78635800D0, 0.78657300D0, 0.78679800D0, 0.78703400D0,
     &   0.78728400D0, 0.78755000D0, 0.78773500D0, 0.78793500D0,
     &   0.78814300D0, 0.78847900D0, 0.78884800D0, 0.78925800D0,
     &   0.78971900D0, 0.79024600D0, 0.79085900D0, 0.79158800D0,
     &   0.79248000D0, 0.79361500D0, 0.79513900D0, 0.79736300D0,
     &   0.79800000D0, 0.80000000D0, 0.80200000D0, 0.80400000D0,
     &   0.80600000D0, 0.80800000D0, 0.81200000D0, 0.81400000D0,
     &   0.81600000D0, 0.82000000D0, 0.82200000D0, 0.82400000D0,
     &   0.82600000D0, 0.82800000D0, 0.83000000D0, 0.83100000D0,
     &   0.83700000D0, 0.84300000D0, 0.84900000D0, 0.85400000D0,
     &   0.86000000D0, 0.86600000D0, 0.87200000D0, 0.87700000D0,
     &   0.88300000D0, 0.88900000D0, 0.89400000D0, 0.89700000D0,
     &   0.90250000D0, 0.90500000D0, 0.91100000D0, 0.91600000D0,
     &   0.92200000D0, 0.92700000D0, 0.93300000D0, 0.93800000D0,
     &   0.94300000D0, 0.94900000D0, 0.95200000D0, 0.95400000D0,
     &   0.95800000D0, 0.96000000D0, 0.96200000D0, 0.96400000D0,
     &   0.96600000D0, 0.96800000D0, 0.97000000D0, 0.97400000D0/
       DATA  (ESA  (I), I= 201, 300) /
     &   0.97800000D0, 0.98000000D0, 0.98070000D0, 0.98140000D0,
     &   0.98210000D0, 0.98280000D0, 0.98350000D0, 0.98420000D0,
     &   0.98490000D0, 0.98560000D0, 0.98630000D0, 0.98700000D0,
     &   0.98770000D0, 0.98840000D0, 0.98910000D0, 0.98980000D0,
     &   0.99050000D0, 0.99120000D0, 0.99190000D0, 0.99260000D0,
     &   0.99330000D0, 0.99400000D0, 0.99470000D0, 0.99540000D0,
     &   0.99610000D0, 0.99680000D0, 0.99750000D0, 0.99820000D0,
     &   0.99890000D0, 0.99960000D0, 0.99990000D0, 1.00001000D0,
     &   1.00030000D0, 1.00100000D0, 1.00170000D0, 1.00240000D0,
     &   1.00310000D0, 1.00380000D0, 1.00450000D0, 1.00520000D0,
     &   1.00590000D0, 1.00660000D0, 1.00730000D0, 1.00800000D0,
     &   1.00870000D0, 1.00940000D0, 1.01010000D0, 1.01080000D0,
     &   1.01150000D0, 1.01220000D0, 1.01290000D0, 1.01360000D0,
     &   1.01430000D0, 1.01500000D0, 1.01520000D0, 1.01540000D0,
     &   1.01560000D0, 1.01580000D0, 1.01600000D0, 1.01620000D0,
     &   1.01640000D0, 1.01660000D0, 1.01680000D0, 1.01700000D0,
     &   1.01720000D0, 1.01740000D0, 1.01770000D0, 1.01790000D0,
     &   1.01800000D0, 1.01820000D0, 1.01840000D0, 1.01860000D0,
     &   1.01880000D0, 1.01900000D0, 1.01920000D0, 1.01940000D0,
     &   1.01960000D0, 1.01980000D0, 1.02000000D0, 1.02020000D0,
     &   1.02040000D0, 1.02060000D0, 1.02080000D0, 1.02100000D0,
     &   1.02120000D0, 1.02140000D0, 1.02160000D0, 1.02180000D0,
     &   1.02200000D0, 1.02220000D0, 1.02240000D0, 1.02270000D0,
     &   1.02290000D0, 1.02300000D0, 1.02320000D0, 1.02340000D0,
     &   1.02360000D0, 1.02380000D0, 1.02400000D0, 1.02420000D0/
       DATA  (ESA  (I), I= 301, 400) /
     &   1.02440000D0, 1.02460000D0, 1.02480000D0, 1.02500000D0,
     &   1.02570000D0, 1.02640000D0, 1.02710000D0, 1.02780000D0,
     &   1.02850000D0, 1.02920000D0, 1.02990000D0, 1.03060000D0,
     &   1.03130000D0, 1.03200000D0, 1.03270000D0, 1.03340000D0,
     &   1.03410000D0, 1.03480000D0, 1.03550000D0, 1.03620000D0,
     &   1.03690000D0, 1.03760000D0, 1.03830000D0, 1.03900000D0,
     &   1.03970000D0, 1.03999000D0, 1.04001000D0, 1.04040000D0,
     &   1.04110000D0, 1.04180000D0, 1.04250000D0, 1.04320000D0,
     &   1.04390000D0, 1.04460000D0, 1.04530000D0, 1.04600000D0,
     &   1.04670000D0, 1.04740000D0, 1.04810000D0, 1.04880000D0,
     &   1.04950000D0, 1.05020000D0, 1.05090000D0, 1.05160000D0,
     &   1.05230000D0, 1.05300000D0, 1.05370000D0, 1.05440000D0,
     &   1.05510000D0, 1.05580000D0, 1.05650000D0, 1.05720000D0,
     &   1.05790000D0, 1.05860000D0, 1.05930000D0, 1.06000000D0,
     &   1.06200000D0, 1.06700000D0, 1.07700000D0, 1.08700000D0,
     &   1.09700000D0, 1.10700000D0, 1.11700000D0, 1.12700000D0,
     &   1.13700000D0, 1.13800000D0, 1.15200000D0, 1.16300000D0,
     &   1.16700000D0, 1.17700000D0, 1.18700000D0, 1.18800000D0,
     &   1.19700000D0, 1.20700000D0, 1.21200000D0, 1.21700000D0,
     &   1.22700000D0, 1.23700000D0, 1.24700000D0, 1.25700000D0,
     &   1.26300000D0, 1.26700000D0, 1.27700000D0, 1.28700000D0,
     &   1.28800000D0, 1.29700000D0, 1.30700000D0, 1.31200000D0,
     &   1.31700000D0, 1.32700000D0, 1.33700000D0, 1.34700000D0,
     &   1.35000000D0, 1.35700000D0, 1.36200000D0, 1.36700000D0,
     &   1.37700000D0, 1.38700000D0, 1.38800000D0, 1.39500000D0/
       DATA  (ESA  (I), I= 401, 500) /
     &   1.41000000D0, 1.41900000D0, 1.42700000D0, 1.43500000D0,
     &   1.43800000D0, 1.45200000D0, 1.45700000D0, 1.46000000D0,
     &   1.46400000D0, 1.47200000D0, 1.48100000D0, 1.49000000D0,
     &   1.49100000D0, 1.50000000D0, 1.50100000D0, 1.50600000D0,
     &   1.51000000D0, 1.52300000D0, 1.52500000D0, 1.53800000D0,
     &   1.53900000D0, 1.54000000D0, 1.55000000D0, 1.56000000D0,
     &   1.56200000D0, 1.57400000D0, 1.57500000D0, 1.58000000D0,
     &   1.58100000D0, 1.58700000D0, 1.59000000D0, 1.59900000D0,
     &   1.60000000D0, 1.61000000D0, 1.61900000D0, 1.62400000D0,
     &   1.62500000D0, 1.63800000D0, 1.64000000D0, 1.65000000D0,
     &   1.65700000D0, 1.66000000D0, 1.66200000D0, 1.66300000D0,
     &   1.67300000D0, 1.67500000D0, 1.68100000D0, 1.68700000D0,
     &   1.69000000D0, 1.70000000D0, 1.71000000D0, 1.71200000D0,
     &   1.71300000D0, 1.71900000D0, 1.72200000D0, 1.72500000D0,
     &   1.73800000D0, 1.74000000D0, 1.74600000D0, 1.75000000D0,
     &   1.75600000D0, 1.75700000D0, 1.76000000D0, 1.76200000D0,
     &   1.76400000D0, 1.76900000D0, 1.77500000D0, 1.78100000D0,
     &   1.79000000D0, 1.79900000D0, 1.80000000D0, 1.81200000D0,
     &   1.81900000D0, 1.82500000D0, 1.82600000D0, 1.83400000D0,
     &   1.83500000D0, 1.83800000D0, 1.84500000D0, 1.85700000D0,
     &   1.85900000D0, 1.87400000D0, 1.88100000D0, 1.88600000D0,
     &   1.90000000D0, 1.91900000D0, 1.92500000D0, 1.93000000D0,
     &   1.93800000D0, 1.94000000D0, 1.94500000D0, 1.94600000D0,
     &   1.95000000D0, 1.95500000D0, 1.96000000D0, 1.96200000D0,
     &   1.98100000D0, 1.99050000D0, 2.00500000D0, 2.05000000D0/
       DATA  (ESA  (I), I= 501, 600) /
     &   2.10000000D0, 2.15010000D0, 2.22000000D0, 2.26000000D0,
     &   2.30000000D0, 2.40000000D0, 2.45000000D0, 2.50000000D0,
     &   2.55000000D0, 2.60000000D0, 2.65000000D0, 2.70000000D0,
     &   2.75000000D0, 2.80000000D0, 2.85000000D0, 2.90000000D0,
     &   2.91000000D0, 2.92000000D0, 2.93000000D0, 2.94000000D0,
     &   2.95000000D0, 2.96000000D0, 2.97000000D0, 2.97200000D0,
     &   2.97400000D0, 2.97600000D0, 2.97800000D0, 2.98000000D0,
     &   2.98200000D0, 2.98400000D0, 2.98600000D0, 2.98800000D0,
     &   2.99000000D0, 2.99900000D0, 3.00500000D0, 3.00800000D0,
     &   3.01000000D0, 3.01200000D0, 3.01400000D0, 3.01600000D0,
     &   3.01800000D0, 3.02000000D0, 3.02100000D0, 3.02200000D0,
     &   3.02300000D0, 3.02400000D0, 3.02500000D0, 3.02600000D0,
     &   3.02700000D0, 3.02800000D0, 3.02900000D0, 3.03000000D0,
     &   3.03100000D0, 3.03200000D0, 3.03300000D0, 3.03400000D0,
     &   3.03500000D0, 3.03600000D0, 3.03700000D0, 3.03800000D0,
     &   3.03900000D0, 3.04000000D0, 3.04100000D0, 3.04200000D0,
     &   3.04300000D0, 3.04400000D0, 3.04500000D0, 3.04600000D0,
     &   3.04700000D0, 3.04800000D0, 3.04900000D0, 3.05000000D0,
     &   3.05100000D0, 3.05200000D0, 3.05300000D0, 3.05400000D0,
     &   3.05500000D0, 3.05600000D0, 3.05700000D0, 3.05800000D0,
     &   3.05900000D0, 3.06000000D0, 3.06050000D0, 3.06100000D0,
     &   3.06150000D0, 3.06200000D0, 3.06250000D0, 3.06300000D0,
     &   3.06350000D0, 3.06400000D0, 3.06450000D0, 3.06500000D0,
     &   3.06550000D0, 3.06600000D0, 3.06650000D0, 3.06700000D0,
     &   3.06750000D0, 3.06800000D0, 3.06850000D0, 3.06900000D0/
       DATA  (ESA  (I), I= 601, 700) /
     &   3.06950000D0, 3.07000000D0, 3.07050000D0, 3.07100000D0,
     &   3.07150000D0, 3.07200000D0, 3.07250000D0, 3.07300000D0,
     &   3.07350000D0, 3.07400000D0, 3.07450000D0, 3.07500000D0,
     &   3.07550000D0, 3.07600000D0, 3.07650000D0, 3.07700000D0,
     &   3.07750000D0, 3.07800000D0, 3.07850000D0, 3.07900000D0,
     &   3.07970000D0, 3.08000000D0, 3.08050000D0, 3.08100000D0,
     &   3.08150000D0, 3.08200000D0, 3.08250000D0, 3.08300000D0,
     &   3.08350000D0, 3.08400000D0, 3.08450000D0, 3.08500000D0,
     &   3.08550000D0, 3.08587000D0, 3.08688300D0, 3.08789600D0,
     &   3.08890900D0, 3.08992200D0, 3.09093500D0, 3.09194800D0,
     &   3.09296100D0, 3.09397400D0, 3.09498700D0, 3.09600000D0,
     &   3.09605000D0, 3.09610000D0, 3.09615000D0, 3.09620000D0,
     &   3.09625000D0, 3.09630000D0, 3.09635000D0, 3.09640000D0,
     &   3.09645000D0, 3.09650000D0, 3.09655000D0, 3.09660000D0,
     &   3.09665000D0, 3.09665500D0, 3.09673500D0, 3.09677100D0,
     &   3.09679300D0, 3.09680900D0, 3.09682000D0, 3.09682900D0,
     &   3.09683600D0, 3.09684300D0, 3.09684800D0, 3.09685300D0,
     &   3.09685700D0, 3.09686100D0, 3.09686400D0, 3.09686800D0,
     &   3.09687000D0, 3.09687300D0, 3.09687600D0, 3.09687800D0,
     &   3.09688100D0, 3.09688300D0, 3.09688500D0, 3.09688700D0,
     &   3.09688900D0, 3.09689100D0, 3.09689300D0, 3.09689500D0,
     &   3.09689700D0, 3.09689900D0, 3.09690100D0, 3.09690400D0,
     &   3.09690600D0, 3.09690900D0, 3.09691200D0, 3.09692000D0,
     &   3.09692800D0, 3.09693100D0, 3.09693400D0, 3.09693600D0,
     &   3.09693900D0, 3.09694100D0, 3.09694300D0, 3.09694500D0/
       DATA  (ESA  (I), I= 701, 800) /
     &   3.09694700D0, 3.09694900D0, 3.09695100D0, 3.09695300D0,
     &   3.09695500D0, 3.09695700D0, 3.09695900D0, 3.09696200D0,
     &   3.09696400D0, 3.09696700D0, 3.09697000D0, 3.09697200D0,
     &   3.09697600D0, 3.09697900D0, 3.09698300D0, 3.09698700D0,
     &   3.09699200D0, 3.09699700D0, 3.09700400D0, 3.09701100D0,
     &   3.09702000D0, 3.09703100D0, 3.09704700D0, 3.09706900D0,
     &   3.09710500D0, 3.09715000D0, 3.09720000D0, 3.09725000D0,
     &   3.09730000D0, 3.09735000D0, 3.09740000D0, 3.09745000D0,
     &   3.09750000D0, 3.09755000D0, 3.09760000D0, 3.09765000D0,
     &   3.09770000D0, 3.09775000D0, 3.09780000D0, 3.09785000D0,
     &   3.09790000D0, 3.09795000D0, 3.09800000D0, 3.09898700D0,
     &   3.09997400D0, 3.10096100D0, 3.10194800D0, 3.10293500D0,
     &   3.10392200D0, 3.10490900D0, 3.10589600D0, 3.10688300D0,
     &   3.10787000D0, 3.10800000D0, 3.10900000D0, 3.11000000D0,
     &   3.11100000D0, 3.11200000D0, 3.11300000D0, 3.11400000D0,
     &   3.11500000D0, 3.11600000D0, 3.11700000D0, 3.11800000D0,
     &   3.11900000D0, 3.12000000D0, 3.12100000D0, 3.12200000D0,
     &   3.12300000D0, 3.12400000D0, 3.12500000D0, 3.12600000D0,
     &   3.12700000D0, 3.12800000D0, 3.12900000D0, 3.13000000D0,
     &   3.13100000D0, 3.13200000D0, 3.13300000D0, 3.13400000D0,
     &   3.13500000D0, 3.13600000D0, 3.13700000D0, 3.13800000D0,
     &   3.13900000D0, 3.14000000D0, 3.14100000D0, 3.14200000D0,
     &   3.14300000D0, 3.14400000D0, 3.14500000D0, 3.14600000D0,
     &   3.14700000D0, 3.14800000D0, 3.14900000D0, 3.15000000D0,
     &   3.15100000D0, 3.15200000D0, 3.15300000D0, 3.15400000D0/
       DATA  (ESA  (I), I= 801, 900) /
     &   3.15500000D0, 3.15600000D0, 3.15700000D0, 3.15800000D0,
     &   3.15900000D0, 3.16000000D0, 3.16100000D0, 3.16200000D0,
     &   3.16300000D0, 3.16400000D0, 3.16500000D0, 3.16600000D0,
     &   3.16700000D0, 3.16800000D0, 3.16900000D0, 3.17000000D0,
     &   3.17100000D0, 3.17200000D0, 3.17300000D0, 3.17400000D0,
     &   3.17500000D0, 3.17600000D0, 3.17700000D0, 3.17800000D0,
     &   3.17900000D0, 3.18000000D0, 3.18100000D0, 3.18200000D0,
     &   3.18300000D0, 3.18400000D0, 3.18500000D0, 3.18600000D0,
     &   3.18700000D0, 3.18800000D0, 3.18900000D0, 3.19000000D0,
     &   3.19100000D0, 3.19200000D0, 3.19300000D0, 3.19400000D0,
     &   3.19500000D0, 3.19600000D0, 3.19700000D0, 3.19800000D0,
     &   3.19900000D0, 3.19990000D0, 3.20100000D0, 3.20200000D0,
     &   3.20300000D0, 3.20400000D0, 3.20500000D0, 3.20600000D0,
     &   3.20700000D0, 3.20800000D0, 3.20900000D0, 3.21000000D0,
     &   3.25000000D0, 3.30000000D0, 3.37000000D0, 3.45000000D0,
     &   3.50000000D0, 3.52000000D0, 3.54000000D0, 3.56000000D0,
     &   3.57500000D0, 3.59000000D0, 3.59500000D0, 3.60500000D0,
     &   3.61000000D0, 3.61500000D0, 3.62000000D0, 3.62500000D0,
     &   3.63000000D0, 3.63500000D0, 3.64000000D0, 3.64500000D0,
     &   3.65000000D0, 3.65200000D0, 3.65400000D0, 3.65600000D0,
     &   3.65800000D0, 3.66000000D0, 3.66200000D0, 3.66300000D0,
     &   3.66400000D0, 3.66500000D0, 3.66600000D0, 3.66700000D0,
     &   3.66800000D0, 3.66900000D0, 3.67000000D0, 3.67100000D0,
     &   3.67200000D0, 3.67300000D0, 3.67400000D0, 3.67496000D0,
     &   3.67551000D0, 3.67606000D0, 3.67661000D0, 3.67716000D0/
       DATA  (ESA  (I), I= 901,1000) /
     &   3.67771000D0, 3.67826000D0, 3.67881000D0, 3.67936000D0,
     &   3.67991000D0, 3.68046000D0, 3.68101000D0, 3.68156000D0,
     &   3.68211000D0, 3.68266000D0, 3.68321000D0, 3.68376000D0,
     &   3.68431000D0, 3.68486000D0, 3.68527300D0, 3.68541000D0,
     &   3.68552000D0, 3.68569900D0, 3.68574600D0, 3.68578100D0,
     &   3.68580900D0, 3.68583200D0, 3.68585100D0, 3.68586800D0,
     &   3.68588300D0, 3.68589500D0, 3.68590700D0, 3.68591800D0,
     &   3.68592800D0, 3.68593700D0, 3.68594600D0, 3.68595300D0,
     &   3.68596100D0, 3.68596800D0, 3.68597500D0, 3.68598200D0,
     &   3.68598800D0, 3.68599500D0, 3.68600100D0, 3.68600700D0,
     &   3.68601300D0, 3.68602000D0, 3.68602600D0, 3.68603300D0,
     &   3.68603900D0, 3.68604700D0, 3.68605500D0, 3.68606600D0,
     &   3.68607500D0, 3.68608500D0, 3.68609000D0, 3.68609500D0,
     &   3.68610000D0, 3.68611400D0, 3.68612500D0, 3.68613300D0,
     &   3.68614100D0, 3.68614700D0, 3.68615400D0, 3.68616000D0,
     &   3.68616700D0, 3.68617300D0, 3.68617900D0, 3.68618500D0,
     &   3.68619200D0, 3.68619800D0, 3.68620500D0, 3.68621200D0,
     &   3.68621900D0, 3.68622700D0, 3.68623400D0, 3.68624300D0,
     &   3.68625200D0, 3.68626200D0, 3.68627300D0, 3.68628500D0,
     &   3.68629700D0, 3.68631200D0, 3.68632900D0, 3.68634800D0,
     &   3.68637100D0, 3.68639900D0, 3.68643400D0, 3.68648100D0,
     &   3.68654800D0, 3.68651000D0, 3.68660000D0, 3.68667000D0,
     &   3.68672000D0, 3.68685000D0, 3.68690700D0, 3.68706000D0,
     &   3.68761000D0, 3.68816000D0, 3.68871000D0, 3.68926000D0,
     &   3.68981000D0, 3.69036000D0, 3.69091000D0, 3.69146000D0/
       DATA  (ESA  (I), I=1001,1100) /
     &   3.69201000D0, 3.69256000D0, 3.69311000D0, 3.69366000D0,
     &   3.69421000D0, 3.69476000D0, 3.69531000D0, 3.69586000D0,
     &   3.69641000D0, 3.69696000D0, 3.69796000D0, 3.69950000D0,
     &   3.70050000D0, 3.70250000D0, 3.70450000D0, 3.70700000D0,
     &   3.71200000D0, 3.72128100D0, 3.73082800D0, 3.73660200D0,
     &   3.74060200D0, 3.74360300D0, 3.74597300D0, 3.74791700D0,
     &   3.74955600D0, 3.75096800D0, 3.75220600D0, 3.75330900D0,
     &   3.75430100D0, 3.75520500D0, 3.75603600D0, 3.75680500D0,
     &   3.75752300D0, 3.75819800D0, 3.75883700D0, 3.75944400D0,
     &   3.76002600D0, 3.76058600D0, 3.76112800D0, 3.76165500D0,
     &   3.76217200D0, 3.76268100D0, 3.76318700D0, 3.76369200D0,
     &   3.76420200D0, 3.76472200D0, 3.76526100D0, 3.76582800D0,
     &   3.76644200D0, 3.76713800D0, 3.76800500D0, 3.77000000D0,
     &   3.77199500D0, 3.77286200D0, 3.77355800D0, 3.77417200D0,
     &   3.77474000D0, 3.77527800D0, 3.77579800D0, 3.77630800D0,
     &   3.77681400D0, 3.77731900D0, 3.77782800D0, 3.77834500D0,
     &   3.77887200D0, 3.77941400D0, 3.77997400D0, 3.78055600D0,
     &   3.78116300D0, 3.78180200D0, 3.78247700D0, 3.78319500D0,
     &   3.78396400D0, 3.78479500D0, 3.78569900D0, 3.78669100D0,
     &   3.78779400D0, 3.78903200D0, 3.79044400D0, 3.79208300D0,
     &   3.79402700D0, 3.79639700D0, 3.79939800D0, 3.80339800D0,
     &   3.80917200D0, 3.81871900D0, 3.82200000D0, 3.83200000D0,
     &   3.85000000D0, 3.85200000D0, 3.86700000D0, 3.87300000D0,
     &   3.87800000D0, 3.88400000D0, 3.89000000D0, 3.89600000D0,
     &   3.90000000D0, 3.90200000D0, 3.90800000D0, 3.91400000D0/
       DATA  (ESA  (I), I=1101,1200) /
     &   3.92000000D0, 3.92600000D0, 3.93200000D0, 3.93800000D0,
     &   3.94400000D0, 3.95000000D0, 3.95600000D0, 3.96200000D0,
     &   3.96800000D0, 3.97400000D0, 3.98000000D0, 3.98600000D0,
     &   3.99200000D0, 3.99800000D0, 4.00000000D0, 4.00400000D0,
     &   4.01000000D0, 4.01600000D0, 4.02000000D0, 4.02200000D0,
     &   4.02800000D0, 4.03000000D0, 4.03400000D0, 4.04000000D0,
     &   4.04600000D0, 4.05000000D0, 4.05200000D0, 4.05800000D0,
     &   4.06400000D0, 4.07000000D0, 4.07600000D0, 4.08200000D0,
     &   4.08800000D0, 4.09000000D0, 4.09400000D0, 4.10000000D0,
     &   4.10500000D0, 4.10900000D0, 4.11000000D0, 4.11300000D0,
     &   4.11800000D0, 4.12100000D0, 4.12500000D0, 4.12900000D0,
     &   4.13000000D0, 4.13300000D0, 4.13600000D0, 4.14100000D0,
     &   4.14700000D0, 4.15000000D0, 4.15300000D0, 4.15900000D0,
     &   4.16500000D0, 4.17100000D0, 4.17700000D0, 4.18000000D0,
     &   4.18200000D0, 4.18500000D0, 4.19000000D0, 4.19500000D0,
     &   4.19900000D0, 4.20100000D0, 4.20800000D0, 4.21200000D0,
     &   4.21400000D0, 4.22000000D0, 4.22600000D0, 4.23200000D0,
     &   4.23800000D0, 4.24000000D0, 4.24400000D0, 4.25000000D0,
     &   4.25600000D0, 4.26200000D0, 4.26800000D0, 4.27400000D0,
     &   4.28000000D0, 4.29200000D0, 4.30000000D0, 4.30400000D0,
     &   4.31000000D0, 4.31600000D0, 4.32800000D0, 4.33000000D0,
     &   4.34000000D0, 4.35000000D0, 4.35200000D0, 4.36400000D0,
     &   4.37600000D0, 4.38000000D0, 4.38200000D0, 4.38800000D0,
     &   4.39000000D0, 4.39400000D0, 4.40000000D0, 4.40600000D0,
     &   4.41000000D0, 4.41200000D0, 4.41800000D0, 4.42400000D0/
       DATA  (ESA  (I), I=1201,1300) /
     &   4.43000000D0, 4.43600000D0, 4.44000000D0, 4.44200000D0,
     &   4.44800000D0, 4.45000000D0, 4.46000000D0, 4.47200000D0,
     &   4.48400000D0, 4.49600000D0, 4.50450000D0, 4.54000000D0,
     &   4.55000000D0, 4.57000000D0, 4.60000000D0, 4.62000000D0,
     &   4.65000000D0, 4.66000000D0, 4.70000000D0, 4.71000000D0,
     &   4.80000000D0, 4.90000000D0, 4.98000000D0, 5.06500000D0,
     &   5.15000000D0, 5.22500000D0, 5.25000000D0, 5.30000000D0,
     &   5.40000000D0, 5.45000000D0, 5.50000000D0, 5.60000000D0,
     &   5.70000000D0, 5.75000000D0, 5.80000000D0, 5.85000000D0,
     &   5.90000000D0, 5.95000000D0, 6.00000000D0, 6.05000000D0,
     &   6.10000000D0, 6.15000000D0, 6.20000000D0, 6.25000000D0,
     &   6.30000000D0, 6.35000000D0, 6.40000000D0, 6.45000000D0,
     &   6.50000000D0, 6.55000000D0, 6.60000000D0, 6.65000000D0,
     &   6.70000000D0, 6.75000000D0, 6.80000000D0, 6.85000000D0,
     &   6.90000000D0, 6.95000000D0, 7.00000000D0, 7.05000000D0,
     &   7.10000000D0, 7.15000000D0, 7.20000000D0, 7.25000000D0,
     &   7.30000000D0, 7.35000000D0, 7.40000000D0, 7.44000000D0,
     &   7.50000000D0, 7.60000000D0, 7.70000000D0, 7.80000000D0,
     &   7.90000000D0, 8.00000000D0, 8.10000000D0, 8.20000000D0,
     &   8.30000000D0, 8.40000000D0, 8.50000000D0, 8.60000000D0,
     &   8.70000000D0, 8.80000000D0, 8.90000000D0, 8.91000000D0,
     &   9.00000000D0, 9.10000000D0, 9.20000000D0, 9.28000000D0,
     &   9.30000000D0, 9.35000000D0, 9.39000000D0, 9.40000000D0,
     &   9.41000000D0, 9.41500000D0, 9.42000000D0, 9.42400000D0,
     &   9.42800000D0, 9.43000000D0, 9.43200000D0, 9.43400000D0/
       DATA  (ESA  (I), I=1301,1400) /
     &   9.43600000D0, 9.43800000D0, 9.44000000D0, 9.44100000D0,
     &   9.44200000D0, 9.44300000D0, 9.44400000D0, 9.44500000D0,
     &   9.44600000D0, 9.44700000D0, 9.44800000D0, 9.44900000D0,
     &   9.44937000D0, 9.44959000D0, 9.44981000D0, 9.45003000D0,
     &   9.45025000D0, 9.45047000D0, 9.45069000D0, 9.45091000D0,
     &   9.45113000D0, 9.45135000D0, 9.45157000D0, 9.45179000D0,
     &   9.45201000D0, 9.45223000D0, 9.45245000D0, 9.45267000D0,
     &   9.45289000D0, 9.45311000D0, 9.45333000D0, 9.45355000D0,
     &   9.45377000D0, 9.45399000D0, 9.45421000D0, 9.45443000D0,
     &   9.45465000D0, 9.45487000D0, 9.45509000D0, 9.45531000D0,
     &   9.45553000D0, 9.45575000D0, 9.45597000D0, 9.45619000D0,
     &   9.45641000D0, 9.45663000D0, 9.45685000D0, 9.45707000D0,
     &   9.45729000D0, 9.45751000D0, 9.45773000D0, 9.45795000D0,
     &   9.45817000D0, 9.45839000D0, 9.45861000D0, 9.45883000D0,
     &   9.45905000D0, 9.45927000D0, 9.45949000D0, 9.45971000D0,
     &   9.45993000D0, 9.46000000D0, 9.46014595D0, 9.46019268D0,
     &   9.46021366D0, 9.46022606D0, 9.46023464D0, 9.46024132D0,
     &   9.46024704D0, 9.46025085D0, 9.46025467D0, 9.46025848D0,
     &   9.46026039D0, 9.46026325D0, 9.46026516D0, 9.46026802D0,
     &   9.46026897D0, 9.46027088D0, 9.46027279D0, 9.46027470D0,
     &   9.46027565D0, 9.46027660D0, 9.46027851D0, 9.46027946D0,
     &   9.46028042D0, 9.46028233D0, 9.46028328D0, 9.46028423D0,
     &   9.46028519D0, 9.46028709D0, 9.46028805D0, 9.46028900D0,
     &   9.46029091D0, 9.46029186D0, 9.46029377D0, 9.46029568D0,
     &   9.46030045D0, 9.46030426D0, 9.46030617D0, 9.46030807D0/
       DATA  (ESA  (I), I=1401,1500) /
     &   9.46030998D0, 9.46031094D0, 9.46031189D0, 9.46031284D0,
     &   9.46031475D0, 9.46031570D0, 9.46031666D0, 9.46031761D0,
     &   9.46031952D0, 9.46032047D0, 9.46032143D0, 9.46032333D0,
     &   9.46032429D0, 9.46032619D0, 9.46032715D0, 9.46032906D0,
     &   9.46033096D0, 9.46033287D0, 9.46033478D0, 9.46033669D0,
     &   9.46033955D0, 9.46034145D0, 9.46034527D0, 9.46034908D0,
     &   9.46035290D0, 9.46035862D0, 9.46036530D0, 9.46037388D0,
     &   9.46038628D0, 9.46040726D0, 9.46045494D0, 9.46059000D0,
     &   9.46081000D0, 9.46103000D0, 9.46125000D0, 9.46147000D0,
     &   9.46169000D0, 9.46191000D0, 9.46213000D0, 9.46235000D0,
     &   9.46257000D0, 9.46279000D0, 9.46301000D0, 9.46323000D0,
     &   9.46345000D0, 9.46367000D0, 9.46389000D0, 9.46411000D0,
     &   9.46433000D0, 9.46455000D0, 9.46477000D0, 9.46499000D0,
     &   9.46521000D0, 9.46543000D0, 9.46565000D0, 9.46587000D0,
     &   9.46609000D0, 9.46631000D0, 9.46653000D0, 9.46675000D0,
     &   9.46697000D0, 9.46719000D0, 9.46741000D0, 9.46763000D0,
     &   9.46785000D0, 9.46807000D0, 9.46829000D0, 9.46851000D0,
     &   9.46873000D0, 9.46895000D0, 9.46917000D0, 9.46939000D0,
     &   9.46961000D0, 9.46983000D0, 9.47005000D0, 9.47027000D0,
     &   9.47049000D0, 9.47071000D0, 9.47093000D0, 9.47115000D0,
     &   9.47137000D0, 9.47337000D0, 9.47500000D0, 9.47700000D0,
     &   9.48000000D0, 9.48400000D0, 9.49000000D0, 9.49500000D0,
     &   9.50500000D0, 9.51000000D0, 9.51500000D0, 9.52000000D0,
     &   9.52500000D0, 9.53000000D0, 9.54000000D0, 9.55000000D0,
     &   9.60000000D0, 9.70000000D0, 9.80000000D0, 9.90000000D0/
       DATA  (ESA  (I), I=1501,1600) /
     &   9.95000000D0, 9.97500000D0, 9.99000000D0,10.00000000D0,
     &  10.01000000D0,10.01100000D0,10.01200000D0,10.01226000D0,
     &  10.01281000D0,10.01336000D0,10.01391000D0,10.01446000D0,
     &  10.01501000D0,10.01556000D0,10.01611000D0,10.01666000D0,
     &  10.01721000D0,10.01776000D0,10.01831000D0,10.01886000D0,
     &  10.01941000D0,10.01996000D0,10.02051000D0,10.02106000D0,
     &  10.02161000D0,10.02216000D0,10.02250000D0,10.02253750D0,
     &  10.02257500D0,10.02261250D0,10.02265000D0,10.02268750D0,
     &  10.02272500D0,10.02276250D0,10.02280000D0,10.02283750D0,
     &  10.02287500D0,10.02291250D0,10.02295000D0,10.02298750D0,
     &  10.02302500D0,10.02306250D0,10.02310000D0,10.02313750D0,
     &  10.02317500D0,10.02321250D0,10.02322000D0,10.02322500D0,
     &  10.02323000D0,10.02323400D0,10.02323700D0,10.02324000D0,
     &  10.02324200D0,10.02324400D0,10.02324600D0,10.02324800D0,
     &  10.02324930D0,10.02324950D0,10.02324960D0,10.02324980D0,
     &  10.02324988D0,10.02324994D0,10.02325000D0,10.02325060D0,
     &  10.02325150D0,10.02325250D0,10.02325340D0,10.02325440D0,
     &  10.02325540D0,10.02325630D0,10.02325680D0,10.02325730D0,
     &  10.02325780D0,10.02325850D0,10.02325900D0,10.02325950D0,
     &  10.02325980D0,10.02325990D0,10.02325995D0,10.02326000D0,
     &  10.02326005D0,10.02326010D0,10.02326050D0,10.02326100D0,
     &  10.02326150D0,10.02326390D0,10.02326490D0,10.02326680D0,
     &  10.02326770D0,10.02326870D0,10.02326970D0,10.02327060D0,
     &  10.02327160D0,10.02327250D0,10.02327350D0,10.02327440D0,
     &  10.02327540D0,10.02327630D0,10.02327730D0,10.02327820D0/
       DATA  (ESA  (I), I=1601,1700) /
     &  10.02328010D0,10.02328110D0,10.02328210D0,10.02328300D0,
     &  10.02328490D0,10.02328590D0,10.02328750D0,10.02329000D0,
     &  10.02330000D0,10.02331000D0,10.02332000D0,10.02333000D0,
     &  10.02334000D0,10.02335000D0,10.02336250D0,10.02339000D0,
     &  10.02340000D0,10.02341000D0,10.02342000D0,10.02343750D0,
     &  10.02347500D0,10.02351250D0,10.02355000D0,10.02358750D0,
     &  10.02362500D0,10.02366250D0,10.02370000D0,10.02373750D0,
     &  10.02377500D0,10.02381250D0,10.02385000D0,10.02388750D0,
     &  10.02392500D0,10.02396250D0,10.02400000D0,10.02436000D0,
     &  10.02491000D0,10.02546000D0,10.02656000D0,10.02766000D0,
     &  10.02876000D0,10.02986000D0,10.03096000D0,10.03206000D0,
     &  10.03316000D0,10.03426000D0,10.03500000D0,10.03600000D0,
     &  10.03700000D0,10.03800000D0,10.03900000D0,10.04000000D0,
     &  10.04500000D0,10.05000000D0,10.05500000D0,10.06000000D0,
     &  10.06500000D0,10.07000000D0,10.07500000D0,10.08000000D0,
     &  10.20000000D0,10.25000000D0,10.26000000D0,10.27000000D0,
     &  10.28000000D0,10.29000000D0,10.29500000D0,10.30000000D0,
     &  10.31000000D0,10.32000000D0,10.33000000D0,10.34000000D0,
     &  10.34420000D0,10.34493333D0,10.34566667D0,10.34640000D0,
     &  10.34713333D0,10.34786667D0,10.34860000D0,10.34933333D0,
     &  10.35006667D0,10.35080000D0,10.35153333D0,10.35226667D0,
     &  10.35300000D0,10.35309167D0,10.35318333D0,10.35327500D0,
     &  10.35336667D0,10.35345833D0,10.35355000D0,10.35364167D0,
     &  10.35373333D0,10.35382500D0,10.35391667D0,10.35400833D0,
     &  10.35410000D0,10.35419167D0,10.35428333D0,10.35437500D0/
       DATA  (ESA  (I), I=1701,1800) /
     &  10.35440000D0,10.35446667D0,10.35455833D0,10.35465000D0,
     &  10.35474167D0,10.35483334D0,10.35492500D0,10.35501667D0,
     &  10.35510834D0,10.35512330D0,10.35514660D0,10.35515710D0,
     &  10.35516340D0,10.35516780D0,10.35517110D0,10.35517370D0,
     &  10.35517580D0,10.35517760D0,10.35517920D0,10.35518060D0,
     &  10.35518180D0,10.35518290D0,10.35518390D0,10.35518480D0,
     &  10.35518570D0,10.35518650D0,10.35518720D0,10.35518790D0,
     &  10.35518860D0,10.35518930D0,10.35518990D0,10.35519050D0,
     &  10.35519110D0,10.35519170D0,10.35519230D0,10.35519280D0,
     &  10.35519340D0,10.35519400D0,10.35519460D0,10.35519530D0,
     &  10.35519600D0,10.35519680D0,10.35519770D0,10.35519970D0,
     &  10.35520000D0,10.35520100D0,10.35520230D0,10.35520320D0,
     &  10.35520400D0,10.35520470D0,10.35520540D0,10.35520600D0,
     &  10.35520660D0,10.35520720D0,10.35520770D0,10.35520830D0,
     &  10.35520890D0,10.35520950D0,10.35521010D0,10.35521070D0,
     &  10.35521140D0,10.35521210D0,10.35521280D0,10.35521350D0,
     &  10.35521430D0,10.35521520D0,10.35521610D0,10.35521710D0,
     &  10.35521820D0,10.35521940D0,10.35522080D0,10.35522240D0,
     &  10.35522420D0,10.35522630D0,10.35522890D0,10.35523220D0,
     &  10.35523660D0,10.35524290D0,10.35525340D0,10.35527670D0,
     &  10.35529000D0,10.35529300D0,10.35529700D0,10.35531000D0,
     &  10.35532500D0,10.35538334D0,10.35547500D0,10.35556667D0,
     &  10.35565834D0,10.35575000D0,10.35584167D0,10.35593334D0,
     &  10.35602500D0,10.35611667D0,10.35620834D0,10.35630000D0,
     &  10.35639167D0,10.35648334D0,10.35657500D0,10.35666667D0/
       DATA  (ESA  (I), I=1801,1900) /
     &  10.35740000D0,10.35813333D0,10.35886667D0,10.35960000D0,
     &  10.36033333D0,10.36106667D0,10.36180000D0,10.36326667D0,
     &  10.36473333D0,10.36546667D0,10.36620000D0,10.37000000D0,
     &  10.37500000D0,10.38000000D0,10.38500000D0,10.39000000D0,
     &  10.39500000D0,10.40000000D0,10.40500000D0,10.41000000D0,
     &  10.41500000D0,10.42000000D0,10.42500000D0,10.43000000D0,
     &  10.43500000D0,10.44000000D0,10.44500000D0,10.45000000D0,
     &  10.45500000D0,10.46000000D0,10.46500000D0,10.47000000D0,
     &  10.47300000D0,10.52897000D0,10.54217000D0,10.54889000D0,
     &  10.55317000D0,10.55622000D0,10.55855000D0,10.56042000D0,
     &  10.56197000D0,10.56328000D0,10.56442000D0,10.56543000D0,
     &  10.56633000D0,10.56714000D0,10.56788000D0,10.56857000D0,
     &  10.56921000D0,10.56980000D0,10.57036000D0,10.57090000D0,
     &  10.57141000D0,10.57189000D0,10.57237000D0,10.57282000D0,
     &  10.57327000D0,10.57371000D0,10.57415000D0,10.57459000D0,
     &  10.57503000D0,10.57547000D0,10.57594000D0,10.57643000D0,
     &  10.57695000D0,10.57755000D0,10.57829000D0,10.58000000D0,
     &  10.58171000D0,10.58245000D0,10.58305000D0,10.58357000D0,
     &  10.58406000D0,10.58453000D0,10.58497000D0,10.58541000D0,
     &  10.58585000D0,10.58629000D0,10.58673000D0,10.58718000D0,
     &  10.58763000D0,10.58811000D0,10.58859000D0,10.58910000D0,
     &  10.58964000D0,10.59020000D0,10.59079000D0,10.59143000D0,
     &  10.59212000D0,10.59286000D0,10.59367000D0,10.59457000D0,
     &  10.59558000D0,10.59671000D0,10.59803000D0,10.59958000D0,
     &  10.60145000D0,10.60378000D0,10.60683000D0,10.61111000D0/
       DATA  (ESA  (I), I=1901,2000) /
     &  10.61783000D0,10.63103000D0,10.68700000D0,10.69000000D0,
     &  10.71309000D0,10.72975000D0,10.74256000D0,10.75286000D0,
     &  10.76141000D0,10.76869000D0,10.77500000D0,10.78057000D0,
     &  10.78554000D0,10.79004000D0,10.79414000D0,10.79791000D0,
     &  10.80141000D0,10.80468000D0,10.80775000D0,10.81065000D0,
     &  10.81341000D0,10.81604000D0,10.81858000D0,10.82102000D0,
     &  10.82339000D0,10.82570000D0,10.82796000D0,10.83019000D0,
     &  10.83240000D0,10.83460000D0,10.83681000D0,10.83906000D0,
     &  10.84135000D0,10.84374000D0,10.84626000D0,10.84900000D0,
     &  10.85212000D0,10.85601000D0,10.86500000D0,10.87288000D0,
     &  10.87627000D0,10.87895000D0,10.88128000D0,10.88340000D0,
     &  10.88539000D0,10.88728000D0,10.88910000D0,10.89088000D0,
     &  10.89262000D0,10.89434000D0,10.89605000D0,10.89775000D0,
     &  10.89946000D0,10.90119000D0,10.90292000D0,10.90468000D0,
     &  10.90648000D0,10.90830000D0,10.91017000D0,10.91208000D0,
     &  10.91406000D0,10.91609000D0,10.91820000D0,10.92038000D0,
     &  10.92266000D0,10.92504000D0,10.92754000D0,10.93017000D0,
     &  10.93295000D0,10.93590000D0,10.93905000D0,10.94242000D0,
     &  10.94606000D0,10.95000000D0,10.97500000D0,10.97638000D0,
     &  10.97771000D0,10.97900000D0,10.98025000D0,10.98146000D0,
     &  10.98263000D0,10.98377000D0,10.98489000D0,10.98598000D0,
     &  10.98705000D0,10.98810000D0,10.98913000D0,10.99014000D0,
     &  10.99114000D0,10.99213000D0,10.99310000D0,10.99407000D0,
     &  10.99504000D0,10.99600000D0,10.99697000D0,10.99793000D0,
     &  10.99890000D0,10.99988000D0,11.00087000D0,11.00188000D0/
       DATA  (ESA  (I), I=2001,2100) /
     &  11.00290000D0,11.00396000D0,11.00506000D0,11.00621000D0,
     &  11.00742000D0,11.00873000D0,11.01018000D0,11.01186000D0,
     &  11.01399000D0,11.01900000D0,11.02401000D0,11.02614000D0,
     &  11.02782000D0,11.02927000D0,11.03058000D0,11.03179000D0,
     &  11.03294000D0,11.03404000D0,11.03510000D0,11.03612000D0,
     &  11.03713000D0,11.03812000D0,11.03910000D0,11.04007000D0,
     &  11.04103000D0,11.04200000D0,11.04296000D0,11.04392000D0,
     &  11.04490000D0,11.04587000D0,11.04686000D0,11.04786000D0,
     &  11.04887000D0,11.04990000D0,11.05095000D0,11.05202000D0,
     &  11.05311000D0,11.05423000D0,11.05537000D0,11.05654000D0,
     &  11.05775000D0,11.05900000D0,11.06029000D0,11.06162000D0,
     &  11.06300000D0,11.07000000D0,11.09200000D0,11.11500000D0,
     &  11.13700000D0,11.16000000D0,11.18200000D0,11.20500000D0,
     &  11.22700000D0,11.25000000D0,11.27300000D0,11.29500000D0,
     &  11.31800000D0,11.34000000D0,11.50000000D0,11.65500000D0,
     &  11.67700000D0,11.70000000D0,11.72200000D0,11.74500000D0,
     &  11.76700000D0,11.79000000D0,11.81200000D0,11.83500000D0,
     &  11.85800000D0,11.88000000D0,11.90300000D0,11.92500000D0,
     &  11.94800000D0,11.97000000D0,11.99300000D0,12.01500000D0,
     &  12.03800000D0,12.06000000D0,12.08300000D0,12.10500000D0,
     &  12.12700000D0,12.15000000D0,12.17200000D0,12.19500000D0,
     &  12.21700000D0,12.24000000D0,12.26200000D0,12.28500000D0,
     &  12.30700000D0,12.33000000D0,12.35200000D0,12.37500000D0,
     &  12.39800000D0,12.42000000D0,12.44300000D0,12.46500000D0,
     &  12.48800000D0,12.51000000D0,12.53300000D0,12.55500000D0/
       DATA  (ESA  (I), I=2101,2174) /
     &  12.57800000D0,12.60000000D0,12.62300000D0,12.64500000D0,
     &  12.66700000D0,12.69000000D0,12.71200000D0,12.73500000D0,
     &  12.75700000D0,12.78000000D0,12.80200000D0,12.82500000D0,
     &  12.84700000D0,12.87000000D0,12.89200000D0,12.91500000D0,
     &  12.93800000D0,12.96000000D0,12.98300000D0,13.00500000D0,
     &  13.02800000D0,13.05000000D0,13.07300000D0,13.09500000D0,
     &  13.11800000D0,13.14000000D0,13.16300000D0,13.18500000D0,
     &  13.20800000D0,13.23000000D0,13.25200000D0,13.27500000D0,
     &  13.29700000D0,13.32000000D0,13.34200000D0,13.36500000D0,
     &  13.38700000D0,13.41000000D0,13.43200000D0,13.45500000D0,
     &  13.47700000D0,13.50000000D0,13.75000000D0,14.00000000D0,
     &  14.04000000D0,16.00000000D0,17.00000000D0,20.00000000D0,
     &  21.95000000D0,22.05000000D0,25.00000000D0,25.01000000D0,
     &  27.50000000D0,27.60000000D0,27.66000000D0,29.00000000D0,
     &  29.93000000D0,30.10000000D0,30.38000000D0,30.80000000D0,
     &  31.10000000D0,31.29000000D0,33.20000000D0,33.30000000D0,
     &  33.89000000D0,34.00000000D0,34.50000000D0,34.70000000D0,
     &  34.86000000D0,35.01000000D0,35.45000000D0,36.10000000D0,
     &  36.38000000D0,38.29000000D0/
  
         DATA ((DAS  (I,J), I=   1, 100), J=1,1) /
     &  -9.23713801E-04,-9.82331973E-04,-1.03886765E-03,-1.09627561E-03,
     &  -1.15583404E-03,-1.18536986E-03,-1.23679924E-03,-1.32939672E-03,
     &  -1.36633784E-03,-1.40443323E-03,-1.46306424E-03,-1.51941904E-03,
     &  -1.58331150E-03,-1.62499480E-03,-1.67654200E-03,-1.72831077E-03,
     &  -1.78003409E-03,-1.83277327E-03,-1.87580121E-03,-1.93078752E-03,
     &  -1.97607773E-03,-2.03241466E-03,-2.07721576E-03,-2.13618500E-03,
     &  -2.18488495E-03,-2.23304278E-03,-2.29292383E-03,-2.32632488E-03,
     &  -2.34213228E-03,-2.39264177E-03,-2.44433940E-03,-2.49610935E-03,
     &  -2.54853999E-03,-2.60170519E-03,-2.65777213E-03,-2.71607110E-03,
     &  -2.77436348E-03,-2.83219106E-03,-2.89675335E-03,-2.96146293E-03,
     &  -3.01059456E-03,-3.07589068E-03,-3.14196313E-03,-3.19213596E-03,
     &  -3.26100085E-03,-3.33119937E-03,-3.38561268E-03,-3.46174784E-03,
     &  -3.51928799E-03,-3.60006705E-03,-4.04598421E-03,-4.52497004E-03,
     &  -5.20574127E-03,-6.07854233E-03,-6.37304130E-03,-6.46029667E-03,
     &  -6.69030635E-03,-7.00336527E-03,-7.33462473E-03,-7.67749331E-03,
     &  -8.03347286E-03,-8.15185060E-03,-8.36913071E-03,-8.72367983E-03,
     &  -9.02339243E-03,-9.33368750E-03,-9.58519180E-03,-9.81513200E-03,
     &  -9.84880250E-03,-9.92343988E-03,-9.95304534E-03,-9.97505316E-03,
     &  -9.87185508E-03,-9.62986736E-03,-9.18913321E-03,-8.63936294E-03,
     &  -7.85758686E-03,-6.93658610E-03,-6.12103999E-03,-5.87973354E-03,
     &  -5.46809268E-03,-5.01625010E-03,-4.70936674E-03,-4.54113368E-03,
     &  -4.43874747E-03,-4.69005989E-03,-5.08880804E-03,-5.43207295E-03,
     &  -5.78134037E-03,-6.01307267E-03,-6.25620915E-03,-6.43495353E-03,
     &  -6.58940547E-03,-6.60604765E-03,-6.57020004E-03,-6.51732035E-03,
     &  -6.42427592E-03,-6.32983583E-03,-6.19864320E-03,-6.03718770E-03/
  
         DATA ((DAS  (I,J), I= 101, 200), J=1,1) /
     &  -5.73319951E-03,-5.44796846E-03,-5.13382269E-03,-4.77280024E-03,
     &  -4.40286433E-03,-3.91603390E-03,-3.43889163E-03,-2.97143754E-03,
     &  -2.38838010E-03,-1.73704212E-03,-1.01413581E-03,-1.21470259E-04,
     &   7.98521788E-04, 1.76861241E-03, 3.00811642E-03, 4.50081849E-03,
     &   6.52301222E-03, 1.15172339E-02, 1.62412579E-02, 1.80194283E-02,
     &   1.92921944E-02, 2.02876226E-02, 2.10979453E-02, 2.17403100E-02,
     &   2.22928849E-02, 2.27471222E-02, 2.31191242E-02, 2.34257880E-02,
     &   2.36440762E-02, 2.37764972E-02, 2.39172980E-02, 2.46412948E-02,
     &   2.40389258E-02, 2.40507034E-02, 2.39994104E-02, 2.39251420E-02,
     &   2.38282220E-02, 2.36522070E-02, 2.35407233E-02, 2.32720572E-02,
     &   2.31064334E-02, 2.27986940E-02, 2.25264014E-02, 2.21355320E-02,
     &   2.17195418E-02, 2.12108775E-02, 2.06256549E-02, 1.99798495E-02,
     &   1.92321919E-02, 1.84002066E-02, 1.75124433E-02, 1.65101793E-02,
     &   1.63002077E-02, 1.57473121E-02, 1.51944166E-02, 1.47378042E-02,
     &   1.44651154E-02, 1.41482995E-02, 1.36393802E-02, 1.35260556E-02,
     &   1.33560051E-02, 1.32098994E-02, 1.31180681E-02, 1.30163677E-02,
     &   1.29040962E-02, 1.27929189E-02, 1.26927927E-02, 1.26225101E-02,
     &   1.22872381E-02, 1.19490163E-02, 1.16001017E-02, 1.13089203E-02,
     &   1.09564082E-02, 1.06023913E-02, 1.02296812E-02, 9.91660763E-03,
     &   9.52672184E-03, 9.14130759E-03, 8.81520414E-03, 8.62786774E-03,
     &   8.27736911E-03, 8.11586920E-03, 7.74020338E-03, 7.41914835E-03,
     &   7.02493339E-03, 6.68150692E-03, 6.25458012E-03, 5.88466989E-03,
     &   5.48322167E-03, 4.98060189E-03, 4.71952607E-03, 4.53399143E-03,
     &   4.16211193E-03, 3.95191752E-03, 3.73085157E-03, 3.49958836E-03,
     &   3.24652010E-03, 2.99644972E-03, 2.73480566E-03, 2.18159006E-03/
  
         DATA ((DAS  (I,J), I= 201, 300), J=1,1) /
     &   1.56517764E-03, 1.19903477E-03, 1.06278633E-03, 9.20247596E-04,
     &   7.78049134E-04, 6.29379106E-04, 4.89873722E-04, 3.16018954E-04,
     &   1.32450853E-04,-2.02799195E-05,-2.01281736E-04,-3.86221512E-04,
     &  -5.78473050E-04,-7.69636640E-04,-9.77196988E-04,-1.18904726E-03,
     &  -1.41074020E-03,-1.64449272E-03,-1.87529848E-03,-2.12300236E-03,
     &  -2.37831108E-03,-2.56799062E-03,-2.90810682E-03,-3.23913505E-03,
     &  -3.55646908E-03,-3.89947562E-03,-4.26280274E-03,-4.57951462E-03,
     &  -5.05102538E-03,-5.48578558E-03,-5.65625495E-03,-5.91064877E-03,
     &  -5.96775190E-03,-6.58732409E-03,-7.16520863E-03,-7.76668347E-03,
     &  -8.38810121E-03,-9.11410998E-03,-9.91651343E-03,-1.06857985E-02,
     &  -1.15567496E-02,-1.25703340E-02,-1.34215376E-02,-1.47466616E-02,
     &  -1.60717857E-02,-1.74706517E-02,-1.91535729E-02,-2.10250371E-02,
     &  -2.31525413E-02,-2.55741767E-02,-2.83575353E-02,-3.16156965E-02,
     &  -3.53714084E-02,-3.89929103E-02,-4.09732485E-02,-4.23138210E-02,
     &  -4.41859972E-02,-4.50927630E-02,-4.45503783E-02,-4.78505401E-02,
     &  -4.91839403E-02,-5.03866918E-02,-5.14534956E-02,-5.22974108E-02,
     &  -5.28461769E-02,-5.29500685E-02,-5.20198543E-02,-5.03356389E-02,
     &  -4.91676836E-02,-4.59280458E-02,-4.13782762E-02,-3.53743919E-02,
     &  -2.55379248E-02,-1.89565725E-02,-8.91287526E-03, 1.86994875E-03,
     &   1.28419799E-02, 2.34490796E-02, 3.31785499E-02, 4.16462600E-02,
     &   4.86802759E-02, 5.42356476E-02, 5.83733308E-02, 6.12605140E-02,
     &   6.30903178E-02, 6.40770757E-02, 6.43823822E-02, 6.41493185E-02,
     &   6.35505655E-02, 6.26605249E-02, 6.10094271E-02, 6.05359302E-02,
     &   5.81979946E-02, 5.76082668E-02, 5.63552733E-02, 5.49863126E-02,
     &   5.36408562E-02, 5.23294731E-02, 5.10447134E-02, 4.97762861E-02/
  
         DATA ((DAS  (I,J), I= 301, 400), J=1,1) /
     &   4.96008752E-02, 4.74032745E-02, 4.62933015E-02, 4.52203909E-02,
     &   4.17473415E-02, 3.87748695E-02, 3.61945474E-02, 3.39448022E-02,
     &   3.19920490E-02, 2.99182900E-02, 2.87463693E-02, 2.74001234E-02,
     &   2.61427592E-02, 2.51037570E-02, 2.41253555E-02, 2.32136777E-02,
     &   2.24534331E-02, 2.16689105E-02, 2.10033275E-02, 2.03705349E-02,
     &   1.98612414E-02, 1.93248397E-02, 1.93084661E-02, 1.83603092E-02,
     &   1.79323157E-02, 1.77855683E-02, 1.80118770E-02, 1.76446783E-02,
     &   1.71250108E-02, 1.67616574E-02, 1.64274924E-02, 1.61228401E-02,
     &   1.58325250E-02, 1.55707256E-02, 1.53230298E-02, 1.50764101E-02,
     &   1.48483512E-02, 1.46208702E-02, 1.44351236E-02, 1.42151999E-02,
     &   1.40325852E-02, 1.38524914E-02, 1.36709536E-02, 1.35028692E-02,
     &   1.33455930E-02, 1.31798717E-02, 1.30373697E-02, 1.28879731E-02,
     &   1.27384249E-02, 1.26191348E-02, 1.24862847E-02, 1.23577015E-02,
     &   1.22341937E-02, 1.20939534E-02, 1.19941191E-02, 1.18769475E-02,
     &   1.15608693E-02, 1.08762864E-02, 9.81468000E-03, 9.02546108E-03,
     &   8.40572530E-03, 7.89646387E-03, 7.45105786E-03, 7.06113779E-03,
     &   6.71650652E-03, 6.68625125E-03, 6.28976785E-03, 6.02331831E-03,
     &   5.93335810E-03, 5.71221077E-03, 5.50542108E-03, 5.48296861E-03,
     &   5.30214309E-03, 5.11523787E-03, 5.02085101E-03, 4.92777071E-03,
     &   4.67235288E-03, 4.60993891E-03, 4.47157789E-03, 4.35566437E-03,
     &   4.28790147E-03, 4.24337483E-03, 4.12687800E-03, 4.00470617E-03,
     &   3.99385984E-03, 3.90632308E-03, 3.80027108E-03, 3.76002608E-03,
     &   3.71522558E-03, 3.62537968E-03, 3.54010217E-03, 3.44522106E-03,
     &   3.42164977E-03, 3.36564270E-03, 3.33005442E-03, 3.29674889E-03,
     &   3.24724529E-03, 3.21495095E-03, 3.20985717E-03, 3.19767524E-03/
  
         DATA ((DAS  (I,J), I= 401, 500), J=1,1) /
     &   3.15076806E-03, 3.12511482E-03, 3.08794636E-03, 2.95654074E-03,
     &   2.91910256E-03, 2.85873007E-03, 2.85794796E-03, 2.86145134E-03,
     &   2.87233996E-03, 2.91160080E-03, 2.97186333E-03, 3.04046690E-03,
     &   3.04838614E-03, 3.12013046E-03, 3.12885913E-03, 3.17712134E-03,
     &   3.22081082E-03, 3.39666822E-03, 3.42670195E-03, 3.63655194E-03,
     &   3.65170557E-03, 3.66633363E-03, 3.80581016E-03, 3.91460112E-03,
     &   3.93071409E-03, 3.99915038E-03, 4.00112363E-03, 4.00261710E-03,
     &   4.00288429E-03, 3.98885950E-03, 3.98471862E-03, 3.96711635E-03,
     &   3.96359256E-03, 3.95849465E-03, 3.94741796E-03, 3.94401047E-03,
     &   3.94340237E-03, 3.93043996E-03, 3.93443784E-03, 3.99003761E-03,
     &   4.06396426E-03, 4.09681668E-03, 4.11945228E-03, 4.13079483E-03,
     &   4.24710666E-03, 4.27139664E-03, 4.32288566E-03, 4.36844369E-03,
     &   4.39033366E-03, 4.47413605E-03, 4.57514134E-03, 4.59706955E-03,
     &   4.60399295E-03, 4.67220828E-03, 4.70727124E-03, 4.74394513E-03,
     &   4.88699142E-03, 4.90175165E-03, 4.93360320E-03, 4.93985218E-03,
     &   4.92216282E-03, 4.91703323E-03, 4.90141821E-03, 4.88946100E-03,
     &   4.88086845E-03, 4.85606005E-03, 4.82763635E-03, 4.83277715E-03,
     &   4.86571152E-03, 4.88979826E-03, 4.89833683E-03, 4.87344448E-03,
     &   4.81619039E-03, 4.78358224E-03, 4.77324445E-03, 4.73158699E-03,
     &   4.72577933E-03, 4.71499774E-03, 4.71377125E-03, 4.71182377E-03,
     &   4.70992621E-03, 4.70258939E-03, 4.69778640E-03, 4.69298189E-03,
     &   4.67759849E-03, 4.63397728E-03, 4.61221084E-03, 4.58892083E-03,
     &   4.54748780E-03, 4.53834617E-03, 4.50950779E-03, 4.50420984E-03,
     &   4.47876387E-03, 4.45472445E-03, 4.43145990E-03, 4.42287871E-03,
     &   4.38144399E-03, 4.28189794E-03, 4.36225140E-03, 4.42190590E-03/
  
         DATA ((DAS  (I,J), I= 501, 600), J=1,1) /
     &   4.51523940E-03, 4.60947038E-03, 4.79738880E-03, 4.78537615E-03,
     &   4.76036620E-03, 4.65997788E-03, 4.56788649E-03, 4.44158493E-03,
     &   4.28879182E-03, 4.11858185E-03, 3.90416579E-03, 3.62920684E-03,
     &   3.25693640E-03, 2.72868316E-03, 1.97208678E-03, 8.32637335E-04,
     &   5.34456612E-04, 2.03560524E-04,-1.66159115E-04,-5.82143152E-04,
     &  -1.05368047E-03,-1.59283555E-03,-2.21582420E-03,-2.35221964E-03,
     &  -2.49294135E-03,-2.63852942E-03,-2.78867433E-03,-2.94400169E-03,
     &  -3.10466519E-03,-3.27108904E-03,-3.44324788E-03,-3.62174896E-03,
     &  -3.80691583E-03,-4.74058808E-03,-5.45807138E-03,-5.85201863E-03,
     &  -6.13015644E-03,-6.42155535E-03,-6.72705499E-03,-7.04761444E-03,
     &  -7.38425875E-03,-7.73832270E-03,-7.92229279E-03,-8.11116631E-03,
     &  -8.30512647E-03,-8.50437831E-03,-8.70921078E-03,-8.91970927E-03,
     &  -9.13611897E-03,-9.35891937E-03,-9.58827848E-03,-9.82449071E-03,
     &  -1.00678629E-02,-1.03187259E-02,-1.05774324E-02,-1.08443499E-02,
     &  -1.11198811E-02,-1.14044152E-02,-1.16985632E-02,-1.20025675E-02,
     &  -1.23170931E-02,-1.26426606E-02,-1.29798604E-02,-1.33293294E-02,
     &  -1.36917491E-02,-1.40678548E-02,-1.44584332E-02,-1.48643213E-02,
     &  -1.52865060E-02,-1.57259378E-02,-1.61837693E-02,-1.66611077E-02,
     &  -1.71592158E-02,-1.76794810E-02,-1.82234628E-02,-1.87928286E-02,
     &  -1.93892781E-02,-2.00149441E-02,-2.06718750E-02,-2.13625420E-02,
     &  -2.20896118E-02,-2.28560802E-02,-2.32551212E-02,-2.36652628E-02,
     &  -2.40869754E-02,-2.45207584E-02,-2.49671341E-02,-2.54266607E-02,
     &  -2.58998607E-02,-2.63875714E-02,-2.68902347E-02,-2.74085721E-02,
     &  -2.79435561E-02,-2.84954804E-02,-2.90657553E-02,-2.96552282E-02,
     &  -3.02646528E-02,-3.08951432E-02,-3.15478116E-02,-3.22238503E-02/
  
         DATA ((DAS  (I,J), I= 601, 700), J=1,1) /
     &  -3.29245649E-02,-3.36513028E-02,-3.44055579E-02,-3.51889122E-02,
     &  -3.60030798E-02,-3.68499189E-02,-3.77314441E-02,-3.86498230E-02,
     &  -3.96074182E-02,-4.06067977E-02,-4.16510688E-02,-4.27427177E-02,
     &  -4.38853026E-02,-4.50825245E-02,-4.63384098E-02,-4.76573174E-02,
     &  -4.90442320E-02,-5.05044987E-02,-5.20440970E-02,-5.36696853E-02,
     &  -5.61041509E-02,-5.72093551E-02,-5.91410399E-02,-6.11942355E-02,
     &  -6.33807654E-02,-6.57140544E-02,-6.82094069E-02,-7.08843374E-02,
     &  -7.37589746E-02,-7.68565773E-02,-8.02041653E-02,-8.38333918E-02,
     &  -8.77812528E-02,-9.09333350E-02,-1.00757025E-01,-1.12796594E-01,
     &  -1.27900775E-01,-1.47416986E-01,-1.73631114E-01,-2.10807584E-01,
     &  -2.70012117E-01,-3.61369722E-01,-5.53262313E-01,-1.16876646E+00,
     &  -1.23619059E+00,-1.31181077E+00,-1.39734213E+00,-1.49436987E+00,
     &  -1.60593687E+00,-1.73533077E+00,-1.88716218E+00,-2.06776714E+00,
     &  -2.28608534E+00,-2.55513057E+00,-2.89471468E+00,-3.32172876E+00,
     &  -3.92922909E+00,-4.00002779E+00,-5.58532449E+00,-6.74075076E+00,
     &  -7.66911292E+00,-4.78297724E+00,-9.10102075E+00,-9.29852706E+00,
     &  -1.00734839E+01,-1.05102768E+01,-1.08136001E+01,-1.10936657E+01,
     &  -1.12882517E+01,-1.14448537E+01,-1.15303410E+01,-1.15912117E+01,
     &  -1.15945754E+01,-1.15592634E+01,-1.14669968E+01,-1.13682916E+01,
     &  -1.11548149E+01,-1.09627163E+01,-1.07256351E+01,-1.02327822E+01,
     &  -9.75035343E+00,-9.22005226E+00,-8.64495437E+00,-8.72310014E+00,
     &  -8.13872809E+00,-7.49072708E+00,-6.78062819E+00,-5.60593880E+00,
     &  -4.75672252E+00,-3.43373189E+00,-1.96719139E+00, 1.98023030E+00,
     &   5.61518307E+00, 6.78819730E+00, 7.82882968E+00, 8.44453347E+00,
     &   9.24908348E+00, 9.24691486E+00, 9.77104540E+00, 1.02463962E+01/
  
         DATA ((DAS  (I,J), I= 701, 800), J=1,1) /
     &   1.06704338E+01, 1.09730263E+01, 1.12025174E+01, 1.13196253E+01,
     &   1.14361062E+01, 1.15199987E+01, 1.15748895E+01, 1.16098382E+01,
     &   8.99966999E+00, 9.52207994E+00, 1.14869921E+01, 1.14187366E+01,
     &   1.12496132E+01, 1.11002886E+01, 1.08800086E+01, 1.06439227E+01,
     &   1.03371892E+01, 1.00894538E+01, 9.35477710E+00, 9.16963530E+00,
     &   8.65249673E+00, 8.06972718E+00, 7.32019202E+00, 6.39462367E+00,
     &   5.38794581E+00, 4.44077409E+00, 3.70503851E+00, 3.17415323E+00,
     &   2.77442403E+00, 2.46317852E+00, 2.21424148E+00, 2.01074720E+00,
     &   1.84142222E+00, 1.69824303E+00, 1.57572720E+00, 1.46968684E+00,
     &   1.37702145E+00, 1.29535712E+00, 1.22285011E+00, 1.15804580E+00,
     &   1.09978134E+00, 1.04711650E+00, 9.99282474E-01, 5.26736862E-01,
     &   3.58964451E-01, 2.73203641E-01, 2.22439318E-01, 1.85268350E-01,
     &   1.59684443E-01, 1.40566978E-01, 1.25703977E-01, 1.13808551E-01,
     &   1.04069646E-01, 1.02916774E-01, 9.48817859E-02, 8.80792232E-02,
     &   8.22453325E-02, 7.71867681E-02, 7.27583993E-02, 6.88492687E-02,
     &   6.53729290E-02, 6.22613628E-02, 5.94600035E-02, 5.69244537E-02,
     &   5.46186511E-02, 5.25126715E-02, 5.05815774E-02, 4.88044436E-02,
     &   4.71635476E-02, 4.56436566E-02, 4.42321908E-02, 4.29174941E-02,
     &   4.16903882E-02, 4.05420466E-02, 3.94652033E-02, 3.84533770E-02,
     &   3.75008455E-02, 3.66025364E-02, 3.57539430E-02, 3.49511455E-02,
     &   3.41903527E-02, 3.34684177E-02, 3.27823179E-02, 3.21296331E-02,
     &   3.15078951E-02, 3.09149484E-02, 3.03488341E-02, 2.98077842E-02,
     &   2.92901503E-02, 2.87944477E-02, 2.83191602E-02, 2.78635724E-02,
     &   2.74258632E-02, 2.70051099E-02, 2.66006123E-02, 2.62113073E-02,
     &   2.58363650E-02, 2.54749917E-02, 2.51264697E-02, 2.47901231E-02/
  
         DATA ((DAS  (I,J), I= 801, 900), J=1,1) /
     &   2.44652127E-02, 2.41516406E-02, 2.38482244E-02, 2.35545732E-02,
     &   2.32705067E-02, 2.29954433E-02, 2.27289613E-02, 2.24706646E-02,
     &   2.22201886E-02, 2.19771895E-02, 2.17413449E-02, 2.15123535E-02,
     &   2.12898740E-02, 2.10738163E-02, 2.08637574E-02, 2.06595234E-02,
     &   2.04608809E-02, 2.02676261E-02, 2.00795649E-02, 1.98965159E-02,
     &   1.97182997E-02, 1.95447820E-02, 1.93759086E-02, 1.92112362E-02,
     &   1.90509785E-02, 1.88949198E-02, 1.87429619E-02, 1.85950405E-02,
     &   1.84511099E-02, 1.83111459E-02, 1.81751549E-02, 1.80432447E-02,
     &   1.79153768E-02, 1.77917351E-02, 1.76726897E-02, 1.75585884E-02,
     &   1.72745854E-02, 1.71515806E-02, 1.70310325E-02, 1.69128518E-02,
     &   1.67967899E-02, 1.66837446E-02, 1.65712299E-02, 1.64623641E-02,
     &   1.63541253E-02, 1.62545912E-02, 1.61462366E-02, 1.60467937E-02,
     &   1.59475588E-02, 1.58515229E-02, 1.57559792E-02, 1.56620108E-02,
     &   1.55702791E-02, 1.54798842E-02, 1.53906536E-02, 1.53034721E-02,
     &   1.26663399E-02, 1.07846281E-02, 9.10778384E-03, 7.60320851E-03,
     &   6.60947797E-03, 6.14790641E-03, 5.61307692E-03, 4.96606301E-03,
     &   4.36809319E-03, 3.61942318E-03, 3.32622912E-03, 2.65231262E-03,
     &   2.27572006E-03, 1.84523694E-03, 1.34407460E-03, 7.60808455E-04,
     &   7.83473726E-05,-7.30249025E-04,-1.70305199E-03,-2.89848551E-03,
     &  -4.40731927E-03,-5.12967510E-03,-5.93897132E-03,-6.85257483E-03,
     &  -7.89279926E-03,-9.08881114E-03,-1.04794426E-02,-1.12635535E-02,
     &  -1.21176313E-02,-1.30515779E-02,-1.40773669E-02,-1.52094824E-02,
     &  -1.64653839E-02,-1.78670315E-02,-1.94415700E-02,-2.12234210E-02,
     &  -2.32567925E-02,-2.55996183E-02,-2.83286104E-02,-3.14088373E-02,
     &  -3.34251630E-02,-3.56626034E-02,-3.81598493E-02,-4.09651974E-02/
  
         DATA ((DAS  (I,J), I= 901,1000), J=1,1) /
     &  -4.41397365E-02,-4.77618946E-02,-5.19340810E-02,-5.67926474E-02,
     &  -6.25232677E-02,-6.93857258E-02,-7.77549361E-02,-8.81939113E-02,
     &  -1.01589732E-01,-1.19433179E-01,-1.44457110E-01,-1.82407053E-01,
     &  -2.49534264E-01,-3.68265321E-01,-5.38266349E-01,-6.36852875E-01,
     &  -7.44758451E-01,-1.01089056E+00,-1.10708560E+00,-1.13777847E+00,
     &  -1.25313711E+00,-1.29741650E+00,-1.35658231E+00,-1.39655723E+00,
     &  -1.40554875E+00,-1.43155070E+00,-1.47288014E+00,-1.48705774E+00,
     &  -1.49544443E+00,-1.49843193E+00,-1.49620186E+00,-1.49024628E+00,
     &  -1.47822646E+00,-1.46254899E+00,-1.44333157E+00,-1.41700631E+00,
     &  -1.38590362E+00,-1.34603772E+00,-1.30567389E+00,-1.25931491E+00,
     &  -1.20663794E+00,-1.13687628E+00,-1.06977310E+00,-9.82865534E-01,
     &  -9.01038579E-01,-7.81741091E-01,-6.51549077E-01,-4.57104212E-01,
     &  -2.87615288E-01,-9.23888760E-02, 6.49752686E-03, 1.05385067E-01,
     &   2.03634700E-01, 4.70126111E-01, 6.64599495E-01, 7.94817164E-01,
     &   9.14143593E-01, 9.95993831E-01, 1.08292998E+00, 1.15005828E+00,
     &   1.21984978E+00, 1.27255235E+00, 1.31893676E+00, 1.35932906E+00,
     &   1.39922325E+00, 1.43031680E+00, 1.45666866E+00, 1.47594316E+00,
     &   1.49164437E+00, 1.50368990E+00, 1.50966682E+00, 1.51192261E+00,
     &   1.50895912E+00, 1.50059715E+00, 1.48644465E+00, 1.44495645E+00,
     &   1.41898834E+00, 1.41019447E+00, 1.37024415E+00, 1.31097116E+00,
     &   1.26685048E+00, 1.15200458E+00, 1.12083822E+00, 1.02466476E+00,
     &   9.08390118E-01, 9.71516041E-01, 8.32749286E-01, 7.47390848E-01,
     &   6.95834922E-01, 5.89268979E-01, 5.52109146E-01, 4.75136401E-01,
     &   5.77045122E-01, 2.22312742E-01, 1.74038741E-01, 1.43932298E-01,
     &   1.23146750E-01, 1.07880766E-01, 9.61741927E-02, 8.69031234E-02/
  
         DATA ((DAS  (I,J), I=1001,1100), J=1,1) /
     &   7.93735117E-02, 7.31322057E-02, 6.78690098E-02, 6.33562897E-02,
     &   5.94678008E-02, 5.61302699E-02, 5.31719358E-02, 5.05423632E-02,
     &   4.81933786E-02, 4.60836688E-02, 4.27318109E-02, 3.85480431E-02,
     &   3.63056456E-02, 3.26337239E-02, 2.97521078E-02, 2.69137080E-02,
     &   2.28673166E-02, 1.82779306E-02, 1.54128902E-02, 1.40809255E-02,
     &   1.33895075E-02, 1.28782113E-02, 1.25008729E-02, 1.21949023E-02,
     &   1.19693175E-02, 1.17716893E-02, 1.16054767E-02, 1.14629176E-02,
     &   1.13396742E-02, 1.12593759E-02, 1.11375293E-02, 1.10544726E-02,
     &   1.09812596E-02, 1.09167557E-02, 1.08602319E-02, 1.08106593E-02,
     &   1.07675255E-02, 1.07304061E-02, 1.06989093E-02, 1.06728733E-02,
     &   1.06175771E-02, 1.06367181E-02, 1.06267000E-02, 1.06223931E-02,
     &   1.06229695E-02, 1.06319605E-02, 1.06502560E-02, 1.06768417E-02,
     &   1.07163383E-02, 1.07750126E-02, 1.08690903E-02, 1.11703222E-02,
     &   1.15499745E-02, 1.17297293E-02, 1.18748852E-02, 1.20008042E-02,
     &   1.21136124E-02, 1.22155863E-02, 1.23089587E-02, 1.23939112E-02,
     &   1.24706614E-02, 1.25341922E-02, 1.25991109E-02, 1.26485981E-02,
     &   1.26435044E-02, 1.26587352E-02, 1.25009284E-02, 1.27621612E-02,
     &   1.28494030E-02, 1.29197829E-02, 1.29570674E-02, 1.29811508E-02,
     &   1.29921613E-02, 1.29902188E-02, 1.29746914E-02, 1.29444940E-02,
     &   1.28911691E-02, 1.30594708E-02, 1.27429267E-02, 1.26288209E-02,
     &   1.24865621E-02, 1.23074356E-02, 1.20836057E-02, 1.17977279E-02,
     &   1.14122355E-02, 1.08574433E-02, 1.06917711E-02, 1.02517561E-02,
     &   9.59062856E-03, 9.52247464E-03, 9.06500148E-03, 8.87889242E-03,
     &   8.73073000E-03, 8.60475759E-03, 8.40899849E-03, 8.20107922E-03,
     &   8.15594800E-03, 8.14955540E-03, 8.11365389E-03, 8.04898876E-03/
  
         DATA ((DAS  (I,J), I=1101,1200), J=1,1) /
     &   8.01337630E-03, 8.02329856E-03, 8.15826776E-03, 8.14268992E-03,
     &   7.99308245E-03, 7.93224939E-03, 7.81525165E-03, 7.40364083E-03,
     &   7.30499684E-03, 7.51352106E-03, 7.44196799E-03, 7.26620822E-03,
     &   7.00320317E-03, 6.64144149E-03, 6.41065318E-03, 6.05690245E-03,
     &   5.82504387E-03, 5.94440016E-03, 6.49543899E-03, 6.87261038E-03,
     &   7.72250302E-03, 8.08075244E-03, 8.37355420E-03, 8.69983812E-03,
     &   8.95260290E-03, 8.89973463E-03, 8.83258803E-03, 8.96274338E-03,
     &   9.34417758E-03, 9.06306984E-03, 8.71211588E-03, 8.77281532E-03,
     &   8.89038815E-03, 8.97396378E-03, 9.09506645E-03, 9.10954862E-03,
     &   9.02547311E-03, 8.84706632E-03, 8.74064418E-03, 8.53678379E-03,
     &   8.51088906E-03, 8.64621479E-03, 8.79918773E-03, 8.99023129E-03,
     &   9.07452434E-03, 9.25308041E-03, 9.32806963E-03, 9.22409316E-03,
     &   9.32227877E-03, 9.54473060E-03, 9.78106498E-03, 1.00203900E-02,
     &   1.01625122E-02, 1.02830287E-02, 1.04321031E-02, 1.05458127E-02,
     &   1.06276993E-02, 1.07148105E-02, 1.08387210E-02, 1.09454864E-02,
     &   1.10389985E-02, 1.11354369E-02, 1.09775398E-02, 1.04876244E-02,
     &   1.03800073E-02, 1.04557536E-02, 1.06153068E-02, 1.04255623E-02,
     &   1.04224312E-02, 1.05567317E-02, 1.06417994E-02, 9.90285615E-03,
     &   9.11772320E-03, 8.85461502E-03, 8.66556026E-03, 8.96192054E-03,
     &   8.96777283E-03, 8.84150632E-03, 8.73074661E-03, 8.66628232E-03,
     &   8.57478844E-03, 8.45293662E-03, 8.11398305E-03, 8.13660445E-03,
     &   8.16417397E-03, 8.10178446E-03, 8.07914208E-03, 8.06435166E-03,
     &   8.11420215E-03, 8.13938915E-03, 8.15323035E-03, 8.19066394E-03,
     &   8.17753398E-03, 8.21827804E-03, 8.59676219E-03, 9.00087126E-03,
     &   9.11435224E-03, 9.14785882E-03, 9.16753458E-03, 9.03672611E-03/
  
         DATA ((DAS  (I,J), I=1201,1300), J=1,1) /
     &   9.30330876E-03, 9.63275398E-03, 9.75856870E-03, 9.81072606E-03,
     &   9.90066692E-03, 9.91388857E-03, 9.82245202E-03, 9.66184068E-03,
     &   9.60542722E-03, 9.66787104E-03, 9.67673712E-03, 9.40174880E-03,
     &   9.41481076E-03, 9.57768474E-03, 9.53548064E-03, 9.35719435E-03,
     &   9.26563808E-03, 9.29579732E-03, 9.39336254E-03, 9.39781136E-03,
     &   9.61585589E-03, 9.71197930E-03, 9.93609807E-03, 1.01742243E-02,
     &   1.02463756E-02, 1.00031850E-02, 1.01966992E-02, 1.03226752E-02,
     &   1.05121129E-02, 1.05918111E-02, 1.06656936E-02, 1.08012487E-02,
     &   1.09252288E-02, 1.09839273E-02, 1.10407900E-02, 1.10960139E-02,
     &   1.11497576E-02, 1.12021511E-02, 1.12533023E-02, 1.13033023E-02,
     &   1.13522284E-02, 1.14001471E-02, 1.14471157E-02, 1.14931843E-02,
     &   1.15383967E-02, 1.15827913E-02, 1.16264019E-02, 1.16692591E-02,
     &   1.17113888E-02, 1.17528149E-02, 1.17935585E-02, 1.18336377E-02,
     &   1.18730692E-02, 1.19118673E-02, 1.19500447E-02, 1.19876122E-02,
     &   1.20245792E-02, 1.20609536E-02, 1.20967418E-02, 1.21319488E-02,
     &   1.21665784E-02, 1.22006329E-02, 1.22341135E-02, 1.22670197E-02,
     &   1.22993499E-02, 1.23311011E-02, 1.23622687E-02, 1.23867785E-02,
     &   1.24228267E-02, 1.24809542E-02, 1.25365501E-02, 1.25894760E-02,
     &   1.26395465E-02, 1.26865168E-02, 1.27300630E-02, 1.27697551E-02,
     &   1.28050152E-02, 1.28350530E-02, 1.28587610E-02, 1.28745389E-02,
     &   1.28799890E-02, 1.28713141E-02, 1.28421195E-02, 1.28376906E-02,
     &   1.27806259E-02, 1.26622727E-02, 1.24252535E-02, 1.20214104E-02,
     &   1.18539443E-02, 1.11606317E-02, 9.87875376E-03, 9.28859340E-03,
     &   8.46102445E-03, 7.90880538E-03, 7.21826284E-03, 6.52764831E-03,
     &   5.66455702E-03, 5.14690177E-03, 4.55555129E-03, 3.87363163E-03/
  
         DATA ((DAS  (I,J), I=1301,1400), J=1,1) /
     &   3.07869792E-03, 2.14022782E-03, 1.01562544E-03, 3.65364295E-04,
     &  -3.56414900E-04,-1.16218096E-03,-2.06748918E-03,-3.09200888E-03,
     &  -4.26100319E-03,-5.60753579E-03,-7.17596635E-03,-9.02845385E-03,
     &  -9.80375645E-03,-1.02926898E-02,-1.08066185E-02,-1.13610004E-02,
     &  -1.18936040E-02,-1.24462406E-02,-1.11599520E-02,-1.36520890E-02,
     &  -1.43018536E-02,-1.49846535E-02,-1.57026299E-02,-1.64582997E-02,
     &  -1.72545301E-02,-1.80945460E-02,-1.89818655E-02,-1.99208305E-02,
     &  -2.09156962E-02,-2.19716697E-02,-2.30945140E-02,-2.42907479E-02,
     &  -2.55677731E-02,-2.69340263E-02,-2.83991659E-02,-2.99742855E-02,
     &  -3.16722691E-02,-3.35079942E-02,-3.54989188E-02,-3.76655636E-02,
     &  -4.00322344E-02,-4.26279338E-02,-4.54875415E-02,-4.86533057E-02,
     &  -5.21767246E-02,-5.61246512E-02,-6.05750426E-02,-6.56318996E-02,
     &  -7.14280284E-02,-7.81382972E-02,-8.59973744E-02,-9.53277601E-02,
     &  -1.06585092E-01,-1.20434773E-01,-1.37888264E-01, 3.92764487E-05,
     &  -1.91207800E-01,-2.34923171E-01,-3.02321143E-01,-4.19743898E-01,
     &  -6.75261411E-01,-8.33685610E-01,-1.60051809E+00,-2.23207575E+00,
     &  -2.69067187E+00,-3.04434239E+00,-3.21189616E-03,-3.59013252E+00,
     &  -3.82679557E+00,-3.99150354E+00,-4.15871167E+00,-4.32345957E+00,
     &  -4.40288141E+00,-4.51418751E+00,-4.58160216E+00,-4.66515968E+00,
     &  -4.68530259E+00,-4.72229080E+00,-4.73050228E+00,-4.72048508E+00,
     &  -4.70521579E+00,-4.68217059E+00,-5.22831430E-02,-5.10191550E-02,
     &  -4.49522521E+00,-4.33331504E+00,-4.23280065E+00,-4.11949194E+00,
     &  -3.98885465E+00,-3.67824298E+00,-3.49714317E+00,-3.30088492E+00,
     &  -2.85477387E+00,-2.60782936E+00,-7.92295764E-01,-1.46745097E+00,
     &   1.71684599E-01, 1.47385462E+00, 2.07366763E+00, 2.61630299E+00/
  
         DATA ((DAS  (I,J), I=1401,1500), J=1,1) /
     &   3.09849722E+00, 3.31525809E+00, 3.51259147E+00, 3.69289430E+00,
     &   4.00501929E+00, 4.13617480E+00, 4.25331291E+00, 4.36119809E+00,
     &   4.51956978E+00, 4.58130299E+00, 4.63372092E+00, 4.70755101E+00,
     &   4.73138998E+00, 4.75573740E+00, 4.75792801E+00, 4.74532589E+00,
     &   4.71414448E+00, 4.73445698E+00, 4.69279894E+00, 4.54490589E+00,
     &   4.43626921E+00, 4.35651779E+00, 4.18876781E+00, 4.02168847E+00,
     &   3.85687765E+00, 3.62010603E+00, 3.36535864E+00, 3.07370983E+00,
     &   2.71902604E+00, 2.26064918E+00, 1.61905529E+00, 8.89865575E-01,
     &   5.14859718E-01, 3.64342290E-01, 2.83304394E-01, 2.32680840E-01,
     &   1.98060629E-01, 1.72937833E-01, 1.53772862E-01, 1.38754361E-01,
     &   1.26646162E-01, 1.16677176E-01, 1.08326650E-01, 1.01230176E-01,
     &   9.51250871E-02, 8.98173050E-02, 3.82490522E-02, 8.10433021E-02,
     &   7.73709782E-02, 7.40834271E-02, 7.11186197E-02, 6.84321750E-02,
     &   6.59867571E-02, 6.37513627E-02, 6.17000966E-02, 5.98111546E-02,
     &   5.80660480E-02, 1.76004742E-02, 5.49464517E-02, 5.35467145E-02,
     &   5.22396334E-02, 5.10163570E-02, 4.98691343E-02, 4.87911516E-02,
     &   4.77763984E-02, 4.68195575E-02, 4.59159155E-02, 4.50612920E-02,
     &   4.42519881E-02, 4.34847576E-02, 4.27568266E-02, 4.20660170E-02,
     &   4.14112779E-02, 4.07958256E-02, 4.02166684E-02, 3.95973823E-02,
     &   3.90299205E-02, 3.84918001E-02, 3.79784590E-02, 3.74874402E-02,
     &   3.70169726E-02, 3.34877633E-02, 3.13378351E-02, 2.92885411E-02,
     &   2.70257827E-02, 2.49683158E-02, 2.31589479E-02, 2.27160492E-02,
     &   2.10620879E-02, 1.85747304E-02, 1.69850946E-02, 1.69113243E-02,
     &   1.67529998E-02, 1.65775680E-02, 1.62436923E-02, 1.59566416E-02,
     &   1.50425611E-02, 1.42353904E-02, 1.37614096E-02, 1.31293641E-02/
  
         DATA ((DAS  (I,J), I=1501,1600), J=1,1) /
     &   1.23823287E-02, 1.15222186E-02, 1.04174084E-02, 8.90427460E-03,
     &   5.12477161E-03, 4.40858653E-03, 3.56531412E-03, 3.32096830E-03,
     &   2.76404307E-03, 2.14526882E-03, 1.45372348E-03, 6.75750945E-04,
     &  -2.05951925E-04,-1.21364048E-03,-2.37643169E-03,-3.73317162E-03,
     &  -5.33687384E-03,-7.26183574E-03,-9.61553376E-03,-1.25595309E-02,
     &  -1.63485788E-02,-2.14098479E-02,-2.85227661E-02,-3.93484005E-02,
     &  -5.70054390E-02,-9.22902961E-02,-1.39690773E-01,-1.47648408E-01,
     &  -1.56476217E-01,-1.66325034E-01,-1.77382653E-01,-1.89885675E-01,
     &  -2.04138189E-01,-2.20532500E-01,-2.39591375E-01,-2.62020364E-01,
     &  -2.88798249E-01,-3.21322540E-01,-3.61659568E-01,-4.12997284E-01,
     &  -4.80522632E-01,-5.73259121E-01,-7.08393585E-01,-9.22941382E-01,
     &  -1.31229568E+00,-2.19314618E+00,-2.50181762E+00,-2.63612779E+00,
     &  -3.01414962E+00,-3.24422760E+00,-3.41085522E+00,-2.95942021E+00,
     &  -2.59700325E+00,-3.91453557E+00,-3.78293794E+00,-2.55862673E-01,
     &  -1.35650968E+00,-1.32488261E+00,-1.30910917E+00,-3.13387524E+00,
     &  -3.11513749E+00,-3.10096497E+00,-3.08669121E+00,-2.93857584E+00,
     &  -2.69951148E+00,-2.41342105E+00,-2.14082352E+00,-2.25630472E+00,
     &  -1.91327372E+00,-1.57430478E+00,-1.37520207E+00,-1.18447911E+00,
     &  -9.71752567E-01,-6.64913273E-01,-4.40881618E-01, 4.03253572E-02,
     &   4.04285422E-02, 4.04629126E-02, 4.04800932E-02, 4.04972707E-02,
     &   4.05144451E-02, 4.05316164E-02, 4.06688755E-02, 4.08401704E-02,
     &   4.10111541E-02, 1.69407165E+00, 2.04573057E+00, 2.64218250E+00,
     &   2.87299917E+00, 3.08938005E+00, 3.25043672E+00, 3.16511252E+00,
     &   3.36771278E+00, 3.55536519E+00, 3.61157277E+00, 3.64335793E+00,
     &   3.65337009E+00, 3.65271210E+00, 3.64121159E+00, 3.62306374E+00/
  
         DATA ((DAS  (I,J), I=1601,1700), J=1,1) /
     &   2.63466039E+00, 3.52728109E+00, 3.48368396E+00, 3.44058464E+00,
     &   3.33243051E+00, 3.27644047E+00, 3.18550485E+00, 3.04012072E+00,
     &   2.52955959E+00, 2.13173492E+00, 1.82995724E+00, 1.59842370E+00,
     &   1.41666341E+00, 1.24451849E+00, 1.08057954E+00, 8.98223843E-01,
     &   8.36743140E-01, 7.83129459E-01, 7.35894513E-01, 6.66064684E-01,
     &   5.53689067E-01, 4.74210678E-01, 4.15068643E-01, 3.69361631E-01,
     &   3.32983198E-01, 3.03349046E-01, 2.78744329E-01, 2.57989819E-01,
     &   2.40249131E-01, 2.24909966E-01, 2.11516071E-01, 1.99720047E-01,
     &   1.89251931E-01, 1.79899017E-01, 1.71493921E-01, 1.19937027E-01,
     &   8.45993992E-02, 6.69377153E-02, 4.93045603E-02, 4.03463864E-02,
     &   3.50296732E-02, 3.14930226E-02, 2.89691302E-02, 2.70769659E-02,
     &   2.56054817E-02, 2.44282616E-02, 2.37603601E-02, 2.29809320E-02,
     &   2.23147911E-02, 2.17388593E-02, 2.12359286E-02, 2.07929061E-02,
     &   1.91868842E-02, 1.81781389E-02, 1.74841439E-02, 1.69760781E-02,
     &   1.65863346E-02, 1.62730953E-02, 1.60235228E-02, 1.58158825E-02,
     &   1.40447253E-02, 1.35525799E-02, 1.34286452E-02, 1.32852202E-02,
     &   1.31145633E-02, 1.29028069E-02, 1.27751565E-02, 1.26282107E-02,
     &   1.22504637E-02, 1.16822110E-02, 1.06948047E-02, 8.45597163E-03,
     &   6.32026720E-03, 5.76929721E-03, 5.13388238E-03, 4.39290770E-03,
     &   3.51753553E-03, 2.46736362E-03, 1.18403223E-03,-4.20170902E-04,
     &  -2.48339890E-03,-5.23681206E-03,-9.10186502E-03,-1.49232295E-02,
     &  -2.45035134E-02,-2.61738243E-02,-2.79960526E-02,-2.99922941E-02,
     &  -3.21889040E-02,-3.46243353E-02,-3.73126168E-02,-4.03272528E-02,
     &  -4.37184213E-02,-4.75622064E-02,-5.19551371E-02,-5.70233020E-02,
     &  -6.29366849E-02,-6.99250151E-02,-7.83097646E-02,-8.85573307E-02/
  
         DATA ((DAS  (I,J), I=1701,1800), J=1,1) /
     &  -9.17568996E-02,-1.01367484E-01,-1.17832385E-01,-1.39783077E-01,
     &  -1.70503515E-01,-2.16552820E-01,-2.93202966E-01,-4.46005131E-01,
     &  -8.97636411E-01,-1.06980699E+00,-1.51466182E+00,-1.73287494E+00,
     &  -2.13176780E+00,-2.37459679E+00,-2.59106029E+00,-2.78724965E+00,
     &  -2.95600519E+00,-3.19397325E+00,-3.26502969E+00, 3.18484116E-02,
     &  -3.54032763E+00,-3.65502753E+00,-3.75248041E+00,-3.83316527E+00,
     &  -2.65876554E+00,-3.96806715E+00,-4.01751663E+00,-4.06280971E+00,
     &  -4.10225200E+00,-4.13280080E+00,-4.20196727E+00,-4.13926577E+00,
     &  -4.11239449E+00,-3.85267915E+00,-3.63324842E+00, 8.67863343E-02,
     &  -3.82192738E+00,-3.65386535E+00,-3.44432216E+00,-3.14648149E+00,
     &  -2.79250401E+00,-2.32433284E+00,-1.77866202E+00, 8.19496378E-01,
     &   1.39235817E-02, 8.25211611E-01, 1.80660973E+00, 2.35424758E+00,
     &   2.82792781E+00, 3.18539598E+00, 2.69002629E+00, 2.98435091E+00,
     &   3.26817449E+00, 3.53777075E+00, 3.74860559E+00, 3.98127207E+00,
     &   4.18767969E+00, 1.58835484E+00, 1.72873632E+00, 1.87491990E+00,
     &   2.98437426E-01, 2.24068339E+00, 2.43727551E+00, 2.64311424E+00,
     &   2.88916750E+00, 3.17801557E+00, 3.47600079E+00, 3.81053622E+00,
     &   3.61059236E+00, 3.33803385E+00, 3.06356823E+00, 2.81934461E+00,
     &   2.63636893E+00, 1.03214354E+00, 2.62721710E+00, 2.39865525E+00,
     &   2.16123322E+00, 1.88035422E+00, 1.54256027E+00, 1.09771026E+00,
     &   9.41935035E-01, 9.12717991E-01, 6.13913947E-01, 7.76367008E-01,
     &   6.86173663E-01, 4.73883771E-01, 3.21106825E-01, 2.44453518E-01,
     &   1.98403193E-01, 1.67686705E-01, 1.45735826E-01, 1.29269196E-01,
     &   1.16461244E-01, 1.06212645E-01, 9.78268482E-02, 9.08390277E-02,
     &   8.49259180E-02, 7.98559465E-02, 7.54634594E-02, 7.16192386E-02/
  
         DATA ((DAS  (I,J), I=1801,1900), J=1,1) /
     &   5.23978424E-02, 4.27869627E-02, 3.70214708E-02, 3.31835269E-02,
     &   3.04298851E-02, 2.83538831E-02, 2.67451845E-02, 2.44078781E-02,
     &   2.27898842E-02, 2.21539674E-02, 2.16026171E-02, 1.96174254E-02,
     &   1.81591900E-02, 1.72821253E-02, 1.66934698E-02, 1.62687076E-02,
     &   1.59458145E-02, 1.56903361E-02, 1.54814636E-02, 1.53053388E-02,
     &   1.50158624E-02, 1.50287021E-02, 1.49180083E-02, 1.48176777E-02,
     &   1.47258436E-02, 1.46410521E-02, 1.45614566E-02, 1.44857675E-02,
     &   1.44126175E-02, 1.43403903E-02, 1.42667009E-02, 1.41851986E-02,
     &   1.41308240E-02, 1.32879602E-02, 1.28771265E-02, 1.25792842E-02,
     &   1.23429488E-02, 1.21477267E-02, 1.21255463E-02, 1.18544227E-02,
     &   1.17277450E-02, 1.16287376E-02, 1.15455161E-02, 1.14765338E-02,
     &   1.14510720E-02, 1.13792368E-02, 1.13493386E-02, 1.13310280E-02,
     &   1.13243065E-02, 1.13286518E-02, 1.13437833E-02, 1.13701122E-02,
     &   1.14001100E-02, 1.14538358E-02, 1.15136054E-02, 1.15824170E-02,
     &   1.16650931E-02, 1.17600112E-02, 1.18696552E-02, 1.19946815E-02,
     &   1.21355573E-02, 1.22925097E-02, 1.24778447E-02, 1.26899738E-02,
     &   1.29349495E-02, 1.32402882E-02, 1.36438659E-02, 1.46302077E-02,
     &   1.55625954E-02, 1.59143950E-02, 1.61693151E-02, 1.63666554E-02,
     &   1.65321231E-02, 1.66722754E-02, 1.67874214E-02, 1.68876423E-02,
     &   1.69736909E-02, 1.70466755E-02, 1.71119402E-02, 1.71567776E-02,
     &   1.71958171E-02, 1.72266934E-02, 1.72475204E-02, 1.72600020E-02,
     &   1.72637434E-02, 1.72587829E-02, 1.72456833E-02, 1.72230621E-02,
     &   1.71911581E-02, 1.71502284E-02, 1.70995543E-02, 1.77441179E-02,
     &   1.75409879E-02, 1.68355063E-02, 1.67820092E-02, 1.66677509E-02,
     &   1.65355635E-02, 1.63785157E-02, 1.61970629E-02, 1.59762358E-02/
  
         DATA ((DAS  (I,J), I=1901,2000), J=1,1) /
     &   1.56986552E-02, 1.53230710E-02, 1.69242379E-02, 1.46324639E-02,
     &   1.44434155E-02, 1.43909414E-02, 1.42761988E-02, 1.42238138E-02,
     &   1.41818496E-02, 1.41470455E-02, 1.41177323E-02, 1.40927228E-02,
     &   1.40588313E-02, 1.40529088E-02, 1.40371972E-02, 1.40239408E-02,
     &   1.40111713E-02, 1.40035756E-02, 1.39964142E-02, 1.39910334E-02,
     &   1.39873506E-02, 1.39853340E-02, 1.39627245E-02, 1.39656921E-02,
     &   1.39892030E-02, 1.39935635E-02, 1.40005881E-02, 1.40092406E-02,
     &   1.40198218E-02, 1.40325587E-02, 1.40476806E-02, 1.40655452E-02,
     &   1.40864233E-02, 1.41111341E-02, 1.41404160E-02, 1.41730007E-02,
     &   1.42207205E-02, 1.42822022E-02, 1.44404845E-02, 1.45599828E-02,
     &   1.46376135E-02, 1.46792355E-02, 1.47129909E-02, 1.47415125E-02,
     &   1.47662770E-02, 1.47879397E-02, 1.48070656E-02, 1.48241232E-02,
     &   1.48392366E-02, 1.48526894E-02, 1.48646371E-02, 1.48751475E-02,
     &   1.48843956E-02, 1.48924584E-02, 1.48992829E-02, 1.49050227E-02,
     &   1.49097110E-02, 1.49133131E-02, 1.49187877E-02, 1.49177288E-02,
     &   1.49181752E-02, 1.49176164E-02, 1.49161579E-02, 1.49136798E-02,
     &   1.49101462E-02, 1.49055424E-02, 1.48997378E-02, 1.48929082E-02,
     &   1.48848809E-02, 1.48862960E-02, 1.48772705E-02, 1.48664341E-02,
     &   1.48533216E-02, 1.48244043E-02, 1.47074844E-02, 1.47331139E-02,
     &   1.47302461E-02, 1.47277869E-02, 1.47257362E-02, 1.47240908E-02,
     &   1.47228443E-02, 1.47219815E-02, 1.47214973E-02, 1.47213854E-02,
     &   1.47194019E-02, 1.47198055E-02, 1.47212098E-02, 1.46771863E-02,
     &   1.46791420E-02, 1.46816224E-02, 1.47289048E-02, 1.47319075E-02,
     &   1.47353698E-02, 1.47393126E-02, 1.47438089E-02, 1.47487810E-02,
     &   1.47543462E-02, 1.47605330E-02, 1.47673689E-02, 1.47749574E-02/
  
         DATA ((DAS  (I,J), I=2001,2100), J=1,1) /
     &   1.47832557E-02, 1.47925559E-02, 1.48029320E-02, 1.48145579E-02,
     &   1.48276278E-02, 1.48427083E-02, 1.48604625E-02, 1.48823041E-02,
     &   1.49116788E-02, 1.49859933E-02, 1.50604121E-02, 1.50906709E-02,
     &   1.51251671E-02, 1.51468276E-02, 1.51655200E-02, 1.51559744E-02,
     &   1.51688226E-02, 1.51805208E-02, 1.51912381E-02, 1.52010340E-02,
     &   1.52102368E-02, 1.52187833E-02, 1.52267904E-02, 1.52342838E-02,
     &   1.52412598E-02, 1.52478525E-02, 1.52539735E-02, 1.52596297E-02,
     &   1.52653267E-02, 1.52701747E-02, 1.52744785E-02, 1.52787375E-02,
     &   1.52826620E-02, 1.52862932E-02, 1.52896295E-02, 1.52926705E-02,
     &   1.52954150E-02, 1.52978876E-02, 1.53000656E-02, 1.53019695E-02,
     &   1.53047743E-02, 1.53057983E-02, 1.53065566E-02, 1.53070115E-02,
     &   1.53070963E-02, 1.53031365E-02, 1.52622780E-02, 1.52058859E-02,
     &   1.52028378E-02, 1.51778021E-02, 1.51587653E-02, 1.51398401E-02,
     &   1.51245254E-02, 1.51094072E-02, 1.50952794E-02, 1.50796196E-02,
     &   1.50630206E-02, 1.50459393E-02, 1.50244117E-02, 1.50028842E-02,
     &   1.50266621E-02, 1.50495298E-02, 1.50699570E-02, 1.50901359E-02,
     &   1.51085371E-02, 1.51270093E-02, 1.51440711E-02, 1.51613754E-02,
     &   1.51782163E-02, 1.51939519E-02, 1.52100634E-02, 1.52251891E-02,
     &   1.52407380E-02, 1.52553850E-02, 1.52704854E-02, 1.52847451E-02,
     &   1.52994777E-02, 1.53134159E-02, 1.53278396E-02, 1.53415050E-02,
     &   1.53550510E-02, 1.53690934E-02, 1.53824182E-02, 1.53962433E-02,
     &   1.54093721E-02, 1.54230034E-02, 1.54359564E-02, 1.54494127E-02,
     &   1.54622059E-02, 1.54755026E-02, 1.54881494E-02, 1.55012990E-02,
     &   1.55143776E-02, 1.55268235E-02, 1.55397704E-02, 1.55520944E-02,
     &   1.55649177E-02, 1.55771271E-02, 1.55898341E-02, 1.56019352E-02/
  
         DATA ((DAS  (I,J), I=2101,2174), J=1,1) /
     &   1.56145319E-02, 1.56265303E-02, 1.56390224E-02, 1.56509229E-02,
     &   1.56627773E-02, 1.56751222E-02, 1.56868851E-02, 1.56991364E-02,
     &   1.57108116E-02, 1.57206571E-02, 1.57323026E-02, 1.57444389E-02,
     &   1.57560113E-02, 1.57680724E-02, 1.57795742E-02, 1.57915627E-02,
     &   1.58035150E-02, 1.58149141E-02, 1.58267970E-02, 1.58381308E-02,
     &   1.58499463E-02, 1.58612165E-02, 1.58729664E-02, 1.58842727E-02,
     &   1.58960522E-02, 1.59072015E-02, 1.59188260E-02, 1.59299154E-02,
     &   1.59414781E-02, 1.59525090E-02, 1.59635116E-02, 1.59749845E-02,
     &   1.59859304E-02, 1.59973446E-02, 1.60082348E-02, 1.60195913E-02,
     &   1.60304269E-02, 1.60779700E-02, 1.60887390E-02, 1.60999485E-02,
     &   1.61106241E-02, 1.61217367E-02, 1.62055715E-02, 1.63224819E-02,
     &   1.63409255E-02, 1.71707339E-02, 1.75484160E-02, 1.85474405E-02,
     &   1.92208853E-02, 1.91395117E-02, 1.98972951E-02, 1.98997016E-02,
     &   2.04695212E-02, 2.04913122E-02, 2.05043678E-02, 2.07877388E-02,
     &   2.09765627E-02, 2.10104570E-02, 2.10658587E-02, 2.11479847E-02,
     &   2.12059392E-02, 2.12423432E-02, 2.15957528E-02, 2.16136916E-02,
     &   2.17216627E-02, 2.17409777E-02, 2.20377576E-02, 2.18592530E-02,
     &   2.19188503E-02, 2.19448719E-02, 2.19866792E-02, 2.20948995E-02,
     &   2.21409075E-02, 2.24454539E-02/
  
         DATA ((DAS  (I,J), I=   1, 100), J=2,2) /
     &   5.17063442E-06, 5.49380474E-06, 5.83033264E-06, 6.19522402E-06,
     &   6.60771661E-06, 6.77315445E-06, 7.80982455E-06, 7.98528463E-06,
     &   8.45855917E-06, 8.96274656E-06, 8.81332892E-06, 8.74303700E-06,
     &   8.70314775E-06, 8.84809466E-06, 9.07057823E-06, 9.34997639E-06,
     &   9.60875051E-06, 9.82970768E-06, 1.00092065E-05, 1.02953820E-05,
     &   1.05491360E-05, 1.08333124E-05, 1.10471322E-05, 1.13249618E-05,
     &   1.15791395E-05, 1.18795349E-05, 1.22868518E-05, 1.24982862E-05,
     &   1.25978618E-05, 1.28999674E-05, 1.32157141E-05, 1.34946768E-05,
     &   1.38351271E-05, 1.41800266E-05, 1.45375398E-05, 1.49115328E-05,
     &   1.52982426E-05, 1.57352816E-05, 1.61672680E-05, 1.66126771E-05,
     &   1.69973999E-05, 1.75048445E-05, 1.80555381E-05, 1.85233622E-05,
     &   1.92345180E-05, 2.01680852E-05, 2.09197152E-05, 2.14457357E-05,
     &   2.17065589E-05, 2.19574380E-05, 2.54013406E-05, 2.94444614E-05,
     &   3.50691527E-05, 4.16631634E-05, 4.60952359E-05, 4.71102149E-05,
     &   4.83248170E-05, 4.92464960E-05, 5.09822082E-05, 5.14440044E-05,
     &   5.24724569E-05, 5.28875290E-05, 5.39036731E-05, 5.56673836E-05,
     &   5.77884262E-05, 6.01011736E-05, 6.18409392E-05, 6.37588810E-05,
     &   6.46285422E-05, 6.61525068E-05, 6.76199866E-05, 6.72297845E-05,
     &   6.92356076E-05, 7.20781345E-05, 7.55034543E-05, 8.04400125E-05,
     &   8.64097136E-05, 9.69794550E-05, 1.11355848E-04, 1.32265925E-04,
     &   1.51894477E-04, 1.58554165E-04, 1.69880263E-04, 1.81494223E-04,
     &   2.04370530E-04, 2.43637844E-04, 2.75302534E-04, 3.00828902E-04,
     &   3.23293838E-04, 3.42862480E-04, 3.59748620E-04, 3.74825132E-04,
     &   3.87947041E-04, 3.97614216E-04, 4.06904449E-04, 4.20333447E-04,
     &   4.26135074E-04, 4.28889700E-04, 4.31269383E-04, 4.32442697E-04/
  
         DATA ((DAS  (I,J), I= 101, 200), J=2,2) /
     &   4.32262424E-04, 4.30940488E-04, 4.28487506E-04, 4.24855575E-04,
     &   4.20339350E-04, 4.13911303E-04, 4.05945409E-04, 3.96337001E-04,
     &   3.84854660E-04, 3.71402140E-04, 3.55713187E-04, 3.37144941E-04,
     &   3.15362957E-04, 2.89595618E-04, 2.58419036E-04, 2.19212720E-04,
     &   1.66612278E-04, 6.66670322E-05, 1.52815038E-04, 2.05720573E-04,
     &   2.45649967E-04, 2.77802841E-04, 3.04735456E-04, 3.27735268E-04,
     &   3.47457747E-04, 3.64303935E-04, 3.78820692E-04, 3.91388589E-04,
     &   4.02123591E-04, 4.11171957E-04, 4.18686001E-04, 4.43578593E-04,
     &   4.29628311E-04, 4.33820481E-04, 4.36172695E-04, 4.36773160E-04,
     &   4.35412370E-04, 4.32529977E-04, 4.30143512E-04, 4.23432162E-04,
     &   4.19629114E-04, 4.13147506E-04, 4.05708847E-04, 3.97114305E-04,
     &   3.87488255E-04, 3.74606361E-04, 3.59783251E-04, 3.42898485E-04,
     &   3.23333116E-04, 3.00725418E-04, 2.74179116E-04, 2.43164192E-04,
     &   2.35872435E-04, 2.14848056E-04, 1.95941761E-04, 1.82066870E-04,
     &   1.71307072E-04, 1.64375167E-04, 1.43354850E-04, 1.30245981E-04,
     &   1.21627312E-04, 1.10192379E-04, 1.05712403E-04, 1.01128926E-04,
     &   9.69521177E-05, 9.31447006E-05, 8.98875566E-05, 8.83596970E-05,
     &   8.13182595E-05, 7.64530966E-05, 7.28818373E-05, 7.06447273E-05,
     &   6.92776315E-05, 6.82472778E-05, 6.75343682E-05, 6.71069575E-05,
     &   6.67706253E-05, 6.68851465E-05, 6.74897853E-05, 6.79641500E-05,
     &   6.91599233E-05, 6.98185401E-05, 7.16045392E-05, 7.33696038E-05,
     &   7.60809053E-05, 7.87336073E-05, 8.25649268E-05, 8.61410088E-05,
     &   9.04828731E-05, 9.65727395E-05, 1.00163235E-04, 1.02717872E-04,
     &   1.08428090E-04, 1.11485319E-04, 1.14626181E-04, 1.18338761E-04,
     &   1.22586089E-04, 1.27475448E-04, 1.32492388E-04, 1.42718801E-04/
  
         DATA ((DAS  (I,J), I= 201, 300), J=2,2) /
     &   1.54758526E-04, 1.62230042E-04, 1.65096805E-04, 1.68099043E-04,
     &   1.71240262E-04, 1.74525877E-04, 1.77962929E-04, 1.81545914E-04,
     &   1.85271053E-04, 1.89176088E-04, 1.93269754E-04, 1.97564820E-04,
     &   2.02070894E-04, 2.06780784E-04, 2.11724048E-04, 2.16945298E-04,
     &   2.22452981E-04, 2.28273454E-04, 2.34447859E-04, 2.41019253E-04,
     &   2.48038732E-04, 2.55567684E-04, 2.63685284E-04, 2.72491812E-04,
     &   2.82119998E-04, 2.92755998E-04, 3.04690217E-04, 3.18437142E-04,
     &   3.35219681E-04, 3.59967576E-04, 3.84187655E-04, 4.17572140E-04,
     &   3.77056410E-04, 3.77525798E-04, 3.86231867E-04, 3.97864213E-04,
     &   4.12380354E-04, 4.28295201E-04, 4.47457308E-04, 4.65814733E-04,
     &   4.87704405E-04, 5.11992606E-04, 5.34243230E-04, 6.00016467E-04,
     &   6.02879082E-04, 6.40854527E-04, 6.83809999E-04, 7.32671601E-04,
     &   7.88577980E-04, 8.52920181E-04, 9.27301055E-04, 1.01364619E-03,
     &   1.11368213E-03, 1.21063443E-03, 1.26366524E-03, 1.29974564E-03,
     &   1.34962222E-03, 1.37367759E-03, 1.35907049E-03, 1.44785540E-03,
     &   1.48329709E-03, 1.51553902E-03, 1.54409002E-03, 1.56674118E-03,
     &   1.58099059E-03, 1.58370232E-03, 1.55851441E-03, 1.51350022E-03,
     &   1.48147013E-03, 1.39416272E-03, 1.27171359E-03, 1.11027137E-03,
     &   8.46201188E-04, 6.70224528E-04, 4.02832771E-04, 1.33238261E-04,
     &   2.09932206E-04, 4.85425493E-04, 7.44925534E-04, 9.72322628E-04,
     &   1.16131022E-03, 1.31085573E-03, 1.42208105E-03, 1.50000683E-03,
     &   1.54970614E-03, 1.57628135E-03, 1.58465836E-03, 1.57906508E-03,
     &   1.56303787E-03, 1.53945756E-03, 1.49524858E-03, 1.48284635E-03,
     &   1.42019894E-03, 1.40465700E-03, 1.37112331E-03, 1.33473131E-03,
     &   1.29889788E-03, 1.26374283E-03, 1.22941826E-03, 1.19602616E-03/
  
         DATA ((DAS  (I,J), I= 301, 400), J=2,2) /
     &   1.19156110E-03, 1.13286783E-03, 1.10301363E-03, 1.07433304E-03,
     &   9.82902537E-04, 9.04078095E-04, 8.36164281E-04, 7.77248467E-04,
     &   7.25896300E-04, 6.70738174E-04, 6.41242976E-04, 6.06129020E-04,
     &   5.74889275E-04, 5.46984670E-04, 5.21977599E-04, 4.99515568E-04,
     &   4.79320310E-04, 4.61154501E-04, 4.44844030E-04, 4.30288173E-04,
     &   4.15849182E-04, 4.04894473E-04, 4.08863711E-04, 3.92291004E-04,
     &   4.03177884E-04, 4.83854993E-04, 4.72526143E-04, 3.77220382E-04,
     &   3.48640013E-04, 3.30248163E-04, 3.16370123E-04, 3.04832684E-04,
     &   2.95229567E-04, 2.86166772E-04, 2.78049368E-04, 2.70786870E-04,
     &   2.63988386E-04, 2.57622519E-04, 2.51778165E-04, 2.46003557E-04,
     &   2.40637955E-04, 2.35535535E-04, 2.30554873E-04, 2.25857558E-04,
     &   2.21378362E-04, 2.17137323E-04, 2.13071424E-04, 2.09188525E-04,
     &   2.05483884E-04, 2.01944079E-04, 1.98572281E-04, 1.95324695E-04,
     &   1.92202683E-04, 1.89197889E-04, 1.86377360E-04, 1.83633095E-04,
     &   1.76347414E-04, 1.61016725E-04, 1.39884923E-04, 1.27156823E-04,
     &   1.18820189E-04, 1.13325848E-04, 1.09982357E-04, 1.08151159E-04,
     &   1.07051958E-04, 1.06927822E-04, 1.07141850E-04, 1.08932900E-04,
     &   1.09580665E-04, 1.11282607E-04, 1.13697880E-04, 1.13836085E-04,
     &   1.16324914E-04, 1.19665391E-04, 1.21224090E-04, 1.23491157E-04,
     &   1.27508688E-04, 1.32324005E-04, 1.37727588E-04, 1.43858189E-04,
     &   1.47436906E-04, 1.50396061E-04, 1.57407960E-04, 1.65743644E-04,
     &   1.66506659E-04, 1.74685002E-04, 1.84914880E-04, 1.90150588E-04,
     &   1.96139504E-04, 2.08596737E-04, 2.23552223E-04, 2.42269227E-04,
     &   2.48411603E-04, 2.64643973E-04, 2.76979120E-04, 2.90975972E-04,
     &   3.24313894E-04, 3.72450492E-04, 3.78403971E-04, 4.34376858E-04/
  
         DATA ((DAS  (I,J), I= 401, 500), J=2,2) /
     &   5.42685258E-04, 5.50871186E-04, 4.64089686E-04, 3.82677907E-04,
     &   3.74613664E-04, 3.17484067E-04, 3.05115321E-04, 2.98847867E-04,
     &   2.89124470E-04, 2.71196593E-04, 2.55091050E-04, 2.38058865E-04,
     &   2.36828899E-04, 2.23045137E-04, 2.20008775E-04, 2.06881791E-04,
     &   1.98874552E-04, 1.70171861E-04, 1.67009634E-04, 1.53333570E-04,
     &   1.52861199E-04, 1.52896074E-04, 1.44864998E-04, 1.32974305E-04,
     &   1.29392180E-04, 1.22914020E-04, 1.22481703E-04, 1.26434273E-04,
     &   1.26359421E-04, 1.23345204E-04, 1.25581785E-04, 1.19486337E-04,
     &   1.20463407E-04, 1.20649501E-04, 1.24897406E-04, 1.22319182E-04,
     &   1.22753065E-04, 1.25514125E-04, 1.28564661E-04, 1.40145748E-04,
     &   1.49385129E-04, 1.54935849E-04, 1.56612703E-04, 1.58532816E-04,
     &   1.76102297E-04, 1.79337341E-04, 1.92181177E-04, 1.92153805E-04,
     &   1.96037962E-04, 1.98911027E-04, 2.17378038E-04, 2.20692721E-04,
     &   2.22711495E-04, 2.35274254E-04, 2.38590033E-04, 2.41844774E-04,
     &   2.64667971E-04, 2.68995503E-04, 2.80369420E-04, 2.86173312E-04,
     &   2.93853729E-04, 2.94525802E-04, 2.98212038E-04, 2.99749072E-04,
     &   3.02352773E-04, 3.07112962E-04, 3.11526454E-04, 3.17471829E-04,
     &   3.29809373E-04, 3.45002912E-04, 3.47839047E-04, 3.87069707E-04,
     &   4.21892141E-04, 4.59398779E-04, 4.66892392E-04, 5.11296529E-04,
     &   5.12957288E-04, 5.13890751E-04, 5.20207932E-04, 4.72852093E-04,
     &   4.61514570E-04, 4.07547632E-04, 3.91881408E-04, 3.81271243E-04,
     &   3.54280970E-04, 3.36398910E-04, 3.34493351E-04, 3.34272961E-04,
     &   3.30635151E-04, 3.31024957E-04, 3.31429749E-04, 3.31791120E-04,
     &   3.33497958E-04, 3.34674726E-04, 3.34631707E-04, 3.34755815E-04,
     &   3.41906689E-04, 3.45929967E-04, 3.42937768E-04, 2.85909332E-04/
  
         DATA ((DAS  (I,J), I= 501, 600), J=2,2) /
     &   2.55216991E-04, 2.37483505E-04, 2.21964603E-04, 2.14629938E-04,
     &   2.11486867E-04, 2.04272997E-04, 1.98188253E-04, 1.96196662E-04,
     &   1.98298973E-04, 2.04391348E-04, 2.14301524E-04, 2.28861631E-04,
     &   2.49954472E-04, 2.81091707E-04, 3.28086974E-04, 4.01993902E-04,
     &   4.22386779E-04, 4.44397912E-04, 4.69700988E-04, 4.98573183E-04,
     &   5.31633677E-04, 5.69705938E-04, 6.14205367E-04, 6.23951956E-04,
     &   6.34059319E-04, 6.44532240E-04, 6.55382596E-04, 6.66627473E-04,
     &   6.78152543E-04, 6.90117516E-04, 7.02544302E-04, 7.15460330E-04,
     &   7.28870569E-04, 7.96209178E-04, 8.48604949E-04, 8.77526452E-04,
     &   8.97908197E-04, 9.19262860E-04, 9.41677204E-04, 9.65204859E-04,
     &   9.89939455E-04, 1.01597228E-03, 1.02950870E-03, 1.04341515E-03,
     &   1.05769888E-03, 1.07238291E-03, 1.08747633E-03, 1.10300389E-03,
     &   1.11897686E-03, 1.13542189E-03, 1.15235257E-03, 1.16979780E-03,
     &   1.18777389E-03, 1.20630930E-03, 1.22543016E-03, 1.24516433E-03,
     &   1.26554145E-03, 1.28659316E-03, 1.30835320E-03, 1.33085766E-03,
     &   1.35414492E-03, 1.37825640E-03, 1.40323626E-03, 1.42913192E-03,
     &   1.45599434E-03, 1.48387832E-03, 1.51284289E-03, 1.54295177E-03,
     &   1.57427375E-03, 1.60688322E-03, 1.64086077E-03, 1.67629388E-03,
     &   1.71327843E-03, 1.75191733E-03, 1.79232357E-03, 1.83462072E-03,
     &   1.87894412E-03, 1.92544236E-03, 1.97427891E-03, 2.02563403E-03,
     &   2.07970703E-03, 2.13671880E-03, 2.16640211E-03, 2.19691483E-03,
     &   2.22829097E-03, 2.26056874E-03, 2.29378634E-03, 2.32798642E-03,
     &   2.36321201E-03, 2.39951092E-03, 2.43693177E-03, 2.47552832E-03,
     &   2.51535569E-03, 2.55647462E-03, 2.59894780E-03, 2.64284412E-03,
     &   2.68823520E-03, 2.73519953E-03, 2.78381922E-03, 2.83418414E-03/
  
         DATA ((DAS  (I,J), I= 601, 700), J=2,2) /
     &   2.88638870E-03, 2.94053680E-03, 2.99673751E-03, 3.05511023E-03,
     &   3.11578315E-03, 3.17889475E-03, 3.24459485E-03, 3.31304580E-03,
     &   3.38442381E-03, 3.45892050E-03, 3.53674455E-03, 3.61812369E-03,
     &   3.70330694E-03, 3.79256703E-03, 3.88620338E-03, 3.98454601E-03,
     &   4.08795808E-03, 4.19684201E-03, 4.31164308E-03, 4.43285710E-03,
     &   4.61439374E-03, 4.69679776E-03, 4.84083485E-03, 4.99392759E-03,
     &   5.15695664E-03, 5.33092167E-03, 5.51696010E-03, 5.71637371E-03,
     &   5.93065746E-03, 6.16153866E-03, 6.41102197E-03, 6.68144934E-03,
     &   6.97557216E-03, 7.21037034E-03, 7.94184362E-03, 8.83764634E-03,
     &   9.96014140E-03, 1.14078164E-02, 1.33458660E-02, 1.60741774E-02,
     &   2.01997312E-02, 2.71648222E-02, 4.14363767E-02, 8.71294888E-02,
     &   9.21342003E-02, 9.77466148E-02, 1.04084130E-01, 1.11296321E-01,
     &   1.19576715E-01, 1.29180104E-01, 1.40448679E-01, 1.53852642E-01,
     &   1.70055489E-01, 1.90023088E-01, 2.15214236E-01, 2.47931128E-01,
     &   2.92001996E-01, 2.97256392E-01, 4.14909046E-01, 5.00662499E-01,
     &   5.69560448E-01, 6.29480540E-01, 6.75653764E-01, 7.15997473E-01,
     &   7.48330144E-01, 7.80540645E-01, 8.02667349E-01, 8.23154848E-01,
     &   8.37611564E-01, 8.49529499E-01, 8.56226789E-01, 8.61225875E-01,
     &   8.61650970E-01, 8.59135037E-01, 8.52157952E-01, 8.44617370E-01,
     &   8.28306993E-01, 8.13693027E-01, 7.95754524E-01, 7.74209317E-01,
     &   7.48786728E-01, 7.19237829E-01, 6.85347385E-01, 6.46947226E-01,
     &   6.03930554E-01, 5.56266477E-01, 5.04013787E-01, 4.17411809E-01,
     &   3.54631319E-01, 2.53995190E-01, 1.47366067E-01, 1.47264383E-01,
     &   4.17322768E-01, 5.03931902E-01, 5.80604118E-01, 6.25951557E-01,
     &   6.85287795E-01, 7.19184080E-01, 7.48738789E-01, 7.74167104E-01/
  
         DATA ((DAS  (I,J), I= 701, 800), J=2,2) /
     &   7.95717909E-01, 8.13661850E-01, 8.28281069E-01, 8.39860717E-01,
     &   8.48682199E-01, 8.55018013E-01, 8.59127993E-01, 8.61650089E-01,
     &   8.61228831E-01, 8.57946695E-01, 8.52016778E-01, 8.46853579E-01,
     &   8.34224065E-01, 8.23180468E-01, 8.06957498E-01, 7.89563396E-01,
     &   7.66869619E-01, 7.43734582E-01, 7.11473887E-01, 6.80086822E-01,
     &   6.41739387E-01, 5.98489693E-01, 5.42860252E-01, 4.79088696E-01,
     &   3.99460100E-01, 3.29166150E-01, 2.74563526E-01, 2.35164060E-01,
     &   2.05498059E-01, 1.82398800E-01, 1.63923711E-01, 1.48821123E-01,
     &   1.36250621E-01, 1.25628029E-01, 1.16535181E-01, 1.08665119E-01,
     &   1.01787570E-01, 9.57264858E-02, 9.03450127E-02, 8.55351900E-02,
     &   8.12107228E-02, 7.73018187E-02, 7.37514302E-02, 3.86730993E-02,
     &   2.62109568E-02, 1.98271313E-02, 1.59468628E-02, 1.33389616E-02,
     &   1.14658028E-02, 1.00552485E-02, 8.95478340E-03, 8.07229556E-03,
     &   7.34886848E-03, 7.26318900E-03, 6.66576517E-03, 6.15969276E-03,
     &   5.72551442E-03, 5.34893221E-03, 5.01920386E-03, 4.72810216E-03,
     &   4.46921961E-03, 4.23749167E-03, 4.02886246E-03, 3.84004555E-03,
     &   3.66834976E-03, 3.51155022E-03, 3.36779157E-03, 3.23551432E-03,
     &   3.11339811E-03, 3.00031759E-03, 2.89530775E-03, 2.79753624E-03,
     &   2.70628131E-03, 2.62091427E-03, 2.54088469E-03, 2.46570875E-03,
     &   2.39495932E-03, 2.32825805E-03, 2.26526853E-03, 2.20569062E-03,
     &   2.14925571E-03, 2.09572268E-03, 2.04487449E-03, 1.99651521E-03,
     &   1.95046757E-03, 1.90657074E-03, 1.86467848E-03, 1.82465755E-03,
     &   1.78638627E-03, 1.74975313E-03, 1.71465656E-03, 1.68100230E-03,
     &   1.64870428E-03, 1.61768290E-03, 1.58786498E-03, 1.55918256E-03,
     &   1.53157282E-03, 1.50497749E-03, 1.47934249E-03, 1.45461752E-03/
  
         DATA ((DAS  (I,J), I= 801, 900), J=2,2) /
     &   1.43075574E-03, 1.40771351E-03, 1.38545011E-03, 1.36392756E-03,
     &   1.34311014E-03, 1.32296458E-03, 1.30345964E-03, 1.28456604E-03,
     &   1.26625626E-03, 1.24850444E-03, 1.23128627E-03, 1.21457886E-03,
     &   1.19836037E-03, 1.18261129E-03, 1.16731163E-03, 1.15244356E-03,
     &   1.13798999E-03, 1.12393478E-03, 1.11026267E-03, 1.09695925E-03,
     &   1.08401042E-03, 1.07140419E-03, 1.05912795E-03, 1.04717020E-03,
     &   1.03552009E-03, 1.02416740E-03, 1.01310250E-03, 1.00231637E-03,
     &   9.91800595E-04, 9.81547338E-04, 9.71549384E-04, 9.61800166E-04,
     &   9.52293811E-04, 9.43025226E-04, 9.33990222E-04, 9.25185693E-04,
     &   9.16614824E-04, 9.08024792E-04, 8.99626832E-04, 8.91416029E-04,
     &   8.83388010E-04, 8.75528292E-04, 8.67876507E-04, 8.60371041E-04,
     &   8.53057088E-04, 8.46701699E-04, 8.38459417E-04, 8.31468342E-04,
     &   8.24607316E-04, 8.17888791E-04, 8.11293590E-04, 8.04820746E-04,
     &   7.98482471E-04, 7.92260704E-04, 7.86152331E-04, 7.80159819E-04,
     &   6.06582580E-04, 4.98792109E-04, 4.40546752E-04, 4.58717895E-04,
     &   5.25088807E-04, 5.71076787E-04, 6.34078035E-04, 7.21600285E-04,
     &   8.10816798E-04, 9.30761519E-04, 9.80383429E-04, 1.09676255E-03,
     &   1.16681373E-03, 1.24714595E-03, 1.33931283E-03, 1.44736087E-03,
     &   1.57529312E-03, 1.72882323E-03, 1.91620315E-03, 2.14975081E-03,
     &   2.44859876E-03, 2.59284550E-03, 2.75517787E-03, 2.93918957E-03,
     &   3.14951186E-03, 3.39219656E-03, 3.67529153E-03, 3.83527596E-03,
     &   4.00977793E-03, 4.20085989E-03, 4.41099908E-03, 4.64318737E-03,
     &   4.90108198E-03, 5.18919228E-03, 5.51315162E-03, 5.88008275E-03,
     &   6.29913254E-03, 6.78223850E-03, 7.34528718E-03, 7.98101271E-03,
     &   8.39721035E-03, 8.85904478E-03, 9.37445140E-03, 9.95331838E-03/
  
         DATA ((DAS  (I,J), I= 901,1000), J=2,2) /
     &   1.06081258E-02, 1.13548547E-02, 1.22143061E-02, 1.32140658E-02,
     &   1.43915145E-02, 1.57985944E-02, 1.75096585E-02, 1.96350024E-02,
     &   2.23455319E-02, 2.59209306E-02, 3.08522842E-02, 3.80872723E-02,
     &   4.97162324E-02, 7.13972158E-02, 1.05497229E-01, 1.24905585E-01,
     &   1.46075193E-01, 1.98162313E-01, 2.16928058E-01, 2.32415839E-01,
     &   2.45568555E-01, 2.56643891E-01, 2.65730636E-01, 2.73554805E-01,
     &   2.79961276E-01, 2.84546395E-01, 2.88441648E-01, 2.91199140E-01,
     &   2.92834663E-01, 2.93425364E-01, 2.93005888E-01, 2.91859676E-01,
     &   2.89533464E-01, 2.86489503E-01, 2.82386411E-01, 2.77107268E-01,
     &   2.71556209E-01, 2.63778800E-01, 2.55915673E-01, 2.46878135E-01,
     &   2.36608182E-01, 2.23006578E-01, 2.09922775E-01, 1.92976997E-01,
     &   1.77021564E-01, 1.53759311E-01, 1.28372179E-01, 9.04548667E-02,
     &   5.74035584E-02, 1.93339000E-02, 2.65393795E-04, 1.92373502E-02,
     &   3.83960193E-02, 9.03633423E-02, 1.28286229E-01, 1.53678391E-01,
     &   1.76946313E-01, 1.92906319E-01, 2.09857682E-01, 2.22946412E-01,
     &   2.36553848E-01, 2.46828813E-01, 2.55871331E-01, 2.63739367E-01,
     &   2.71522375E-01, 2.77078094E-01, 2.82362489E-01, 2.86470615E-01,
     &   2.89519377E-01, 2.91850783E-01, 2.93001283E-01, 2.93425925E-01,
     &   2.92840009E-01, 2.91209380E-01, 2.88456790E-01, 2.84566354E-01,
     &   2.79985555E-01, 2.73583861E-01, 2.65764381E-01, 2.56682107E-01,
     &   2.45611291E-01, 2.32463033E-01, 2.16979607E-01, 1.98218200E-01,
     &   1.75473434E-01, 1.87821765E-01, 1.60670648E-01, 1.43947229E-01,
     &   1.33836801E-01, 1.12892643E-01, 1.05565734E-01, 8.97933348E-02,
     &   5.81416083E-02, 4.28990427E-02, 3.39699622E-02, 2.81126862E-02,
     &   2.39770637E-02, 2.09021588E-02, 1.85266549E-02, 1.66364839E-02/
  
         DATA ((DAS  (I,J), I=1001,1100), J=2,2) /
     &   1.50967980E-02, 1.38184453E-02, 1.27401334E-02, 1.18183409E-02,
     &   1.10213133E-02, 1.03253388E-02, 9.71235581E-03, 9.16836338E-03,
     &   8.68234251E-03, 8.24550090E-03, 7.55496383E-03, 6.69302158E-03,
     &   6.23203310E-03, 5.47876502E-03, 4.88936640E-03, 4.31148142E-03,
     &   3.49107996E-03, 2.58869494E-03, 2.05533469E-03, 1.83358169E-03,
     &   1.70951939E-03, 1.62897413E-03, 1.57202905E-03, 1.52918763E-03,
     &   1.49556596E-03, 1.46827684E-03, 1.44549303E-03, 1.42603581E-03,
     &   1.40911616E-03, 1.39412545E-03, 1.38065255E-03, 1.36837818E-03,
     &   1.35705672E-03, 1.34648316E-03, 1.33648863E-03, 1.32698986E-03,
     &   1.31783366E-03, 1.30893901E-03, 1.30023268E-03, 1.29164463E-03,
     &   1.28308136E-03, 1.27448373E-03, 1.26576058E-03, 1.25685678E-03,
     &   1.24765415E-03, 1.23803973E-03, 1.22783005E-03, 1.21682668E-03,
     &   1.20463738E-03, 1.19054400E-03, 1.17275738E-03, 1.13275495E-03,
     &   1.09819012E-03, 1.08598632E-03, 1.07802296E-03, 1.07221714E-03,
     &   1.06781711E-03, 1.06443266E-03, 1.06180180E-03, 1.05973786E-03,
     &   1.05810083E-03, 1.05669617E-03, 1.05568637E-03, 1.05474886E-03,
     &   1.05400370E-03, 1.05381937E-03, 1.06613187E-03, 1.05159136E-03,
     &   1.04914529E-03, 1.04688794E-03, 1.04425254E-03, 1.04100204E-03,
     &   1.03699154E-03, 1.03203202E-03, 1.02599809E-03, 1.01871757E-03,
     &   1.00994537E-03, 9.99520095E-04, 9.86951863E-04, 9.71694091E-04,
     &   9.53543134E-04, 9.31683929E-04, 9.05230767E-04, 8.71914610E-04,
     &   8.29008010E-04, 7.68983424E-04, 7.51383900E-04, 7.01997152E-04,
     &   6.31497847E-04, 6.24698371E-04, 5.79396220E-04, 5.63962099E-04,
     &   5.51867789E-04, 5.37660801E-04, 5.24762822E-04, 5.12202497E-04,
     &   5.04432338E-04, 5.00298527E-04, 4.89258309E-04, 4.78650317E-04/
  
         DATA ((DAS  (I,J), I=1101,1200), J=2,2) /
     &   4.69060897E-04, 4.60048043E-04, 4.51875045E-04, 4.44075067E-04,
     &   4.36614688E-04, 4.31142256E-04, 4.24344031E-04, 4.11109733E-04,
     &   4.05218555E-04, 4.00047119E-04, 3.95088571E-04, 3.89614515E-04,
     &   3.84527299E-04, 3.79869436E-04, 3.79458743E-04, 3.76693381E-04,
     &   3.70551205E-04, 3.64901570E-04, 3.64389856E-04, 3.64038412E-04,
     &   3.63659549E-04, 3.62510550E-04, 3.59689675E-04, 3.64273038E-04,
     &   3.71053715E-04, 4.03372636E-04, 4.37851061E-04, 4.11970587E-04,
     &   3.44407495E-04, 3.46238226E-04, 3.43630592E-04, 3.57443271E-04,
     &   3.50494024E-04, 3.40316776E-04, 3.29161559E-04, 3.24343927E-04,
     &   3.19918325E-04, 3.16970197E-04, 3.16304179E-04, 3.13033532E-04,
     &   3.10055919E-04, 3.09250524E-04, 3.08676250E-04, 3.07416846E-04,
     &   3.07166467E-04, 3.05895323E-04, 3.04639074E-04, 3.02126206E-04,
     &   3.00055932E-04, 3.00787730E-04, 3.00196535E-04, 3.01498016E-04,
     &   3.01986910E-04, 3.21195766E-04, 3.32996452E-04, 3.29305489E-04,
     &   3.19423978E-04, 3.13389732E-04, 2.98529407E-04, 2.91280351E-04,
     &   3.03719544E-04, 3.24685716E-04, 3.23793170E-04, 2.89786873E-04,
     &   2.89112585E-04, 2.86349922E-04, 2.88543018E-04, 2.80906713E-04,
     &   2.78632116E-04, 2.79628732E-04, 2.78246142E-04, 2.73966129E-04,
     &   2.72845649E-04, 2.71573653E-04, 2.72527775E-04, 2.69772925E-04,
     &   2.66475133E-04, 2.64982570E-04, 2.74201147E-04, 2.77657178E-04,
     &   2.79666755E-04, 2.84065913E-04, 2.58627695E-04, 2.63782827E-04,
     &   2.74342981E-04, 2.69870828E-04, 2.69362258E-04, 2.74348425E-04,
     &   2.75063127E-04, 2.77672836E-04, 2.75440579E-04, 2.57033507E-04,
     &   2.74451101E-04, 3.45584565E-04, 3.09197119E-04, 2.61528568E-04,
     &   2.57213229E-04, 2.54122720E-04, 2.50095909E-04, 2.46450635E-04/
  
         DATA ((DAS  (I,J), I=1201,1300), J=2,2) /
     &   2.47171575E-04, 2.47239176E-04, 2.50252494E-04, 2.48164442E-04,
     &   2.48090723E-04, 2.50495553E-04, 2.46898352E-04, 2.51180006E-04,
     &   2.60509606E-04, 2.89783590E-04, 2.85220858E-04, 2.79596871E-04,
     &   3.01712331E-04, 2.61344145E-04, 2.52883297E-04, 2.55488573E-04,
     &   2.80846875E-04, 2.79074811E-04, 3.08716181E-04, 3.10461804E-04,
     &   3.69438396E-04, 4.49930545E-04, 4.49133963E-04, 7.34755353E-04,
     &   7.68692841E-04, 3.89968126E-04, 3.26810177E-04, 2.68993123E-04,
     &   2.22714217E-04, 2.10504223E-04, 2.01456035E-04, 1.88744330E-04,
     &   1.80066697E-04, 1.76641191E-04, 1.73649195E-04, 1.71004873E-04,
     &   1.68644549E-04, 1.66519907E-04, 1.64587930E-04, 1.62830155E-04,
     &   1.61217734E-04, 1.59731616E-04, 1.58356184E-04, 1.57078501E-04,
     &   1.55887743E-04, 1.54774778E-04, 1.53731838E-04, 1.52752272E-04,
     &   1.51830344E-04, 1.50961081E-04, 1.50140152E-04, 1.49363762E-04,
     &   1.48628577E-04, 1.47931654E-04, 1.47270390E-04, 1.46642476E-04,
     &   1.46045861E-04, 1.45478718E-04, 1.44939422E-04, 1.44426529E-04,
     &   1.43938751E-04, 1.43474952E-04, 1.43034124E-04, 1.42615385E-04,
     &   1.42217967E-04, 1.41841211E-04, 1.41484559E-04, 1.41213401E-04,
     &   1.40829834E-04, 1.40251296E-04, 1.39748007E-04, 1.39320688E-04,
     &   1.38971921E-04, 1.38706511E-04, 1.38532054E-04, 1.38459836E-04,
     &   1.38506242E-04, 1.38695036E-04, 1.39061163E-04, 1.39658497E-04,
     &   1.40567356E-04, 1.41927388E-04, 1.43987056E-04, 1.44247113E-04,
     &   1.47242770E-04, 1.52845051E-04, 1.64117304E-04, 1.85298979E-04,
     &   1.94848409E-04, 2.38176863E-04, 3.28234939E-04, 3.72045814E-04,
     &   4.34846318E-04, 4.77356795E-04, 5.30986242E-04, 5.85003554E-04,
     &   6.52894842E-04, 6.93766151E-04, 7.40563087E-04, 7.94640178E-04/
  
         DATA ((DAS  (I,J), I=1301,1400), J=2,2) /
     &   8.57797871E-04, 9.32482502E-04, 1.02210446E-03, 1.07396921E-03,
     &   1.13156498E-03, 1.19588607E-03, 1.26817079E-03, 1.34998118E-03,
     &   1.44331621E-03, 1.55077603E-03, 1.67580637E-03, 1.82307263E-03,
     &   1.88441898E-03, 1.92291198E-03, 1.96302516E-03, 2.00486266E-03,
     &   2.04853773E-03, 2.09417373E-03, 2.14190536E-03, 2.19187992E-03,
     &   2.24425883E-03, 2.29921942E-03, 2.35695686E-03, 2.41768651E-03,
     &   2.48164661E-03, 2.54910134E-03, 2.62034453E-03, 2.69570387E-03,
     &   2.77554599E-03, 2.86028235E-03, 2.95037641E-03, 3.04635199E-03,
     &   3.14880353E-03, 3.25840836E-03, 3.37594168E-03, 3.50229486E-03,
     &   3.63849814E-03, 3.78574865E-03, 3.94544574E-03, 4.11923549E-03,
     &   4.30906760E-03, 4.51726882E-03, 4.74663867E-03, 5.00057597E-03,
     &   5.28324827E-03, 5.59982216E-03, 5.95678173E-03, 6.36237710E-03,
     &   6.82726950E-03, 7.36548150E-03, 7.99583488E-03, 8.74419558E-03,
     &   9.64710874E-03, 1.07579431E-02, 1.21578282E-02, 1.39763963E-02,
     &   1.64343770E-02, 1.99406083E-02, 2.53463861E-02, 3.47642881E-02,
     &   5.52582201E-02, 6.79647244E-02, 1.29452001E-01, 1.80123348E-01,
     &   2.16852339E-01, 2.45271630E-01, 2.68621553E-01, 2.89055299E-01,
     &   3.08014968E-01, 3.21213959E-01, 3.34649514E-01, 3.47863263E-01,
     &   3.54234232E-01, 3.63163019E-01, 3.68513045E-01, 3.75153841E-01,
     &   3.76884466E-01, 3.79444284E-01, 3.80508092E-01, 3.79706335E-01,
     &   3.78482977E-01, 3.76636048E-01, 3.70787163E-01, 3.66685584E-01,
     &   3.61644547E-01, 3.48656254E-01, 3.40592711E-01, 3.31376987E-01,
     &   3.20832849E-01, 2.96108926E-01, 2.81588885E-01, 2.65847854E-01,
     &   2.30067179E-01, 2.10260832E-01, 1.66673979E-01, 1.18688956E-01,
     &   1.26724617E-02, 1.17112928E-01, 1.65221076E-01, 2.08743262E-01/
  
         DATA ((DAS  (I,J), I=1401,1500), J=2,2) /
     &   2.47415654E-01, 2.64801627E-01, 2.80629604E-01, 2.95091682E-01,
     &   3.20127020E-01, 3.30646656E-01, 3.40041774E-01, 3.48176608E-01,
     &   3.61295467E-01, 3.66347170E-01, 3.70551126E-01, 3.76472522E-01,
     &   3.78384582E-01, 3.80337595E-01, 3.80513409E-01, 3.79502800E-01,
     &   3.77001906E-01, 3.73299846E-01, 3.68672675E-01, 3.63341952E-01,
     &   3.54432671E-01, 3.48103726E-01, 3.34863696E-01, 3.21463011E-01,
     &   3.08224009E-01, 2.89252074E-01, 2.68801129E-01, 2.45429052E-01,
     &   2.16981747E-01, 1.80217950E-01, 1.28758573E-01, 7.02752208E-02,
     &   4.01959587E-02, 2.81236038E-02, 2.16238876E-02, 1.75635675E-02,
     &   1.47868027E-02, 1.27681903E-02, 1.12345975E-02, 1.00300038E-02,
     &   9.05881745E-03, 8.25920562E-03, 7.58940176E-03, 7.02017718E-03,
     &   6.53046516E-03, 6.10469800E-03, 5.73112280E-03, 5.40070047E-03,
     &   5.10636520E-03, 4.84251389E-03, 4.60464631E-03, 4.38910644E-03,
     &   4.19289341E-03, 4.01352106E-03, 3.84891208E-03, 3.69731733E-03,
     &   3.55725349E-03, 3.42745440E-03, 3.30683272E-03, 3.19444946E-03,
     &   3.08948950E-03, 2.99124182E-03, 2.89908339E-03, 2.81246598E-03,
     &   2.73090526E-03, 2.65397174E-03, 2.58128323E-03, 2.51249850E-03,
     &   2.44731196E-03, 2.38544909E-03, 2.32666260E-03, 2.27072915E-03,
     &   2.21744651E-03, 2.16663112E-03, 2.11811598E-03, 2.07174884E-03,
     &   2.02739059E-03, 1.98491390E-03, 1.94420194E-03, 1.90514740E-03,
     &   1.86765147E-03, 1.58492563E-03, 1.41170205E-03, 1.24568726E-03,
     &   1.06046521E-03, 8.87421997E-04, 7.17123766E-04, 6.22039825E-04,
     &   4.96961553E-04, 4.54366737E-04, 4.20243879E-04, 3.91205916E-04,
     &   3.67015674E-04, 3.47134505E-04, 3.16556824E-04, 2.92518887E-04,
     &   2.38086809E-04, 2.15934648E-04, 2.25858111E-04, 2.89405336E-04/
  
         DATA ((DAS  (I,J), I=1501,1600), J=2,2) /
     &   4.18706231E-04, 6.04024378E-04, 8.59151727E-04, 1.21746999E-03,
     &   2.12433479E-03, 2.29684481E-03, 2.50010030E-03, 2.55901698E-03,
     &   2.69333248E-03, 2.84260506E-03, 3.00947354E-03, 3.19723632E-03,
     &   3.41007218E-03, 3.65335355E-03, 3.93410562E-03, 4.26169694E-03,
     &   4.64890029E-03, 5.11359977E-03, 5.68162550E-03, 6.39172410E-03,
     &   7.30477972E-03, 8.52226408E-03, 1.02268110E-02, 1.27836675E-02,
     &   1.70449137E-02, 2.55657479E-02, 3.69959426E-02, 3.89144913E-02,
     &   4.10427763E-02, 4.34171560E-02, 4.60829020E-02, 4.90971064E-02,
     &   5.25328048E-02, 5.64849539E-02, 6.10793118E-02, 6.64860089E-02,
     &   7.29409743E-02, 8.07810727E-02, 9.05043822E-02, 1.02879346E-01,
     &   1.19155989E-01, 1.41510139E-01, 1.74083841E-01, 2.25799744E-01,
     &   3.19651743E-01, 5.31970822E-01, 6.06399974E-01, 6.64981366E-01,
     &   7.30275437E-01, 7.85072839E-01, 8.24591608E-01, 8.58108160E-01,
     &   8.73551270E-01, 8.79682643E-01, 8.71970870E-01, 8.44644627E-01,
     &   8.13182580E-01, 8.07229166E-01, 8.04134111E-01, 7.97703012E-01,
     &   7.95039399E-01, 7.93007098E-01, 7.90944950E-01, 7.68643224E-01,
     &   7.29195506E-01, 6.76411143E-01, 6.20485169E-01, 5.48849676E-01,
     &   4.67452792E-01, 3.86422616E-01, 3.38540017E-01, 2.88848387E-01,
     &   2.37572383E-01, 1.63609547E-01, 1.09606156E-01, 5.49666906E-02,
     &   2.20086677E-02, 1.10094433E-02, 5.50971113E-03, 1.72418946E-04,
     &   5.49848980E-03, 1.09982186E-02, 5.49554882E-02, 1.09595027E-01,
     &   1.63598540E-01, 4.05014717E-01, 4.92855450E-01, 6.33605437E-01,
     &   6.87739335E-01, 7.38599170E-01, 7.80175445E-01, 8.10240995E-01,
     &   8.36237882E-01, 8.53670809E-01, 8.67227655E-01, 8.74879417E-01,
     &   8.79061299E-01, 8.79520767E-01, 8.76963010E-01, 8.72363091E-01/
  
         DATA ((DAS  (I,J), I=1601,1700), J=2,2) /
     &   8.57158629E-01, 8.46910961E-01, 8.35549300E-01, 8.24594860E-01,
     &   7.99934672E-01, 7.86438361E-01, 7.64518561E-01, 7.30280477E-01,
     &   6.06406354E-01, 5.10444815E-01, 4.37782657E-01, 3.81962798E-01,
     &   3.38148309E-01, 3.03019835E-01, 2.67944533E-01, 2.13180991E-01,
     &   1.98361330E-01, 1.85445313E-01, 1.74092122E-01, 1.57219991E-01,
     &   1.30132223E-01, 1.10974171E-01, 9.67180931E-02, 8.57001012E-02,
     &   7.69314282E-02, 6.97880820E-02, 6.38570510E-02, 5.88541812E-02,
     &   5.45776059E-02, 5.08799934E-02, 4.76513096E-02, 4.48077249E-02,
     &   4.22842567E-02, 4.00297567E-02, 3.80034175E-02, 2.55741644E-02,
     &   1.70533313E-02, 1.27920845E-02, 8.53067852E-03, 6.40014581E-03,
     &   5.12203338E-03, 4.27014725E-03, 3.66181532E-03, 3.20571073E-03,
     &   2.85109444E-03, 2.56752400E-03, 2.40672494E-03, 2.21916736E-03,
     &   2.05899267E-03, 1.92062914E-03, 1.79992277E-03, 1.69371343E-03,
     &   1.30998440E-03, 1.07088621E-03, 9.08235017E-04, 7.90882342E-04,
     &   7.02783907E-04, 6.35041083E-04, 5.79717778E-04, 5.34583779E-04,
     &   2.70371314E-04, 2.65243017E-04, 2.72381714E-04, 2.78423963E-04,
     &   2.90360600E-04, 3.10267734E-04, 3.22750854E-04, 3.39878555E-04,
     &   3.86327776E-04, 4.66043657E-04, 6.17632362E-04, 9.86464541E-04,
     &   1.34886024E-03, 1.44307794E-03, 1.55195838E-03, 1.67916320E-03,
     &   1.82969026E-03, 2.01054079E-03, 2.23181762E-03, 2.50868450E-03,
     &   2.86497023E-03, 3.34036123E-03, 4.00636034E-03, 5.00592935E-03,
     &   6.67257597E-03, 6.96248967E-03, 7.27873502E-03, 7.62514721E-03,
     &   8.00621283E-03, 8.42735483E-03, 8.89535122E-03, 9.41841809E-03,
     &   1.00068115E-02, 1.06737355E-02, 1.14359415E-02, 1.23153093E-02,
     &   1.33413365E-02, 1.45538949E-02, 1.60087472E-02, 1.77869864E-02/
  
         DATA ((DAS  (I,J), I=1701,1800), J=2,2) /
     &   1.83426411E-02, 2.00096095E-02, 2.28665594E-02, 2.66754244E-02,
     &   3.20060516E-02, 3.99971632E-02, 5.32971580E-02, 7.98119011E-02,
     &   1.58181008E-01, 1.88056666E-01, 2.65249824E-01, 3.23953670E-01,
     &   3.72323234E-01, 4.14540689E-01, 4.51996135E-01, 4.85597294E-01,
     &   5.15611440E-01, 5.43431473E-01, 5.69704150E-01, 5.93714465E-01,
     &   6.14834352E-01, 6.34370489E-01, 6.51984601E-01, 6.67412441E-01,
     &   6.82070091E-01, 6.94076497E-01, 7.03452307E-01, 7.11412630E-01,
     &   7.17539692E-01, 7.21335203E-01, 7.22290100E-01, 7.20676697E-01,
     &   7.16017430E-01, 7.07784659E-01, 6.95407037E-01, 6.81491681E-01,
     &   6.59939562E-01, 6.32522549E-01, 5.98683216E-01, 5.50474357E-01,
     &   4.92419496E-01, 4.13934057E-01, 3.11087275E-01, 4.26218761E-02,
     &   2.12981784E-04, 1.40818753E-01, 3.11082220E-01, 4.13929516E-01,
     &   4.92415487E-01, 5.50470848E-01, 5.98680218E-01, 6.32519988E-01,
     &   6.59937428E-01, 6.81489959E-01, 6.95405644E-01, 7.07783642E-01,
     &   7.16016765E-01, 7.20676361E-01, 7.22290071E-01, 7.21335458E-01,
     &   7.17540251E-01, 7.11413467E-01, 7.03453396E-01, 6.94077816E-01,
     &   6.82071646E-01, 6.67414235E-01, 6.51986605E-01, 6.34372699E-01,
     &   6.14836760E-01, 5.93717061E-01, 5.69706932E-01, 5.43434434E-01,
     &   5.15614567E-01, 4.85600578E-01, 4.51999573E-01, 4.14544276E-01,
     &   3.72326964E-01, 3.23957538E-01, 2.65253825E-01, 1.88060795E-01,
     &   1.61030004E-01, 1.55960138E-01, 1.49671477E-01, 1.32302620E-01,
     &   1.16649207E-01, 7.98118048E-02, 5.33014005E-02, 4.00003208E-02,
     &   3.20096029E-02, 2.66796744E-02, 2.28708102E-02, 2.00135880E-02,
     &   1.77912380E-02, 1.60129992E-02, 1.45580029E-02, 1.33455892E-02,
     &   1.23195623E-02, 1.14401056E-02, 1.06779891E-02, 1.00110654E-02/
  
         DATA ((DAS  (I,J), I=1801,1900), J=2,2) /
     &   6.67683285E-03, 5.01019050E-03, 4.01062644E-03, 3.34463384E-03,
     &   2.86924456E-03, 2.51297538E-03, 2.23613186E-03, 1.83406707E-03,
     &   1.55642206E-03, 1.44758351E-03, 1.35340272E-03, 1.01669576E-03,
     &   7.73979663E-04, 6.32262507E-04, 5.40691960E-04, 4.77602409E-04,
     &   4.32229315E-04, 3.98570466E-04, 3.73057448E-04, 3.53427683E-04,
     &   3.38121546E-04, 3.26062501E-04, 3.16536870E-04, 3.09032168E-04,
     &   3.03177900E-04, 2.98708241E-04, 2.95440031E-04, 2.93264152E-04,
     &   2.92154915E-04, 2.92220072E-04, 2.92893514E-04, 2.92834627E-04,
     &   2.97008271E-04, 3.74874544E-04, 4.44509083E-04, 5.01118900E-04,
     &   5.48892235E-04, 5.89428190E-04, 6.24281668E-04, 6.54209648E-04,
     &   6.79884085E-04, 7.01598635E-04, 7.19849393E-04, 7.34950517E-04,
     &   7.46965844E-04, 7.56045568E-04, 7.62406898E-04, 7.66174298E-04,
     &   7.67318416E-04, 7.65967470E-04, 7.62149268E-04, 7.55745317E-04,
     &   7.46912952E-04, 7.35828211E-04, 7.21763841E-04, 7.05638737E-04,
     &   6.86460398E-04, 6.64577680E-04, 6.39480278E-04, 6.11096315E-04,
     &   5.79432892E-04, 5.44607037E-04, 5.04194207E-04, 4.59116906E-04,
     &   4.09110687E-04, 3.51186262E-04, 2.86787199E-04, 2.52508397E-04,
     &   3.91373646E-04, 4.62548904E-04, 5.16994121E-04, 5.60313446E-04,
     &   5.97259936E-04, 6.28936840E-04, 6.55195248E-04, 6.78218188E-04,
     &   6.98109384E-04, 7.15022711E-04, 7.29143462E-04, 7.40899152E-04,
     &   7.50170091E-04, 7.57574141E-04, 7.62671328E-04, 7.65859158E-04,
     &   7.67051115E-04, 7.66234634E-04, 7.63473357E-04, 7.58663564E-04,
     &   7.51748245E-04, 7.42797359E-04, 7.31653254E-04, 7.18097476E-04,
     &   6.99765423E-04, 6.83458440E-04, 6.61667989E-04, 6.36628578E-04,
     &   6.07877968E-04, 5.74718990E-04, 5.36388840E-04, 4.91252183E-04/
  
         DATA ((DAS  (I,J), I=1901,2000), J=2,2) /
     &   4.37584904E-04, 3.70440010E-04, 2.65156032E-04, 2.79943197E-04,
     &   2.67913158E-04, 2.63828464E-04, 2.62577749E-04, 2.62296229E-04,
     &   2.62170381E-04, 2.62478185E-04, 2.63087712E-04, 2.63755574E-04,
     &   2.64394916E-04, 2.64905734E-04, 2.65261992E-04, 2.65514229E-04,
     &   2.65592302E-04, 2.65530490E-04, 2.65282103E-04, 2.64785929E-04,
     &   2.64101622E-04, 2.63188069E-04, 2.62057476E-04, 2.60709400E-04,
     &   2.59122277E-04, 2.57251418E-04, 2.55130254E-04, 2.52741772E-04,
     &   2.50075113E-04, 2.47126219E-04, 2.43881141E-04, 2.40318487E-04,
     &   2.36375440E-04, 2.32056953E-04, 2.27461699E-04, 2.21807852E-04,
     &   2.15678299E-04, 2.09153308E-04, 1.99995867E-04, 2.03348738E-04,
     &   2.07368899E-04, 2.11129415E-04, 2.14957302E-04, 2.18523907E-04,
     &   2.21651205E-04, 2.24640136E-04, 2.27489799E-04, 2.30134461E-04,
     &   2.32602383E-04, 2.34911445E-04, 2.37057201E-04, 2.39030578E-04,
     &   2.40846297E-04, 2.42509448E-04, 2.43997627E-04, 2.45337727E-04,
     &   2.46533091E-04, 2.47572689E-04, 2.48452329E-04, 2.49176540E-04,
     &   2.49771230E-04, 2.50234189E-04, 2.50579161E-04, 2.50793890E-04,
     &   2.50859191E-04, 2.50804807E-04, 2.50678675E-04, 2.50512888E-04,
     &   2.50323438E-04, 2.50169284E-04, 2.50160207E-04, 2.49248122E-04,
     &   2.47583861E-04, 2.45725501E-04, 2.38618797E-04, 2.38347375E-04,
     &   2.38048193E-04, 2.37715346E-04, 2.37339509E-04, 2.36917959E-04,
     &   2.36457034E-04, 2.35951305E-04, 2.35394467E-04, 2.34119763E-04,
     &   2.32808142E-04, 2.31516417E-04, 2.30230063E-04, 2.28929805E-04,
     &   2.27594227E-04, 2.26226469E-04, 2.24836394E-04, 2.23392753E-04,
     &   2.21891787E-04, 2.20338240E-04, 2.18702685E-04, 2.17025435E-04,
     &   2.15280187E-04, 2.13447954E-04, 2.11488316E-04, 2.09520214E-04/
  
         DATA ((DAS  (I,J), I=2001,2100), J=2,2) /
     &   2.07426009E-04, 2.05293756E-04, 2.02817056E-04, 2.00240793E-04,
     &   1.97610854E-04, 1.94929165E-04, 1.91839557E-04, 1.88484387E-04,
     &   1.84933044E-04, 1.79742191E-04, 1.80057444E-04, 1.81676421E-04,
     &   1.83599769E-04, 1.85519517E-04, 1.87183088E-04, 1.88919579E-04,
     &   1.90685476E-04, 1.92417862E-04, 1.93838492E-04, 1.95273955E-04,
     &   1.96601030E-04, 1.97902441E-04, 1.99142490E-04, 2.00310644E-04,
     &   2.01426601E-04, 2.02502852E-04, 2.03507950E-04, 2.04447816E-04,
     &   2.05353087E-04, 2.06195837E-04, 2.07004356E-04, 2.07772581E-04,
     &   2.08493071E-04, 2.09178400E-04, 2.09845700E-04, 2.10503946E-04,
     &   2.11128762E-04, 2.11394411E-04, 2.11673441E-04, 2.11993153E-04,
     &   2.12395786E-04, 2.12930930E-04, 2.13409045E-04, 2.12989110E-04,
     &   2.12513637E-04, 2.09713690E-04, 2.05770888E-04, 2.04282981E-04,
     &   2.05506395E-04, 2.09306489E-04, 2.14651030E-04, 2.21514951E-04,
     &   2.29005261E-04, 2.37461418E-04, 2.46519681E-04, 2.55657560E-04,
     &   2.65887898E-04, 2.76364476E-04, 2.57183396E-04, 2.38002317E-04,
     &   2.29530395E-04, 2.21958215E-04, 2.15675853E-04, 2.09910149E-04,
     &   2.05022602E-04, 2.00456665E-04, 1.96527540E-04, 1.92809488E-04,
     &   1.89433666E-04, 1.86482116E-04, 1.83649763E-04, 1.81154036E-04,
     &   1.78742279E-04, 1.76603598E-04, 1.74524866E-04, 1.72671665E-04,
     &   1.70861568E-04, 1.69240517E-04, 1.67650493E-04, 1.66220924E-04,
     &   1.64873004E-04, 1.63543859E-04, 1.62342877E-04, 1.61155002E-04,
     &   1.60078565E-04, 1.59010967E-04, 1.58041011E-04, 1.57076652E-04,
     &   1.56198439E-04, 1.55323342E-04, 1.54524715E-04, 1.53727301E-04,
     &   1.52965752E-04, 1.52268742E-04, 1.51570865E-04, 1.50931031E-04,
     &   1.50289341E-04, 1.49700084E-04, 1.49108211E-04, 1.48563897E-04/
  
         DATA ((DAS  (I,J), I=2101,2174), J=2,2) /
     &   1.48016387E-04, 1.47512177E-04, 1.47004333E-04, 1.46536049E-04,
     &   1.46083979E-04, 1.45627819E-04, 1.45206450E-04, 1.44780787E-04,
     &   1.44387157E-04, 1.43989301E-04, 1.43620798E-04, 1.43247768E-04,
     &   1.42902115E-04, 1.42551885E-04, 1.42227059E-04, 1.41897636E-04,
     &   1.41578150E-04, 1.41281451E-04, 1.40980171E-04, 1.40677433E-04,
     &   1.40392769E-04, 1.40127998E-04, 1.39858730E-04, 1.39607871E-04,
     &   1.39353005E-04, 1.39115416E-04, 1.38873454E-04, 1.38647925E-04,
     &   1.38418095E-04, 1.38203739E-04, 1.37994546E-04, 1.37781167E-04,
     &   1.37581974E-04, 1.37378676E-04, 1.37188786E-04, 1.36994874E-04,
     &   1.36813651E-04, 1.36628701E-04, 1.36455603E-04, 1.36278653E-04,
     &   1.36113111E-04, 1.35943800E-04, 1.34318865E-04, 1.33009191E-04,
     &   1.32822772E-04, 1.27629081E-04, 1.26346147E-04, 1.24212923E-04,
     &   1.23458462E-04, 1.23416035E-04, 1.22679551E-04, 1.22677590E-04,
     &   1.22265642E-04, 1.22252746E-04, 1.22243632E-04, 1.22075134E-04,
     &   1.21973117E-04, 1.21955652E-04, 1.21927611E-04, 1.21887165E-04,
     &   1.21859398E-04, 1.21842273E-04, 1.21687619E-04, 1.21680339E-04,
     &   1.21640113E-04, 1.21632635E-04, 1.21623381E-04, 1.21585663E-04,
     &   1.21582034E-04, 1.21572857E-04, 1.21539954E-04, 1.21502831E-04,
     &   1.21487509E-04, 1.21392576E-04/


c      ++++ deghadslow16 ++++  

c updated dec 2016
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 13:16:17 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN:  1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (ESA  (I), I=   1, 100) /
     &   0.28207018D0, 0.28800000D0, 0.29400000D0, 0.30000000D0,
     &   0.30600000D0, 0.30900000D0, 0.31500000D0, 0.32600000D0,
     &   0.33100000D0, 0.33600000D0, 0.34100000D0, 0.34600000D0,
     &   0.35200000D0, 0.35600000D0, 0.36100000D0, 0.36600000D0,
     &   0.37100000D0, 0.37600000D0, 0.38000000D0, 0.38500000D0,
     &   0.38900000D0, 0.39400000D0, 0.39800000D0, 0.40300000D0,
     &   0.40700000D0, 0.41100000D0, 0.41600000D0, 0.41871100D0,
     &   0.42000000D0, 0.42400000D0, 0.42800000D0, 0.43200000D0,
     &   0.43600000D0, 0.44000000D0, 0.44400000D0, 0.44800000D0,
     &   0.45200000D0, 0.45600000D0, 0.46000000D0, 0.46400000D0,
     &   0.46700000D0, 0.47100000D0, 0.47500000D0, 0.47800000D0,
     &   0.48200000D0, 0.48600000D0, 0.48900000D0, 0.49300000D0,
     &   0.49600000D0, 0.50000000D0, 0.52000000D0, 0.54000000D0,
     &   0.56600000D0, 0.59200000D0, 0.60000000D0, 0.60200000D0,
     &   0.60800000D0, 0.61600000D0, 0.62400000D0, 0.63200000D0,
     &   0.64000000D0, 0.64300000D0, 0.64800000D0, 0.65600000D0,
     &   0.66300000D0, 0.67100000D0, 0.67800000D0, 0.68600000D0,
     &   0.68800000D0, 0.69300000D0, 0.69600000D0, 0.70000000D0,
     &   0.70700000D0, 0.71400000D0, 0.72100000D0, 0.72800000D0,
     &   0.73500000D0, 0.74200000D0, 0.74800000D0, 0.75000000D0,
     &   0.75500000D0, 0.75744000D0, 0.76007300D0, 0.76207300D0,
     &   0.76507300D0, 0.76851700D0, 0.77060500D0, 0.77205400D0,
     &   0.77314300D0, 0.77400300D0, 0.77470900D0, 0.77530500D0,
     &   0.77582000D0, 0.77627100D0, 0.77667300D0, 0.77726600D0,
     &   0.77746600D0, 0.77766900D0, 0.77795100D0, 0.77821500D0/
       DATA  (ESA  (I), I= 101, 200) /
     &   0.77846300D0, 0.77869800D0, 0.77892200D0, 0.77913700D0,
     &   0.77934400D0, 0.77954500D0, 0.77974200D0, 0.77993500D0,
     &   0.78012700D0, 0.78031800D0, 0.78051000D0, 0.78070600D0,
     &   0.78090800D0, 0.78112100D0, 0.78135100D0, 0.78161200D0,
     &   0.78193600D0, 0.78268000D0, 0.78341500D0, 0.78373400D0,
     &   0.78399100D0, 0.78421700D0, 0.78442600D0, 0.78462500D0,
     &   0.78481700D0, 0.78500500D0, 0.78519100D0, 0.78537800D0,
     &   0.78556600D0, 0.78575600D0, 0.78595100D0, 0.78615100D0,
     &   0.78635800D0, 0.78657300D0, 0.78679800D0, 0.78703400D0,
     &   0.78728400D0, 0.78755000D0, 0.78773500D0, 0.78793500D0,
     &   0.78814300D0, 0.78847900D0, 0.78884800D0, 0.78925800D0,
     &   0.78971900D0, 0.79024600D0, 0.79085900D0, 0.79158800D0,
     &   0.79248000D0, 0.79361500D0, 0.79513900D0, 0.79736300D0,
     &   0.79800000D0, 0.80000000D0, 0.80200000D0, 0.80400000D0,
     &   0.80600000D0, 0.80800000D0, 0.81200000D0, 0.81400000D0,
     &   0.81600000D0, 0.82000000D0, 0.82200000D0, 0.82400000D0,
     &   0.82600000D0, 0.82800000D0, 0.83000000D0, 0.83100000D0,
     &   0.83700000D0, 0.84300000D0, 0.84900000D0, 0.85400000D0,
     &   0.86000000D0, 0.86600000D0, 0.87200000D0, 0.87700000D0,
     &   0.88300000D0, 0.88900000D0, 0.89400000D0, 0.89700000D0,
     &   0.90250000D0, 0.90500000D0, 0.91100000D0, 0.91600000D0,
     &   0.92200000D0, 0.92700000D0, 0.93300000D0, 0.93800000D0,
     &   0.94300000D0, 0.94900000D0, 0.95200000D0, 0.95400000D0,
     &   0.95800000D0, 0.96000000D0, 0.96200000D0, 0.96400000D0,
     &   0.96600000D0, 0.96800000D0, 0.97000000D0, 0.97400000D0/
       DATA  (ESA  (I), I= 201, 300) /
     &   0.97800000D0, 0.98000000D0, 0.98070000D0, 0.98140000D0,
     &   0.98210000D0, 0.98280000D0, 0.98350000D0, 0.98420000D0,
     &   0.98490000D0, 0.98560000D0, 0.98630000D0, 0.98700000D0,
     &   0.98770000D0, 0.98840000D0, 0.98910000D0, 0.98980000D0,
     &   0.99050000D0, 0.99120000D0, 0.99190000D0, 0.99260000D0,
     &   0.99330000D0, 0.99400000D0, 0.99470000D0, 0.99540000D0,
     &   0.99610000D0, 0.99680000D0, 0.99750000D0, 0.99820000D0,
     &   0.99890000D0, 0.99960000D0, 0.99990000D0, 1.00001000D0,
     &   1.00030000D0, 1.00100000D0, 1.00170000D0, 1.00240000D0,
     &   1.00310000D0, 1.00380000D0, 1.00450000D0, 1.00520000D0,
     &   1.00590000D0, 1.00660000D0, 1.00730000D0, 1.00800000D0,
     &   1.00870000D0, 1.00940000D0, 1.01010000D0, 1.01080000D0,
     &   1.01150000D0, 1.01220000D0, 1.01290000D0, 1.01360000D0,
     &   1.01430000D0, 1.01500000D0, 1.01520000D0, 1.01540000D0,
     &   1.01560000D0, 1.01580000D0, 1.01600000D0, 1.01620000D0,
     &   1.01640000D0, 1.01660000D0, 1.01680000D0, 1.01700000D0,
     &   1.01720000D0, 1.01740000D0, 1.01770000D0, 1.01790000D0,
     &   1.01800000D0, 1.01820000D0, 1.01840000D0, 1.01860000D0,
     &   1.01880000D0, 1.01900000D0, 1.01920000D0, 1.01940000D0,
     &   1.01960000D0, 1.01980000D0, 1.02000000D0, 1.02020000D0,
     &   1.02040000D0, 1.02060000D0, 1.02080000D0, 1.02100000D0,
     &   1.02120000D0, 1.02140000D0, 1.02160000D0, 1.02180000D0,
     &   1.02200000D0, 1.02220000D0, 1.02240000D0, 1.02270000D0,
     &   1.02290000D0, 1.02300000D0, 1.02320000D0, 1.02340000D0,
     &   1.02360000D0, 1.02380000D0, 1.02400000D0, 1.02420000D0/
       DATA  (ESA  (I), I= 301, 400) /
     &   1.02440000D0, 1.02460000D0, 1.02480000D0, 1.02500000D0,
     &   1.02570000D0, 1.02640000D0, 1.02710000D0, 1.02780000D0,
     &   1.02850000D0, 1.02920000D0, 1.02990000D0, 1.03060000D0,
     &   1.03130000D0, 1.03200000D0, 1.03270000D0, 1.03340000D0,
     &   1.03410000D0, 1.03480000D0, 1.03550000D0, 1.03620000D0,
     &   1.03690000D0, 1.03760000D0, 1.03830000D0, 1.03900000D0,
     &   1.03970000D0, 1.03999000D0, 1.04001000D0, 1.04040000D0,
     &   1.04110000D0, 1.04180000D0, 1.04250000D0, 1.04320000D0,
     &   1.04390000D0, 1.04460000D0, 1.04530000D0, 1.04600000D0,
     &   1.04670000D0, 1.04740000D0, 1.04810000D0, 1.04880000D0,
     &   1.04950000D0, 1.05020000D0, 1.05090000D0, 1.05160000D0,
     &   1.05230000D0, 1.05300000D0, 1.05370000D0, 1.05440000D0,
     &   1.05510000D0, 1.05580000D0, 1.05650000D0, 1.05720000D0,
     &   1.05790000D0, 1.05860000D0, 1.05930000D0, 1.06000000D0,
     &   1.06200000D0, 1.06700000D0, 1.07700000D0, 1.08700000D0,
     &   1.09700000D0, 1.10700000D0, 1.11700000D0, 1.12700000D0,
     &   1.13700000D0, 1.13800000D0, 1.15200000D0, 1.16300000D0,
     &   1.16700000D0, 1.17700000D0, 1.18700000D0, 1.18800000D0,
     &   1.19700000D0, 1.20700000D0, 1.21200000D0, 1.21700000D0,
     &   1.22700000D0, 1.23700000D0, 1.24700000D0, 1.25700000D0,
     &   1.26300000D0, 1.26700000D0, 1.27700000D0, 1.28700000D0,
     &   1.28800000D0, 1.29700000D0, 1.30700000D0, 1.31200000D0,
     &   1.31700000D0, 1.32700000D0, 1.33700000D0, 1.34700000D0,
     &   1.35000000D0, 1.35700000D0, 1.36200000D0, 1.36700000D0,
     &   1.37700000D0, 1.38700000D0, 1.38800000D0, 1.39500000D0/
       DATA  (ESA  (I), I= 401, 500) /
     &   1.41000000D0, 1.41900000D0, 1.42700000D0, 1.43500000D0,
     &   1.43800000D0, 1.45200000D0, 1.45700000D0, 1.46000000D0,
     &   1.46400000D0, 1.47200000D0, 1.48100000D0, 1.49000000D0,
     &   1.49100000D0, 1.50000000D0, 1.50100000D0, 1.50600000D0,
     &   1.51000000D0, 1.52300000D0, 1.52500000D0, 1.53800000D0,
     &   1.53900000D0, 1.54000000D0, 1.55000000D0, 1.56000000D0,
     &   1.56200000D0, 1.57400000D0, 1.57500000D0, 1.58000000D0,
     &   1.58100000D0, 1.58700000D0, 1.59000000D0, 1.59900000D0,
     &   1.60000000D0, 1.61000000D0, 1.61900000D0, 1.62400000D0,
     &   1.62500000D0, 1.63800000D0, 1.64000000D0, 1.65000000D0,
     &   1.65700000D0, 1.66000000D0, 1.66200000D0, 1.66300000D0,
     &   1.67300000D0, 1.67500000D0, 1.68100000D0, 1.68700000D0,
     &   1.69000000D0, 1.70000000D0, 1.71000000D0, 1.71200000D0,
     &   1.71300000D0, 1.71900000D0, 1.72200000D0, 1.72500000D0,
     &   1.73800000D0, 1.74000000D0, 1.74600000D0, 1.75000000D0,
     &   1.75600000D0, 1.75700000D0, 1.76000000D0, 1.76200000D0,
     &   1.76400000D0, 1.76900000D0, 1.77500000D0, 1.78100000D0,
     &   1.79000000D0, 1.79900000D0, 1.80000000D0, 1.81200000D0,
     &   1.81900000D0, 1.82500000D0, 1.82600000D0, 1.83400000D0,
     &   1.83500000D0, 1.83800000D0, 1.84500000D0, 1.85700000D0,
     &   1.85900000D0, 1.87400000D0, 1.88100000D0, 1.88600000D0,
     &   1.90000000D0, 1.91900000D0, 1.92500000D0, 1.93000000D0,
     &   1.93800000D0, 1.94000000D0, 1.94500000D0, 1.94600000D0,
     &   1.95000000D0, 1.95500000D0, 1.96000000D0, 1.96200000D0,
     &   1.98100000D0, 1.99050000D0, 2.00500000D0, 2.05000000D0/
       DATA  (ESA  (I), I= 501, 600) /
     &   2.10000000D0, 2.15010000D0, 2.22000000D0, 2.26000000D0,
     &   2.30000000D0, 2.40000000D0, 2.45000000D0, 2.50000000D0,
     &   2.55000000D0, 2.60000000D0, 2.65000000D0, 2.70000000D0,
     &   2.75000000D0, 2.80000000D0, 2.85000000D0, 2.90000000D0,
     &   2.91000000D0, 2.92000000D0, 2.93000000D0, 2.94000000D0,
     &   2.95000000D0, 2.96000000D0, 2.97000000D0, 2.97200000D0,
     &   2.97400000D0, 2.97600000D0, 2.97800000D0, 2.98000000D0,
     &   2.98200000D0, 2.98400000D0, 2.98600000D0, 2.98800000D0,
     &   2.99000000D0, 2.99900000D0, 3.00500000D0, 3.00800000D0,
     &   3.01000000D0, 3.01200000D0, 3.01400000D0, 3.01600000D0,
     &   3.01800000D0, 3.02000000D0, 3.02100000D0, 3.02200000D0,
     &   3.02300000D0, 3.02400000D0, 3.02500000D0, 3.02600000D0,
     &   3.02700000D0, 3.02800000D0, 3.02900000D0, 3.03000000D0,
     &   3.03100000D0, 3.03200000D0, 3.03300000D0, 3.03400000D0,
     &   3.03500000D0, 3.03600000D0, 3.03700000D0, 3.03800000D0,
     &   3.03900000D0, 3.04000000D0, 3.04100000D0, 3.04200000D0,
     &   3.04300000D0, 3.04400000D0, 3.04500000D0, 3.04600000D0,
     &   3.04700000D0, 3.04800000D0, 3.04900000D0, 3.05000000D0,
     &   3.05100000D0, 3.05200000D0, 3.05300000D0, 3.05400000D0,
     &   3.05500000D0, 3.05600000D0, 3.05700000D0, 3.05800000D0,
     &   3.05900000D0, 3.06000000D0, 3.06050000D0, 3.06100000D0,
     &   3.06150000D0, 3.06200000D0, 3.06250000D0, 3.06300000D0,
     &   3.06350000D0, 3.06400000D0, 3.06450000D0, 3.06500000D0,
     &   3.06550000D0, 3.06600000D0, 3.06650000D0, 3.06700000D0,
     &   3.06750000D0, 3.06800000D0, 3.06850000D0, 3.06900000D0/
       DATA  (ESA  (I), I= 601, 700) /
     &   3.06950000D0, 3.07000000D0, 3.07050000D0, 3.07100000D0,
     &   3.07150000D0, 3.07200000D0, 3.07250000D0, 3.07300000D0,
     &   3.07350000D0, 3.07400000D0, 3.07450000D0, 3.07500000D0,
     &   3.07550000D0, 3.07600000D0, 3.07650000D0, 3.07700000D0,
     &   3.07750000D0, 3.07800000D0, 3.07850000D0, 3.07900000D0,
     &   3.07970000D0, 3.08000000D0, 3.08050000D0, 3.08100000D0,
     &   3.08150000D0, 3.08200000D0, 3.08250000D0, 3.08300000D0,
     &   3.08350000D0, 3.08400000D0, 3.08450000D0, 3.08500000D0,
     &   3.08550000D0, 3.08587000D0, 3.08688300D0, 3.08789600D0,
     &   3.08890900D0, 3.08992200D0, 3.09093500D0, 3.09194800D0,
     &   3.09296100D0, 3.09397400D0, 3.09498700D0, 3.09600000D0,
     &   3.09605000D0, 3.09610000D0, 3.09615000D0, 3.09620000D0,
     &   3.09625000D0, 3.09630000D0, 3.09635000D0, 3.09640000D0,
     &   3.09645000D0, 3.09650000D0, 3.09655000D0, 3.09660000D0,
     &   3.09665000D0, 3.09665500D0, 3.09673500D0, 3.09677100D0,
     &   3.09679300D0, 3.09680900D0, 3.09682000D0, 3.09682900D0,
     &   3.09683600D0, 3.09684300D0, 3.09684800D0, 3.09685300D0,
     &   3.09685700D0, 3.09686100D0, 3.09686400D0, 3.09686800D0,
     &   3.09687000D0, 3.09687300D0, 3.09687600D0, 3.09687800D0,
     &   3.09688100D0, 3.09688300D0, 3.09688500D0, 3.09688700D0,
     &   3.09688900D0, 3.09689100D0, 3.09689300D0, 3.09689500D0,
     &   3.09689700D0, 3.09689900D0, 3.09690100D0, 3.09690400D0,
     &   3.09690600D0, 3.09690900D0, 3.09691200D0, 3.09692000D0,
     &   3.09692800D0, 3.09693100D0, 3.09693400D0, 3.09693600D0,
     &   3.09693900D0, 3.09694100D0, 3.09694300D0, 3.09694500D0/
       DATA  (ESA  (I), I= 701, 800) /
     &   3.09694700D0, 3.09694900D0, 3.09695100D0, 3.09695300D0,
     &   3.09695500D0, 3.09695700D0, 3.09695900D0, 3.09696200D0,
     &   3.09696400D0, 3.09696700D0, 3.09697000D0, 3.09697200D0,
     &   3.09697600D0, 3.09697900D0, 3.09698300D0, 3.09698700D0,
     &   3.09699200D0, 3.09699700D0, 3.09700400D0, 3.09701100D0,
     &   3.09702000D0, 3.09703100D0, 3.09704700D0, 3.09706900D0,
     &   3.09710500D0, 3.09715000D0, 3.09720000D0, 3.09725000D0,
     &   3.09730000D0, 3.09735000D0, 3.09740000D0, 3.09745000D0,
     &   3.09750000D0, 3.09755000D0, 3.09760000D0, 3.09765000D0,
     &   3.09770000D0, 3.09775000D0, 3.09780000D0, 3.09785000D0,
     &   3.09790000D0, 3.09795000D0, 3.09800000D0, 3.09898700D0,
     &   3.09997400D0, 3.10096100D0, 3.10194800D0, 3.10293500D0,
     &   3.10392200D0, 3.10490900D0, 3.10589600D0, 3.10688300D0,
     &   3.10787000D0, 3.10800000D0, 3.10900000D0, 3.11000000D0,
     &   3.11100000D0, 3.11200000D0, 3.11300000D0, 3.11400000D0,
     &   3.11500000D0, 3.11600000D0, 3.11700000D0, 3.11800000D0,
     &   3.11900000D0, 3.12000000D0, 3.12100000D0, 3.12200000D0,
     &   3.12300000D0, 3.12400000D0, 3.12500000D0, 3.12600000D0,
     &   3.12700000D0, 3.12800000D0, 3.12900000D0, 3.13000000D0,
     &   3.13100000D0, 3.13200000D0, 3.13300000D0, 3.13400000D0,
     &   3.13500000D0, 3.13600000D0, 3.13700000D0, 3.13800000D0,
     &   3.13900000D0, 3.14000000D0, 3.14100000D0, 3.14200000D0,
     &   3.14300000D0, 3.14400000D0, 3.14500000D0, 3.14600000D0,
     &   3.14700000D0, 3.14800000D0, 3.14900000D0, 3.15000000D0,
     &   3.15100000D0, 3.15200000D0, 3.15300000D0, 3.15400000D0/
       DATA  (ESA  (I), I= 801, 900) /
     &   3.15500000D0, 3.15600000D0, 3.15700000D0, 3.15800000D0,
     &   3.15900000D0, 3.16000000D0, 3.16100000D0, 3.16200000D0,
     &   3.16300000D0, 3.16400000D0, 3.16500000D0, 3.16600000D0,
     &   3.16700000D0, 3.16800000D0, 3.16900000D0, 3.17000000D0,
     &   3.17100000D0, 3.17200000D0, 3.17300000D0, 3.17400000D0,
     &   3.17500000D0, 3.17600000D0, 3.17700000D0, 3.17800000D0,
     &   3.17900000D0, 3.18000000D0, 3.18100000D0, 3.18200000D0,
     &   3.18300000D0, 3.18400000D0, 3.18500000D0, 3.18600000D0,
     &   3.18700000D0, 3.18800000D0, 3.18900000D0, 3.19000000D0,
     &   3.19100000D0, 3.19200000D0, 3.19300000D0, 3.19400000D0,
     &   3.19500000D0, 3.19600000D0, 3.19700000D0, 3.19800000D0,
     &   3.19900000D0, 3.19990000D0, 3.20100000D0, 3.20200000D0,
     &   3.20300000D0, 3.20400000D0, 3.20500000D0, 3.20600000D0,
     &   3.20700000D0, 3.20800000D0, 3.20900000D0, 3.21000000D0,
     &   3.25000000D0, 3.30000000D0, 3.37000000D0, 3.45000000D0,
     &   3.50000000D0, 3.52000000D0, 3.54000000D0, 3.56000000D0,
     &   3.57500000D0, 3.59000000D0, 3.59500000D0, 3.60500000D0,
     &   3.61000000D0, 3.61500000D0, 3.62000000D0, 3.62500000D0,
     &   3.63000000D0, 3.63500000D0, 3.64000000D0, 3.64500000D0,
     &   3.65000000D0, 3.65200000D0, 3.65400000D0, 3.65600000D0,
     &   3.65800000D0, 3.66000000D0, 3.66200000D0, 3.66300000D0,
     &   3.66400000D0, 3.66500000D0, 3.66600000D0, 3.66700000D0,
     &   3.66800000D0, 3.66900000D0, 3.67000000D0, 3.67100000D0,
     &   3.67200000D0, 3.67300000D0, 3.67400000D0, 3.67496000D0,
     &   3.67551000D0, 3.67606000D0, 3.67661000D0, 3.67716000D0/
       DATA  (ESA  (I), I= 901,1000) /
     &   3.67771000D0, 3.67826000D0, 3.67881000D0, 3.67936000D0,
     &   3.67991000D0, 3.68046000D0, 3.68101000D0, 3.68156000D0,
     &   3.68211000D0, 3.68266000D0, 3.68321000D0, 3.68376000D0,
     &   3.68431000D0, 3.68486000D0, 3.68527300D0, 3.68541000D0,
     &   3.68552000D0, 3.68569900D0, 3.68574600D0, 3.68578100D0,
     &   3.68580900D0, 3.68583200D0, 3.68585100D0, 3.68586800D0,
     &   3.68588300D0, 3.68589500D0, 3.68590700D0, 3.68591800D0,
     &   3.68592800D0, 3.68593700D0, 3.68594600D0, 3.68595300D0,
     &   3.68596100D0, 3.68596800D0, 3.68597500D0, 3.68598200D0,
     &   3.68598800D0, 3.68599500D0, 3.68600100D0, 3.68600700D0,
     &   3.68601300D0, 3.68602000D0, 3.68602600D0, 3.68603300D0,
     &   3.68603900D0, 3.68604700D0, 3.68605500D0, 3.68606600D0,
     &   3.68607500D0, 3.68608500D0, 3.68609000D0, 3.68609500D0,
     &   3.68610000D0, 3.68611400D0, 3.68612500D0, 3.68613300D0,
     &   3.68614100D0, 3.68614700D0, 3.68615400D0, 3.68616000D0,
     &   3.68616700D0, 3.68617300D0, 3.68617900D0, 3.68618500D0,
     &   3.68619200D0, 3.68619800D0, 3.68620500D0, 3.68621200D0,
     &   3.68621900D0, 3.68622700D0, 3.68623400D0, 3.68624300D0,
     &   3.68625200D0, 3.68626200D0, 3.68627300D0, 3.68628500D0,
     &   3.68629700D0, 3.68631200D0, 3.68632900D0, 3.68634800D0,
     &   3.68637100D0, 3.68639900D0, 3.68643400D0, 3.68648100D0,
     &   3.68654800D0, 3.68651000D0, 3.68660000D0, 3.68667000D0,
     &   3.68672000D0, 3.68685000D0, 3.68690700D0, 3.68706000D0,
     &   3.68761000D0, 3.68816000D0, 3.68871000D0, 3.68926000D0,
     &   3.68981000D0, 3.69036000D0, 3.69091000D0, 3.69146000D0/
       DATA  (ESA  (I), I=1001,1100) /
     &   3.69201000D0, 3.69256000D0, 3.69311000D0, 3.69366000D0,
     &   3.69421000D0, 3.69476000D0, 3.69531000D0, 3.69586000D0,
     &   3.69641000D0, 3.69696000D0, 3.69796000D0, 3.69950000D0,
     &   3.70050000D0, 3.70250000D0, 3.70450000D0, 3.70700000D0,
     &   3.71200000D0, 3.72128100D0, 3.73082800D0, 3.73660200D0,
     &   3.74060200D0, 3.74360300D0, 3.74597300D0, 3.74791700D0,
     &   3.74955600D0, 3.75096800D0, 3.75220600D0, 3.75330900D0,
     &   3.75430100D0, 3.75520500D0, 3.75603600D0, 3.75680500D0,
     &   3.75752300D0, 3.75819800D0, 3.75883700D0, 3.75944400D0,
     &   3.76002600D0, 3.76058600D0, 3.76112800D0, 3.76165500D0,
     &   3.76217200D0, 3.76268100D0, 3.76318700D0, 3.76369200D0,
     &   3.76420200D0, 3.76472200D0, 3.76526100D0, 3.76582800D0,
     &   3.76644200D0, 3.76713800D0, 3.76800500D0, 3.77000000D0,
     &   3.77199500D0, 3.77286200D0, 3.77355800D0, 3.77417200D0,
     &   3.77474000D0, 3.77527800D0, 3.77579800D0, 3.77630800D0,
     &   3.77681400D0, 3.77731900D0, 3.77782800D0, 3.77834500D0,
     &   3.77887200D0, 3.77941400D0, 3.77997400D0, 3.78055600D0,
     &   3.78116300D0, 3.78180200D0, 3.78247700D0, 3.78319500D0,
     &   3.78396400D0, 3.78479500D0, 3.78569900D0, 3.78669100D0,
     &   3.78779400D0, 3.78903200D0, 3.79044400D0, 3.79208300D0,
     &   3.79402700D0, 3.79639700D0, 3.79939800D0, 3.80339800D0,
     &   3.80917200D0, 3.81871900D0, 3.82200000D0, 3.83200000D0,
     &   3.85000000D0, 3.85200000D0, 3.86700000D0, 3.87300000D0,
     &   3.87800000D0, 3.88400000D0, 3.89000000D0, 3.89600000D0,
     &   3.90000000D0, 3.90200000D0, 3.90800000D0, 3.91400000D0/
       DATA  (ESA  (I), I=1101,1200) /
     &   3.92000000D0, 3.92600000D0, 3.93200000D0, 3.93800000D0,
     &   3.94400000D0, 3.95000000D0, 3.95600000D0, 3.96200000D0,
     &   3.96800000D0, 3.97400000D0, 3.98000000D0, 3.98600000D0,
     &   3.99200000D0, 3.99800000D0, 4.00000000D0, 4.00400000D0,
     &   4.01000000D0, 4.01600000D0, 4.02000000D0, 4.02200000D0,
     &   4.02800000D0, 4.03000000D0, 4.03400000D0, 4.04000000D0,
     &   4.04600000D0, 4.05000000D0, 4.05200000D0, 4.05800000D0,
     &   4.06400000D0, 4.07000000D0, 4.07600000D0, 4.08200000D0,
     &   4.08800000D0, 4.09000000D0, 4.09400000D0, 4.10000000D0,
     &   4.10500000D0, 4.10900000D0, 4.11000000D0, 4.11300000D0,
     &   4.11800000D0, 4.12100000D0, 4.12500000D0, 4.12900000D0,
     &   4.13000000D0, 4.13300000D0, 4.13600000D0, 4.14100000D0,
     &   4.14700000D0, 4.15000000D0, 4.15300000D0, 4.15900000D0,
     &   4.16500000D0, 4.17100000D0, 4.17700000D0, 4.18000000D0,
     &   4.18200000D0, 4.18500000D0, 4.19000000D0, 4.19500000D0,
     &   4.19900000D0, 4.20100000D0, 4.20800000D0, 4.21200000D0,
     &   4.21400000D0, 4.22000000D0, 4.22600000D0, 4.23200000D0,
     &   4.23800000D0, 4.24000000D0, 4.24400000D0, 4.25000000D0,
     &   4.25600000D0, 4.26200000D0, 4.26800000D0, 4.27400000D0,
     &   4.28000000D0, 4.29200000D0, 4.30000000D0, 4.30400000D0,
     &   4.31000000D0, 4.31600000D0, 4.32800000D0, 4.33000000D0,
     &   4.34000000D0, 4.35000000D0, 4.35200000D0, 4.36400000D0,
     &   4.37600000D0, 4.38000000D0, 4.38200000D0, 4.38800000D0,
     &   4.39000000D0, 4.39400000D0, 4.40000000D0, 4.40600000D0,
     &   4.41000000D0, 4.41200000D0, 4.41800000D0, 4.42400000D0/
       DATA  (ESA  (I), I=1201,1300) /
     &   4.43000000D0, 4.43600000D0, 4.44000000D0, 4.44200000D0,
     &   4.44800000D0, 4.45000000D0, 4.46000000D0, 4.47200000D0,
     &   4.48400000D0, 4.49600000D0, 4.50450000D0, 4.54000000D0,
     &   4.55000000D0, 4.57000000D0, 4.60000000D0, 4.62000000D0,
     &   4.65000000D0, 4.66000000D0, 4.70000000D0, 4.71000000D0,
     &   4.80000000D0, 4.90000000D0, 4.98000000D0, 5.06500000D0,
     &   5.15000000D0, 5.22500000D0, 5.25000000D0, 5.30000000D0,
     &   5.40000000D0, 5.45000000D0, 5.50000000D0, 5.60000000D0,
     &   5.70000000D0, 5.75000000D0, 5.80000000D0, 5.85000000D0,
     &   5.90000000D0, 5.95000000D0, 6.00000000D0, 6.05000000D0,
     &   6.10000000D0, 6.15000000D0, 6.20000000D0, 6.25000000D0,
     &   6.30000000D0, 6.35000000D0, 6.40000000D0, 6.45000000D0,
     &   6.50000000D0, 6.55000000D0, 6.60000000D0, 6.65000000D0,
     &   6.70000000D0, 6.75000000D0, 6.80000000D0, 6.85000000D0,
     &   6.90000000D0, 6.95000000D0, 7.00000000D0, 7.05000000D0,
     &   7.10000000D0, 7.15000000D0, 7.20000000D0, 7.25000000D0,
     &   7.30000000D0, 7.35000000D0, 7.40000000D0, 7.44000000D0,
     &   7.50000000D0, 7.60000000D0, 7.70000000D0, 7.80000000D0,
     &   7.90000000D0, 8.00000000D0, 8.10000000D0, 8.20000000D0,
     &   8.30000000D0, 8.40000000D0, 8.50000000D0, 8.60000000D0,
     &   8.70000000D0, 8.80000000D0, 8.90000000D0, 8.91000000D0,
     &   9.00000000D0, 9.10000000D0, 9.20000000D0, 9.28000000D0,
     &   9.30000000D0, 9.35000000D0, 9.39000000D0, 9.40000000D0,
     &   9.41000000D0, 9.41500000D0, 9.42000000D0, 9.42400000D0,
     &   9.42800000D0, 9.43000000D0, 9.43200000D0, 9.43400000D0/
       DATA  (ESA  (I), I=1301,1400) /
     &   9.43600000D0, 9.43800000D0, 9.44000000D0, 9.44100000D0,
     &   9.44200000D0, 9.44300000D0, 9.44400000D0, 9.44500000D0,
     &   9.44600000D0, 9.44700000D0, 9.44800000D0, 9.44900000D0,
     &   9.44937000D0, 9.44959000D0, 9.44981000D0, 9.45003000D0,
     &   9.45025000D0, 9.45047000D0, 9.45069000D0, 9.45091000D0,
     &   9.45113000D0, 9.45135000D0, 9.45157000D0, 9.45179000D0,
     &   9.45201000D0, 9.45223000D0, 9.45245000D0, 9.45267000D0,
     &   9.45289000D0, 9.45311000D0, 9.45333000D0, 9.45355000D0,
     &   9.45377000D0, 9.45399000D0, 9.45421000D0, 9.45443000D0,
     &   9.45465000D0, 9.45487000D0, 9.45509000D0, 9.45531000D0,
     &   9.45553000D0, 9.45575000D0, 9.45597000D0, 9.45619000D0,
     &   9.45641000D0, 9.45663000D0, 9.45685000D0, 9.45707000D0,
     &   9.45729000D0, 9.45751000D0, 9.45773000D0, 9.45795000D0,
     &   9.45817000D0, 9.45839000D0, 9.45861000D0, 9.45883000D0,
     &   9.45905000D0, 9.45927000D0, 9.45949000D0, 9.45971000D0,
     &   9.45993000D0, 9.46000000D0, 9.46014595D0, 9.46019268D0,
     &   9.46021366D0, 9.46022606D0, 9.46023464D0, 9.46024132D0,
     &   9.46024704D0, 9.46025085D0, 9.46025467D0, 9.46025848D0,
     &   9.46026039D0, 9.46026325D0, 9.46026516D0, 9.46026802D0,
     &   9.46026897D0, 9.46027088D0, 9.46027279D0, 9.46027470D0,
     &   9.46027565D0, 9.46027660D0, 9.46027851D0, 9.46027946D0,
     &   9.46028042D0, 9.46028233D0, 9.46028328D0, 9.46028423D0,
     &   9.46028519D0, 9.46028709D0, 9.46028805D0, 9.46028900D0,
     &   9.46029091D0, 9.46029186D0, 9.46029377D0, 9.46029568D0,
     &   9.46030045D0, 9.46030426D0, 9.46030617D0, 9.46030807D0/
       DATA  (ESA  (I), I=1401,1500) /
     &   9.46030998D0, 9.46031094D0, 9.46031189D0, 9.46031284D0,
     &   9.46031475D0, 9.46031570D0, 9.46031666D0, 9.46031761D0,
     &   9.46031952D0, 9.46032047D0, 9.46032143D0, 9.46032333D0,
     &   9.46032429D0, 9.46032619D0, 9.46032715D0, 9.46032906D0,
     &   9.46033096D0, 9.46033287D0, 9.46033478D0, 9.46033669D0,
     &   9.46033955D0, 9.46034145D0, 9.46034527D0, 9.46034908D0,
     &   9.46035290D0, 9.46035862D0, 9.46036530D0, 9.46037388D0,
     &   9.46038628D0, 9.46040726D0, 9.46045494D0, 9.46059000D0,
     &   9.46081000D0, 9.46103000D0, 9.46125000D0, 9.46147000D0,
     &   9.46169000D0, 9.46191000D0, 9.46213000D0, 9.46235000D0,
     &   9.46257000D0, 9.46279000D0, 9.46301000D0, 9.46323000D0,
     &   9.46345000D0, 9.46367000D0, 9.46389000D0, 9.46411000D0,
     &   9.46433000D0, 9.46455000D0, 9.46477000D0, 9.46499000D0,
     &   9.46521000D0, 9.46543000D0, 9.46565000D0, 9.46587000D0,
     &   9.46609000D0, 9.46631000D0, 9.46653000D0, 9.46675000D0,
     &   9.46697000D0, 9.46719000D0, 9.46741000D0, 9.46763000D0,
     &   9.46785000D0, 9.46807000D0, 9.46829000D0, 9.46851000D0,
     &   9.46873000D0, 9.46895000D0, 9.46917000D0, 9.46939000D0,
     &   9.46961000D0, 9.46983000D0, 9.47005000D0, 9.47027000D0,
     &   9.47049000D0, 9.47071000D0, 9.47093000D0, 9.47115000D0,
     &   9.47137000D0, 9.47337000D0, 9.47500000D0, 9.47700000D0,
     &   9.48000000D0, 9.48400000D0, 9.49000000D0, 9.49500000D0,
     &   9.50500000D0, 9.51000000D0, 9.51500000D0, 9.52000000D0,
     &   9.52500000D0, 9.53000000D0, 9.54000000D0, 9.55000000D0,
     &   9.60000000D0, 9.70000000D0, 9.80000000D0, 9.90000000D0/
       DATA  (ESA  (I), I=1501,1600) /
     &   9.95000000D0, 9.97500000D0, 9.99000000D0,10.00000000D0,
     &  10.01000000D0,10.01100000D0,10.01200000D0,10.01226000D0,
     &  10.01281000D0,10.01336000D0,10.01391000D0,10.01446000D0,
     &  10.01501000D0,10.01556000D0,10.01611000D0,10.01666000D0,
     &  10.01721000D0,10.01776000D0,10.01831000D0,10.01886000D0,
     &  10.01941000D0,10.01996000D0,10.02051000D0,10.02106000D0,
     &  10.02161000D0,10.02216000D0,10.02250000D0,10.02253750D0,
     &  10.02257500D0,10.02261250D0,10.02265000D0,10.02268750D0,
     &  10.02272500D0,10.02276250D0,10.02280000D0,10.02283750D0,
     &  10.02287500D0,10.02291250D0,10.02295000D0,10.02298750D0,
     &  10.02302500D0,10.02306250D0,10.02310000D0,10.02313750D0,
     &  10.02317500D0,10.02321250D0,10.02322000D0,10.02322500D0,
     &  10.02323000D0,10.02323400D0,10.02323700D0,10.02324000D0,
     &  10.02324200D0,10.02324400D0,10.02324600D0,10.02324800D0,
     &  10.02324930D0,10.02324950D0,10.02324960D0,10.02324980D0,
     &  10.02324988D0,10.02324994D0,10.02325000D0,10.02325060D0,
     &  10.02325150D0,10.02325250D0,10.02325340D0,10.02325440D0,
     &  10.02325540D0,10.02325630D0,10.02325680D0,10.02325730D0,
     &  10.02325780D0,10.02325850D0,10.02325900D0,10.02325950D0,
     &  10.02325980D0,10.02325990D0,10.02325995D0,10.02326000D0,
     &  10.02326005D0,10.02326010D0,10.02326050D0,10.02326100D0,
     &  10.02326150D0,10.02326390D0,10.02326490D0,10.02326680D0,
     &  10.02326770D0,10.02326870D0,10.02326970D0,10.02327060D0,
     &  10.02327160D0,10.02327250D0,10.02327350D0,10.02327440D0,
     &  10.02327540D0,10.02327630D0,10.02327730D0,10.02327820D0/
       DATA  (ESA  (I), I=1601,1700) /
     &  10.02328010D0,10.02328110D0,10.02328210D0,10.02328300D0,
     &  10.02328490D0,10.02328590D0,10.02328750D0,10.02329000D0,
     &  10.02330000D0,10.02331000D0,10.02332000D0,10.02333000D0,
     &  10.02334000D0,10.02335000D0,10.02336250D0,10.02339000D0,
     &  10.02340000D0,10.02341000D0,10.02342000D0,10.02343750D0,
     &  10.02347500D0,10.02351250D0,10.02355000D0,10.02358750D0,
     &  10.02362500D0,10.02366250D0,10.02370000D0,10.02373750D0,
     &  10.02377500D0,10.02381250D0,10.02385000D0,10.02388750D0,
     &  10.02392500D0,10.02396250D0,10.02400000D0,10.02436000D0,
     &  10.02491000D0,10.02546000D0,10.02656000D0,10.02766000D0,
     &  10.02876000D0,10.02986000D0,10.03096000D0,10.03206000D0,
     &  10.03316000D0,10.03426000D0,10.03500000D0,10.03600000D0,
     &  10.03700000D0,10.03800000D0,10.03900000D0,10.04000000D0,
     &  10.04500000D0,10.05000000D0,10.05500000D0,10.06000000D0,
     &  10.06500000D0,10.07000000D0,10.07500000D0,10.08000000D0,
     &  10.20000000D0,10.25000000D0,10.26000000D0,10.27000000D0,
     &  10.28000000D0,10.29000000D0,10.29500000D0,10.30000000D0,
     &  10.31000000D0,10.32000000D0,10.33000000D0,10.34000000D0,
     &  10.34420000D0,10.34493333D0,10.34566667D0,10.34640000D0,
     &  10.34713333D0,10.34786667D0,10.34860000D0,10.34933333D0,
     &  10.35006667D0,10.35080000D0,10.35153333D0,10.35226667D0,
     &  10.35300000D0,10.35309167D0,10.35318333D0,10.35327500D0,
     &  10.35336667D0,10.35345833D0,10.35355000D0,10.35364167D0,
     &  10.35373333D0,10.35382500D0,10.35391667D0,10.35400833D0,
     &  10.35410000D0,10.35419167D0,10.35428333D0,10.35437500D0/
       DATA  (ESA  (I), I=1701,1800) /
     &  10.35440000D0,10.35446667D0,10.35455833D0,10.35465000D0,
     &  10.35474167D0,10.35483334D0,10.35492500D0,10.35501667D0,
     &  10.35510834D0,10.35512330D0,10.35514660D0,10.35515710D0,
     &  10.35516340D0,10.35516780D0,10.35517110D0,10.35517370D0,
     &  10.35517580D0,10.35517760D0,10.35517920D0,10.35518060D0,
     &  10.35518180D0,10.35518290D0,10.35518390D0,10.35518480D0,
     &  10.35518570D0,10.35518650D0,10.35518720D0,10.35518790D0,
     &  10.35518860D0,10.35518930D0,10.35518990D0,10.35519050D0,
     &  10.35519110D0,10.35519170D0,10.35519230D0,10.35519280D0,
     &  10.35519340D0,10.35519400D0,10.35519460D0,10.35519530D0,
     &  10.35519600D0,10.35519680D0,10.35519770D0,10.35519970D0,
     &  10.35520000D0,10.35520100D0,10.35520230D0,10.35520320D0,
     &  10.35520400D0,10.35520470D0,10.35520540D0,10.35520600D0,
     &  10.35520660D0,10.35520720D0,10.35520770D0,10.35520830D0,
     &  10.35520890D0,10.35520950D0,10.35521010D0,10.35521070D0,
     &  10.35521140D0,10.35521210D0,10.35521280D0,10.35521350D0,
     &  10.35521430D0,10.35521520D0,10.35521610D0,10.35521710D0,
     &  10.35521820D0,10.35521940D0,10.35522080D0,10.35522240D0,
     &  10.35522420D0,10.35522630D0,10.35522890D0,10.35523220D0,
     &  10.35523660D0,10.35524290D0,10.35525340D0,10.35527670D0,
     &  10.35529000D0,10.35529300D0,10.35529700D0,10.35531000D0,
     &  10.35532500D0,10.35538334D0,10.35547500D0,10.35556667D0,
     &  10.35565834D0,10.35575000D0,10.35584167D0,10.35593334D0,
     &  10.35602500D0,10.35611667D0,10.35620834D0,10.35630000D0,
     &  10.35639167D0,10.35648334D0,10.35657500D0,10.35666667D0/
       DATA  (ESA  (I), I=1801,1900) /
     &  10.35740000D0,10.35813333D0,10.35886667D0,10.35960000D0,
     &  10.36033333D0,10.36106667D0,10.36180000D0,10.36326667D0,
     &  10.36473333D0,10.36546667D0,10.36620000D0,10.37000000D0,
     &  10.37500000D0,10.38000000D0,10.38500000D0,10.39000000D0,
     &  10.39500000D0,10.40000000D0,10.40500000D0,10.41000000D0,
     &  10.41500000D0,10.42000000D0,10.42500000D0,10.43000000D0,
     &  10.43500000D0,10.44000000D0,10.44500000D0,10.45000000D0,
     &  10.45500000D0,10.46000000D0,10.46500000D0,10.47000000D0,
     &  10.47300000D0,10.52897000D0,10.54217000D0,10.54889000D0,
     &  10.55317000D0,10.55622000D0,10.55855000D0,10.56042000D0,
     &  10.56197000D0,10.56328000D0,10.56442000D0,10.56543000D0,
     &  10.56633000D0,10.56714000D0,10.56788000D0,10.56857000D0,
     &  10.56921000D0,10.56980000D0,10.57036000D0,10.57090000D0,
     &  10.57141000D0,10.57189000D0,10.57237000D0,10.57282000D0,
     &  10.57327000D0,10.57371000D0,10.57415000D0,10.57459000D0,
     &  10.57503000D0,10.57547000D0,10.57594000D0,10.57643000D0,
     &  10.57695000D0,10.57755000D0,10.57829000D0,10.58000000D0,
     &  10.58171000D0,10.58245000D0,10.58305000D0,10.58357000D0,
     &  10.58406000D0,10.58453000D0,10.58497000D0,10.58541000D0,
     &  10.58585000D0,10.58629000D0,10.58673000D0,10.58718000D0,
     &  10.58763000D0,10.58811000D0,10.58859000D0,10.58910000D0,
     &  10.58964000D0,10.59020000D0,10.59079000D0,10.59143000D0,
     &  10.59212000D0,10.59286000D0,10.59367000D0,10.59457000D0,
     &  10.59558000D0,10.59671000D0,10.59803000D0,10.59958000D0,
     &  10.60145000D0,10.60378000D0,10.60683000D0,10.61111000D0/
       DATA  (ESA  (I), I=1901,2000) /
     &  10.61783000D0,10.63103000D0,10.68700000D0,10.69000000D0,
     &  10.71309000D0,10.72975000D0,10.74256000D0,10.75286000D0,
     &  10.76141000D0,10.76869000D0,10.77500000D0,10.78057000D0,
     &  10.78554000D0,10.79004000D0,10.79414000D0,10.79791000D0,
     &  10.80141000D0,10.80468000D0,10.80775000D0,10.81065000D0,
     &  10.81341000D0,10.81604000D0,10.81858000D0,10.82102000D0,
     &  10.82339000D0,10.82570000D0,10.82796000D0,10.83019000D0,
     &  10.83240000D0,10.83460000D0,10.83681000D0,10.83906000D0,
     &  10.84135000D0,10.84374000D0,10.84626000D0,10.84900000D0,
     &  10.85212000D0,10.85601000D0,10.86500000D0,10.87288000D0,
     &  10.87627000D0,10.87895000D0,10.88128000D0,10.88340000D0,
     &  10.88539000D0,10.88728000D0,10.88910000D0,10.89088000D0,
     &  10.89262000D0,10.89434000D0,10.89605000D0,10.89775000D0,
     &  10.89946000D0,10.90119000D0,10.90292000D0,10.90468000D0,
     &  10.90648000D0,10.90830000D0,10.91017000D0,10.91208000D0,
     &  10.91406000D0,10.91609000D0,10.91820000D0,10.92038000D0,
     &  10.92266000D0,10.92504000D0,10.92754000D0,10.93017000D0,
     &  10.93295000D0,10.93590000D0,10.93905000D0,10.94242000D0,
     &  10.94606000D0,10.95000000D0,10.97500000D0,10.97638000D0,
     &  10.97771000D0,10.97900000D0,10.98025000D0,10.98146000D0,
     &  10.98263000D0,10.98377000D0,10.98489000D0,10.98598000D0,
     &  10.98705000D0,10.98810000D0,10.98913000D0,10.99014000D0,
     &  10.99114000D0,10.99213000D0,10.99310000D0,10.99407000D0,
     &  10.99504000D0,10.99600000D0,10.99697000D0,10.99793000D0,
     &  10.99890000D0,10.99988000D0,11.00087000D0,11.00188000D0/
       DATA  (ESA  (I), I=2001,2100) /
     &  11.00290000D0,11.00396000D0,11.00506000D0,11.00621000D0,
     &  11.00742000D0,11.00873000D0,11.01018000D0,11.01186000D0,
     &  11.01399000D0,11.01900000D0,11.02401000D0,11.02614000D0,
     &  11.02782000D0,11.02927000D0,11.03058000D0,11.03179000D0,
     &  11.03294000D0,11.03404000D0,11.03510000D0,11.03612000D0,
     &  11.03713000D0,11.03812000D0,11.03910000D0,11.04007000D0,
     &  11.04103000D0,11.04200000D0,11.04296000D0,11.04392000D0,
     &  11.04490000D0,11.04587000D0,11.04686000D0,11.04786000D0,
     &  11.04887000D0,11.04990000D0,11.05095000D0,11.05202000D0,
     &  11.05311000D0,11.05423000D0,11.05537000D0,11.05654000D0,
     &  11.05775000D0,11.05900000D0,11.06029000D0,11.06162000D0,
     &  11.06300000D0,11.07000000D0,11.09200000D0,11.11500000D0,
     &  11.13700000D0,11.16000000D0,11.18200000D0,11.20500000D0,
     &  11.22700000D0,11.25000000D0,11.27300000D0,11.29500000D0,
     &  11.31800000D0,11.34000000D0,11.50000000D0,11.65500000D0,
     &  11.67700000D0,11.70000000D0,11.72200000D0,11.74500000D0,
     &  11.76700000D0,11.79000000D0,11.81200000D0,11.83500000D0,
     &  11.85800000D0,11.88000000D0,11.90300000D0,11.92500000D0,
     &  11.94800000D0,11.97000000D0,11.99300000D0,12.01500000D0,
     &  12.03800000D0,12.06000000D0,12.08300000D0,12.10500000D0,
     &  12.12700000D0,12.15000000D0,12.17200000D0,12.19500000D0,
     &  12.21700000D0,12.24000000D0,12.26200000D0,12.28500000D0,
     &  12.30700000D0,12.33000000D0,12.35200000D0,12.37500000D0,
     &  12.39800000D0,12.42000000D0,12.44300000D0,12.46500000D0,
     &  12.48800000D0,12.51000000D0,12.53300000D0,12.55500000D0/
       DATA  (ESA  (I), I=2101,2174) /
     &  12.57800000D0,12.60000000D0,12.62300000D0,12.64500000D0,
     &  12.66700000D0,12.69000000D0,12.71200000D0,12.73500000D0,
     &  12.75700000D0,12.78000000D0,12.80200000D0,12.82500000D0,
     &  12.84700000D0,12.87000000D0,12.89200000D0,12.91500000D0,
     &  12.93800000D0,12.96000000D0,12.98300000D0,13.00500000D0,
     &  13.02800000D0,13.05000000D0,13.07300000D0,13.09500000D0,
     &  13.11800000D0,13.14000000D0,13.16300000D0,13.18500000D0,
     &  13.20800000D0,13.23000000D0,13.25200000D0,13.27500000D0,
     &  13.29700000D0,13.32000000D0,13.34200000D0,13.36500000D0,
     &  13.38700000D0,13.41000000D0,13.43200000D0,13.45500000D0,
     &  13.47700000D0,13.50000000D0,13.75000000D0,14.00000000D0,
     &  14.04000000D0,16.00000000D0,17.00000000D0,20.00000000D0,
     &  21.95000000D0,22.05000000D0,25.00000000D0,25.01000000D0,
     &  27.50000000D0,27.60000000D0,27.66000000D0,29.00000000D0,
     &  29.93000000D0,30.10000000D0,30.38000000D0,30.80000000D0,
     &  31.10000000D0,31.29000000D0,33.20000000D0,33.30000000D0,
     &  33.89000000D0,34.00000000D0,34.50000000D0,34.70000000D0,
     &  34.86000000D0,35.01000000D0,35.45000000D0,36.10000000D0,
     &  36.38000000D0,38.29000000D0/
  
         DATA ((DGS  (I,J), I=   1, 100), J=1,1) /
     &  -1.90388028E-03,-2.02597482E-03,-2.14336613E-03,-2.26246832E-03,
     &  -2.38604863E-03,-2.44731077E-03,-2.55300745E-03,-2.74463194E-03,
     &  -2.82171653E-03,-2.89766587E-03,-3.01680401E-03,-3.13139284E-03,
     &  -3.26192788E-03,-3.34746348E-03,-3.45358678E-03,-3.56045377E-03,
     &  -3.66735812E-03,-3.77546844E-03,-3.86354965E-03,-3.97586562E-03,
     &  -4.06804666E-03,-4.18216679E-03,-4.27267801E-03,-4.39176306E-03,
     &  -4.48995007E-03,-4.58717026E-03,-4.70844999E-03,-4.77523519E-03,
     &  -4.80712590E-03,-4.90920114E-03,-5.01386042E-03,-5.11852446E-03,
     &  -5.22458733E-03,-5.33257290E-03,-5.44576293E-03,-5.56409047E-03,
     &  -5.68210021E-03,-5.79898619E-03,-5.92992214E-03,-6.06181147E-03,
     &  -6.16006626E-03,-6.29155381E-03,-6.42440181E-03,-6.52619849E-03,
     &  -6.66258906E-03,-6.80311792E-03,-6.91263660E-03,-7.06460041E-03,
     &  -7.17962527E-03,-7.34154341E-03,-8.23587763E-03,-9.19161666E-03,
     &  -1.05333546E-02,-1.22552698E-02,-1.28119642E-02,-1.29769778E-02,
     &  -1.33965896E-02,-1.40319114E-02,-1.46746493E-02,-1.53133224E-02,
     &  -1.59572556E-02,-1.61950631E-02,-1.65851817E-02,-1.72321842E-02,
     &  -1.77429892E-02,-1.82457587E-02,-1.86317030E-02,-1.89193935E-02,
     &  -1.88955747E-02,-1.88971020E-02,-1.88518514E-02,-1.87378928E-02,
     &  -1.82018884E-02,-1.72990201E-02,-1.60411961E-02,-1.41665714E-02,
     &  -1.17591182E-02,-8.80968466E-03,-5.82087865E-03,-4.75924812E-03,
     &  -1.86220134E-03,-4.56287161E-04, 1.07708093E-03, 2.26960932E-03,
     &   4.05959105E-03, 6.01518485E-03, 7.10236602E-03, 7.90038901E-03,
     &   8.51205594E-03, 8.98444177E-03, 9.43497433E-03, 9.77702790E-03,
     &   1.00725943E-02, 1.03746880E-02, 1.06955651E-02, 1.11688989E-02,
     &   1.13398263E-02, 1.15133176E-02, 1.17543252E-02, 1.19571776E-02/
  
         DATA ((DGS  (I,J), I= 101, 200), J=1,1) /
     &   1.21100785E-02, 1.22474350E-02, 1.23775165E-02, 1.25018570E-02,
     &   1.26171829E-02, 1.26979281E-02, 1.27770664E-02, 1.28545979E-02,
     &   1.29221209E-02, 1.29821944E-02, 1.30448398E-02, 1.30769348E-02,
     &   1.31100122E-02, 1.31448909E-02, 1.31616183E-02, 1.31767248E-02,
     &   1.31815964E-02, 1.31704740E-02, 1.32053503E-02, 1.32582201E-02,
     &   1.33261551E-02, 1.34047257E-02, 1.34966055E-02, 1.36025836E-02,
     &   1.37153532E-02, 1.38357405E-02, 1.39709172E-02, 1.41219428E-02,
     &   1.42845899E-02, 1.44468417E-02, 1.46399937E-02, 1.48307309E-02,
     &   1.50276883E-02, 1.52121884E-02, 1.54293792E-02, 1.56171471E-02,
     &   1.57734190E-02, 1.58972265E-02, 1.59102468E-02, 1.59730034E-02,
     &   1.60909937E-02, 1.62555685E-02, 1.64230701E-02, 1.65725164E-02,
     &   1.67242128E-02, 1.68916066E-02, 1.70555178E-02, 1.72256576E-02,
     &   1.74370749E-02, 1.76277531E-02, 1.79235137E-02, 1.83978412E-02,
     &   1.85422266E-02, 1.89949586E-02, 1.94476906E-02, 1.98464596E-02,
     &   2.02012165E-02, 2.04472428E-02, 2.06389551E-02, 2.07655117E-02,
     &   2.09355050E-02, 2.11689541E-02, 2.12239586E-02, 2.12622721E-02,
     &   2.12586025E-02, 2.12609712E-02, 2.11891808E-02, 2.11693891E-02,
     &   2.09564457E-02, 2.05919450E-02, 2.00869612E-02, 1.97248094E-02,
     &   1.91562163E-02, 1.85323675E-02, 1.78416498E-02, 1.72480023E-02,
     &   1.64953347E-02, 1.57145044E-02, 1.50475098E-02, 1.46544845E-02,
     &   1.38971999E-02, 1.35614951E-02, 1.27154852E-02, 1.19577586E-02,
     &   1.10765606E-02, 1.02544724E-02, 9.24033641E-03, 8.31750953E-03,
     &   7.34866577E-03, 6.05251286E-03, 5.37131293E-03, 4.87780737E-03,
     &   3.84342888E-03, 3.27984680E-03, 2.70885032E-03, 2.08179728E-03,
     &   1.40063101E-03, 6.77375300E-04,-3.97156817E-05,-1.69461241E-03/
  
         DATA ((DGS  (I,J), I= 201, 300), J=1,1) /
     &  -3.49922500E-03,-4.56799718E-03,-4.96301817E-03,-5.39530826E-03,
     &  -5.81190627E-03,-6.24247446E-03,-6.65465896E-03,-7.18748879E-03,
     &  -7.73654418E-03,-8.20602100E-03,-8.75395560E-03,-9.30209127E-03,
     &  -9.91715120E-03,-1.05247552E-02,-1.11773243E-02,-1.18592976E-02,
     &  -1.25976548E-02,-1.32933275E-02,-1.40659641E-02,-1.48808107E-02,
     &  -1.57412029E-02,-1.63941199E-02,-1.75415337E-02,-1.86399557E-02,
     &  -1.97288509E-02,-2.09014595E-02,-2.21139005E-02,-2.34414001E-02,
     &  -2.48558115E-02,-2.63666648E-02,-2.69790911E-02,-2.78451923E-02,
     &  -2.81278061E-02,-3.02680095E-02,-3.22461855E-02,-3.42775246E-02,
     &  -3.65026606E-02,-3.88007065E-02,-4.14375795E-02,-4.39719227E-02,
     &  -4.68728176E-02,-5.00171659E-02,-5.29657178E-02,-5.72910762E-02,
     &  -6.16164345E-02,-6.61454713E-02,-7.16569897E-02,-7.77454647E-02,
     &  -8.46571707E-02,-9.25282346E-02,-1.01624601E-01,-1.12127061E-01,
     &  -1.24299973E-01,-1.36088224E-01,-1.42480630E-01,-1.47009356E-01,
     &  -1.52912525E-01,-1.55827200E-01,-1.54085411E-01,-1.64807202E-01,
     &  -1.69122304E-01,-1.73009347E-01,-1.76459414E-01,-1.79238840E-01,
     &  -1.80990238E-01,-1.81331274E-01,-1.78317623E-01,-1.72907591E-01,
     &  -1.69080751E-01,-1.58583233E-01,-1.43847190E-01,-1.24400439E-01,
     &  -9.25381295E-02,-7.12563693E-02,-3.86864033E-02,-3.75465633E-03,
     &   3.17976420E-02, 6.61450821E-02, 9.76614664E-02, 1.25104909E-01,
     &   1.47894897E-01, 1.65890936E-01, 1.79296987E-01, 1.88652683E-01,
     &   1.94636189E-01, 1.97785301E-01, 1.98777898E-01, 1.98073080E-01,
     &   1.96128201E-01, 1.93208780E-01, 1.87871559E-01, 1.86353669E-01,
     &   1.78773322E-01, 1.76873403E-01, 1.72812121E-01, 1.68388116E-01,
     &   1.64033309E-01, 1.59754048E-01, 1.55598881E-01, 1.51544331E-01/
  
         DATA ((DGS  (I,J), I= 301, 400), J=1,1) /
     &   1.50980256E-01, 1.43872815E-01, 1.40255076E-01, 1.36789459E-01,
     &   1.25596935E-01, 1.16007485E-01, 1.07672409E-01, 1.00442600E-01,
     &   9.41338115E-02, 8.74467937E-02, 8.36868383E-02, 7.93155906E-02,
     &   7.54673394E-02, 7.19958081E-02, 6.88289317E-02, 6.59795375E-02,
     &   6.34608859E-02, 6.10667406E-02, 5.89088896E-02, 5.69292545E-02,
     &   5.52549767E-02, 5.35598081E-02, 5.36061683E-02, 5.06016933E-02,
     &   4.93091264E-02, 4.87963679E-02, 4.95381131E-02, 4.85152689E-02,
     &   4.69012737E-02, 4.58068209E-02, 4.47905859E-02, 4.38695268E-02,
     &   4.30332407E-02, 4.22002356E-02, 4.14253334E-02, 4.06922935E-02,
     &   3.99983987E-02, 3.93341764E-02, 3.87045075E-02, 3.80938918E-02,
     &   3.75366997E-02, 3.69784447E-02, 3.64484487E-02, 3.59350969E-02,
     &   3.54021734E-02, 3.49770578E-02, 3.45338842E-02, 3.40630793E-02,
     &   3.36771956E-02, 3.32809489E-02, 3.28831791E-02, 3.24995738E-02,
     &   3.21534411E-02, 3.17261615E-02, 3.13683469E-02, 3.10665363E-02,
     &   3.01151953E-02, 2.80851546E-02, 2.49718351E-02, 2.26831183E-02,
     &   2.09236352E-02, 1.95192226E-02, 1.83150769E-02, 1.72657934E-02,
     &   1.63923714E-02, 1.62898273E-02, 1.52752263E-02, 1.45994421E-02,
     &   1.43847885E-02, 1.38466302E-02, 1.33364956E-02, 1.32807380E-02,
     &   1.28499042E-02, 1.24133328E-02, 1.21779073E-02, 1.19706168E-02,
     &   1.15555243E-02, 1.12219194E-02, 1.09154708E-02, 1.06921902E-02,
     &   1.05518807E-02, 1.04511752E-02, 1.02226520E-02, 1.00291898E-02,
     &   1.00123489E-02, 9.83062651E-03, 9.64957554E-03, 9.59715265E-03,
     &   9.48359792E-03, 9.31020073E-03, 9.15651526E-03, 8.98676391E-03,
     &   8.93803050E-03, 8.82269271E-03, 8.74999378E-03, 8.62875000E-03,
     &   8.48013270E-03, 8.38327043E-03, 8.37759302E-03, 8.29861855E-03/
  
         DATA ((DGS  (I,J), I= 401, 500), J=1,1) /
     &   8.09018541E-03, 7.87824468E-03, 7.67546413E-03, 7.56105433E-03,
     &   7.53589398E-03, 7.47214718E-03, 7.57784057E-03, 7.63276741E-03,
     &   7.69410071E-03, 7.81567141E-03, 7.88539692E-03, 7.89051586E-03,
     &   7.88469957E-03, 7.78677676E-03, 7.77199836E-03, 7.69797211E-03,
     &   7.63307207E-03, 7.40231430E-03, 7.36805413E-03, 7.17201918E-03,
     &   7.16057600E-03, 7.14762624E-03, 7.02609289E-03, 6.88366349E-03,
     &   6.85058883E-03, 6.60155838E-03, 6.57668135E-03, 6.45192701E-03,
     &   6.42635925E-03, 6.29314596E-03, 6.24163424E-03, 6.15046536E-03,
     &   6.14875730E-03, 6.23989784E-03, 6.42002088E-03, 6.56871639E-03,
     &   6.59661451E-03, 7.04187222E-03, 7.10814683E-03, 7.43309184E-03,
     &   7.59185174E-03, 7.64142037E-03, 7.67491244E-03, 7.69111755E-03,
     &   7.84922408E-03, 7.88067432E-03, 8.00251828E-03, 8.14943756E-03,
     &   8.22986455E-03, 8.52848669E-03, 8.87581377E-03, 8.95554970E-03,
     &   8.99645609E-03, 9.26735575E-03, 9.41295027E-03, 9.56587862E-03,
     &   1.02527835E-02, 1.03374623E-02, 1.05508266E-02, 1.06345750E-02,
     &   1.06368309E-02, 1.06268201E-02, 1.06021747E-02, 1.05848728E-02,
     &   1.05664610E-02, 1.05162956E-02, 1.04521753E-02, 1.04808726E-02,
     &   1.06208888E-02, 1.07725714E-02, 1.07871267E-02, 1.09181621E-02,
     &   1.09560326E-02, 1.09718041E-02, 1.09723995E-02, 1.09678364E-02,
     &   1.09642847E-02, 1.09509953E-02, 1.08943677E-02, 1.07025379E-02,
     &   1.06611695E-02, 1.02576804E-02, 1.00376443E-02, 9.88657262E-03,
     &   9.47438971E-03, 9.11613249E-03, 9.05892306E-03, 9.03295456E-03,
     &   9.02524689E-03, 9.02345450E-03, 9.01334716E-03, 9.01134449E-03,
     &   9.00872919E-03, 9.00034334E-03, 8.98199455E-03, 8.96932856E-03,
     &   8.49559143E-03, 7.93333687E-03, 7.83277458E-03, 8.11419735E-03/
  
         DATA ((DGS  (I,J), I= 501, 600), J=1,1) /
     &   8.52849240E-03, 9.10709398E-03, 9.79413533E-03, 9.88612567E-03,
     &   9.93922310E-03, 9.96557442E-03, 9.88753658E-03, 9.74505797E-03,
     &   9.55027824E-03, 9.33855426E-03, 9.05529874E-03, 8.67380796E-03,
     &   8.12414967E-03, 7.31651412E-03, 6.12484017E-03, 4.31755826E-03,
     &   3.84129093E-03, 3.31228148E-03, 2.72053853E-03, 2.05401371E-03,
     &   1.29777141E-03, 4.32198795E-04,-5.68978276E-04,-7.88274230E-04,
     &  -1.01453091E-03,-1.24879681E-03,-1.49027614E-03,-1.74018107E-03,
     &  -1.99870567E-03,-2.26661205E-03,-2.53787759E-03,-2.82510203E-03,
     &  -3.12313055E-03,-4.63087993E-03,-5.78687120E-03,-6.42132816E-03,
     &  -6.86964137E-03,-7.33991867E-03,-7.83264543E-03,-8.34976263E-03,
     &  -8.89286650E-03,-9.46412610E-03,-9.76099267E-03,-1.00661853E-02,
     &  -1.03792648E-02,-1.07009021E-02,-1.10316183E-02,-1.13714608E-02,
     &  -1.17208171E-02,-1.20805674E-02,-1.24509426E-02,-1.28324214E-02,
     &  -1.32254989E-02,-1.36307102E-02,-1.40486273E-02,-1.44798452E-02,
     &  -1.49250184E-02,-1.53847513E-02,-1.58601180E-02,-1.63514064E-02,
     &  -1.68597547E-02,-1.73859886E-02,-1.79310573E-02,-1.84959945E-02,
     &  -1.90819086E-02,-1.96899917E-02,-2.03215226E-02,-2.09778347E-02,
     &  -2.16606142E-02,-2.23713831E-02,-2.31119080E-02,-2.38840914E-02,
     &  -2.46899161E-02,-2.55316296E-02,-2.64117822E-02,-2.73330817E-02,
     &  -2.82981825E-02,-2.93106540E-02,-3.03737422E-02,-3.14916198E-02,
     &  -3.26683519E-02,-3.39089203E-02,-3.45548254E-02,-3.52187102E-02,
     &  -3.59013301E-02,-3.66034579E-02,-3.73259813E-02,-3.80698749E-02,
     &  -3.88358789E-02,-3.96254629E-02,-4.04392224E-02,-4.12783340E-02,
     &  -4.21444872E-02,-4.30384330E-02,-4.39616497E-02,-4.49160572E-02,
     &  -4.59027415E-02,-4.69235455E-02,-4.79802711E-02,-4.90748492E-02/
  
         DATA ((DGS  (I,J), I= 601, 700), J=1,1) /
     &  -5.02094125E-02,-5.13861293E-02,-5.26073911E-02,-5.38757848E-02,
     &  -5.51940862E-02,-5.65653063E-02,-5.79927114E-02,-5.94798075E-02,
     &  -6.10304214E-02,-6.26487116E-02,-6.43392100E-02,-6.61069703E-02,
     &  -6.79572040E-02,-6.98959317E-02,-7.19296964E-02,-7.40655484E-02,
     &  -7.63115776E-02,-7.86764138E-02,-8.11697408E-02,-8.38023469E-02,
     &  -8.77448917E-02,-8.95348225E-02,-9.26629926E-02,-9.59881558E-02,
     &  -9.95294273E-02,-1.03308209E-01,-1.07349479E-01,-1.11681603E-01,
     &  -1.16337186E-01,-1.21353897E-01,-1.26775516E-01,-1.32653365E-01,
     &  -1.39047256E-01,-1.44152295E-01,-1.60062691E-01,-1.79562529E-01,
     &  -2.04025571E-01,-2.35634622E-01,-2.78088252E-01,-3.38300848E-01,
     &  -4.34191429E-01,-5.82159094E-01,-8.92959304E-01,-1.88986646E+00,
     &  -1.99907062E+00,-2.12154962E+00,-2.26008135E+00,-2.41723332E+00,
     &  -2.59793396E+00,-2.80750812E+00,-3.05342343E+00,-3.34594213E+00,
     &  -3.69954347E+00,-4.13530539E+00,-4.68531640E+00,-5.37693418E+00,
     &  -6.36087852E+00,-6.47554831E+00,-9.04319078E+00,-1.09145891E+01,
     &  -1.24182207E+01,-7.74366056E+00,-1.47374253E+01,-1.50573184E+01,
     &  -1.63124855E+01,-1.70199416E+01,-1.75112224E+01,-1.79648336E+01,
     &  -1.82799970E+01,-1.85336390E+01,-1.86720994E+01,-1.87706892E+01,
     &  -1.87761374E+01,-1.87189439E+01,-1.85695033E+01,-1.84096345E+01,
     &  -1.80638745E+01,-1.77527401E+01,-1.73687491E+01,-1.65704947E+01,
     &  -1.57891237E+01,-1.49302159E+01,-1.39987525E+01,-1.41253221E+01,
     &  -1.31788378E+01,-1.21292961E+01,-1.09791769E+01,-9.07657887E+00,
     &  -7.70113675E+00,-5.55834102E+00,-3.18304324E+00, 3.21043996E+00,
     &   9.09782954E+00, 1.09977144E+01, 1.26831856E+01, 1.36804168E+01,
     &   1.49835147E+01, 1.49800023E+01, 1.58289158E+01, 1.65988227E+01/
  
         DATA ((DGS  (I,J), I= 701, 800), J=1,1) /
     &   1.72856197E+01, 1.77757169E+01, 1.81474145E+01, 1.83370896E+01,
     &   1.85257490E+01, 1.86616264E+01, 1.87505310E+01, 1.88071360E+01,
     &   1.45795495E+01, 1.54256763E+01, 1.86081670E+01, 1.84976162E+01,
     &   1.82236937E+01, 1.79818387E+01, 1.76250598E+01, 1.72426807E+01,
     &   1.67458767E+01, 1.63446294E+01, 1.51547025E+01, 1.48548357E+01,
     &   1.40172467E+01, 1.30733579E+01, 1.18593654E+01, 1.03602588E+01,
     &   8.72978244E+00, 7.19568580E+00, 6.00404394E+00, 5.14419002E+00,
     &   4.49676444E+00, 3.99265241E+00, 3.58945894E+00, 3.25986731E+00,
     &   2.98561835E+00, 2.75371670E+00, 2.55528266E+00, 2.38353331E+00,
     &   2.23344687E+00, 2.10117840E+00, 1.98374169E+00, 1.87878073E+00,
     &   1.78441212E+00, 1.69911299E+00, 1.62163814E+00, 8.56275280E-01,
     &   5.84541552E-01, 4.45638777E-01, 3.63418430E-01, 3.03214694E-01,
     &   2.61773924E-01, 2.30810694E-01, 2.06738251E-01, 1.87472342E-01,
     &   1.71699215E-01, 1.69831991E-01, 1.56818616E-01, 1.45801342E-01,
     &   1.36353040E-01, 1.28160413E-01, 1.20988544E-01, 1.14662309E-01,
     &   1.09032414E-01, 1.03993378E-01, 9.94568291E-02, 9.53507523E-02,
     &   9.16168013E-02, 8.82064951E-02, 8.50794356E-02, 8.22017414E-02,
     &   7.95447102E-02, 7.70836014E-02, 7.47982409E-02, 7.26694865E-02,
     &   7.06827442E-02, 6.88235067E-02, 6.70800685E-02, 6.54419359E-02,
     &   6.38998439E-02, 6.24455660E-02, 6.10717271E-02, 5.97721237E-02,
     &   5.85405104E-02, 5.73718355E-02, 5.62611454E-02, 5.52046313E-02,
     &   5.41982460E-02, 5.32384979E-02, 5.23222155E-02, 5.14465444E-02,
     &   5.06088055E-02, 4.98065981E-02, 4.90373627E-02, 4.83002805E-02,
     &   4.75920190E-02, 4.69111608E-02, 4.62567251E-02, 4.56269071E-02,
     &   4.50203692E-02, 4.44358194E-02, 4.38720989E-02, 4.33281128E-02/
  
         DATA ((DGS  (I,J), I= 801, 900), J=1,1) /
     &   4.28026036E-02, 4.22956760E-02, 4.18050717E-02, 4.13302223E-02,
     &   4.08709963E-02, 4.04263794E-02, 3.99956876E-02, 3.95782780E-02,
     &   3.91735628E-02, 3.87809878E-02, 3.84000333E-02, 3.80302150E-02,
     &   3.76709534E-02, 3.73222017E-02, 3.69831866E-02, 3.66536649E-02,
     &   3.63332578E-02, 3.60216435E-02, 3.57185156E-02, 3.54235894E-02,
     &   3.51365776E-02, 3.48572860E-02, 3.45856886E-02, 3.43209149E-02,
     &   3.40635086E-02, 3.38130823E-02, 3.35694986E-02, 3.33326902E-02,
     &   3.31026257E-02, 3.28793182E-02, 3.26628430E-02, 3.24534920E-02,
     &   3.22512385E-02, 3.20565337E-02, 3.18702283E-02, 3.16931229E-02,
     &   3.11476769E-02, 3.09485295E-02, 3.07533465E-02, 3.05619767E-02,
     &   3.03739230E-02, 3.01911626E-02, 3.00083638E-02, 2.98322959E-02,
     &   2.96564669E-02, 2.94927179E-02, 2.93201413E-02, 2.91601531E-02,
     &   2.89996225E-02, 2.88450363E-02, 2.86905763E-02, 2.85386071E-02,
     &   2.83905825E-02, 2.82445829E-02, 2.81002591E-02, 2.79595442E-02,
     &   2.36871787E-02, 2.06783348E-02, 1.80074391E-02, 1.56094985E-02,
     &   1.40134417E-02, 1.32685674E-02, 1.23980849E-02, 1.13300017E-02,
     &   1.03146831E-02, 8.91412051E-03, 8.18781005E-03, 7.10247308E-03,
     &   7.12317832E-03, 6.80005995E-03, 5.88030629E-03, 4.87487735E-03,
     &   3.73320316E-03, 2.39910291E-03, 8.06155156E-04,-1.14277596E-03,
     &  -3.59616776E-03,-4.76930240E-03,-6.08293493E-03,-7.56522916E-03,
     &  -9.25235573E-03,-1.11915938E-02,-1.34458342E-02,-1.47167029E-02,
     &  -1.61008510E-02,-1.76143179E-02,-1.92764992E-02,-2.11108558E-02,
     &  -2.31456678E-02,-2.54165048E-02,-2.79673337E-02,-3.08539071E-02,
     &  -3.41478286E-02,-3.79429322E-02,-4.23634666E-02,-4.73528378E-02,
     &  -5.06188477E-02,-5.42429809E-02,-5.82879034E-02,-6.28318399E-02/
  
         DATA ((DGS  (I,J), I= 901,1000), J=1,1) /
     &  -6.79737334E-02,-7.38406110E-02,-8.05983409E-02,-8.84677669E-02,
     &  -9.77496177E-02,-1.08864655E-01,-1.22420114E-01,-1.39327883E-01,
     &  -1.61024733E-01,-1.89925220E-01,-2.30455650E-01,-2.91921826E-01,
     &  -4.00645266E-01,-5.92949413E-01,-8.68293473E-01,-1.02797021E+00,
     &  -1.20274064E+00,-1.63378437E+00,-1.78958769E+00,-1.83929972E+00,
     &  -2.02614157E+00,-2.09785916E+00,-2.19368769E+00,-2.25843349E+00,
     &  -2.27299671E+00,-2.31511104E+00,-2.38205071E+00,-2.40501361E+00,
     &  -2.41859721E+00,-2.42343594E+00,-2.41982399E+00,-2.41017797E+00,
     &  -2.39070994E+00,-2.36531777E+00,-2.33419208E+00,-2.29155408E+00,
     &  -2.24117829E+00,-2.17660906E+00,-2.11123336E+00,-2.03614755E+00,
     &  -1.95082874E+00,-1.83783854E+00,-1.72915416E+00,-1.58839341E+00,
     &  -1.45586152E+00,-1.26264009E+00,-1.05177322E+00,-7.36838547E-01,
     &  -4.62324026E-01,-1.46123510E-01, 1.40388942E-02, 1.74203141E-01,
     &   3.33334195E-01, 7.64959815E-01, 1.07994068E+00, 1.29084910E+00,
     &   1.48411741E+00, 1.61668701E+00, 1.75749406E+00, 1.86621912E+00,
     &   1.97925765E+00, 2.06461792E+00, 2.13974493E+00, 2.20516673E+00,
     &   2.26978178E+00, 2.32014278E+00, 2.36282384E+00, 2.39404199E+00,
     &   2.41947261E+00, 2.43898228E+00, 2.44866286E+00, 2.45231648E+00,
     &   2.44751662E+00, 2.43397307E+00, 2.41105082E+00, 2.34385401E+00,
     &   2.30179449E+00, 2.28755141E+00, 2.22284544E+00, 2.12684331E+00,
     &   2.05538278E+00, 1.86937140E+00, 1.81889248E+00, 1.66312411E+00,
     &   1.47479864E+00, 1.57704122E+00, 1.35228616E+00, 1.21403445E+00,
     &   1.13053134E+00, 9.57930656E-01, 8.97744328E-01, 7.73074578E-01,
     &   9.38131998E-01, 3.63585847E-01, 2.85398248E-01, 2.36635930E-01,
     &   2.02970301E-01, 1.78244498E-01, 1.59283737E-01, 1.44267669E-01/
  
         DATA ((DGS  (I,J), I=1001,1100), J=1,1) /
     &   1.32072175E-01, 1.21963304E-01, 1.13438642E-01, 1.06129501E-01,
     &   9.98314060E-02, 9.44256799E-02, 8.96341275E-02, 8.53750609E-02,
     &   8.15704552E-02, 7.81533970E-02, 7.27244528E-02, 6.59480795E-02,
     &   6.23161121E-02, 5.63687864E-02, 5.17015262E-02, 4.71043073E-02,
     &   4.05507323E-02, 3.31183346E-02, 2.84793320E-02, 2.63230486E-02,
     &   2.52039898E-02, 2.43765046E-02, 2.37658723E-02, 2.32707501E-02,
     &   2.29057647E-02, 2.25860124E-02, 2.23171058E-02, 2.20864805E-02,
     &   2.18871156E-02, 2.17572876E-02, 2.15601488E-02, 2.14258223E-02,
     &   2.13074277E-02, 2.12031288E-02, 2.11117465E-02, 2.10316156E-02,
     &   2.09619074E-02, 2.09019355E-02, 2.08510663E-02, 2.08090383E-02,
     &   2.07196167E-02, 2.07507566E-02, 2.07346684E-02, 2.07278306E-02,
     &   2.07289040E-02, 2.07436096E-02, 2.07733913E-02, 2.08166085E-02,
     &   2.08807509E-02, 2.09759784E-02, 2.11285970E-02, 2.16170586E-02,
     &   2.22325427E-02, 2.25239371E-02, 2.27592442E-02, 2.29633708E-02,
     &   2.31462495E-02, 2.33115719E-02, 2.34629580E-02, 2.36007043E-02,
     &   2.37251647E-02, 2.38282144E-02, 2.39335137E-02, 2.40138221E-02,
     &   2.40057313E-02, 2.40305643E-02, 2.37751413E-02, 2.41984272E-02,
     &   2.43399150E-02, 2.44541028E-02, 2.45146989E-02, 2.45539278E-02,
     &   2.45719996E-02, 2.45691122E-02, 2.45442457E-02, 2.44956478E-02,
     &   2.44096275E-02, 2.46826119E-02, 2.41703683E-02, 2.39860818E-02,
     &   2.37562996E-02, 2.34669481E-02, 2.31054078E-02, 2.26437159E-02,
     &   2.20213029E-02, 2.11260274E-02, 2.08588464E-02, 2.01497316E-02,
     &   1.90854966E-02, 1.89758508E-02, 1.82405081E-02, 1.79413424E-02,
     &   1.77032685E-02, 1.75015247E-02, 1.71867600E-02, 1.68523087E-02,
     &   1.67807541E-02, 1.67711728E-02, 1.67153468E-02, 1.66129398E-02/
  
         DATA ((DGS  (I,J), I=1101,1200), J=1,1) /
     &   1.65575936E-02, 1.65760031E-02, 1.67969503E-02, 1.67740660E-02,
     &   1.65341022E-02, 1.64379253E-02, 1.62507826E-02, 1.55864901E-02,
     &   1.54291679E-02, 1.57692640E-02, 1.56557975E-02, 1.53734707E-02,
     &   1.49498815E-02, 1.43662745E-02, 1.39932500E-02, 1.34218646E-02,
     &   1.30487315E-02, 1.32444249E-02, 1.41384700E-02, 1.47501270E-02,
     &   1.61289706E-02, 1.67099911E-02, 1.71858066E-02, 1.77166743E-02,
     &   1.81284407E-02, 1.80443720E-02, 1.79363864E-02, 1.81494714E-02,
     &   1.87695428E-02, 1.83165707E-02, 1.77505266E-02, 1.78512332E-02,
     &   1.80440085E-02, 1.81801380E-02, 1.83777883E-02, 1.84034598E-02,
     &   1.82691333E-02, 1.79816797E-02, 1.78096935E-02, 1.74806675E-02,
     &   1.74406979E-02, 1.76610759E-02, 1.79104314E-02, 1.82214216E-02,
     &   1.83583321E-02, 1.86486657E-02, 1.87712249E-02, 1.86042815E-02,
     &   1.87656970E-02, 1.91270403E-02, 1.95108915E-02, 1.99007573E-02,
     &   2.01333174E-02, 2.03309135E-02, 2.05746244E-02, 2.07598221E-02,
     &   2.08930877E-02, 2.10350612E-02, 2.12370558E-02, 2.14111630E-02,
     &   2.15635917E-02, 2.17203153E-02, 2.14668062E-02, 2.06749277E-02,
     &   2.05015294E-02, 2.06272334E-02, 2.08888918E-02, 2.05846692E-02,
     &   2.05823210E-02, 2.08006591E-02, 2.09399708E-02, 1.97453223E-02,
     &   1.84759647E-02, 1.80523185E-02, 1.77486995E-02, 1.82311581E-02,
     &   1.82428155E-02, 1.80429019E-02, 1.78667443E-02, 1.77638355E-02,
     &   1.76178740E-02, 1.74228994E-02, 1.68785476E-02, 1.69159455E-02,
     &   1.69644521E-02, 1.68671628E-02, 1.68312399E-02, 1.68117709E-02,
     &   1.68969527E-02, 1.69392297E-02, 1.69623881E-02, 1.70252352E-02,
     &   1.70047071E-02, 1.70721726E-02, 1.76873949E-02, 1.83441154E-02,
     &   1.85293805E-02, 1.85843811E-02, 1.86184396E-02, 1.84087594E-02/
  
         DATA ((DGS  (I,J), I=1201,1300), J=1,1) /
     &   1.88427127E-02, 1.93784769E-02, 1.95837010E-02, 1.96689009E-02,
     &   1.98167391E-02, 1.98388741E-02, 1.96943714E-02, 1.94385294E-02,
     &   1.93514327E-02, 1.94568249E-02, 1.94741866E-02, 1.90412309E-02,
     &   1.90658587E-02, 1.93365637E-02, 1.92784668E-02, 1.89964789E-02,
     &   1.88582568E-02, 1.89104352E-02, 1.90816559E-02, 1.90921300E-02,
     &   1.94741547E-02, 1.96607764E-02, 2.00472862E-02, 2.04579528E-02,
     &   2.05985911E-02, 2.02250182E-02, 2.05450791E-02, 2.07621800E-02,
     &   2.10943173E-02, 2.12356543E-02, 2.13673048E-02, 2.16100263E-02,
     &   2.18329475E-02, 2.19386805E-02, 2.20411758E-02, 2.21407521E-02,
     &   2.22376658E-02, 2.23321265E-02, 2.24243082E-02, 2.25143565E-02,
     &   2.26023957E-02, 2.26885311E-02, 2.27728538E-02, 2.28554421E-02,
     &   2.29363691E-02, 2.30156842E-02, 2.30934434E-02, 2.31696925E-02,
     &   2.32444691E-02, 2.33178074E-02, 2.33897362E-02, 2.34602794E-02,
     &   2.35294580E-02, 2.35972884E-02, 2.36637839E-02, 2.37289541E-02,
     &   2.37928059E-02, 2.38553424E-02, 2.39165642E-02, 2.39764685E-02,
     &   2.40350492E-02, 2.40922975E-02, 2.41482008E-02, 2.42027434E-02,
     &   2.42559060E-02, 2.43076651E-02, 2.43579940E-02, 2.43972057E-02,
     &   2.44542278E-02, 2.45442941E-02, 2.46277864E-02, 2.47041841E-02,
     &   2.47728209E-02, 2.48328435E-02, 2.48831475E-02, 2.49222889E-02,
     &   2.49483486E-02, 2.49587221E-02, 2.49497818E-02, 2.49163072E-02,
     &   2.48504903E-02, 2.47400042E-02, 2.45641022E-02, 2.45416793E-02,
     &   2.42845999E-02, 2.38219160E-02, 2.29758207E-02, 2.16056998E-02,
     &   2.10478370E-02, 1.87636885E-02, 1.45808410E-02, 1.26615437E-02,
     &   9.97321692E-03, 8.18062465E-03, 5.93996194E-03, 3.69982355E-03,
     &   9.00980173E-04,-7.77377184E-04,-2.69445632E-03,-4.90491740E-03/
  
         DATA ((DGS  (I,J), I=1301,1400), J=1,1) /
     &  -7.48146654E-03,-1.05229754E-02,-1.41674256E-02,-1.62745810E-02,
     &  -1.86134060E-02,-2.12242913E-02,-2.41576254E-02,-2.74771235E-02,
     &  -3.12646210E-02,-3.56272218E-02,-4.07086212E-02,-4.67101719E-02,
     &  -4.92219030E-02,-5.08058798E-02,-5.24708247E-02,-5.42668102E-02,
     &  -5.59922491E-02,-5.77825809E-02,-5.36160438E-02,-6.16890406E-02,
     &  -6.37940011E-02,-6.60059740E-02,-6.83318945E-02,-7.07799164E-02,
     &  -7.33593267E-02,-7.60805727E-02,-7.89550499E-02,-8.19968237E-02,
     &  -8.52196774E-02,-8.86404794E-02,-9.22778968E-02,-9.61530470E-02,
     &  -1.00289906E-01,-1.04715804E-01,-1.09462026E-01,-1.14564508E-01,
     &  -1.20064987E-01,-1.26011654E-01,-1.32461062E-01,-1.39479685E-01,
     &  -1.47146256E-01,-1.55554724E-01,-1.64818076E-01,-1.75073167E-01,
     &  -1.86486817E-01,-1.99275583E-01,-2.13691994E-01,-2.30072942E-01,
     &  -2.48848628E-01,-2.70585508E-01,-2.96043746E-01,-3.26268026E-01,
     &  -3.62734302E-01,-4.07598029E-01,-4.64135656E-01,-1.73442287E-02,
     &  -6.36855082E-01,-7.78463369E-01,-9.96787206E-01,-1.37715738E+00,
     &  -2.20486081E+00,-2.71804772E+00,-5.20206444E+00,-7.24788253E+00,
     &  -8.73342265E+00,-9.87907502E+00,-2.78768681E-02,-1.16470645E+01,
     &  -1.24136921E+01,-1.29472342E+01,-1.34888750E+01,-1.40225463E+01,
     &  -1.42798192E+01,-1.46403754E+01,-1.48587531E+01,-1.51294227E+01,
     &  -1.51946721E+01,-1.53144887E+01,-1.53410884E+01,-1.53086394E+01,
     &  -1.52591773E+01,-1.51845265E+01,-1.86834426E-01,-1.82739964E-01,
     &  -1.45789504E+01,-1.40544714E+01,-1.37288730E+01,-1.33618297E+01,
     &  -1.29386536E+01,-1.19324826E+01,-1.13458422E+01,-1.07100987E+01,
     &  -9.26500177E+00,-8.46506921E+00,-2.58397293E+00,-4.77101742E+00,
     &   5.38668988E-01, 4.75681581E+00, 6.69980276E+00, 8.45757291E+00/
  
         DATA ((DGS  (I,J), I=1401,1500), J=1,1) /
     &   1.00195549E+01, 1.07217129E+01, 1.13609391E+01, 1.19449978E+01,
     &   1.29560709E+01, 1.33809257E+01, 1.37603737E+01, 1.41098484E+01,
     &   1.46228652E+01, 1.48228389E+01, 1.49926374E+01, 1.52317967E+01,
     &   1.53090188E+01, 1.53878879E+01, 1.53949840E+01, 1.53541617E+01,
     &   1.52531551E+01, 1.53189538E+01, 1.51840100E+01, 1.47049370E+01,
     &   1.43530278E+01, 1.40946874E+01, 1.35512914E+01, 1.30100677E+01,
     &   1.24761925E+01, 1.17092133E+01, 1.08840046E+01, 9.93926048E+00,
     &   8.79032579E+00, 7.30549594E+00, 5.22716728E+00, 2.86508756E+00,
     &   1.65032301E+00, 1.16274857E+00, 9.00240637E-01, 7.36254527E-01,
     &   6.24108386E-01, 5.42727416E-01, 4.80645760E-01, 4.31995847E-01,
     &   3.92773338E-01, 3.60480429E-01, 3.33430229E-01, 3.10442307E-01,
     &   2.90665802E-01, 2.73472027E-01, 1.06425734E-01, 2.45049887E-01,
     &   2.33153887E-01, 2.22504290E-01, 2.12900163E-01, 2.04197743E-01,
     &   1.96276086E-01, 1.89034762E-01, 1.82389889E-01, 1.76270835E-01,
     &   1.70617711E-01, 3.95365609E-02, 1.60512010E-01, 1.55977649E-01,
     &   1.51743430E-01, 1.47780682E-01, 1.44064296E-01, 1.40572200E-01,
     &   1.37284925E-01, 1.34185247E-01, 1.31257897E-01, 1.28489334E-01,
     &   1.25867576E-01, 1.23382107E-01, 1.21023941E-01, 1.18786024E-01,
     &   1.16664951E-01, 1.14671140E-01, 1.12794901E-01, 1.10788672E-01,
     &   1.08950317E-01, 1.07207010E-01, 1.05543970E-01, 1.03953240E-01,
     &   1.02429081E-01, 9.09953600E-02, 8.40298488E-02, 7.73900538E-02,
     &   7.00580489E-02, 6.33903316E-02, 5.75248873E-02, 5.60867277E-02,
     &   5.07214872E-02, 4.26600780E-02, 3.75068037E-02, 3.72639576E-02,
     &   3.67472433E-02, 3.61751326E-02, 3.50859799E-02, 3.41485451E-02,
     &   3.11499279E-02, 2.84609367E-02, 2.68522603E-02, 2.47323809E-02/
  
         DATA ((DGS  (I,J), I=1501,1600), J=1,1) /
     &   2.22765611E-02, 1.94724988E-02, 1.58829535E-02, 1.09742963E-02,
     &  -1.27584963E-03,-3.59651484E-03,-6.32885664E-03,-7.12055624E-03,
     &  -8.92500730E-03,-1.09298071E-02,-1.31703359E-02,-1.56908301E-02,
     &  -1.85473401E-02,-2.18119581E-02,-2.55790035E-02,-2.99743110E-02,
     &  -3.51696086E-02,-4.14055695E-02,-4.90303443E-02,-5.85672874E-02,
     &  -7.08416215E-02,-8.72370882E-02,-1.10278505E-01,-1.45346602E-01,
     &  -2.02543810E-01,-3.16843184E-01,-4.70388789E-01,-4.96166150E-01,
     &  -5.24762285E-01,-5.56665794E-01,-5.92484999E-01,-6.32986329E-01,
     &  -6.79154824E-01,-7.32261289E-01,-7.93999130E-01,-8.66653856E-01,
     &  -9.53396050E-01,-1.05875270E+00,-1.18941731E+00,-1.35571668E+00,
     &  -1.57445300E+00,-1.87485629E+00,-2.31260023E+00,-3.00758946E+00,
     &  -4.26883309E+00,-7.12219072E+00,-8.12207663E+00,-8.55715040E+00,
     &  -9.78168450E+00,-1.05269810E+01,-1.10667413E+01,-9.60439837E+00,
     &  -8.43041348E+00,-1.26983237E+01,-1.22720367E+01,-8.46707409E-01,
     &  -4.41205647E+00,-4.30960626E+00,-4.25851102E+00,-1.01695142E+01,
     &  -1.01088167E+01,-1.00629073E+01,-1.00166700E+01,-9.53687678E+00,
     &  -8.76247054E+00,-7.83573177E+00,-6.95270084E+00,-7.32678154E+00,
     &  -6.21559397E+00,-5.11756476E+00,-4.47260715E+00,-3.85479423E+00,
     &  -3.16570465E+00,-2.17175366E+00,-1.44604319E+00, 1.12740718E-01,
     &   1.13074968E-01, 1.13186304E-01, 1.13241958E-01, 1.13297601E-01,
     &   1.13353234E-01, 1.13408858E-01, 1.13853484E-01, 1.14408363E-01,
     &   1.14962233E-01, 5.46975596E+00, 6.60889212E+00, 8.54099145E+00,
     &   9.28868075E+00, 9.98960792E+00, 1.05113222E+01, 1.02349297E+01,
     &   1.08912170E+01, 1.14990834E+01, 1.16811578E+01, 1.17841201E+01,
     &   1.18165527E+01, 1.18144213E+01, 1.17771675E+01, 1.17183807E+01/
  
         DATA ((DGS  (I,J), I=1601,1700), J=1,1) /
     &   8.51662490E+00, 1.14081100E+01, 1.12668849E+01, 1.11272723E+01,
     &   1.07769264E+01, 1.05955567E+01, 1.03009870E+01, 9.83004109E+00,
     &   8.17616966E+00, 6.88748779E+00, 5.90993299E+00, 5.15992150E+00,
     &   4.57114155E+00, 4.01350888E+00, 3.48245797E+00, 2.89174929E+00,
     &   2.69259354E+00, 2.51892161E+00, 2.36591244E+00, 2.13971119E+00,
     &   1.77569046E+00, 1.51823441E+00, 1.32665434E+00, 1.17859463E+00,
     &   1.06075318E+00, 9.64758616E-01, 8.85056010E-01, 8.17825461E-01,
     &   7.60357650E-01, 7.10669144E-01, 6.67281989E-01, 6.29070853E-01,
     &   5.95161237E-01, 5.64864119E-01, 5.37637287E-01, 3.70627699E-01,
     &   2.56157384E-01, 1.98945128E-01, 1.41824895E-01, 1.12805712E-01,
     &   9.55823892E-02, 8.41252608E-02, 7.59487820E-02, 6.98186730E-02,
     &   6.50512822E-02, 6.12371073E-02, 5.90730344E-02, 5.65475067E-02,
     &   5.43889528E-02, 5.25226153E-02, 5.08927517E-02, 4.94569500E-02,
     &   4.42509830E-02, 4.09797887E-02, 3.87281738E-02, 3.70788452E-02,
     &   3.58128024E-02, 3.47945833E-02, 3.39826033E-02, 3.33064571E-02,
     &   2.74849075E-02, 2.58559312E-02, 2.54475377E-02, 2.49760165E-02,
     &   2.44162898E-02, 2.37234361E-02, 2.33064853E-02, 2.28270320E-02,
     &   2.15964967E-02, 1.97488598E-02, 1.65434570E-02, 9.28428896E-03,
     &   2.36317381E-03, 5.77901884E-04,-1.48091396E-03,-3.88167196E-03,
     &  -6.71778660E-03,-1.01201337E-02,-1.42777591E-02,-1.94747911E-02,
     &  -2.61587520E-02,-3.50784442E-02,-4.75990947E-02,-6.64568663E-02,
     &  -9.74909847E-02,-1.02901721E-01,-1.08804566E-01,-1.15271096E-01,
     &  -1.22386684E-01,-1.30275891E-01,-1.38984161E-01,-1.48749598E-01,
     &  -1.59734744E-01,-1.72186061E-01,-1.86416237E-01,-2.02833713E-01,
     &  -2.21989122E-01,-2.44626630E-01,-2.71787589E-01,-3.04982809E-01/
  
         DATA ((DGS  (I,J), I=1701,1800), J=1,1) /
     &  -3.15347257E-01,-3.46479071E-01,-3.99814235E-01,-4.70919639E-01,
     &  -5.70433065E-01,-7.19601613E-01,-9.67896110E-01,-1.46287145E+00,
     &  -2.92585024E+00,-3.48356604E+00,-4.92459371E+00,-5.63145608E+00,
     &  -6.92359813E+00,-7.71019920E+00,-8.41139399E+00,-9.04691433E+00,
     &  -9.59356772E+00,-1.03644227E+01,-1.05945973E+01, 8.50495001E-02,
     &  -1.14863757E+01,-1.18579255E+01,-1.21736067E+01,-1.24349709E+01,
     &  -8.63071305E+00,-1.28719614E+01,-1.30321441E+01,-1.31788629E+01,
     &  -1.33066292E+01,-1.34055866E+01,-1.36296390E+01,-1.34265287E+01,
     &  -1.33394840E+01,-1.24981826E+01,-1.17873760E+01, 2.63011064E-01,
     &  -1.23985677E+01,-1.18541608E+01,-1.11753832E+01,-1.02105816E+01,
     &  -9.06393491E+00,-7.54737816E+00,-5.77977514E+00, 2.63649416E+00,
     &   2.69852070E-02, 2.65500763E+00, 5.83407126E+00, 7.60804612E+00,
     &   9.14244845E+00, 1.03004026E+01, 8.69574117E+00, 9.64915313E+00,
     &   1.05685488E+01, 1.14418577E+01, 1.21248194E+01, 1.28785009E+01,
     &   1.35471214E+01, 5.12707361E+00, 5.58181429E+00, 6.05534984E+00,
     &   9.48616899E-01, 7.24017523E+00, 7.87700022E+00, 8.54377797E+00,
     &   9.34082347E+00, 1.02764951E+01, 1.12417649E+01, 1.23254326E+01,
     &   1.16777503E+01, 1.07948457E+01, 9.90576345E+00, 9.11464472E+00,
     &   8.52192774E+00, 3.32532660E+00, 8.49228202E+00, 7.75189680E+00,
     &   6.98281060E+00, 6.07295333E+00, 4.97873025E+00, 3.53771819E+00,
     &   3.03311222E+00, 2.93846883E+00, 1.97054659E+00, 2.49678421E+00,
     &   2.20461899E+00, 1.51694383E+00, 1.02205018E+00, 7.73745440E-01,
     &   6.24573591E-01, 5.25072959E-01, 4.53966950E-01, 4.00626187E-01,
     &   3.59137054E-01, 3.25938490E-01, 2.98774137E-01, 2.76138280E-01,
     &   2.56983756E-01, 2.40560428E-01, 2.26331689E-01, 2.13878961E-01/
  
         DATA ((DGS  (I,J), I=1801,1900), J=1,1) /
     &   1.51614184E-01, 1.20480956E-01, 1.01804174E-01, 8.93713394E-02,
     &   8.04509067E-02, 7.37255677E-02, 6.85139734E-02, 6.09416832E-02,
     &   5.56994772E-02, 5.36390363E-02, 5.18525338E-02, 4.54192595E-02,
     &   4.06921464E-02, 3.78476338E-02, 3.59373727E-02, 3.45580167E-02,
     &   3.35086494E-02, 3.26776616E-02, 3.19976475E-02, 3.14237154E-02,
     &   3.04826030E-02, 3.05207912E-02, 3.01588167E-02, 2.98304137E-02,
     &   2.95295359E-02, 2.92514722E-02, 2.89902430E-02, 2.87416696E-02,
     &   2.85013226E-02, 2.82639670E-02, 2.80218765E-02, 2.77544798E-02,
     &   2.75763208E-02, 2.48082581E-02, 2.34685678E-02, 2.24992514E-02,
     &   2.17308150E-02, 2.10963835E-02, 2.10229726E-02, 2.01434633E-02,
     &   1.97320754E-02, 1.94104813E-02, 1.91401367E-02, 1.89160044E-02,
     &   1.88329231E-02, 1.85996835E-02, 1.85023382E-02, 1.84425625E-02,
     &   1.84203613E-02, 1.84340423E-02, 1.84826832E-02, 1.85676096E-02,
     &   1.86644411E-02, 1.88381549E-02, 1.90314469E-02, 1.92540485E-02,
     &   1.95215619E-02, 1.98287380E-02, 2.01836156E-02, 2.05883218E-02,
     &   2.10443696E-02, 2.15524943E-02, 2.21525399E-02, 2.28393664E-02,
     &   2.36325735E-02, 2.46212627E-02, 2.59280856E-02, 2.91220205E-02,
     &   3.21411805E-02, 3.32802782E-02, 3.41056451E-02, 3.47445462E-02,
     &   3.52802220E-02, 3.57339056E-02, 3.61066070E-02, 3.64309610E-02,
     &   3.67094060E-02, 3.69455327E-02, 3.71566521E-02, 3.73015943E-02,
     &   3.74277554E-02, 3.75274528E-02, 3.75945980E-02, 3.76346893E-02,
     &   3.76464482E-02, 3.76300058E-02, 3.75871782E-02, 3.75134738E-02,
     &   3.74096657E-02, 3.72765875E-02, 3.71118972E-02, 3.91992453E-02,
     &   3.85395514E-02, 3.62545328E-02, 3.60803580E-02, 3.57092048E-02,
     &   3.52797607E-02, 3.47694791E-02, 3.41796625E-02, 3.34614817E-02/
  
         DATA ((DGS  (I,J), I=1901,2000), J=1,1) /
     &   3.25578357E-02, 3.13324213E-02, 3.64794048E-02, 2.90562883E-02,
     &   2.84286952E-02, 2.82477734E-02, 2.78676890E-02, 2.76912568E-02,
     &   2.75497335E-02, 2.74322392E-02, 2.73331684E-02, 2.72485244E-02,
     &   2.71355019E-02, 2.71133876E-02, 2.70598248E-02, 2.70144310E-02,
     &   2.69710793E-02, 2.69443665E-02, 2.69191918E-02, 2.68998960E-02,
     &   2.68861923E-02, 2.68779713E-02, 2.68031027E-02, 2.68111521E-02,
     &   2.68857941E-02, 2.68984419E-02, 2.69197526E-02, 2.69463577E-02,
     &   2.69792245E-02, 2.70190808E-02, 2.70666596E-02, 2.71230993E-02,
     &   2.71892775E-02, 2.72678096E-02, 2.73610696E-02, 2.74648926E-02,
     &   2.76175078E-02, 2.78142255E-02, 2.83213523E-02, 2.87036786E-02,
     &   2.89532135E-02, 2.90863734E-02, 2.91945234E-02, 2.92855741E-02,
     &   2.93645748E-02, 2.94339742E-02, 2.94950208E-02, 2.95490227E-02,
     &   2.95969601E-02, 2.96402586E-02, 2.96791756E-02, 2.97130906E-02,
     &   2.97418876E-02, 2.97658476E-02, 2.97855301E-02, 2.98021357E-02,
     &   2.98159787E-02, 2.98265778E-02, 2.98427627E-02, 2.98379228E-02,
     &   2.98377025E-02, 2.98344996E-02, 2.98284611E-02, 2.98188602E-02,
     &   2.98056301E-02, 2.97890888E-02, 2.97686852E-02, 2.97446316E-02,
     &   2.97167123E-02, 2.97193469E-02, 2.96878971E-02, 2.96505115E-02,
     &   2.96056652E-02, 2.95093572E-02, 2.91138951E-02, 2.91960011E-02,
     &   2.91858287E-02, 2.91770070E-02, 2.91695356E-02, 2.91634038E-02,
     &   2.91585914E-02, 2.91550419E-02, 2.91527321E-02, 2.91516488E-02,
     &   2.91445162E-02, 2.91451296E-02, 2.91489982E-02, 2.90057248E-02,
     &   2.90113999E-02, 2.90187814E-02, 2.91713040E-02, 2.91803911E-02,
     &   2.91909669E-02, 2.92031060E-02, 2.92170319E-02, 2.92325059E-02,
     &   2.92498942E-02, 2.92692901E-02, 2.92907821E-02, 2.93146993E-02/
  
         DATA ((DGS  (I,J), I=2001,2100), J=1,1) /
     &   2.93409089E-02, 2.93703382E-02, 2.94032265E-02, 2.94401307E-02,
     &   2.94816732E-02, 2.95296633E-02, 2.95862228E-02, 2.96558724E-02,
     &   2.97496289E-02, 2.99870733E-02, 3.02248595E-02, 3.03214842E-02,
     &   3.04321295E-02, 3.05013472E-02, 3.05610415E-02, 3.05293297E-02,
     &   3.05701978E-02, 3.06073736E-02, 3.06413983E-02, 3.06724647E-02,
     &   3.07016161E-02, 3.07286548E-02, 3.07539531E-02, 3.07775938E-02,
     &   3.07995653E-02, 3.08202884E-02, 3.08394905E-02, 3.08571869E-02,
     &   3.08750027E-02, 3.08900746E-02, 3.09033712E-02, 3.09165160E-02,
     &   3.09285707E-02, 3.09396626E-02, 3.09497863E-02, 3.09589406E-02,
     &   3.09671215E-02, 3.09744021E-02, 3.09807158E-02, 3.09861220E-02,
     &   3.09944206E-02, 3.09969248E-02, 3.09985426E-02, 3.09991517E-02,
     &   3.09985296E-02, 3.09811563E-02, 3.08345414E-02, 3.06369942E-02,
     &   3.06129023E-02, 3.05168702E-02, 3.04401641E-02, 3.03654855E-02,
     &   3.03018737E-02, 3.02382977E-02, 3.01779590E-02, 3.01133093E-02,
     &   3.00449552E-02, 2.99750446E-02, 2.98085830E-02, 2.96421213E-02,
     &   2.97056484E-02, 2.97656334E-02, 2.98183470E-02, 2.98696678E-02,
     &   2.99158643E-02, 2.99617069E-02, 3.00036146E-02, 3.00457282E-02,
     &   3.00863693E-02, 3.01240621E-02, 3.01623984E-02, 3.01981716E-02,
     &   3.02347449E-02, 3.02690250E-02, 3.03042059E-02, 3.03372902E-02,
     &   3.03713414E-02, 3.04034437E-02, 3.04365568E-02, 3.04678351E-02,
     &   3.04987561E-02, 3.05307275E-02, 3.05609921E-02, 3.05923228E-02,
     &   3.06220130E-02, 3.06527789E-02, 3.06819597E-02, 3.07122218E-02,
     &   3.07409453E-02, 3.07707528E-02, 3.07990619E-02, 3.08284553E-02,
     &   3.08576506E-02, 3.08853984E-02, 3.09142286E-02, 3.09416402E-02,
     &   3.09701313E-02, 3.09972299E-02, 3.10254045E-02, 3.10522099E-02/
  
         DATA ((DGS  (I,J), I=2101,2174), J=1,1) /
     &   3.10800874E-02, 3.11066169E-02, 3.11342142E-02, 3.11604830E-02,
     &   3.11866295E-02, 3.12138367E-02, 3.12397420E-02, 3.12667032E-02,
     &   3.12923786E-02, 3.13116032E-02, 3.13397402E-02, 3.13663714E-02,
     &   3.13917492E-02, 3.14181826E-02, 3.14433749E-02, 3.14696180E-02,
     &   3.14957665E-02, 3.15206912E-02, 3.15466595E-02, 3.15714147E-02,
     &   3.15972088E-02, 3.16218000E-02, 3.16474252E-02, 3.16721751E-02,
     &   3.16979395E-02, 3.17220177E-02, 3.17473612E-02, 3.17714900E-02,
     &   3.17966375E-02, 3.18206180E-02, 3.18445273E-02, 3.18694483E-02,
     &   3.18932146E-02, 3.19179878E-02, 3.19416145E-02, 3.19662434E-02,
     &   3.19897335E-02, 3.20896142E-02, 3.21129420E-02, 3.21372171E-02,
     &   3.21603295E-02, 3.21843813E-02, 3.23683029E-02, 3.26199524E-02,
     &   3.26595833E-02, 3.44276554E-02, 3.52250447E-02, 3.73202032E-02,
     &   3.87239764E-02, 3.85550512E-02, 4.01308024E-02, 4.01357996E-02,
     &   4.13179981E-02, 4.13632193E-02, 4.13903344E-02, 4.19775169E-02,
     &   4.23686176E-02, 4.24388145E-02, 4.25535444E-02, 4.27235936E-02,
     &   4.28435765E-02, 4.29189357E-02, 4.36500829E-02, 4.36880726E-02,
     &   4.39107931E-02, 4.39507425E-02, 4.45663284E-02, 4.41952172E-02,
     &   4.43188775E-02, 4.43726920E-02, 4.44587192E-02, 4.46824679E-02,
     &   4.47775821E-02, 4.54070608E-02/
  
         DATA ((DGS  (I,J), I=   1, 100), J=2,2) /
     &   1.18589995E-05, 1.25695268E-05, 1.33091582E-05, 1.41080429E-05,
     &   1.50059649E-05, 1.53716807E-05, 1.75621338E-05, 1.80626941E-05,
     &   1.90154589E-05, 2.00504371E-05, 1.97786056E-05, 1.96930356E-05,
     &   1.96836228E-05, 2.00242341E-05, 2.05306197E-05, 2.11505682E-05,
     &   2.17282616E-05, 2.22269780E-05, 2.26299959E-05, 2.32563019E-05,
     &   2.38024934E-05, 2.44129835E-05, 2.48714268E-05, 2.54725717E-05,
     &   2.60210019E-05, 2.66645551E-05, 2.75405376E-05, 2.79951902E-05,
     &   2.82076949E-05, 2.88542221E-05, 2.95287679E-05, 3.01257585E-05,
     &   3.08524939E-05, 3.15860514E-05, 3.23433177E-05, 3.31331859E-05,
     &   3.39505392E-05, 3.48708566E-05, 3.57798571E-05, 3.67147377E-05,
     &   3.75197377E-05, 3.85777097E-05, 3.97268344E-05, 4.07051199E-05,
     &   4.21937874E-05, 4.41524860E-05, 4.57320147E-05, 4.68258258E-05,
     &   4.73543442E-05, 4.78508728E-05, 5.49976884E-05, 6.33110002E-05,
     &   7.47163642E-05, 8.79522134E-05, 9.65786591E-05, 9.86173153E-05,
     &   1.01013625E-04, 1.02626930E-04, 1.05378765E-04, 1.05297266E-04,
     &   1.06545255E-04, 1.07067679E-04, 1.08603783E-04, 1.11246581E-04,
     &   1.14651826E-04, 1.18058036E-04, 1.20102471E-04, 1.21845365E-04,
     &   1.22982403E-04, 1.24259901E-04, 1.26254195E-04, 1.23089161E-04,
     &   1.22926443E-04, 1.23379377E-04, 1.23509096E-04, 1.24122026E-04,
     &   1.22155350E-04, 1.23164189E-04, 1.23509070E-04, 1.72447276E-04,
     &   1.54938290E-04, 1.58204420E-04, 1.54936723E-04, 1.52897084E-04,
     &   1.49151532E-04, 1.55587192E-04, 1.59222097E-04, 1.53838943E-04,
     &   1.52252247E-04, 1.51488065E-04, 1.49230236E-04, 1.50830846E-04,
     &   1.52738121E-04, 1.57113345E-04, 1.63974246E-04, 1.76421718E-04,
     &   1.70967618E-04, 1.68953886E-04, 1.59821985E-04, 1.51339283E-04/
  
         DATA ((DGS  (I,J), I= 101, 200), J=2,2) /
     &   1.41887155E-04, 1.34220318E-04, 1.27364824E-04, 1.22507654E-04,
     &   1.20439681E-04, 1.19708130E-04, 1.20450601E-04, 1.22041932E-04,
     &   1.24571170E-04, 1.28325767E-04, 1.32922698E-04, 1.36810776E-04,
     &   1.40504563E-04, 1.44058441E-04, 1.47341996E-04, 1.49330942E-04,
     &   1.48909304E-04, 1.40079962E-04, 1.29003122E-04, 1.25790305E-04,
     &   1.24261238E-04, 1.23743234E-04, 1.24115191E-04, 1.25137627E-04,
     &   1.25996235E-04, 1.25843614E-04, 1.25863754E-04, 1.26268017E-04,
     &   1.27391019E-04, 1.28839994E-04, 1.32070607E-04, 1.37075768E-04,
     &   1.44392985E-04, 1.53595843E-04, 1.64577679E-04, 1.75798997E-04,
     &   1.85818634E-04, 1.91723059E-04, 1.91846966E-04, 1.81542981E-04,
     &   1.73460292E-04, 1.62719475E-04, 1.52738627E-04, 1.44307863E-04,
     &   1.37975015E-04, 1.34007375E-04, 1.30840506E-04, 1.30271779E-04,
     &   1.28545109E-04, 1.28713956E-04, 1.28718316E-04, 1.37110861E-04,
     &   1.39046026E-04, 1.42903506E-04, 1.26858057E-04, 1.24457661E-04,
     &   1.24335511E-04, 1.24329387E-04, 1.18584895E-04, 1.19888069E-04,
     &   1.24365877E-04, 1.33689196E-04, 1.35967256E-04, 1.34753635E-04,
     &   1.32939950E-04, 1.30886658E-04, 1.29595488E-04, 1.28998256E-04,
     &   1.29085568E-04, 1.31749816E-04, 1.35239978E-04, 1.38628280E-04,
     &   1.44439651E-04, 1.49425944E-04, 1.54112655E-04, 1.57943029E-04,
     &   1.62591503E-04, 1.68018610E-04, 1.73485106E-04, 1.77025408E-04,
     &   1.84166142E-04, 1.87662658E-04, 1.96644286E-04, 2.04873568E-04,
     &   2.16160246E-04, 2.26720144E-04, 2.41257835E-04, 2.54903738E-04,
     &   2.70655926E-04, 2.92375435E-04, 3.04803288E-04, 3.13690742E-04,
     &   3.33287398E-04, 3.44254440E-04, 3.54888800E-04, 3.67130046E-04,
     &   3.80777616E-04, 3.96144969E-04, 4.12744904E-04, 4.48836490E-04/
  
         DATA ((DGS  (I,J), I= 201, 300), J=2,2) /
     &   4.90894369E-04, 5.15852434E-04, 5.25334935E-04, 5.35228566E-04,
     &   5.45550178E-04, 5.56325971E-04, 5.67580692E-04, 5.79332063E-04,
     &   5.91594189E-04, 6.04425890E-04, 6.17857674E-04, 6.31928195E-04,
     &   6.46676759E-04, 6.62134771E-04, 6.78372603E-04, 6.95489476E-04,
     &   7.13573175E-04, 7.32680306E-04, 7.52942265E-04, 7.74495557E-04,
     &   7.97504126E-04, 8.22165898E-04, 8.48642168E-04, 8.77507222E-04,
     &   9.08914780E-04, 9.43519706E-04, 9.82179160E-04, 1.02646664E-03,
     &   1.07945905E-03, 1.15591656E-03, 1.22543562E-03, 1.31841747E-03,
     &   1.21354074E-03, 1.21762053E-03, 1.24747207E-03, 1.28594397E-03,
     &   1.33245485E-03, 1.38433465E-03, 1.44664940E-03, 1.50628505E-03,
     &   1.57733591E-03, 1.65613592E-03, 1.72830493E-03, 1.94160394E-03,
     &   1.95087208E-03, 2.07399444E-03, 2.21325077E-03, 2.37164108E-03,
     &   2.55285388E-03, 2.76139475E-03, 3.00245662E-03, 3.28228264E-03,
     &   3.60641654E-03, 3.92053288E-03, 4.09234692E-03, 4.20923628E-03,
     &   4.37084689E-03, 4.44877879E-03, 4.40143132E-03, 4.68909815E-03,
     &   4.80393863E-03, 4.90841096E-03, 5.00091993E-03, 5.07431053E-03,
     &   5.12048292E-03, 5.12927247E-03, 5.04767481E-03, 4.90184010E-03,
     &   4.79807075E-03, 4.51520644E-03, 4.11847380E-03, 3.59537456E-03,
     &   2.73961139E-03, 2.16919597E-03, 1.30183263E-03, 4.22348835E-04,
     &   6.74286175E-04, 1.57000725E-03, 2.41148757E-03, 3.14848584E-03,
     &   3.76088634E-03, 4.24543837E-03, 4.60581330E-03, 4.85829322E-03,
     &   5.01932091E-03, 5.10543497E-03, 5.13259507E-03, 5.11449032E-03,
     &   5.06257874E-03, 4.98620032E-03, 4.84299063E-03, 4.80283022E-03,
     &   4.59988278E-03, 4.54953931E-03, 4.44090913E-03, 4.32301483E-03,
     &   4.20692407E-03, 4.09300752E-03, 3.98181641E-03, 3.87372021E-03/
  
         DATA ((DGS  (I,J), I= 301, 400), J=2,2) /
     &   3.85930313E-03, 3.66914486E-03, 3.57249219E-03, 3.47964199E-03,
     &   3.18359182E-03, 2.92834582E-03, 2.70834175E-03, 2.51754081E-03,
     &   2.35126277E-03, 2.17266391E-03, 2.07719957E-03, 1.96352982E-03,
     &   1.86240165E-03, 1.77206353E-03, 1.69109132E-03, 1.61833363E-03,
     &   1.55287545E-03, 1.49394734E-03, 1.44098327E-03, 1.39363900E-03,
     &   1.34689264E-03, 1.31089206E-03, 1.32291047E-03, 1.26742698E-03,
     &   1.29713115E-03, 1.53171214E-03, 1.50085547E-03, 1.21554233E-03,
     &   1.12420321E-03, 1.06495962E-03, 1.01966724E-03, 9.81756776E-04,
     &   9.50157180E-04, 9.20209555E-04, 8.93576542E-04, 8.69408645E-04,
     &   8.47024539E-04, 8.26084219E-04, 8.06938688E-04, 7.87975307E-04,
     &   7.70404898E-04, 7.53792844E-04, 7.37550341E-04, 7.22284245E-04,
     &   7.07615416E-04, 6.93723748E-04, 6.80397228E-04, 6.67737207E-04,
     &   6.55647258E-04, 6.44079129E-04, 6.33040194E-04, 6.22469310E-04,
     &   6.12229438E-04, 6.02422077E-04, 5.93205966E-04, 5.84217845E-04,
     &   5.60327085E-04, 5.09297305E-04, 4.37379733E-04, 3.92427408E-04,
     &   3.62176007E-04, 3.41499187E-04, 3.27736510E-04, 3.18662595E-04,
     &   3.12987476E-04, 3.12488314E-04, 3.10156697E-04, 3.12098579E-04,
     &   3.13067669E-04, 3.16136945E-04, 3.21180479E-04, 3.21532941E-04,
     &   3.26887478E-04, 3.33983394E-04, 3.37536942E-04, 3.42363895E-04,
     &   3.51649392E-04, 3.62955898E-04, 3.75861755E-04, 3.90437789E-04,
     &   3.99402483E-04, 4.06441087E-04, 4.24431287E-04, 4.45017946E-04,
     &   4.46877037E-04, 4.66269253E-04, 4.90580501E-04, 5.01854198E-04,
     &   5.15878652E-04, 5.42237952E-04, 5.73958499E-04, 6.12965368E-04,
     &   6.24775048E-04, 6.60415900E-04, 6.83137055E-04, 7.13578432E-04,
     &   7.73582666E-04, 8.60261199E-04, 8.68511456E-04, 9.51908580E-04/
  
         DATA ((DGS  (I,J), I= 401, 500), J=2,2) /
     &   1.13139032E-03, 1.17410998E-03, 1.10436324E-03, 1.04509120E-03,
     &   1.02737948E-03, 9.52901804E-04, 9.42593015E-04, 9.36058416E-04,
     &   9.15195026E-04, 8.61583793E-04, 8.13746196E-04, 7.68765284E-04,
     &   7.69057928E-04, 7.53804489E-04, 7.45061190E-04, 7.18791989E-04,
     &   7.16436334E-04, 6.79938355E-04, 6.78191038E-04, 6.65766524E-04,
     &   6.66332135E-04, 6.69408259E-04, 6.52246344E-04, 6.32437328E-04,
     &   6.27291910E-04, 6.84937016E-04, 6.89839599E-04, 7.38993792E-04,
     &   7.45583850E-04, 7.77957009E-04, 8.02431276E-04, 8.03532680E-04,
     &   8.07628330E-04, 8.02503906E-04, 7.98903745E-04, 7.72827625E-04,
     &   7.70279456E-04, 7.09576011E-04, 7.05506016E-04, 6.62931385E-04,
     &   6.16592843E-04, 6.04289613E-04, 5.87955459E-04, 5.84424801E-04,
     &   5.36649527E-04, 5.26577108E-04, 5.36632048E-04, 5.03168338E-04,
     &   5.10122635E-04, 4.46334830E-04, 4.64954504E-04, 4.63514941E-04,
     &   4.65170834E-04, 4.75042216E-04, 4.53883571E-04, 4.34658022E-04,
     &   4.78396763E-04, 4.99568627E-04, 5.49262667E-04, 5.65792805E-04,
     &   5.79234478E-04, 5.76418772E-04, 5.83790960E-04, 5.79920075E-04,
     &   5.88396367E-04, 5.97637546E-04, 5.98819739E-04, 6.22406603E-04,
     &   6.63555775E-04, 6.84901938E-04, 6.94011172E-04, 7.38404695E-04,
     &   7.72898595E-04, 7.98399101E-04, 8.02875889E-04, 8.42152796E-04,
     &   8.53722707E-04, 8.45897217E-04, 8.74788378E-04, 9.01184386E-04,
     &   9.03588969E-04, 9.52212752E-04, 9.78392370E-04, 9.88060312E-04,
     &   1.00315473E-03, 1.11002693E-03, 1.15935431E-03, 1.20570180E-03,
     &   1.26444427E-03, 1.28552982E-03, 1.33424250E-03, 1.34481250E-03,
     &   1.39328219E-03, 1.44657552E-03, 1.49016358E-03, 1.50976583E-03,
     &   1.88986460E-03, 2.21971709E-03, 2.48733306E-03, 1.67033728E-03/
  
         DATA ((DGS  (I,J), I= 501, 600), J=2,2) /
     &   1.55167033E-03, 1.42074083E-03, 9.43759576E-04, 8.55602295E-04,
     &   7.92082804E-04, 6.93304668E-04, 6.61380159E-04, 6.32728119E-04,
     &   6.11593815E-04, 5.99606743E-04, 5.94685972E-04, 5.96995457E-04,
     &   6.09411953E-04, 6.37650274E-04, 6.89770715E-04, 7.81587312E-04,
     &   8.08580956E-04, 8.37424867E-04, 8.71870952E-04, 9.12128558E-04,
     &   9.59124075E-04, 1.01410791E-03, 1.07959722E-03, 1.09402073E-03,
     &   1.10905996E-03, 1.12471127E-03, 1.14098850E-03, 1.15791810E-03,
     &   1.17517144E-03, 1.19315415E-03, 1.21190138E-03, 1.23146095E-03,
     &   1.25181802E-03, 1.35494009E-03, 1.43573130E-03, 1.48056456E-03,
     &   1.51220891E-03, 1.54543566E-03, 1.58039443E-03, 1.61714448E-03,
     &   1.65584693E-03, 1.69664612E-03, 1.71788680E-03, 1.73973174E-03,
     &   1.76218373E-03, 1.78528879E-03, 1.80905272E-03, 1.83352447E-03,
     &   1.85871397E-03, 1.88467280E-03, 1.91141456E-03, 1.93899437E-03,
     &   1.96743038E-03, 1.99677313E-03, 2.02706488E-03, 2.05835064E-03,
     &   2.09067842E-03, 2.12409938E-03, 2.15866816E-03, 2.19444343E-03,
     &   2.23148659E-03, 2.26986546E-03, 2.30965129E-03, 2.35092089E-03,
     &   2.39375677E-03, 2.43824769E-03, 2.48448926E-03, 2.53258483E-03,
     &   2.58264597E-03, 2.63479310E-03, 2.68915669E-03, 2.74587834E-03,
     &   2.80511434E-03, 2.86703043E-03, 2.93180964E-03, 2.99965204E-03,
     &   3.07077685E-03, 3.14542470E-03, 3.22386032E-03, 3.30637571E-03,
     &   3.39329362E-03, 3.48497181E-03, 3.53271777E-03, 3.58180789E-03,
     &   3.63229590E-03, 3.68424501E-03, 3.73771578E-03, 3.79277860E-03,
     &   3.84950187E-03, 3.90796429E-03, 3.96824335E-03, 4.03042736E-03,
     &   4.09460439E-03, 4.16087399E-03, 4.22933653E-03, 4.30010477E-03,
     &   4.37329353E-03, 4.44903107E-03, 4.52744928E-03, 4.60869482E-03/
  
         DATA ((DGS  (I,J), I= 601, 700), J=2,2) /
     &   4.69291925E-03, 4.78029255E-03, 4.87098982E-03, 4.96520513E-03,
     &   5.06314610E-03, 5.16503701E-03, 5.27112051E-03, 5.38165957E-03,
     &   5.49693959E-03, 5.61727088E-03, 5.74299148E-03, 5.87447019E-03,
     &   6.01211040E-03, 6.15635367E-03, 6.30768485E-03, 6.46663891E-03,
     &   6.63380359E-03, 6.80983114E-03, 6.99544223E-03, 7.19144048E-03,
     &   7.48500977E-03, 7.61828004E-03, 7.85124383E-03, 8.09887497E-03,
     &   8.36259935E-03, 8.64403658E-03, 8.94502837E-03, 9.26768371E-03,
     &   9.61442339E-03, 9.98804558E-03, 1.03917966E-02, 1.08294702E-02,
     &   1.13055222E-02, 1.16855736E-02, 1.28696499E-02, 1.43198843E-02,
     &   1.61372829E-02, 1.84813628E-02, 2.16196830E-02, 2.60379591E-02,
     &   3.27192936E-02, 4.39997146E-02, 6.71141264E-02, 1.41120796E-01,
     &   1.49226697E-01, 1.58316871E-01, 1.68581461E-01, 1.80262730E-01,
     &   1.93674125E-01, 2.09228323E-01, 2.27479557E-01, 2.49189394E-01,
     &   2.75432475E-01, 3.07773174E-01, 3.48574251E-01, 4.01564478E-01,
     &   4.72944292E-01, 4.81454627E-01, 6.72011940E-01, 8.10903403E-01,
     &   9.22494680E-01, 1.01954488E+00, 1.09432982E+00, 1.15967293E+00,
     &   1.21204088E+00, 1.26421096E+00, 1.30004870E+00, 1.33323150E+00,
     &   1.35664647E+00, 1.37594948E+00, 1.38679681E+00, 1.39489363E+00,
     &   1.39558214E+00, 1.39150719E+00, 1.38020668E+00, 1.36799349E+00,
     &   1.34157622E+00, 1.31790656E+00, 1.28885228E+00, 1.25395636E+00,
     &   1.21278039E+00, 1.16492121E+00, 1.11003020E+00, 1.04783498E+00,
     &   9.78162579E-01, 9.00962961E-01, 8.16331351E-01, 6.76065566E-01,
     &   5.74382504E-01, 4.11386195E-01, 2.38683360E-01, 2.38518666E-01,
     &   6.75921349E-01, 8.16198724E-01, 9.40381675E-01, 1.01382913E+00,
     &   1.10993368E+00, 1.16483415E+00, 1.21270275E+00, 1.25388798E+00/
  
         DATA ((DGS  (I,J), I= 701, 800), J=2,2) /
     &   1.28879297E+00, 1.31785606E+00, 1.34153423E+00, 1.36028933E+00,
     &   1.37457714E+00, 1.38483900E+00, 1.39149578E+00, 1.39558072E+00,
     &   1.39489842E+00, 1.38958247E+00, 1.37997802E+00, 1.37161539E+00,
     &   1.35115987E+00, 1.33327299E+00, 1.30699729E+00, 1.27882475E+00,
     &   1.24206854E+00, 1.20459763E+00, 1.15234626E+00, 1.10150987E+00,
     &   1.03940005E+00, 9.69350232E-01, 8.79249430E-01, 7.75961169E-01,
     &   6.46989896E-01, 5.33137586E-01, 4.44699901E-01, 3.80886173E-01,
     &   3.32837354E-01, 2.95424427E-01, 2.65501087E-01, 2.41040053E-01,
     &   2.20680139E-01, 2.03475179E-01, 1.88747885E-01, 1.76001088E-01,
     &   1.64861827E-01, 1.55044959E-01, 1.46328832E-01, 1.38538585E-01,
     &   1.31534449E-01, 1.25203384E-01, 1.19452992E-01, 6.26386479E-02,
     &   4.24548526E-02, 3.21158675E-02, 2.58317950E-02, 2.16085256E-02,
     &   1.85752894E-02, 1.62913155E-02, 1.45095807E-02, 1.30808946E-02,
     &   1.19098329E-02, 1.17711461E-02, 1.08041757E-02, 9.98516343E-03,
     &   9.28259499E-03, 8.67331254E-03, 8.13991723E-03, 7.66908378E-03,
     &   7.25043419E-03, 6.87576563E-03, 6.53850895E-03, 6.23334122E-03,
     &   5.95590373E-03, 5.70259285E-03, 5.47040355E-03, 5.25681005E-03,
     &   5.05967369E-03, 4.87717180E-03, 4.70774157E-03, 4.55003485E-03,
     &   4.40288230E-03, 4.26526608E-03, 4.13629455E-03, 4.01518418E-03,
     &   3.90124303E-03, 3.79385841E-03, 3.69248543E-03, 3.59663799E-03,
     &   3.50588107E-03, 3.41982416E-03, 3.33811574E-03, 3.26043853E-03,
     &   3.18650540E-03, 3.11605591E-03, 3.04885326E-03, 2.98468165E-03,
     &   2.92334406E-03, 2.86465936E-03, 2.80846477E-03, 2.75460601E-03,
     &   2.70294426E-03, 2.65335031E-03, 2.60570647E-03, 2.55990234E-03,
     &   2.51583622E-03, 2.47341385E-03, 2.43254768E-03, 2.39315637E-03/
  
         DATA ((DGS  (I,J), I= 801, 900), J=2,2) /
     &   2.35516407E-03, 2.31850028E-03, 2.28309917E-03, 2.24889959E-03,
     &   2.21584339E-03, 2.18387701E-03, 2.15295005E-03, 2.12301520E-03,
     &   2.09402812E-03, 2.06594713E-03, 2.03873306E-03, 2.01234908E-03,
     &   1.98675926E-03, 1.96193480E-03, 1.93784113E-03, 1.91445057E-03,
     &   1.89173583E-03, 1.86967121E-03, 1.84823246E-03, 1.82739677E-03,
     &   1.80714056E-03, 1.78744772E-03, 1.76829730E-03, 1.74967151E-03,
     &   1.73155377E-03, 1.71392862E-03, 1.69678175E-03, 1.68010003E-03,
     &   1.66387154E-03, 1.64808559E-03, 1.63273291E-03, 1.61780569E-03,
     &   1.60329790E-03, 1.58920549E-03, 1.57552695E-03, 1.56226386E-03,
     &   1.54944286E-03, 1.53613449E-03, 1.52314054E-03, 1.51045424E-03,
     &   1.49807018E-03, 1.48593936E-03, 1.47424060E-03, 1.46272360E-03,
     &   1.45158803E-03, 1.44216450E-03, 1.42852174E-03, 1.41771593E-03,
     &   1.40710760E-03, 1.39673509E-03, 1.38655014E-03, 1.37655412E-03,
     &   1.36678415E-03, 1.35719464E-03, 1.34778070E-03, 1.33855243E-03,
     &   1.06638098E-03, 9.02428724E-04, 8.13626638E-04, 8.33975589E-04,
     &   9.27494410E-04, 9.95118592E-04, 1.08976925E-03, 1.22379205E-03,
     &   1.36223077E-03, 1.55043345E-03, 1.62892077E-03, 1.81297342E-03,
     &   1.92415128E-03, 2.05202942E-03, 2.19874124E-03, 2.37131767E-03,
     &   2.57617062E-03, 2.82252623E-03, 3.12373676E-03, 3.49974626E-03,
     &   3.98153959E-03, 4.21427985E-03, 4.47631542E-03, 4.77346689E-03,
     &   5.11323530E-03, 5.50542252E-03, 5.96306341E-03, 6.22174645E-03,
     &   6.50394367E-03, 6.81299553E-03, 7.15291433E-03, 7.52854588E-03,
     &   7.94581365E-03, 8.41202127E-03, 8.93629288E-03, 9.53016493E-03,
     &   1.02084522E-02, 1.09904895E-02, 1.19020076E-02, 1.29312554E-02,
     &   1.36051187E-02, 1.43528984E-02, 1.51874470E-02, 1.61247801E-02/
  
         DATA ((DGS  (I,J), I= 901,1000), J=2,2) /
     &   1.71851112E-02, 1.83943241E-02, 1.97861095E-02, 2.14051470E-02,
     &   2.33119805E-02, 2.55907389E-02, 2.83618488E-02, 3.18039515E-02,
     &   3.61938567E-02, 4.19845566E-02, 4.99714438E-02, 6.16894372E-02,
     &   8.05241745E-02, 1.15639779E-01, 1.70870054E-01, 2.02304948E-01,
     &   2.36592483E-01, 3.20955869E-01, 3.51349990E-01, 3.76434926E-01,
     &   3.97737853E-01, 4.15676131E-01, 4.30393569E-01, 4.43066062E-01,
     &   4.53442368E-01, 4.60868702E-01, 4.67177688E-01, 4.71643888E-01,
     &   4.74292878E-01, 4.75249614E-01, 4.74570205E-01, 4.72713731E-01,
     &   4.68946059E-01, 4.64015877E-01, 4.57370262E-01, 4.48819845E-01,
     &   4.39829017E-01, 4.27232258E-01, 4.14496666E-01, 3.99858926E-01,
     &   3.83225096E-01, 3.61195124E-01, 3.40003816E-01, 3.12557422E-01,
     &   2.86715055E-01, 2.49038134E-01, 2.07919645E-01, 1.46506593E-01,
     &   9.29749314E-02, 3.13162926E-02, 5.53274329E-04, 3.11599244E-02,
     &   6.21894933E-02, 1.46358355E-01, 2.07780435E-01, 2.48907070E-01,
     &   2.86593174E-01, 3.12442949E-01, 3.39898387E-01, 3.61097675E-01,
     &   3.83137093E-01, 3.99779042E-01, 4.14424846E-01, 4.27168390E-01,
     &   4.39774216E-01, 4.48772593E-01, 4.57331517E-01, 4.63985284E-01,
     &   4.68923243E-01, 4.72699328E-01, 4.74562747E-01, 4.75250522E-01,
     &   4.74301538E-01, 4.71660473E-01, 4.67202212E-01, 4.60901029E-01,
     &   4.53481692E-01, 4.43113123E-01, 4.30448224E-01, 4.15738028E-01,
     &   3.97807070E-01, 3.76511365E-01, 3.51433483E-01, 3.21046387E-01,
     &   2.84207611E-01, 3.04207702E-01, 2.60232143E-01, 2.33145907E-01,
     &   2.16770467E-01, 1.82848092E-01, 1.70981010E-01, 1.45435139E-01,
     &   9.41703128E-02, 6.94827593E-02, 5.50209088E-02, 4.55343387E-02,
     &   3.88362631E-02, 3.38561898E-02, 3.00089083E-02, 2.69477014E-02/
  
         DATA ((DGS  (I,J), I=1001,1100), J=2,2) /
     &   2.44541611E-02, 2.23838914E-02, 2.06376199E-02, 1.91448563E-02,
     &   1.78541694E-02, 1.67271538E-02, 1.57345561E-02, 1.48536993E-02,
     &   1.40667366E-02, 1.33594273E-02, 1.22414015E-02, 1.08459769E-02,
     &   1.00997394E-02, 8.88051268E-03, 7.92669475E-03, 6.99172097E-03,
     &   5.66493593E-03, 4.20698699E-03, 3.34670469E-03, 2.98962063E-03,
     &   2.79007176E-03, 2.66062638E-03, 2.56916844E-03, 2.50039790E-03,
     &   2.44645054E-03, 2.40268005E-03, 2.36614746E-03, 2.33495760E-03,
     &   2.30784228E-03, 2.28382378E-03, 2.26224173E-03, 2.24258350E-03,
     &   2.22445482E-03, 2.20752681E-03, 2.19152863E-03, 2.17632664E-03,
     &   2.16167540E-03, 2.14744510E-03, 2.13351846E-03, 2.11978337E-03,
     &   2.10609032E-03, 2.09234479E-03, 2.07840117E-03, 2.06417155E-03,
     &   2.04946731E-03, 2.03410839E-03, 2.01780229E-03, 2.00023301E-03,
     &   1.98077558E-03, 1.95828605E-03, 1.92991447E-03, 1.86615467E-03,
     &   1.81111716E-03, 1.79169686E-03, 1.77902682E-03, 1.76979012E-03,
     &   1.76278968E-03, 1.75740433E-03, 1.75321706E-03, 1.74993095E-03,
     &   1.74732327E-03, 1.74508486E-03, 1.74347369E-03, 1.74197730E-03,
     &   1.74078634E-03, 1.74048596E-03, 1.76003900E-03, 1.73693129E-03,
     &   1.73303805E-03, 1.72944436E-03, 1.72525017E-03, 1.72007920E-03,
     &   1.71370165E-03, 1.70581792E-03, 1.69622970E-03, 1.68466486E-03,
     &   1.67073611E-03, 1.65418986E-03, 1.63425292E-03, 1.61006487E-03,
     &   1.58131159E-03, 1.54671595E-03, 1.50489819E-03, 1.45231345E-03,
     &   1.38473826E-03, 1.29052218E-03, 1.26297608E-03, 1.18590771E-03,
     &   1.07656632E-03, 1.06606984E-03, 9.96390666E-04, 9.72759287E-04,
     &   9.54284972E-04, 9.32640151E-04, 9.13036943E-04, 8.94000903E-04,
     &   8.82248364E-04, 8.76008325E-04, 8.59362908E-04, 8.43412923E-04/
  
         DATA ((DGS  (I,J), I=1101,1200), J=2,2) /
     &   8.29025154E-04, 8.15533866E-04, 8.03321785E-04, 7.91692865E-04,
     &   7.80594770E-04, 7.72437223E-04, 7.62360241E-04, 7.42953987E-04,
     &   7.34274558E-04, 7.26657344E-04, 7.19364998E-04, 7.11349038E-04,
     &   7.03909052E-04, 6.97102017E-04, 6.96468236E-04, 6.92425360E-04,
     &   6.83534598E-04, 6.75372606E-04, 6.74553513E-04, 6.74008739E-04,
     &   6.73332272E-04, 6.71658526E-04, 6.67575220E-04, 6.73926000E-04,
     &   6.83427101E-04, 7.29800484E-04, 7.80150404E-04, 7.42130668E-04,
     &   6.45383491E-04, 6.47811126E-04, 6.44021833E-04, 6.63319538E-04,
     &   6.53386533E-04, 6.39072215E-04, 6.23464236E-04, 6.16666985E-04,
     &   6.10456803E-04, 6.06316591E-04, 6.05380407E-04, 6.00834585E-04,
     &   5.96654467E-04, 5.95487504E-04, 5.94613048E-04, 5.92806892E-04,
     &   5.92443351E-04, 5.90646574E-04, 5.88871992E-04, 5.85351100E-04,
     &   5.82413264E-04, 5.83334367E-04, 5.82466783E-04, 5.84092456E-04,
     &   5.84620665E-04, 6.10760505E-04, 6.26997404E-04, 6.21800838E-04,
     &   6.08086192E-04, 5.99729404E-04, 5.79391412E-04, 5.69519668E-04,
     &   5.86232508E-04, 6.14964546E-04, 6.13587543E-04, 5.67145994E-04,
     &   5.66199229E-04, 5.62374139E-04, 5.65178581E-04, 5.54865018E-04,
     &   5.51718444E-04, 5.52996623E-04, 5.51078223E-04, 5.45294356E-04,
     &   5.43689705E-04, 5.41888077E-04, 5.43015979E-04, 5.39268051E-04,
     &   5.34822057E-04, 5.32619988E-04, 5.44559876E-04, 5.49054162E-04,
     &   5.51603947E-04, 5.57352536E-04, 5.23610551E-04, 5.30273534E-04,
     &   5.43953069E-04, 5.37857068E-04, 5.37149027E-04, 5.43500171E-04,
     &   5.44221750E-04, 5.47613327E-04, 5.44610885E-04, 5.20354400E-04,
     &   5.43151040E-04, 6.40807833E-04, 5.89926561E-04, 5.25857845E-04,
     &   5.20168908E-04, 5.16130845E-04, 5.10830701E-04, 5.06047178E-04/
  
         DATA ((DGS  (I,J), I=1201,1300), J=2,2) /
     &   5.06855100E-04, 5.06828666E-04, 5.10619212E-04, 5.07901590E-04,
     &   5.07695815E-04, 5.10747400E-04, 5.05947488E-04, 5.11230135E-04,
     &   5.23126400E-04, 5.61876437E-04, 5.55582210E-04, 5.47468522E-04,
     &   5.77301461E-04, 5.22796440E-04, 5.11286157E-04, 5.14363582E-04,
     &   5.47524180E-04, 5.45002459E-04, 5.84926578E-04, 5.87221839E-04,
     &   6.69905789E-04, 7.87730909E-04, 7.85942628E-04, 1.22630935E-03,
     &   1.27938427E-03, 6.96401559E-04, 6.04971813E-04, 5.24580519E-04,
     &   4.63316516E-04, 4.47656865E-04, 4.36170083E-04, 4.20152284E-04,
     &   4.09245501E-04, 4.04932400E-04, 4.01156715E-04, 3.97810765E-04,
     &   3.94815311E-04, 3.92110657E-04, 3.89644662E-04, 3.87393585E-04,
     &   3.85322928E-04, 3.83409669E-04, 3.81635021E-04, 3.79983491E-04,
     &   3.78442176E-04, 3.77000239E-04, 3.75648510E-04, 3.74379179E-04,
     &   3.73185555E-04, 3.72061883E-04, 3.71003187E-04, 3.70005159E-04,
     &   3.69064058E-04, 3.68176637E-04, 3.67340074E-04, 3.66551928E-04,
     &   3.65810092E-04, 3.65112759E-04, 3.64458400E-04, 3.63845734E-04,
     &   3.63273717E-04, 3.62741526E-04, 3.62248547E-04, 3.61794374E-04,
     &   3.61378801E-04, 3.61001823E-04, 3.60663638E-04, 3.60421288E-04,
     &   3.60105495E-04, 3.59710319E-04, 3.59488006E-04, 3.59453129E-04,
     &   3.59626016E-04, 3.60034357E-04, 3.60715576E-04, 3.61720399E-04,
     &   3.63118337E-04, 3.65006420E-04, 3.67523639E-04, 3.70880291E-04,
     &   3.75385017E-04, 3.81568845E-04, 3.90365694E-04, 3.91447305E-04,
     &   4.03619488E-04, 4.25541970E-04, 4.68051363E-04, 5.45063270E-04,
     &   5.79024526E-04, 7.29614423E-04, 1.03330643E-03, 1.17884643E-03,
     &   1.38615526E-03, 1.52589118E-03, 1.70170282E-03, 1.87839242E-03,
     &   2.10005680E-03, 2.23333486E-03, 2.38581508E-03, 2.56188483E-03/
  
         DATA ((DGS  (I,J), I=1301,1400), J=2,2) /
     &   2.76737596E-03, 3.01021251E-03, 3.30144139E-03, 3.46990721E-03,
     &   3.65693884E-03, 3.86575710E-03, 4.10037319E-03, 4.36584703E-03,
     &   4.66865384E-03, 5.01721631E-03, 5.42269614E-03, 5.90020603E-03,
     &   6.09909962E-03, 6.22389373E-03, 6.35393618E-03, 6.48956428E-03,
     &   6.63114487E-03, 6.77907760E-03, 6.93379877E-03, 7.09578551E-03,
     &   7.26556079E-03, 7.44369895E-03, 7.63083225E-03, 7.82765833E-03,
     &   8.03494886E-03, 8.25355967E-03, 8.48444253E-03, 8.72865896E-03,
     &   8.98739654E-03, 9.26198820E-03, 9.55393515E-03, 9.86493427E-03,
     &   1.01969111E-02, 1.05520598E-02, 1.09328914E-02, 1.13422934E-02,
     &   1.17836031E-02, 1.22606983E-02, 1.27781119E-02, 1.33411762E-02,
     &   1.39562069E-02, 1.46307411E-02, 1.53738472E-02, 1.61965353E-02,
     &   1.71123052E-02, 1.81378933E-02, 1.92943035E-02, 2.06082608E-02,
     &   2.21143001E-02, 2.38578453E-02, 2.58998659E-02, 2.83241501E-02,
     &   3.12490793E-02, 3.48475321E-02, 3.93823132E-02, 4.52733426E-02,
     &   5.32356350E-02, 6.45935477E-02, 8.21047012E-02, 1.12612413E-01,
     &   1.78998943E-01, 2.20159423E-01, 4.19336523E-01, 5.83477307E-01,
     &   7.02454312E-01, 7.94513527E-01, 8.70151428E-01, 9.36342895E-01,
     &   9.97759352E-01, 1.04051512E+00, 1.08403720E+00, 1.12684078E+00,
     &   1.14747839E+00, 1.17640160E+00, 1.19373205E+00, 1.21524373E+00,
     &   1.22084978E+00, 1.22914185E+00, 1.23258786E+00, 1.22999072E+00,
     &   1.22602787E+00, 1.22004507E+00, 1.20109865E+00, 1.18781232E+00,
     &   1.17148278E+00, 1.12940953E+00, 1.10328913E+00, 1.07343644E+00,
     &   1.03928059E+00, 9.59191859E-01, 9.12156781E-01, 8.61166527E-01,
     &   7.45261425E-01, 6.81102303E-01, 5.39910480E-01, 3.84471558E-01,
     &   4.10494085E-02, 3.79366296E-01, 5.35204058E-01, 6.76186407E-01/
  
         DATA ((DGS  (I,J), I=1401,1500), J=2,2) /
     &   8.01458707E-01, 8.57777459E-01, 9.09049363E-01, 9.55896678E-01,
     &   1.03699418E+00, 1.07107066E+00, 1.10150446E+00, 1.12785580E+00,
     &   1.17035200E+00, 1.18671609E+00, 1.20033405E+00, 1.21951536E+00,
     &   1.22570913E+00, 1.23203557E+00, 1.23260509E+00, 1.22933140E+00,
     &   1.22123020E+00, 1.20923804E+00, 1.19424915E+00, 1.17698122E+00,
     &   1.14812120E+00, 1.12761972E+00, 1.08473101E+00, 1.04132188E+00,
     &   9.98436504E-01, 9.36980311E-01, 8.70733132E-01, 7.95023465E-01,
     &   7.02873506E-01, 5.83783755E-01, 4.17090288E-01, 2.27643868E-01,
     &   1.30207376E-01, 9.11010388E-02, 7.00462676E-02, 5.68934836E-02,
     &   4.78985470E-02, 4.13595099E-02, 3.63916069E-02, 3.24894374E-02,
     &   2.93433496E-02, 2.67530466E-02, 2.45832333E-02, 2.27392287E-02,
     &   2.11527908E-02, 1.97734908E-02, 1.85632573E-02, 1.74928099E-02,
     &   1.65392600E-02, 1.56844576E-02, 1.49138247E-02, 1.42155186E-02,
     &   1.35798183E-02, 1.29986703E-02, 1.24653457E-02, 1.19741784E-02,
     &   1.15203635E-02, 1.10997994E-02, 1.07089638E-02, 1.03448153E-02,
     &   1.00047132E-02, 9.68635430E-03, 9.38772053E-03, 9.10703593E-03,
     &   8.84273160E-03, 8.59341628E-03, 8.35785194E-03, 8.13493327E-03,
     &   7.92367030E-03, 7.72317380E-03, 7.53264273E-03, 7.35135361E-03,
     &   7.17865135E-03, 7.01394134E-03, 6.85668262E-03, 6.70638201E-03,
     &   6.56258890E-03, 6.42489076E-03, 6.29290924E-03, 6.16629666E-03,
     &   6.04473297E-03, 5.12796511E-03, 4.56608524E-03, 4.02739054E-03,
     &   3.42602825E-03, 2.86368373E-03, 2.30938643E-03, 1.99922269E-03,
     &   1.59005771E-03, 1.45030136E-03, 1.33805123E-03, 1.24227698E-03,
     &   1.16227621E-03, 1.09634954E-03, 9.94567361E-04, 9.14135491E-04,
     &   7.30058190E-04, 6.54244218E-04, 6.88859502E-04, 9.04739623E-04/
  
         DATA ((DGS  (I,J), I=1501,1600), J=2,2) /
     &   1.33398419E-03, 1.94123604E-03, 2.77227884E-03, 3.93617472E-03,
     &   6.87705170E-03, 7.43619430E-03, 8.09493159E-03, 8.28586683E-03,
     &   8.72113812E-03, 9.20486029E-03, 9.74558127E-03, 1.03539856E-02,
     &   1.10436098E-02, 1.18318568E-02, 1.27414835E-02, 1.38028375E-02,
     &   1.50572941E-02, 1.65627856E-02, 1.84029840E-02, 2.07034020E-02,
     &   2.36612629E-02, 2.76052664E-02, 3.31270218E-02, 4.14096817E-02,
     &   5.52134070E-02, 8.28153054E-02, 1.19841488E-01, 1.26056295E-01,
     &   1.32950506E-01, 1.40641897E-01, 1.49277116E-01, 1.59041104E-01,
     &   1.70170447E-01, 1.82972739E-01, 1.97855352E-01, 2.15369393E-01,
     &   2.36279110E-01, 2.61675719E-01, 2.93172653E-01, 3.33259145E-01,
     &   3.85984430E-01, 4.58396713E-01, 5.63913406E-01, 7.31437834E-01,
     &   1.03545460E+00, 1.72322429E+00, 1.96432421E+00, 2.15408816E+00,
     &   2.36559662E+00, 2.54310300E+00, 2.67111698E+00, 2.77968786E+00,
     &   2.82971305E+00, 2.84957453E+00, 2.82459363E+00, 2.73607515E+00,
     &   2.63415948E+00, 2.61487445E+00, 2.60484858E+00, 2.58401618E+00,
     &   2.57538789E+00, 2.56880461E+00, 2.56212465E+00, 2.48988220E+00,
     &   2.36209838E+00, 2.19111287E+00, 2.00995068E+00, 1.77790032E+00,
     &   1.51422967E+00, 1.25174691E+00, 1.09663979E+00, 9.35672643E-01,
     &   7.69573193E-01, 5.29983802E-01, 3.55049448E-01, 1.78054593E-01,
     &   7.12927221E-02, 3.56622835E-02, 1.78460479E-02, 5.02132283E-04,
     &   1.78096950E-02, 3.56259222E-02, 1.78018304E-01, 3.55013399E-01,
     &   5.29948147E-01, 1.31197270E+00, 1.59651704E+00, 2.05245145E+00,
     &   2.22780852E+00, 2.39255986E+00, 2.52723877E+00, 2.62463074E+00,
     &   2.70884300E+00, 2.76531385E+00, 2.80922883E+00, 2.83401534E+00,
     &   2.84756180E+00, 2.84905016E+00, 2.84076477E+00, 2.82586416E+00/
  
         DATA ((DGS  (I,J), I=1601,1700), J=2,2) /
     &   2.77661202E+00, 2.74341653E+00, 2.70661246E+00, 2.67112751E+00,
     &   2.59124525E+00, 2.54752636E+00, 2.47652109E+00, 2.36561294E+00,
     &   1.96434488E+00, 1.65349464E+00, 1.41811858E+00, 1.23730012E+00,
     &   1.09537092E+00, 9.81578515E-01, 8.67958343E-01, 6.90561640E-01,
     &   6.42555994E-01, 6.00716865E-01, 5.63940230E-01, 5.09285974E-01,
     &   4.21539984E-01, 3.59480891E-01, 3.13300864E-01, 2.77610038E-01,
     &   2.49205478E-01, 2.26065874E-01, 2.06853348E-01, 1.90647434E-01,
     &   1.76794221E-01, 1.64816455E-01, 1.54357699E-01, 1.45146403E-01,
     &   1.36972066E-01, 1.29669005E-01, 1.23105029E-01, 8.28425692E-02,
     &   5.52406746E-02, 4.14369476E-02, 2.76325250E-02, 2.07306853E-02,
     &   1.65901090E-02, 1.38302170E-02, 1.18592756E-02, 1.03814479E-02,
     &   9.23237397E-03, 8.31344095E-03, 7.79232110E-03, 7.18443795E-03,
     &   6.66525734E-03, 6.21673069E-03, 5.82540190E-03, 5.48103437E-03,
     &   4.23641710E-03, 3.46032800E-03, 2.93190384E-03, 2.55025043E-03,
     &   2.26340441E-03, 2.04255728E-03, 1.86195304E-03, 1.71439629E-03,
     &   8.41372003E-04, 8.24171210E-04, 8.48271593E-04, 8.68631814E-04,
     &   9.08733945E-04, 9.75344075E-04, 1.01697130E-03, 1.07393577E-03,
     &   1.22773168E-03, 1.49008237E-03, 1.98598302E-03, 3.18628086E-03,
     &   4.36267326E-03, 4.66831412E-03, 5.02145410E-03, 5.43395424E-03,
     &   5.92200413E-03, 6.50828284E-03, 7.22551657E-03, 8.12282541E-03,
     &   9.27739843E-03, 1.08177925E-02, 1.29756282E-02, 1.62140044E-02,
     &   2.16132597E-02, 2.25524397E-02, 2.35769165E-02, 2.46991133E-02,
     &   2.59335637E-02, 2.72978344E-02, 2.88138814E-02, 3.05083195E-02,
     &   3.24143713E-02, 3.45748088E-02, 3.70438950E-02, 3.98925065E-02,
     &   4.32161946E-02, 4.71441169E-02, 5.18569073E-02, 5.76172515E-02/
  
         DATA ((DGS  (I,J), I=1701,1800), J=2,2) /
     &   5.94172111E-02, 6.48170979E-02, 7.40717327E-02, 8.64099257E-02,
     &   1.03677596E-01, 1.29563428E-01, 1.72646438E-01, 2.58536261E-01,
     &   5.12399020E-01, 6.09175876E-01, 8.59229316E-01, 1.04938993E+00,
     &   1.20607448E+00, 1.34283038E+00, 1.46416059E+00, 1.57300554E+00,
     &   1.67023100E+00, 1.76034902E+00, 1.84545466E+00, 1.92323178E+00,
     &   1.99164587E+00, 2.05492969E+00, 2.11198746E+00, 2.16196319E+00,
     &   2.20944402E+00, 2.24833663E+00, 2.27870789E+00, 2.30449393E+00,
     &   2.32434145E+00, 2.33663633E+00, 2.33972955E+00, 2.33450322E+00,
     &   2.31941035E+00, 2.29274177E+00, 2.25264667E+00, 2.20757037E+00,
     &   2.13775613E+00, 2.04894362E+00, 1.93932716E+00, 1.78316318E+00,
     &   1.59510484E+00, 1.34086530E+00, 1.00771154E+00, 1.38065730E-01,
     &   6.46031661E-04, 4.56157093E-01, 1.00769517E+00, 1.34085059E+00,
     &   1.59509186E+00, 1.78315182E+00, 1.93931745E+00, 2.04893533E+00,
     &   2.13774922E+00, 2.20756479E+00, 2.25264216E+00, 2.29273847E+00,
     &   2.31940820E+00, 2.33450213E+00, 2.33972945E+00, 2.33663715E+00,
     &   2.32434326E+00, 2.30449664E+00, 2.27871141E+00, 2.24834090E+00,
     &   2.20944906E+00, 2.16196900E+00, 2.11199395E+00, 2.05493685E+00,
     &   1.99165367E+00, 1.92324019E+00, 1.84546367E+00, 1.76035861E+00,
     &   1.67024113E+00, 1.57301618E+00, 1.46417173E+00, 1.34284200E+00,
     &   1.20608657E+00, 1.04940246E+00, 8.59242277E-01, 6.09189252E-01,
     &   5.21627832E-01, 5.05204906E-01, 4.84833914E-01, 4.28570599E-01,
     &   3.77864161E-01, 2.58535950E-01, 1.72660181E-01, 1.29573657E-01,
     &   1.03689099E-01, 8.64236929E-02, 7.40855022E-02, 6.48299857E-02,
     &   5.76310241E-02, 5.18706811E-02, 4.71574244E-02, 4.32299706E-02,
     &   3.99062836E-02, 3.70573846E-02, 3.45885879E-02, 3.24281514E-02/
  
         DATA ((DGS  (I,J), I=1801,1900), J=2,2) /
     &   2.16270503E-02, 1.62278098E-02, 1.29894508E-02, 1.08316376E-02,
     &   9.29125089E-03, 8.13673346E-03, 7.23950256E-03, 5.93619825E-03,
     &   5.03593631E-03, 4.68293580E-03, 4.37741857E-03, 3.28449848E-03,
     &   2.49546206E-03, 2.03375789E-03, 1.73468515E-03, 1.52807922E-03,
     &   1.37908048E-03, 1.26824660E-03, 1.18401448E-03, 1.11904663E-03,
     &   1.06827484E-03, 1.02819373E-03, 9.96477509E-04, 9.71452799E-04,
     &   9.51907597E-04, 9.36970943E-04, 9.26042309E-04, 9.18764705E-04,
     &   9.15057413E-04, 9.15284115E-04, 9.17548423E-04, 9.17359527E-04,
     &   9.31238871E-04, 1.19018117E-03, 1.41960735E-03, 1.60531150E-03,
     &   1.76164784E-03, 1.89409579E-03, 2.00785685E-03, 2.10546727E-03,
     &   2.18915764E-03, 2.25990994E-03, 2.31935684E-03, 2.36853234E-03,
     &   2.40765175E-03, 2.43720932E-03, 2.45791562E-03, 2.47017797E-03,
     &   2.47390205E-03, 2.46950554E-03, 2.45707855E-03, 2.43623422E-03,
     &   2.40748263E-03, 2.37139406E-03, 2.32559657E-03, 2.27307688E-03,
     &   2.21059512E-03, 2.13927721E-03, 2.05744548E-03, 1.96484431E-03,
     &   1.86146724E-03, 1.74765511E-03, 1.61540866E-03, 1.46761554E-03,
     &   1.30319449E-03, 1.11184510E-03, 8.97267866E-04, 7.81737151E-04,
     &   1.24472681E-03, 1.47888620E-03, 1.65732422E-03, 1.79900647E-03,
     &   1.91968794E-03, 2.02306235E-03, 2.10869760E-03, 2.18374418E-03,
     &   2.24855736E-03, 2.30365080E-03, 2.34963680E-03, 2.38791357E-03,
     &   2.41809563E-03, 2.44219733E-03, 2.45878847E-03, 2.46916431E-03,
     &   2.47304402E-03, 2.47038699E-03, 2.46140018E-03, 2.44574533E-03,
     &   2.42323564E-03, 2.39409695E-03, 2.35781344E-03, 2.31367006E-03,
     &   2.25395855E-03, 2.20082839E-03, 2.12980847E-03, 2.04816246E-03,
     &   1.95436043E-03, 1.84609155E-03, 1.72080460E-03, 1.57304198E-03/
  
         DATA ((DGS  (I,J), I=1901,2000), J=2,2) /
     &   1.39692997E-03, 1.17564645E-03, 8.24690344E-04, 8.74472866E-04,
     &   8.34030716E-04, 8.20280711E-04, 8.16079522E-04, 8.15145600E-04,
     &   8.14734382E-04, 8.15785256E-04, 8.17852917E-04, 8.20115784E-04,
     &   8.22280920E-04, 8.24011271E-04, 8.25219356E-04, 8.26075938E-04,
     &   8.26344641E-04, 8.26141206E-04, 8.25308174E-04, 8.23638971E-04,
     &   8.21334536E-04, 8.18255713E-04, 8.14443089E-04, 8.09894326E-04,
     &   8.04535577E-04, 7.98214386E-04, 7.91041962E-04, 7.82958658E-04,
     &   7.73925107E-04, 7.63924405E-04, 7.52905433E-04, 7.40790829E-04,
     &   7.27360603E-04, 7.12623666E-04, 6.96908350E-04, 6.77520657E-04,
     &   6.56432366E-04, 6.33897209E-04, 6.02106566E-04, 6.13793420E-04,
     &   6.27755258E-04, 6.40778486E-04, 6.54001162E-04, 6.66292521E-04,
     &   6.77048794E-04, 6.87311636E-04, 6.97080720E-04, 7.06133979E-04,
     &   7.14571671E-04, 7.22457760E-04, 7.29778998E-04, 7.36505786E-04,
     &   7.42689524E-04, 7.48348983E-04, 7.53409682E-04, 7.57964669E-04,
     &   7.62026332E-04, 7.65557695E-04, 7.68544766E-04, 7.71003884E-04,
     &   7.73023133E-04, 7.74595643E-04, 7.75768179E-04, 7.76499108E-04,
     &   7.76723619E-04, 7.76542807E-04, 7.76119070E-04, 7.75560926E-04,
     &   7.74922833E-04, 7.74404646E-04, 7.74378415E-04, 7.71291022E-04,
     &   7.65651177E-04, 7.59349045E-04, 7.35219545E-04, 7.34297190E-04,
     &   7.33280088E-04, 7.32148100E-04, 7.30869399E-04, 7.29434635E-04,
     &   7.27865314E-04, 7.26142867E-04, 7.24245687E-04, 7.19898666E-04,
     &   7.15422977E-04, 7.11012448E-04, 7.06617499E-04, 7.02172172E-04,
     &   6.97603018E-04, 6.92920484E-04, 6.88158075E-04, 6.83208361E-04,
     &   6.78057927E-04, 6.72722471E-04, 6.67100213E-04, 6.61329011E-04,
     &   6.55317655E-04, 6.48999696E-04, 6.42234235E-04, 6.35430905E-04/
  
         DATA ((DGS  (I,J), I=2001,2100), J=2,2) /
     &   6.28181705E-04, 6.20790029E-04, 6.12189849E-04, 6.03227072E-04,
     &   5.94059058E-04, 5.84690574E-04, 5.73870324E-04, 5.62086151E-04,
     &   5.49572522E-04, 5.31203470E-04, 5.32332452E-04, 5.38077600E-04,
     &   5.44888091E-04, 5.51671727E-04, 5.57539572E-04, 5.63654129E-04,
     &   5.69861743E-04, 5.75941693E-04, 5.80920757E-04, 5.85945454E-04,
     &   5.90585402E-04, 5.95130637E-04, 5.99457145E-04, 6.03528975E-04,
     &   6.07415442E-04, 6.11160540E-04, 6.14655384E-04, 6.17921145E-04,
     &   6.21064663E-04, 6.24035575E-04, 6.26861207E-04, 6.29496835E-04,
     &   6.31953309E-04, 6.34326941E-04, 6.36637138E-04, 6.38915026E-04,
     &   6.41076412E-04, 6.41996116E-04, 6.42961904E-04, 6.44068070E-04,
     &   6.45460387E-04, 6.47309803E-04, 6.48961855E-04, 6.47514659E-04,
     &   6.45875415E-04, 6.36210423E-04, 6.22588707E-04, 6.17460626E-04,
     &   6.21737784E-04, 6.34931547E-04, 6.53414069E-04, 6.77052026E-04,
     &   7.02737430E-04, 7.31614253E-04, 7.62421720E-04, 7.93383790E-04,
     &   8.27924893E-04, 8.63178771E-04, 7.98579695E-04, 7.33980619E-04,
     &   7.05164249E-04, 6.79316209E-04, 6.57798180E-04, 6.37986198E-04,
     &   6.21140161E-04, 6.05356721E-04, 5.91736779E-04, 5.78814367E-04,
     &   5.67051119E-04, 5.56741517E-04, 5.46825617E-04, 5.38069144E-04,
     &   5.29589721E-04, 5.22055527E-04, 5.14718765E-04, 5.08166308E-04,
     &   5.01755405E-04, 4.96004802E-04, 4.90355657E-04, 4.85269239E-04,
     &   4.80466906E-04, 4.75725334E-04, 4.71435722E-04, 4.67188039E-04,
     &   4.63334659E-04, 4.59509023E-04, 4.56029953E-04, 4.52567855E-04,
     &   4.49412381E-04, 4.46265652E-04, 4.43391817E-04, 4.40520415E-04,
     &   4.37776419E-04, 4.35263541E-04, 4.32746221E-04, 4.30437175E-04,
     &   4.28120434E-04, 4.25992176E-04, 4.23853737E-04, 4.21886532E-04/
  
         DATA ((DGS  (I,J), I=2101,2174), J=2,2) /
     &   4.19907258E-04, 4.18084108E-04, 4.16247471E-04, 4.14553654E-04,
     &   4.12918297E-04, 4.11268010E-04, 4.09743514E-04, 4.08203457E-04,
     &   4.06779317E-04, 4.05338602E-04, 4.04005582E-04, 4.02656313E-04,
     &   4.01406234E-04, 4.00139800E-04, 3.98965445E-04, 3.97774716E-04,
     &   3.96620186E-04, 3.95548280E-04, 3.94460128E-04, 3.93363816E-04,
     &   3.92336260E-04, 3.91380843E-04, 3.90409557E-04, 3.89508270E-04,
     &   3.88586630E-04, 3.87730653E-04, 3.86859306E-04, 3.86047516E-04,
     &   3.85220636E-04, 3.84449807E-04, 3.83697921E-04, 3.82931390E-04,
     &   3.82216209E-04, 3.81486693E-04, 3.80805677E-04, 3.80110640E-04,
     &   3.79461472E-04, 3.78806060E-04, 3.78186690E-04, 3.77553929E-04,
     &   3.76962342E-04, 3.76357678E-04, 3.70572635E-04, 3.65954613E-04,
     &   3.65300847E-04, 3.47668607E-04, 3.43578522E-04, 3.37140240E-04,
     &   3.34994023E-04, 3.34869609E-04, 3.32841068E-04, 3.32835757E-04,
     &   3.31730325E-04, 3.31696620E-04, 3.31671882E-04, 3.31226145E-04,
     &   3.30957893E-04, 3.30912104E-04, 3.30838665E-04, 3.30732896E-04,
     &   3.30660387E-04, 3.30615711E-04, 3.30213587E-04, 3.30194749E-04,
     &   3.30091196E-04, 3.30071861E-04, 3.30056308E-04, 3.29950034E-04,
     &   3.29943165E-04, 3.29919527E-04, 3.29832241E-04, 3.29736731E-04,
     &   3.29697351E-04, 3.29453905E-04/

      save
      RETURN
      END

c      ++++ dalhadshigh16 ++++  

c updated dec 2016
       subroutine dalhad_timelike1h16
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL EMA(NC),DAM(NC,2),DGM(NC,2)
       COMMON /DATM16/EMA,DAM,DGM
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 12:21:14 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN:  2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (EMA  (I), I=   1, 100) /
     &   1.3005E+01, 1.3500E+01, 1.4000E+01, 1.4500E+01, 1.5000E+01,
     &   1.6000E+01, 1.7000E+01, 1.8000E+01, 1.9000E+01, 2.0000E+01,
     &   2.1000E+01, 2.2000E+01, 2.3000E+01, 2.4000E+01, 2.5000E+01,
     &   2.6000E+01, 2.7000E+01, 2.8000E+01, 2.9000E+01, 3.0000E+01,
     &   3.1000E+01, 3.2000E+01, 3.3000E+01, 3.4000E+01, 3.5000E+01,
     &   3.6000E+01, 3.7000E+01, 3.8000E+01, 3.9000E+01, 4.0000E+01,
     &   4.1000E+01, 4.2000E+01, 4.3000E+01, 4.4000E+01, 4.5000E+01,
     &   4.6000E+01, 4.7000E+01, 4.8000E+01, 4.9000E+01, 5.0000E+01,
     &   5.1000E+01, 5.2000E+01, 5.3000E+01, 5.4000E+01, 5.5000E+01,
     &   5.6000E+01, 5.7000E+01, 5.8000E+01, 5.9000E+01, 6.0000E+01,
     &   6.1000E+01, 6.2000E+01, 6.3000E+01, 6.4000E+01, 6.5000E+01,
     &   6.6000E+01, 6.7000E+01, 6.8000E+01, 6.9000E+01, 7.0000E+01,
     &   7.1000E+01, 7.2000E+01, 7.3000E+01, 7.4000E+01, 7.5000E+01,
     &   7.6000E+01, 7.7000E+01, 7.8000E+01, 7.9000E+01, 8.0000E+01,
     &   8.1000E+01, 8.2000E+01, 8.3000E+01, 8.4000E+01, 8.5000E+01,
     &   8.6000E+01, 8.7000E+01, 8.8000E+01, 8.9000E+01, 9.0000E+01,
     &   9.1000E+01, 9.2000E+01, 9.3000E+01, 9.4000E+01, 9.5000E+01,
     &   9.6000E+01, 9.7000E+01, 9.8000E+01, 9.9000E+01, 1.0000E+02,
     &   1.0900E+02, 1.1800E+02, 1.2700E+02, 1.3600E+02, 1.4500E+02,
     &   1.5400E+02, 1.6300E+02, 1.7200E+02, 1.8100E+02, 1.9000E+02/
  
       DATA  (EMA  (I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02, 2.1700E+02, 2.2600E+02, 2.3500E+02,
     &   2.4400E+02, 2.5300E+02, 2.6200E+02, 2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02, 3.0700E+02, 3.1600E+02, 3.2500E+02,
     &   3.3400E+02, 3.4300E+02, 3.5200E+02, 3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02, 3.9700E+02, 4.0600E+02, 4.1500E+02,
     &   4.2400E+02, 4.3300E+02, 4.4200E+02, 4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02, 4.8700E+02, 4.9600E+02, 5.0500E+02,
     &   5.1400E+02, 5.2300E+02, 5.3200E+02, 5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02, 5.7700E+02, 5.8600E+02, 5.9500E+02,
     &   6.0400E+02, 6.1300E+02, 6.2200E+02, 6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02, 6.6700E+02, 6.7600E+02, 6.8500E+02,
     &   6.9400E+02, 7.0300E+02, 7.1200E+02, 7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02, 7.5700E+02, 7.6600E+02, 7.7500E+02,
     &   7.8400E+02, 7.9300E+02, 8.0200E+02, 8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02, 8.4700E+02, 8.5600E+02, 8.6500E+02,
     &   8.7400E+02, 8.8300E+02, 8.9200E+02, 9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02, 9.3700E+02, 9.4600E+02, 9.5500E+02,
     &   9.6400E+02, 9.7300E+02, 9.8200E+02, 9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03, 4.0000E+03, 5.0000E+03, 6.0000E+03,
     &   8.0000E+03, 1.0000E+04, 1.2000E+04, 1.4000E+04, 2.0000E+04/
  
  
         DATA ((DAM  (I,J), I=   1, 100), J=1,1) /
     &   1.5838E-02, 1.6122E-02, 1.6322E-02, 1.6548E-02, 1.6764E-02,
     &   1.7171E-02, 1.7548E-02, 1.7902E-02, 1.8233E-02, 1.8547E-02,
     &   1.8844E-02, 1.9236E-02, 1.9395E-02, 1.9651E-02, 1.9897E-02,
     &   2.0134E-02, 2.0360E-02, 2.0578E-02, 2.0788E-02, 2.0991E-02,
     &   2.1187E-02, 2.1376E-02, 2.1560E-02, 2.1741E-02, 2.1943E-02,
     &   2.2078E-02, 2.2242E-02, 2.2400E-02, 2.2555E-02, 2.2706E-02,
     &   2.2852E-02, 2.2995E-02, 2.3143E-02, 2.3272E-02, 2.3405E-02,
     &   2.3599E-02, 2.3663E-02, 2.3788E-02, 2.3910E-02, 2.4030E-02,
     &   2.4147E-02, 2.4263E-02, 2.4375E-02, 2.4510E-02, 2.4595E-02,
     &   2.4702E-02, 2.4807E-02, 2.5034E-02, 2.5011E-02, 2.5110E-02,
     &   2.5208E-02, 2.5304E-02, 2.5399E-02, 2.5492E-02, 2.5584E-02,
     &   2.5674E-02, 2.5763E-02, 2.5851E-02, 2.5937E-02, 2.6023E-02,
     &   2.6106E-02, 2.6189E-02, 2.6271E-02, 2.6351E-02, 2.6431E-02,
     &   2.6509E-02, 2.6586E-02, 2.6663E-02, 2.6738E-02, 2.6812E-02,
     &   2.6886E-02, 2.6958E-02, 2.7030E-02, 2.7101E-02, 2.7171E-02,
     &   2.7240E-02, 2.7308E-02, 2.7376E-02, 2.7442E-02, 2.7509E-02,
     &   2.7574E-02, 2.7638E-02, 2.7702E-02, 2.7766E-02, 2.7828E-02,
     &   2.7890E-02, 2.7951E-02, 2.8012E-02, 2.8072E-02, 2.8131E-02,
     &   2.8641E-02, 2.9110E-02, 2.9544E-02, 2.9949E-02, 3.0329E-02,
     &   3.0685E-02, 3.1022E-02, 3.1340E-02, 3.1643E-02, 3.1931E-02/
  
         DATA ((DAM  (I,J), I= 101, 200), J=1,1) /
     &   3.2206E-02, 3.2469E-02, 3.2722E-02, 3.2964E-02, 3.3197E-02,
     &   3.3422E-02, 3.3639E-02, 3.3848E-02, 3.4051E-02, 3.4247E-02,
     &   3.4438E-02, 3.4623E-02, 3.4803E-02, 3.4978E-02, 3.5148E-02,
     &   3.5314E-02, 3.5476E-02, 3.5633E-02, 3.5788E-02, 3.5940E-02,
     &   3.6089E-02, 3.6234E-02, 3.6377E-02, 3.6516E-02, 3.6653E-02,
     &   3.6787E-02, 3.6920E-02, 3.7049E-02, 3.7177E-02, 3.7303E-02,
     &   3.7426E-02, 3.7548E-02, 3.7668E-02, 3.7787E-02, 3.7897E-02,
     &   3.8000E-02, 3.8102E-02, 3.8202E-02, 3.8300E-02, 3.8397E-02,
     &   3.8492E-02, 3.8585E-02, 3.8677E-02, 3.8768E-02, 3.8857E-02,
     &   3.8945E-02, 3.9032E-02, 3.9117E-02, 3.9201E-02, 3.9284E-02,
     &   3.9365E-02, 3.9446E-02, 3.9526E-02, 3.9604E-02, 3.9681E-02,
     &   3.9758E-02, 3.9833E-02, 3.9907E-02, 3.9981E-02, 4.0053E-02,
     &   4.0125E-02, 4.0196E-02, 4.0266E-02, 4.0335E-02, 4.0403E-02,
     &   4.0471E-02, 4.0538E-02, 4.0604E-02, 4.0669E-02, 4.0733E-02,
     &   4.0797E-02, 4.0860E-02, 4.0923E-02, 4.0984E-02, 4.1046E-02,
     &   4.1106E-02, 4.1166E-02, 4.1225E-02, 4.1284E-02, 4.1342E-02,
     &   4.1400E-02, 4.1457E-02, 4.1513E-02, 4.1569E-02, 4.1624E-02,
     &   4.1679E-02, 4.1733E-02, 4.1787E-02, 4.1840E-02, 4.1893E-02,
     &   4.5940E-02, 4.8303E-02, 4.9980E-02, 5.1280E-02, 5.2340E-02,
     &   5.4015E-02, 5.5313E-02, 5.6371E-02, 5.7268E-02, 5.9340E-02/
  
  
         DATA ((DAM  (I,J), I=   1, 100), J=2,2) /
     &   1.4068E-04, 1.3594E-04, 1.3301E-04, 1.3102E-04, 1.2959E-04,
     &   1.2763E-04, 1.2635E-04, 1.2543E-04, 1.2475E-04, 1.2421E-04,
     &   1.2378E-04, 1.2344E-04, 1.2314E-04, 1.2289E-04, 1.2268E-04,
     &   1.2250E-04, 1.2234E-04, 1.2220E-04, 1.2208E-04, 1.2197E-04,
     &   1.2187E-04, 1.2178E-04, 1.2170E-04, 1.2163E-04, 1.2157E-04,
     &   1.2151E-04, 1.2145E-04, 1.2141E-04, 1.2136E-04, 1.2132E-04,
     &   1.2128E-04, 1.2125E-04, 1.2122E-04, 1.2118E-04, 1.2116E-04,
     &   1.2114E-04, 1.2111E-04, 1.2108E-04, 1.2106E-04, 1.2104E-04,
     &   1.2102E-04, 1.2101E-04, 1.2099E-04, 1.2098E-04, 1.2096E-04,
     &   1.2094E-04, 1.2093E-04, 1.2094E-04, 1.2091E-04, 1.2090E-04,
     &   1.2089E-04, 1.2088E-04, 1.2087E-04, 1.2086E-04, 1.2085E-04,
     &   1.2084E-04, 1.2083E-04, 1.2083E-04, 1.2082E-04, 1.2081E-04,
     &   1.2081E-04, 1.2080E-04, 1.2079E-04, 1.2079E-04, 1.2078E-04,
     &   1.2078E-04, 1.2077E-04, 1.2077E-04, 1.2076E-04, 1.2076E-04,
     &   1.2076E-04, 1.2075E-04, 1.2075E-04, 1.2074E-04, 1.2074E-04,
     &   1.2074E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04,
     &   1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2071E-04,
     &   1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2070E-04, 1.2070E-04,
     &   1.2069E-04, 1.2068E-04, 1.2067E-04, 1.2066E-04, 1.2066E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2064E-04, 1.2064E-04/
  
         DATA ((DAM  (I,J), I= 101, 200), J=2,2) /
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04,
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04,
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2071E-04, 1.2072E-04, 1.2073E-04, 1.2074E-04, 1.2074E-04,
     &   1.2075E-04, 1.2076E-04, 1.2076E-04, 1.2077E-04, 1.2078E-04/
  

c      ++++ deghadshigh16 ++++  

c updated dec 2016
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 16:17:48 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN:  2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (EMA  (I), I=   1, 100) /
     &   1.3005E+01, 1.3500E+01, 1.4000E+01, 1.4500E+01, 1.5000E+01,
     &   1.6000E+01, 1.7000E+01, 1.8000E+01, 1.9000E+01, 2.0000E+01,
     &   2.1000E+01, 2.2000E+01, 2.3000E+01, 2.4000E+01, 2.5000E+01,
     &   2.6000E+01, 2.7000E+01, 2.8000E+01, 2.9000E+01, 3.0000E+01,
     &   3.1000E+01, 3.2000E+01, 3.3000E+01, 3.4000E+01, 3.5000E+01,
     &   3.6000E+01, 3.7000E+01, 3.8000E+01, 3.9000E+01, 4.0000E+01,
     &   4.1000E+01, 4.2000E+01, 4.3000E+01, 4.4000E+01, 4.5000E+01,
     &   4.6000E+01, 4.7000E+01, 4.8000E+01, 4.9000E+01, 5.0000E+01,
     &   5.1000E+01, 5.2000E+01, 5.3000E+01, 5.4000E+01, 5.5000E+01,
     &   5.6000E+01, 5.7000E+01, 5.8000E+01, 5.9000E+01, 6.0000E+01,
     &   6.1000E+01, 6.2000E+01, 6.3000E+01, 6.4000E+01, 6.5000E+01,
     &   6.6000E+01, 6.7000E+01, 6.8000E+01, 6.9000E+01, 7.0000E+01,
     &   7.1000E+01, 7.2000E+01, 7.3000E+01, 7.4000E+01, 7.5000E+01,
     &   7.6000E+01, 7.7000E+01, 7.8000E+01, 7.9000E+01, 8.0000E+01,
     &   8.1000E+01, 8.2000E+01, 8.3000E+01, 8.4000E+01, 8.5000E+01,
     &   8.6000E+01, 8.7000E+01, 8.8000E+01, 8.9000E+01, 9.0000E+01,
     &   9.1000E+01, 9.2000E+01, 9.3000E+01, 9.4000E+01, 9.5000E+01,
     &   9.6000E+01, 9.7000E+01, 9.8000E+01, 9.9000E+01, 1.0000E+02,
     &   1.0900E+02, 1.1800E+02, 1.2700E+02, 1.3600E+02, 1.4500E+02,
     &   1.5400E+02, 1.6300E+02, 1.7200E+02, 1.8100E+02, 1.9000E+02/
  
       DATA  (EMA  (I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02, 2.1700E+02, 2.2600E+02, 2.3500E+02,
     &   2.4400E+02, 2.5300E+02, 2.6200E+02, 2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02, 3.0700E+02, 3.1600E+02, 3.2500E+02,
     &   3.3400E+02, 3.4300E+02, 3.5200E+02, 3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02, 3.9700E+02, 4.0600E+02, 4.1500E+02,
     &   4.2400E+02, 4.3300E+02, 4.4200E+02, 4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02, 4.8700E+02, 4.9600E+02, 5.0500E+02,
     &   5.1400E+02, 5.2300E+02, 5.3200E+02, 5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02, 5.7700E+02, 5.8600E+02, 5.9500E+02,
     &   6.0400E+02, 6.1300E+02, 6.2200E+02, 6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02, 6.6700E+02, 6.7600E+02, 6.8500E+02,
     &   6.9400E+02, 7.0300E+02, 7.1200E+02, 7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02, 7.5700E+02, 7.6600E+02, 7.7500E+02,
     &   7.8400E+02, 7.9300E+02, 8.0200E+02, 8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02, 8.4700E+02, 8.5600E+02, 8.6500E+02,
     &   8.7400E+02, 8.8300E+02, 8.9200E+02, 9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02, 9.3700E+02, 9.4600E+02, 9.5500E+02,
     &   9.6400E+02, 9.7300E+02, 9.8200E+02, 9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03, 4.0000E+03, 5.0000E+03, 6.0000E+03,
     &   8.0000E+03, 1.0000E+04, 1.2000E+04, 1.4000E+04, 2.0000E+04/
  
  
         DATA ((DGM  (I,J), I=   1, 100), J=1,1) /
     &   3.1571E-02, 3.2184E-02, 3.2620E-02, 3.3104E-02, 3.3565E-02,
     &   3.4428E-02, 3.5225E-02, 3.5968E-02, 3.6663E-02, 3.7320E-02,
     &   3.7938E-02, 3.8754E-02, 3.9086E-02, 3.9620E-02, 4.0131E-02,
     &   4.0623E-02, 4.1090E-02, 4.1542E-02, 4.1977E-02, 4.2397E-02,
     &   4.2804E-02, 4.3196E-02, 4.3576E-02, 4.3951E-02, 4.4369E-02,
     &   4.4648E-02, 4.4985E-02, 4.5313E-02, 4.5634E-02, 4.5946E-02,
     &   4.6247E-02, 4.6543E-02, 4.6849E-02, 4.7114E-02, 4.7389E-02,
     &   4.7790E-02, 4.7922E-02, 4.8180E-02, 4.8432E-02, 4.8680E-02,
     &   4.8922E-02, 4.9159E-02, 4.9392E-02, 4.9671E-02, 4.9845E-02,
     &   5.0066E-02, 5.0282E-02, 5.0754E-02, 5.0703E-02, 5.0909E-02,
     &   5.1111E-02, 5.1309E-02, 5.1505E-02, 5.1697E-02, 5.1886E-02,
     &   5.2073E-02, 5.2256E-02, 5.2437E-02, 5.2615E-02, 5.2791E-02,
     &   5.2964E-02, 5.3134E-02, 5.3303E-02, 5.3469E-02, 5.3632E-02,
     &   5.3794E-02, 5.3953E-02, 5.4111E-02, 5.4266E-02, 5.4419E-02,
     &   5.4571E-02, 5.4721E-02, 5.4868E-02, 5.5014E-02, 5.5159E-02,
     &   5.5301E-02, 5.5442E-02, 5.5582E-02, 5.5719E-02, 5.5855E-02,
     &   5.5990E-02, 5.6123E-02, 5.6255E-02, 5.6386E-02, 5.6514E-02,
     &   5.6642E-02, 5.6768E-02, 5.6893E-02, 5.7017E-02, 5.7140E-02,
     &   5.8190E-02, 5.9157E-02, 6.0053E-02, 6.0888E-02, 6.1670E-02,
     &   6.2405E-02, 6.3099E-02, 6.3756E-02, 6.4380E-02, 6.4974E-02/
  
         DATA ((DGM  (I,J), I= 101, 200), J=1,1) /
     &   6.5541E-02, 6.6084E-02, 6.6604E-02, 6.7103E-02, 6.7584E-02,
     &   6.8047E-02, 6.8494E-02, 6.8926E-02, 6.9344E-02, 6.9749E-02,
     &   7.0142E-02, 7.0523E-02, 7.0894E-02, 7.1254E-02, 7.1605E-02,
     &   7.1947E-02, 7.2281E-02, 7.2604E-02, 7.2925E-02, 7.3239E-02,
     &   7.3545E-02, 7.3845E-02, 7.4138E-02, 7.4426E-02, 7.4708E-02,
     &   7.4985E-02, 7.5258E-02, 7.5525E-02, 7.5788E-02, 7.6047E-02,
     &   7.6302E-02, 7.6553E-02, 7.6801E-02, 7.7045E-02, 7.7273E-02,
     &   7.7486E-02, 7.7695E-02, 7.7901E-02, 7.8104E-02, 7.8303E-02,
     &   7.8499E-02, 7.8692E-02, 7.8881E-02, 7.9068E-02, 7.9252E-02,
     &   7.9433E-02, 7.9612E-02, 7.9787E-02, 7.9961E-02, 8.0131E-02,
     &   8.0300E-02, 8.0466E-02, 8.0630E-02, 8.0791E-02, 8.0951E-02,
     &   8.1108E-02, 8.1264E-02, 8.1417E-02, 8.1569E-02, 8.1718E-02,
     &   8.1866E-02, 8.2012E-02, 8.2156E-02, 8.2299E-02, 8.2439E-02,
     &   8.2579E-02, 8.2716E-02, 8.2852E-02, 8.2987E-02, 8.3120E-02,
     &   8.3251E-02, 8.3381E-02, 8.3510E-02, 8.3638E-02, 8.3764E-02,
     &   8.3888E-02, 8.4012E-02, 8.4134E-02, 8.4255E-02, 8.4375E-02,
     &   8.4493E-02, 8.4611E-02, 8.4727E-02, 8.4842E-02, 8.4956E-02,
     &   8.5069E-02, 8.5181E-02, 8.5292E-02, 8.5402E-02, 8.5511E-02,
     &   9.3853E-02, 9.8725E-02, 1.0218E-01, 1.0486E-01, 1.0705E-01,
     &   1.1050E-01, 1.1317E-01, 1.1536E-01, 1.1721E-01, 1.2148E-01/
  
  
         DATA ((DGM  (I,J), I=   1, 100), J=2,2) /
     &   3.9336E-04, 3.7636E-04, 3.6595E-04, 3.5905E-04, 3.5415E-04,
     &   3.4767E-04, 3.4358E-04, 3.4076E-04, 3.3871E-04, 3.3714E-04,
     &   3.3591E-04, 3.3495E-04, 3.3410E-04, 3.3342E-04, 3.3284E-04,
     &   3.3235E-04, 3.3192E-04, 3.3155E-04, 3.3123E-04, 3.3094E-04,
     &   3.3068E-04, 3.3046E-04, 3.3025E-04, 3.3007E-04, 3.2992E-04,
     &   3.2975E-04, 3.2961E-04, 3.2949E-04, 3.2937E-04, 3.2927E-04,
     &   3.2917E-04, 3.2908E-04, 3.2901E-04, 3.2892E-04, 3.2885E-04,
     &   3.2882E-04, 3.2872E-04, 3.2866E-04, 3.2861E-04, 3.2856E-04,
     &   3.2851E-04, 3.2847E-04, 3.2843E-04, 3.2841E-04, 3.2835E-04,
     &   3.2832E-04, 3.2828E-04, 3.2831E-04, 3.2822E-04, 3.2819E-04,
     &   3.2817E-04, 3.2814E-04, 3.2812E-04, 3.2810E-04, 3.2808E-04,
     &   3.2805E-04, 3.2804E-04, 3.2802E-04, 3.2800E-04, 3.2798E-04,
     &   3.2797E-04, 3.2795E-04, 3.2794E-04, 3.2792E-04, 3.2791E-04,
     &   3.2789E-04, 3.2788E-04, 3.2787E-04, 3.2786E-04, 3.2785E-04,
     &   3.2784E-04, 3.2783E-04, 3.2782E-04, 3.2781E-04, 3.2780E-04,
     &   3.2779E-04, 3.2778E-04, 3.2777E-04, 3.2777E-04, 3.2776E-04,
     &   3.2775E-04, 3.2775E-04, 3.2774E-04, 3.2773E-04, 3.2773E-04,
     &   3.2772E-04, 3.2771E-04, 3.2771E-04, 3.2770E-04, 3.2770E-04,
     &   3.2766E-04, 3.2763E-04, 3.2760E-04, 3.2759E-04, 3.2757E-04,
     &   3.2756E-04, 3.2755E-04, 3.2755E-04, 3.2754E-04, 3.2753E-04/
  
         DATA ((DGM  (I,J), I= 101, 200), J=2,2) /
     &   3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2752E-04, 3.2752E-04,
     &   3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04,
     &   3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04,
     &   3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2753E-04,
     &   3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04,
     &   3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04,
     &   3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04,
     &   3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04,
     &   3.2754E-04, 3.2754E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04,
     &   3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04,
     &   3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2756E-04,
     &   3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04,
     &   3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04,
     &   3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2757E-04,
     &   3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04,
     &   3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04,
     &   3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04,
     &   3.2757E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04,
     &   3.2762E-04, 3.2764E-04, 3.2766E-04, 3.2767E-04, 3.2768E-04,
     &   3.2770E-04, 3.2771E-04, 3.2771E-04, 3.2773E-04, 3.2774E-04/
  
      save
      RETURN
      END
      
c      ++++ dalhadt16 ++++  

c updated dec 2016
       subroutine dalhad_spacelike16
       IMPLICIT NONE
       INTEGER NA,NC,I,J
       PARAMETER(NA=979,NC=200)
       REAL ETA(NA),DAT(NA,2),DGT(NA,2)
       REAL XXX(NC),YGG(NC,2),Y3G(NC,2)
       COMMON /DATT16/ETA,DAT,DGT
       COMMON /DATH16/XXX,YGG,Y3G
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 11:06:05 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (ETA  (I), I=   1, 100) /
     &  -1.0000E+03,-9.9000E+02,-9.8000E+02,-9.7000E+02,-9.6000E+02,
     &  -9.5000E+02,-9.4000E+02,-9.3000E+02,-9.2000E+02,-9.1000E+02,
     &  -9.0000E+02,-8.9000E+02,-8.8000E+02,-8.7000E+02,-8.6000E+02,
     &  -8.5000E+02,-8.4000E+02,-8.3000E+02,-8.2000E+02,-8.1000E+02,
     &  -8.0000E+02,-7.9000E+02,-7.8000E+02,-7.7000E+02,-7.6000E+02,
     &  -7.5000E+02,-7.4000E+02,-7.3000E+02,-7.2000E+02,-7.1000E+02,
     &  -7.0000E+02,-6.9000E+02,-6.8000E+02,-6.7000E+02,-6.6000E+02,
     &  -6.5000E+02,-6.4000E+02,-6.3000E+02,-6.2000E+02,-6.1000E+02,
     &  -6.0000E+02,-5.9000E+02,-5.8000E+02,-5.7000E+02,-5.6000E+02,
     &  -5.5000E+02,-5.4000E+02,-5.3000E+02,-5.2000E+02,-5.1000E+02,
     &  -5.0000E+02,-4.9000E+02,-4.8000E+02,-4.7000E+02,-4.6000E+02,
     &  -4.5000E+02,-4.4000E+02,-4.3000E+02,-4.2000E+02,-4.1000E+02,
     &  -4.0000E+02,-3.9000E+02,-3.8000E+02,-3.7000E+02,-3.6000E+02,
     &  -3.5000E+02,-3.4000E+02,-3.3000E+02,-3.2000E+02,-3.1000E+02,
     &  -3.0000E+02,-2.9000E+02,-2.8000E+02,-2.7000E+02,-2.6000E+02,
     &  -2.5000E+02,-2.4000E+02,-2.3000E+02,-2.2000E+02,-2.1000E+02,
     &  -2.0000E+02,-1.9000E+02,-1.8000E+02,-1.7000E+02,-1.6000E+02,
     &  -1.5000E+02,-1.4000E+02,-1.3000E+02,-1.2000E+02,-1.1000E+02,
     &  -1.0000E+02,-9.9000E+01,-9.8000E+01,-9.7000E+01,-9.6000E+01,
     &  -9.5000E+01,-9.4000E+01,-9.3000E+01,-9.2000E+01,-9.1000E+01/
  
       DATA  (ETA  (I), I= 101, 200) /
     &  -9.0000E+01,-8.9000E+01,-8.8000E+01,-8.7000E+01,-8.6000E+01,
     &  -8.5000E+01,-8.4000E+01,-8.3000E+01,-8.2000E+01,-8.1000E+01,
     &  -8.0000E+01,-7.9000E+01,-7.8000E+01,-7.7000E+01,-7.6000E+01,
     &  -7.5000E+01,-7.4000E+01,-7.3000E+01,-7.2000E+01,-7.1000E+01,
     &  -7.0000E+01,-6.9000E+01,-6.8000E+01,-6.7000E+01,-6.6000E+01,
     &  -6.5000E+01,-6.4000E+01,-6.3000E+01,-6.2000E+01,-6.1000E+01,
     &  -6.0000E+01,-5.9000E+01,-5.8000E+01,-5.7000E+01,-5.6000E+01,
     &  -5.5000E+01,-5.4000E+01,-5.3000E+01,-5.2000E+01,-5.1000E+01,
     &  -5.0000E+01,-4.9000E+01,-4.8000E+01,-4.7000E+01,-4.6000E+01,
     &  -4.5000E+01,-4.4000E+01,-4.3000E+01,-4.2000E+01,-4.1000E+01,
     &  -4.0000E+01,-3.9000E+01,-3.8000E+01,-3.7000E+01,-3.6000E+01,
     &  -3.5000E+01,-3.4000E+01,-3.3000E+01,-3.2000E+01,-3.1000E+01,
     &  -3.0000E+01,-2.9000E+01,-2.8000E+01,-2.7000E+01,-2.6000E+01,
     &  -2.5000E+01,-2.4000E+01,-2.3000E+01,-2.2000E+01,-2.1000E+01,
     &  -2.0000E+01,-1.9000E+01,-1.8000E+01,-1.7000E+01,-1.6000E+01,
     &  -1.5000E+01,-1.4000E+01,-1.3000E+01,-1.2000E+01,-1.1000E+01,
     &  -1.0000E+01,-9.9100E+00,-9.8200E+00,-9.7300E+00,-9.6400E+00,
     &  -9.5500E+00,-9.4600E+00,-9.3700E+00,-9.2800E+00,-9.1900E+00,
     &  -9.1000E+00,-9.0100E+00,-8.9200E+00,-8.8300E+00,-8.7400E+00,
     &  -8.6500E+00,-8.5600E+00,-8.4700E+00,-8.3800E+00,-8.2900E+00/
  
       DATA  (ETA  (I), I= 201, 300) /
     &  -8.2000E+00,-8.1100E+00,-8.0200E+00,-7.9300E+00,-7.8400E+00,
     &  -7.7500E+00,-7.6600E+00,-7.5700E+00,-7.4800E+00,-7.3900E+00,
     &  -7.3000E+00,-7.2100E+00,-7.1200E+00,-7.0300E+00,-6.9400E+00,
     &  -6.8500E+00,-6.7600E+00,-6.6700E+00,-6.5800E+00,-6.4900E+00,
     &  -6.4000E+00,-6.3100E+00,-6.2200E+00,-6.1300E+00,-6.0400E+00,
     &  -5.9500E+00,-5.8600E+00,-5.7700E+00,-5.6800E+00,-5.5900E+00,
     &  -5.5000E+00,-5.4100E+00,-5.3200E+00,-5.2300E+00,-5.1400E+00,
     &  -5.0500E+00,-4.9600E+00,-4.8700E+00,-4.7800E+00,-4.6900E+00,
     &  -4.6000E+00,-4.5100E+00,-4.4200E+00,-4.3300E+00,-4.2400E+00,
     &  -4.1500E+00,-4.0600E+00,-3.9700E+00,-3.8800E+00,-3.7900E+00,
     &  -3.7000E+00,-3.6100E+00,-3.5200E+00,-3.4300E+00,-3.3400E+00,
     &  -3.2500E+00,-3.1600E+00,-3.0700E+00,-2.9800E+00,-2.8900E+00,
     &  -2.8000E+00,-2.7100E+00,-2.6200E+00,-2.5300E+00,-2.4400E+00,
     &  -2.3500E+00,-2.2600E+00,-2.1700E+00,-2.0800E+00,-1.9900E+00,
     &  -1.9000E+00,-1.8100E+00,-1.7200E+00,-1.6300E+00,-1.5400E+00,
     &  -1.4500E+00,-1.3600E+00,-1.2700E+00,-1.1800E+00,-1.0900E+00,
     &  -1.0000E+00,-9.9100E-01,-9.8200E-01,-9.7300E-01,-9.6400E-01,
     &  -9.5500E-01,-9.4600E-01,-9.3700E-01,-9.2800E-01,-9.1900E-01,
     &  -9.1000E-01,-9.0100E-01,-8.9200E-01,-8.8300E-01,-8.7400E-01,
     &  -8.6500E-01,-8.5600E-01,-8.4700E-01,-8.3800E-01,-8.2900E-01/
  
       DATA  (ETA  (I), I= 301, 400) /
     &  -8.2000E-01,-8.1100E-01,-8.0200E-01,-7.9300E-01,-7.8400E-01,
     &  -7.7500E-01,-7.6600E-01,-7.5700E-01,-7.4800E-01,-7.3900E-01,
     &  -7.3000E-01,-7.2100E-01,-7.1200E-01,-7.0300E-01,-6.9400E-01,
     &  -6.8500E-01,-6.7600E-01,-6.6700E-01,-6.5800E-01,-6.4900E-01,
     &  -6.4000E-01,-6.3100E-01,-6.2200E-01,-6.1300E-01,-6.0400E-01,
     &  -5.9500E-01,-5.8600E-01,-5.7700E-01,-5.6800E-01,-5.5900E-01,
     &  -5.5000E-01,-5.4100E-01,-5.3200E-01,-5.2300E-01,-5.1400E-01,
     &  -5.0500E-01,-4.9600E-01,-4.8700E-01,-4.7800E-01,-4.6900E-01,
     &  -4.6000E-01,-4.5100E-01,-4.4200E-01,-4.3300E-01,-4.2400E-01,
     &  -4.1500E-01,-4.0600E-01,-3.9700E-01,-3.8800E-01,-3.7900E-01,
     &  -3.7000E-01,-3.6100E-01,-3.5200E-01,-3.4300E-01,-3.3400E-01,
     &  -3.2500E-01,-3.1600E-01,-3.0700E-01,-2.9800E-01,-2.8900E-01,
     &  -2.8000E-01,-2.7100E-01,-2.6200E-01,-2.5300E-01,-2.4400E-01,
     &  -2.3500E-01,-2.2600E-01,-2.1700E-01,-2.0800E-01,-1.9900E-01,
     &  -1.9000E-01,-1.8100E-01,-1.7200E-01,-1.6300E-01,-1.5400E-01,
     &  -1.4500E-01,-1.3600E-01,-1.2700E-01,-1.1800E-01,-1.0900E-01,
     &  -1.0000E-01,-9.9100E-02,-9.8200E-02,-9.7300E-02,-9.6400E-02,
     &  -9.5500E-02,-9.4600E-02,-9.3700E-02,-9.2800E-02,-9.1900E-02,
     &  -9.1000E-02,-9.0100E-02,-8.9200E-02,-8.8300E-02,-8.7400E-02,
     &  -8.6500E-02,-8.5600E-02,-8.4700E-02,-8.3800E-02,-8.2900E-02/
  
       DATA  (ETA  (I), I= 401, 500) /
     &  -8.2000E-02,-8.1100E-02,-8.0200E-02,-7.9300E-02,-7.8400E-02,
     &  -7.7500E-02,-7.6600E-02,-7.5700E-02,-7.4800E-02,-7.3900E-02,
     &  -7.3000E-02,-7.2100E-02,-7.1200E-02,-7.0300E-02,-6.9400E-02,
     &  -6.8500E-02,-6.7600E-02,-6.6700E-02,-6.5800E-02,-6.4900E-02,
     &  -6.4000E-02,-6.3100E-02,-6.2200E-02,-6.1300E-02,-6.0400E-02,
     &  -5.9500E-02,-5.8600E-02,-5.7700E-02,-5.6800E-02,-5.5900E-02,
     &  -5.5000E-02,-5.4100E-02,-5.3200E-02,-5.2300E-02,-5.1400E-02,
     &  -5.0500E-02,-4.9600E-02,-4.8700E-02,-4.7800E-02,-4.6900E-02,
     &  -4.6000E-02,-4.5100E-02,-4.4200E-02,-4.3300E-02,-4.2400E-02,
     &  -4.1500E-02,-4.0600E-02,-3.9700E-02,-3.8800E-02,-3.7900E-02,
     &  -3.7000E-02,-3.6100E-02,-3.5200E-02,-3.4300E-02,-3.3400E-02,
     &  -3.2500E-02,-3.1600E-02,-3.0700E-02,-2.9800E-02,-2.8900E-02,
     &  -2.8000E-02,-2.7100E-02,-2.6200E-02,-2.5300E-02,-2.4400E-02,
     &  -2.3500E-02,-2.2600E-02,-2.1700E-02,-2.0800E-02,-1.9900E-02,
     &  -1.9000E-02,-1.8100E-02,-1.7200E-02,-1.6300E-02,-1.5400E-02,
     &  -1.4500E-02,-1.3600E-02,-1.2700E-02,-1.1800E-02,-1.0900E-02,
     &  -1.0000E-02,-9.9100E-03,-9.8200E-03,-9.7300E-03,-9.6400E-03,
     &  -9.5500E-03,-9.4600E-03,-9.3700E-03,-9.2800E-03,-9.1900E-03,
     &  -9.1000E-03,-9.0100E-03,-8.9200E-03,-8.8300E-03,-8.7400E-03,
     &  -8.6500E-03,-8.5600E-03,-8.4700E-03,-8.3800E-03,-8.2900E-03/
  
       DATA  (ETA  (I), I= 501, 600) /
     &  -8.2000E-03,-8.1100E-03,-8.0200E-03,-7.9300E-03,-7.8400E-03,
     &  -7.7500E-03,-7.6600E-03,-7.5700E-03,-7.4800E-03,-7.3900E-03,
     &  -7.3000E-03,-7.2100E-03,-7.1200E-03,-7.0300E-03,-6.9400E-03,
     &  -6.8500E-03,-6.7600E-03,-6.6700E-03,-6.5800E-03,-6.4900E-03,
     &  -6.4000E-03,-6.3100E-03,-6.2200E-03,-6.1300E-03,-6.0400E-03,
     &  -5.9500E-03,-5.8600E-03,-5.7700E-03,-5.6800E-03,-5.5900E-03,
     &  -5.5000E-03,-5.4100E-03,-5.3200E-03,-5.2300E-03,-5.1400E-03,
     &  -5.0500E-03,-4.9600E-03,-4.8700E-03,-4.7800E-03,-4.6900E-03,
     &  -4.6000E-03,-4.5100E-03,-4.4200E-03,-4.3300E-03,-4.2400E-03,
     &  -4.1500E-03,-4.0600E-03,-3.9700E-03,-3.8800E-03,-3.7900E-03,
     &  -3.7000E-03,-3.6100E-03,-3.5200E-03,-3.4300E-03,-3.3400E-03,
     &  -3.2500E-03,-3.1600E-03,-3.0700E-03,-2.9800E-03,-2.8900E-03,
     &  -2.8000E-03,-2.7100E-03,-2.6200E-03,-2.5300E-03,-2.4400E-03,
     &  -2.3500E-03,-2.2600E-03,-2.1700E-03,-2.0800E-03,-1.9900E-03,
     &  -1.9000E-03,-1.8100E-03,-1.7200E-03,-1.6300E-03,-1.5400E-03,
     &  -1.4500E-03,-1.3600E-03,-1.2700E-03,-1.1800E-03,-1.0900E-03,
     &  -1.0000E-03,-9.9100E-04,-9.8200E-04,-9.7300E-04,-9.6400E-04,
     &  -9.5500E-04,-9.4600E-04,-9.3700E-04,-9.2800E-04,-9.1900E-04,
     &  -9.1000E-04,-9.0100E-04,-8.9200E-04,-8.8300E-04,-8.7400E-04,
     &  -8.6500E-04,-8.5600E-04,-8.4700E-04,-8.3800E-04,-8.2900E-04/
  
       DATA  (ETA  (I), I= 601, 700) /
     &  -8.2000E-04,-8.1100E-04,-8.0200E-04,-7.9300E-04,-7.8400E-04,
     &  -7.7500E-04,-7.6600E-04,-7.5700E-04,-7.4800E-04,-7.3900E-04,
     &  -7.3000E-04,-7.2100E-04,-7.1200E-04,-7.0300E-04,-6.9400E-04,
     &  -6.8500E-04,-6.7600E-04,-6.6700E-04,-6.5800E-04,-6.4900E-04,
     &  -6.4000E-04,-6.3100E-04,-6.2200E-04,-6.1300E-04,-6.0400E-04,
     &  -5.9500E-04,-5.8600E-04,-5.7700E-04,-5.6800E-04,-5.5900E-04,
     &  -5.5000E-04,-5.4100E-04,-5.3200E-04,-5.2300E-04,-5.1400E-04,
     &  -5.0500E-04,-4.9600E-04,-4.8700E-04,-4.7800E-04,-4.6900E-04,
     &  -4.6000E-04,-4.5100E-04,-4.4200E-04,-4.3300E-04,-4.2400E-04,
     &  -4.1500E-04,-4.0600E-04,-3.9700E-04,-3.8800E-04,-3.7900E-04,
     &  -3.7000E-04,-3.6100E-04,-3.5200E-04,-3.4300E-04,-3.3400E-04,
     &  -3.2500E-04,-3.1600E-04,-3.0700E-04,-2.9800E-04,-2.8900E-04,
     &  -2.8000E-04,-2.7100E-04,-2.6200E-04,-2.5300E-04,-2.4400E-04,
     &  -2.3500E-04,-2.2600E-04,-2.1700E-04,-2.0800E-04,-1.9900E-04,
     &  -1.9000E-04,-1.8100E-04,-1.7200E-04,-1.6300E-04,-1.5400E-04,
     &  -1.4500E-04,-1.3600E-04,-1.2700E-04,-1.1800E-04,-1.0900E-04,
     &  -1.0000E-04,-9.9100E-05,-9.8200E-05,-9.7300E-05,-9.6400E-05,
     &  -9.5500E-05,-9.4600E-05,-9.3700E-05,-9.2800E-05,-9.1900E-05,
     &  -9.1000E-05,-9.0100E-05,-8.9200E-05,-8.8300E-05,-8.7400E-05,
     &  -8.6500E-05,-8.5600E-05,-8.4700E-05,-8.3800E-05,-8.2900E-05/
  
       DATA  (ETA  (I), I= 701, 800) /
     &  -8.2000E-05,-8.1100E-05,-8.0200E-05,-7.9300E-05,-7.8400E-05,
     &  -7.7500E-05,-7.6600E-05,-7.5700E-05,-7.4800E-05,-7.3900E-05,
     &  -7.3000E-05,-7.2100E-05,-7.1200E-05,-7.0300E-05,-6.9400E-05,
     &  -6.8500E-05,-6.7600E-05,-6.6700E-05,-6.5800E-05,-6.4900E-05,
     &  -6.4000E-05,-6.3100E-05,-6.2200E-05,-6.1300E-05,-6.0400E-05,
     &  -5.9500E-05,-5.8600E-05,-5.7700E-05,-5.6800E-05,-5.5900E-05,
     &  -5.5000E-05,-5.4100E-05,-5.3200E-05,-5.2300E-05,-5.1400E-05,
     &  -5.0500E-05,-4.9600E-05,-4.8700E-05,-4.7800E-05,-4.6900E-05,
     &  -4.6000E-05,-4.5100E-05,-4.4200E-05,-4.3300E-05,-4.2400E-05,
     &  -4.1500E-05,-4.0600E-05,-3.9700E-05,-3.8800E-05,-3.7900E-05,
     &  -3.7000E-05,-3.6100E-05,-3.5200E-05,-3.4300E-05,-3.3400E-05,
     &  -3.2500E-05,-3.1600E-05,-3.0700E-05,-2.9800E-05,-2.8900E-05,
     &  -2.8000E-05,-2.7100E-05,-2.6200E-05,-2.5300E-05,-2.4400E-05,
     &  -2.3500E-05,-2.2600E-05,-2.1700E-05,-2.0800E-05,-1.9900E-05,
     &  -1.9000E-05,-1.8100E-05,-1.7200E-05,-1.6300E-05,-1.5400E-05,
     &  -1.4500E-05,-1.3600E-05,-1.2700E-05,-1.1800E-05,-1.0900E-05,
     &  -1.0000E-05,-9.9100E-06,-9.8200E-06,-9.7300E-06,-9.6400E-06,
     &  -9.5500E-06,-9.4600E-06,-9.3700E-06,-9.2800E-06,-9.1900E-06,
     &  -9.1000E-06,-9.0100E-06,-8.9200E-06,-8.8300E-06,-8.7400E-06,
     &  -8.6500E-06,-8.5600E-06,-8.4700E-06,-8.3800E-06,-8.2900E-06/
  
       DATA  (ETA  (I), I= 801, 900) /
     &  -8.2000E-06,-8.1100E-06,-8.0200E-06,-7.9300E-06,-7.8400E-06,
     &  -7.7500E-06,-7.6600E-06,-7.5700E-06,-7.4800E-06,-7.3900E-06,
     &  -7.3000E-06,-7.2100E-06,-7.1200E-06,-7.0300E-06,-6.9400E-06,
     &  -6.8500E-06,-6.7600E-06,-6.6700E-06,-6.5800E-06,-6.4900E-06,
     &  -6.4000E-06,-6.3100E-06,-6.2200E-06,-6.1300E-06,-6.0400E-06,
     &  -5.9500E-06,-5.8600E-06,-5.7700E-06,-5.6800E-06,-5.5900E-06,
     &  -5.5000E-06,-5.4100E-06,-5.3200E-06,-5.2300E-06,-5.1400E-06,
     &  -5.0500E-06,-4.9600E-06,-4.8700E-06,-4.7800E-06,-4.6900E-06,
     &  -4.6000E-06,-4.5100E-06,-4.4200E-06,-4.3300E-06,-4.2400E-06,
     &  -4.1500E-06,-4.0600E-06,-3.9700E-06,-3.8800E-06,-3.7900E-06,
     &  -3.7000E-06,-3.6100E-06,-3.5200E-06,-3.4300E-06,-3.3400E-06,
     &  -3.2500E-06,-3.1600E-06,-3.0700E-06,-2.9800E-06,-2.8900E-06,
     &  -2.8000E-06,-2.7100E-06,-2.6200E-06,-2.5300E-06,-2.4400E-06,
     &  -2.3500E-06,-2.2600E-06,-2.1700E-06,-2.0800E-06,-1.9900E-06,
     &  -1.9000E-06,-1.8100E-06,-1.7200E-06,-1.6300E-06,-1.5400E-06,
     &  -1.4500E-06,-1.3600E-06,-1.2700E-06,-1.1800E-06,-1.0900E-06,
     &  -1.0000E-06, 0.0000E+00, 1.0000E-06, 3.0010E-03, 6.0010E-03,
     &   9.0010E-03, 1.2000E-02, 1.5000E-02, 1.8000E-02, 2.1000E-02,
     &   2.4000E-02, 2.7000E-02, 3.0000E-02, 3.3000E-02, 3.6000E-02,
     &   3.9000E-02, 4.2000E-02, 4.5000E-02, 4.8000E-02, 5.1000E-02/
  
       DATA  (ETA  (I), I= 901, 979) /
     &   5.4000E-02, 5.7000E-02, 6.0000E-02, 6.3000E-02, 6.6000E-02,
     &   6.9000E-02, 7.2000E-02, 7.5000E-02, 7.8000E-02, 8.1000E-02,
     &   8.4000E-02, 8.7000E-02, 9.0000E-02, 9.3000E-02, 9.6000E-02,
     &   9.9000E-02, 1.0200E-01, 1.0500E-01, 1.0800E-01, 1.1100E-01,
     &   1.1400E-01, 1.1700E-01, 1.2000E-01, 1.2300E-01, 1.2600E-01,
     &   1.2900E-01, 1.3200E-01, 1.3500E-01, 1.3800E-01, 1.4100E-01,
     &   1.4400E-01, 1.4700E-01, 1.5000E-01, 1.5300E-01, 1.5600E-01,
     &   1.5900E-01, 1.6200E-01, 1.6500E-01, 1.6800E-01, 1.7100E-01,
     &   1.7400E-01, 1.7700E-01, 1.8000E-01, 1.8300E-01, 1.8600E-01,
     &   1.8900E-01, 1.9200E-01, 1.9500E-01, 1.9800E-01, 2.0100E-01,
     &   2.0400E-01, 2.0700E-01, 2.1000E-01, 2.1300E-01, 2.1600E-01,
     &   2.1900E-01, 2.2200E-01, 2.2500E-01, 2.2800E-01, 2.3100E-01,
     &   2.3400E-01, 2.3700E-01, 2.4000E-01, 2.4300E-01, 2.4600E-01,
     &   2.4900E-01, 2.5200E-01, 2.5500E-01, 2.5800E-01, 2.6100E-01,
     &   2.6400E-01, 2.6700E-01, 2.7000E-01, 2.7100E-01, 2.7300E-01,
     &   0.27370000D0, 0.27599999D0, 0.27630001D0, 0.27700001D0/
  
         DATA ((DAT  (I,J), I=   1, 100), J=1,1) /
     &   4.1041E-02, 4.0990E-02, 4.0938E-02, 4.0885E-02, 4.0832E-02,
     &   4.0778E-02, 4.0724E-02, 4.0668E-02, 4.0613E-02, 4.0556E-02,
     &   4.0499E-02, 4.0441E-02, 4.0383E-02, 4.0323E-02, 4.0263E-02,
     &   4.0202E-02, 4.0141E-02, 4.0078E-02, 4.0015E-02, 3.9951E-02,
     &   3.9885E-02, 3.9819E-02, 3.9752E-02, 3.9685E-02, 3.9616E-02,
     &   3.9546E-02, 3.9475E-02, 3.9403E-02, 3.9329E-02, 3.9255E-02,
     &   3.9180E-02, 3.9103E-02, 3.9025E-02, 3.8946E-02, 3.8865E-02,
     &   3.8783E-02, 3.8700E-02, 3.8615E-02, 3.8528E-02, 3.8441E-02,
     &   3.8351E-02, 3.8260E-02, 3.8167E-02, 3.8072E-02, 3.7976E-02,
     &   3.7877E-02, 3.7777E-02, 3.7674E-02, 3.7569E-02, 3.7462E-02,
     &   3.7353E-02, 3.7241E-02, 3.7127E-02, 3.7010E-02, 3.6891E-02,
     &   3.6768E-02, 3.6643E-02, 3.6514E-02, 3.6382E-02, 3.6247E-02,
     &   3.6108E-02, 3.5966E-02, 3.5819E-02, 3.5668E-02, 3.5513E-02,
     &   3.5353E-02, 3.5188E-02, 3.5018E-02, 3.4843E-02, 3.4661E-02,
     &   3.4474E-02, 3.4279E-02, 3.4078E-02, 3.3869E-02, 3.3651E-02,
     &   3.3425E-02, 3.3189E-02, 3.2943E-02, 3.2686E-02, 3.2416E-02,
     &   3.2132E-02, 3.1834E-02, 3.1519E-02, 3.1185E-02, 3.0831E-02,
     &   3.0454E-02, 3.0050E-02, 2.9616E-02, 2.9146E-02, 2.8635E-02,
     &   2.8075E-02, 2.8015E-02, 2.7956E-02, 2.7895E-02, 2.7834E-02,
     &   2.7773E-02, 2.7710E-02, 2.7647E-02, 2.7584E-02, 2.7519E-02/
  
         DATA ((DAT  (I,J), I= 101, 200), J=1,1) /
     &   2.7454E-02, 2.7389E-02, 2.7322E-02, 2.7255E-02, 2.7187E-02,
     &   2.7118E-02, 2.7048E-02, 2.6977E-02, 2.6906E-02, 2.6834E-02,
     &   2.6760E-02, 2.6686E-02, 2.6611E-02, 2.6535E-02, 2.6458E-02,
     &   2.6380E-02, 2.6300E-02, 2.6220E-02, 2.6139E-02, 2.6056E-02,
     &   2.5973E-02, 2.5888E-02, 2.5801E-02, 2.5714E-02, 2.5625E-02,
     &   2.5535E-02, 2.5444E-02, 2.5351E-02, 2.5256E-02, 2.5160E-02,
     &   2.5062E-02, 2.4963E-02, 2.4862E-02, 2.4759E-02, 2.4655E-02,
     &   2.4548E-02, 2.4440E-02, 2.4329E-02, 2.4217E-02, 2.4102E-02,
     &   2.3985E-02, 2.3865E-02, 2.3743E-02, 2.3619E-02, 2.3492E-02,
     &   2.3362E-02, 2.3229E-02, 2.3093E-02, 2.2954E-02, 2.2811E-02,
     &   2.2665E-02, 2.2515E-02, 2.2362E-02, 2.2204E-02, 2.2042E-02,
     &   2.1875E-02, 2.1704E-02, 2.1527E-02, 2.1345E-02, 2.1157E-02,
     &   2.0963E-02, 2.0763E-02, 2.0556E-02, 2.0341E-02, 2.0118E-02,
     &   1.9886E-02, 1.9645E-02, 1.9394E-02, 1.9132E-02, 1.8858E-02,
     &   1.8571E-02, 1.8269E-02, 1.7952E-02, 1.7617E-02, 1.7262E-02,
     &   1.6885E-02, 1.6483E-02, 1.6053E-02, 1.5590E-02, 1.5089E-02,
     &   1.4544E-02, 1.4492E-02, 1.4440E-02, 1.4388E-02, 1.4335E-02,
     &   1.4282E-02, 1.4228E-02, 1.4173E-02, 1.4119E-02, 1.4063E-02,
     &   1.4008E-02, 1.3951E-02, 1.3895E-02, 1.3837E-02, 1.3780E-02,
     &   1.3721E-02, 1.3662E-02, 1.3603E-02, 1.3543E-02, 1.3482E-02/
  
         DATA ((DAT  (I,J), I= 201, 300), J=1,1) /
     &   1.3421E-02, 1.3359E-02, 1.3296E-02, 1.3233E-02, 1.3169E-02,
     &   1.3105E-02, 1.3040E-02, 1.2974E-02, 1.2907E-02, 1.2840E-02,
     &   1.2772E-02, 1.2703E-02, 1.2634E-02, 1.2563E-02, 1.2492E-02,
     &   1.2420E-02, 1.2347E-02, 1.2274E-02, 1.2199E-02, 1.2124E-02,
     &   1.2047E-02, 1.1970E-02, 1.1892E-02, 1.1813E-02, 1.1732E-02,
     &   1.1651E-02, 1.1569E-02, 1.1485E-02, 1.1401E-02, 1.1315E-02,
     &   1.1228E-02, 1.1140E-02, 1.1050E-02, 1.0959E-02, 1.0867E-02,
     &   1.0774E-02, 1.0679E-02, 1.0583E-02, 1.0485E-02, 1.0386E-02,
     &   1.0285E-02, 1.0183E-02, 1.0078E-02, 9.9724E-03, 9.8647E-03,
     &   9.7552E-03, 9.6437E-03, 9.5302E-03, 9.4146E-03, 9.2969E-03,
     &   9.1771E-03, 9.0549E-03, 8.9303E-03, 8.8032E-03, 8.6735E-03,
     &   8.5412E-03, 8.4060E-03, 8.2679E-03, 8.1267E-03, 7.9822E-03,
     &   7.8344E-03, 7.6830E-03, 7.5278E-03, 7.3687E-03, 7.2053E-03,
     &   7.0374E-03, 6.8647E-03, 6.6869E-03, 6.5036E-03, 6.3143E-03,
     &   6.1187E-03, 5.9160E-03, 5.7057E-03, 5.4870E-03, 5.2592E-03,
     &   5.0211E-03, 4.7717E-03, 4.5097E-03, 4.2337E-03, 3.9423E-03,
     &   3.6337E-03, 3.6018E-03, 3.5698E-03, 3.5376E-03, 3.5051E-03,
     &   3.4725E-03, 3.4397E-03, 3.4067E-03, 3.3735E-03, 3.3401E-03,
     &   3.3065E-03, 3.2727E-03, 3.2388E-03, 3.2046E-03, 3.1702E-03,
     &   3.1356E-03, 3.1008E-03, 3.0658E-03, 3.0306E-03, 2.9952E-03/
  
         DATA ((DAT  (I,J), I= 301, 400), J=1,1) /
     &   2.9596E-03, 2.9238E-03, 2.8878E-03, 2.8516E-03, 2.8152E-03,
     &   2.7786E-03, 2.7417E-03, 2.7047E-03, 2.6676E-03, 2.6301E-03,
     &   2.5925E-03, 2.5547E-03, 2.5168E-03, 2.4786E-03, 2.4402E-03,
     &   2.4017E-03, 2.3630E-03, 2.3241E-03, 2.2850E-03, 2.2458E-03,
     &   2.2064E-03, 2.1668E-03, 2.1271E-03, 2.0873E-03, 2.0473E-03,
     &   2.0072E-03, 1.9669E-03, 1.9266E-03, 1.8861E-03, 1.8456E-03,
     &   1.8049E-03, 1.7642E-03, 1.7234E-03, 1.6825E-03, 1.6416E-03,
     &   1.6007E-03, 1.5598E-03, 1.5188E-03, 1.4779E-03, 1.4370E-03,
     &   1.3961E-03, 1.3553E-03, 1.3145E-03, 1.2739E-03, 1.2334E-03,
     &   1.1930E-03, 1.1528E-03, 1.1128E-03, 1.0730E-03, 1.0334E-03,
     &   9.9403E-04, 9.5497E-04, 9.1622E-04, 8.7781E-04, 8.3977E-04,
     &   8.0211E-04, 7.6489E-04, 7.2812E-04, 6.9184E-04, 6.5608E-04,
     &   6.2087E-04, 5.8625E-04, 5.5226E-04, 5.1893E-04, 4.8630E-04,
     &   4.5440E-04, 4.2327E-04, 3.9295E-04, 3.6348E-04, 3.3489E-04,
     &   3.0722E-04, 2.8052E-04, 2.5481E-04, 2.3014E-04, 2.0654E-04,
     &   1.8405E-04, 1.6270E-04, 1.4254E-04, 1.2359E-04, 1.0588E-04,
     &   8.9458E-05, 8.7886E-05, 8.6328E-05, 8.4783E-05, 8.3251E-05,
     &   8.1732E-05, 8.0227E-05, 7.8735E-05, 7.7256E-05, 7.5790E-05,
     &   7.4338E-05, 7.2899E-05, 7.1473E-05, 7.0061E-05, 6.8662E-05,
     &   6.7276E-05, 6.5904E-05, 6.4546E-05, 6.3201E-05, 6.1870E-05/
  
         DATA ((DAT  (I,J), I= 401, 500), J=1,1) /
     &   6.0552E-05, 5.9248E-05, 5.7957E-05, 5.6681E-05, 5.5417E-05,
     &   5.4168E-05, 5.2932E-05, 5.1710E-05, 5.0502E-05, 4.9308E-05,
     &   4.8127E-05, 4.6960E-05, 4.5807E-05, 4.4668E-05, 4.3543E-05,
     &   4.2432E-05, 4.1335E-05, 4.0251E-05, 3.9182E-05, 3.8127E-05,
     &   3.7086E-05, 3.6058E-05, 3.5045E-05, 3.4046E-05, 3.3061E-05,
     &   3.2091E-05, 3.1134E-05, 3.0192E-05, 2.9263E-05, 2.8349E-05,
     &   2.7450E-05, 2.6564E-05, 2.5693E-05, 2.4836E-05, 2.3993E-05,
     &   2.3164E-05, 2.2350E-05, 2.1550E-05, 2.0765E-05, 1.9994E-05,
     &   1.9237E-05, 1.8495E-05, 1.7767E-05, 1.7054E-05, 1.6355E-05,
     &   1.5671E-05, 1.5001E-05, 1.4345E-05, 1.3704E-05, 1.3078E-05,
     &   1.2466E-05, 1.1868E-05, 1.1285E-05, 1.0717E-05, 1.0163E-05,
     &   9.6241E-06, 9.0995E-06, 8.5896E-06, 8.0943E-06, 7.6136E-06,
     &   7.1475E-06, 6.6961E-06, 6.2594E-06, 5.8373E-06, 5.4299E-06,
     &   5.0372E-06, 4.6591E-06, 4.2958E-06, 3.9472E-06, 3.6133E-06,
     &   3.2941E-06, 2.9896E-06, 2.6999E-06, 2.4249E-06, 2.1646E-06,
     &   1.9191E-06, 1.6884E-06, 1.4724E-06, 1.2711E-06, 1.0847E-06,
     &   9.1299E-07, 8.9663E-07, 8.8042E-07, 8.6436E-07, 8.4845E-07,
     &   8.3268E-07, 8.1707E-07, 8.0160E-07, 7.8627E-07, 7.7110E-07,
     &   7.5607E-07, 7.4119E-07, 7.2646E-07, 7.1188E-07, 6.9744E-07,
     &   6.8316E-07, 6.6902E-07, 6.5502E-07, 6.4118E-07, 6.2748E-07/
  
         DATA ((DAT  (I,J), I= 501, 600), J=1,1) /
     &   6.1394E-07, 6.0053E-07, 5.8728E-07, 5.7418E-07, 5.6122E-07,
     &   5.4841E-07, 5.3575E-07, 5.2323E-07, 5.1087E-07, 4.9865E-07,
     &   4.8658E-07, 4.7466E-07, 4.6288E-07, 4.5125E-07, 4.3978E-07,
     &   4.2844E-07, 4.1726E-07, 4.0623E-07, 3.9534E-07, 3.8460E-07,
     &   3.7401E-07, 3.6356E-07, 3.5327E-07, 3.4312E-07, 3.3312E-07,
     &   3.2326E-07, 3.1356E-07, 3.0400E-07, 2.9459E-07, 2.8533E-07,
     &   2.7622E-07, 2.6725E-07, 2.5844E-07, 2.4977E-07, 2.4125E-07,
     &   2.3287E-07, 2.2465E-07, 2.1657E-07, 2.0864E-07, 2.0085E-07,
     &   1.9322E-07, 1.8573E-07, 1.7840E-07, 1.7120E-07, 1.6416E-07,
     &   1.5727E-07, 1.5052E-07, 1.4392E-07, 1.3747E-07, 1.3117E-07,
     &   1.2501E-07, 1.1900E-07, 1.1314E-07, 1.0743E-07, 1.0187E-07,
     &   9.6452E-08, 9.1185E-08, 8.6065E-08, 8.1093E-08, 7.6268E-08,
     &   7.1592E-08, 6.7064E-08, 6.2683E-08, 5.8451E-08, 5.4366E-08,
     &   5.0430E-08, 4.6641E-08, 4.3000E-08, 3.9507E-08, 3.6163E-08,
     &   3.2966E-08, 2.9916E-08, 2.7015E-08, 2.4262E-08, 2.1657E-08,
     &   1.9200E-08, 1.6890E-08, 1.4729E-08, 1.2715E-08, 1.0849E-08,
     &   9.1318E-09, 8.9681E-09, 8.8060E-09, 8.6453E-09, 8.4861E-09,
     &   8.3284E-09, 8.1722E-09, 8.0174E-09, 7.8641E-09, 7.7123E-09,
     &   7.5620E-09, 7.4132E-09, 7.2658E-09, 7.1199E-09, 6.9755E-09,
     &   6.8326E-09, 6.6912E-09, 6.5512E-09, 6.4127E-09, 6.2757E-09/
  
         DATA ((DAT  (I,J), I= 601, 700), J=1,1) /
     &   6.1402E-09, 6.0062E-09, 5.8736E-09, 5.7425E-09, 5.6129E-09,
     &   5.4848E-09, 5.3581E-09, 5.2330E-09, 5.1093E-09, 4.9871E-09,
     &   4.8663E-09, 4.7471E-09, 4.6293E-09, 4.5130E-09, 4.3982E-09,
     &   4.2849E-09, 4.1730E-09, 4.0626E-09, 3.9537E-09, 3.8463E-09,
     &   3.7404E-09, 3.6359E-09, 3.5329E-09, 3.4314E-09, 3.3314E-09,
     &   3.2329E-09, 3.1358E-09, 3.0402E-09, 2.9461E-09, 2.8535E-09,
     &   2.7624E-09, 2.6727E-09, 2.5845E-09, 2.4978E-09, 2.4126E-09,
     &   2.3288E-09, 2.2466E-09, 2.1658E-09, 2.0865E-09, 2.0086E-09,
     &   1.9323E-09, 1.8574E-09, 1.7840E-09, 1.7121E-09, 1.6417E-09,
     &   1.5727E-09, 1.5052E-09, 1.4393E-09, 1.3747E-09, 1.3117E-09,
     &   1.2501E-09, 1.1901E-09, 1.1315E-09, 1.0743E-09, 1.0187E-09,
     &   9.6455E-10, 9.1186E-10, 8.6066E-10, 8.1094E-10, 7.6270E-10,
     &   7.1593E-10, 6.7065E-10, 6.2684E-10, 5.8452E-10, 5.4367E-10,
     &   5.0430E-10, 4.6642E-10, 4.3001E-10, 3.9508E-10, 3.6163E-10,
     &   3.2966E-10, 2.9917E-10, 2.7016E-10, 2.4262E-10, 2.1657E-10,
     &   1.9200E-10, 1.6890E-10, 1.4729E-10, 1.2715E-10, 1.0849E-10,
     &   9.1318E-11, 8.9682E-11, 8.8060E-11, 8.6453E-11, 8.4861E-11,
     &   8.3284E-11, 8.1722E-11, 8.0174E-11, 7.8642E-11, 7.7124E-11,
     &   7.5620E-11, 7.4132E-11, 7.2658E-11, 7.1200E-11, 6.9756E-11,
     &   6.8326E-11, 6.6912E-11, 6.5512E-11, 6.4127E-11, 6.2757E-11/
  
         DATA ((DAT  (I,J), I= 701, 800), J=1,1) /
     &   6.1402E-11, 6.0062E-11, 5.8736E-11, 5.7425E-11, 5.6129E-11,
     &   5.4848E-11, 5.3581E-11, 5.2330E-11, 5.1093E-11, 4.9871E-11,
     &   4.8663E-11, 4.7471E-11, 4.6293E-11, 4.5130E-11, 4.3982E-11,
     &   4.2849E-11, 4.1730E-11, 4.0626E-11, 3.9537E-11, 3.8463E-11,
     &   3.7404E-11, 3.6359E-11, 3.5329E-11, 3.4314E-11, 3.3314E-11,
     &   3.2329E-11, 3.1358E-11, 3.0402E-11, 2.9461E-11, 2.8535E-11,
     &   2.7624E-11, 2.6727E-11, 2.5845E-11, 2.4978E-11, 2.4126E-11,
     &   2.3288E-11, 2.2466E-11, 2.1658E-11, 2.0865E-11, 2.0086E-11,
     &   1.9323E-11, 1.8574E-11, 1.7840E-11, 1.7121E-11, 1.6417E-11,
     &   1.5727E-11, 1.5052E-11, 1.4393E-11, 1.3747E-11, 1.3117E-11,
     &   1.2501E-11, 1.1901E-11, 1.1315E-11, 1.0743E-11, 1.0187E-11,
     &   9.6455E-12, 9.1186E-12, 8.6066E-12, 8.1094E-12, 7.6270E-12,
     &   7.1593E-12, 6.7065E-12, 6.2684E-12, 5.8452E-12, 5.4367E-12,
     &   5.0430E-12, 4.6642E-12, 4.3001E-12, 3.9508E-12, 3.6163E-12,
     &   3.2966E-12, 2.9917E-12, 2.7016E-12, 2.4262E-12, 2.1657E-12,
     &   1.9200E-12, 1.6890E-12, 1.4729E-12, 1.2715E-12, 1.0849E-12,
     &   9.1318E-13, 8.9682E-13, 8.8060E-13, 8.6453E-13, 8.4861E-13,
     &   8.3284E-13, 8.1722E-13, 8.0174E-13, 7.8642E-13, 7.7124E-13,
     &   7.5620E-13, 7.4132E-13, 7.2658E-13, 7.1200E-13, 6.9756E-13,
     &   6.8326E-13, 6.6912E-13, 6.5512E-13, 6.4127E-13, 6.2757E-13/
  
         DATA ((DAT  (I,J), I= 801, 900), J=1,1) /
     &   6.1402E-13, 6.0062E-13, 5.8736E-13, 5.7425E-13, 5.6129E-13,
     &   5.4848E-13, 5.3581E-13, 5.2330E-13, 5.1093E-13, 4.9871E-13,
     &   4.8663E-13, 4.7471E-13, 4.6293E-13, 4.5130E-13, 4.3982E-13,
     &   4.2849E-13, 4.1730E-13, 4.0626E-13, 3.9537E-13, 3.8463E-13,
     &   3.7404E-13, 3.6359E-13, 3.5329E-13, 3.4314E-13, 3.3314E-13,
     &   3.2329E-13, 3.1358E-13, 3.0402E-13, 2.9461E-13, 2.8535E-13,
     &   2.7624E-13, 2.6727E-13, 2.5845E-13, 2.4978E-13, 2.4126E-13,
     &   2.3288E-13, 2.2466E-13, 2.1658E-13, 2.0865E-13, 2.0086E-13,
     &   1.9323E-13, 1.8574E-13, 1.7840E-13, 1.7121E-13, 1.6417E-13,
     &   1.5727E-13, 1.5052E-13, 1.4393E-13, 1.3747E-13, 1.3117E-13,
     &   1.2501E-13, 1.1901E-13, 1.1315E-13, 1.0743E-13, 1.0187E-13,
     &   9.6455E-14, 9.1186E-14, 8.6066E-14, 8.1094E-14, 7.6270E-14,
     &   7.1593E-14, 6.7065E-14, 6.2684E-14, 5.8452E-14, 5.4367E-14,
     &   5.0430E-14, 4.6642E-14, 4.3001E-14, 3.9508E-14, 3.6163E-14,
     &   3.2966E-14, 2.9917E-14, 2.7016E-14, 2.4262E-14, 2.1657E-14,
     &   1.9200E-14, 1.6890E-14, 1.4729E-14, 1.2715E-14, 1.0849E-14,
     &   9.1318E-15, 0.0000E+00,-9.1318E-15,-8.2243E-08,-3.2888E-07,
     &  -7.3997E-07,-1.3154E-06,-2.0556E-06,-2.9607E-06,-4.0309E-06,
     &  -5.2663E-06,-6.6673E-06,-8.2342E-06,-9.9674E-06,-1.1867E-05,
     &  -1.3934E-05,-1.6169E-05,-1.8571E-05,-2.1143E-05,-2.3883E-05/
  
         DATA ((DAT  (I,J), I= 901, 979), J=1,1) /
     &  -2.6793E-05,-2.9874E-05,-3.3127E-05,-3.6551E-05,-4.0149E-05,
     &  -4.3920E-05,-4.7865E-05,-5.1987E-05,-5.6285E-05,-6.0761E-05,
     &  -6.5415E-05,-7.0250E-05,-7.5266E-05,-8.0464E-05,-8.5846E-05,
     &  -9.1413E-05,-9.7167E-05,-1.0311E-04,-1.0924E-04,-1.1556E-04,
     &  -1.2208E-04,-1.2879E-04,-1.3570E-04,-1.4280E-04,-1.5011E-04,
     &  -1.5762E-04,-1.6533E-04,-1.7326E-04,-1.8139E-04,-1.8973E-04,
     &  -1.9829E-04,-2.0706E-04,-2.1605E-04,-2.2527E-04,-2.3471E-04,
     &  -2.4438E-04,-2.5429E-04,-2.6443E-04,-2.7480E-04,-2.8543E-04,
     &  -2.9629E-04,-3.0741E-04,-3.1879E-04,-3.3042E-04,-3.4232E-04,
     &  -3.5448E-04,-3.6692E-04,-3.7965E-04,-3.9265E-04,-4.0595E-04,
     &  -4.1955E-04,-4.3346E-04,-4.4767E-04,-4.6221E-04,-4.7708E-04,
     &  -4.9229E-04,-5.0784E-04,-5.2376E-04,-5.4004E-04,-5.5671E-04,
     &  -5.7377E-04,-5.9125E-04,-6.0916E-04,-6.2752E-04,-6.4634E-04,
     &  -6.6566E-04,-6.8551E-04,-7.0592E-04,-7.2693E-04,-7.4860E-04,
     &  -7.7099E-04,-7.9419E-04,-8.1836E-04,-8.2665E-04,-8.4367E-04,
     &  -8.49788155E-04,-8.70598250E-04,-8.73413678E-04,-8.80102394E-04/
  
         DATA ((DAT  (I,J), I=   1, 100), J=2,2) /
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04, 1.2065E-04,
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04,
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2064E-04,
     &   1.2064E-04, 1.2064E-04, 1.2064E-04, 1.2063E-04, 1.2063E-04,
     &   1.2063E-04, 1.2063E-04, 1.2063E-04, 1.2063E-04, 1.2063E-04,
     &   1.2063E-04, 1.2063E-04, 1.2062E-04, 1.2062E-04, 1.2062E-04,
     &   1.2062E-04, 1.2062E-04, 1.2062E-04, 1.2062E-04, 1.2061E-04,
     &   1.2061E-04, 1.2061E-04, 1.2061E-04, 1.2061E-04, 1.2060E-04,
     &   1.2060E-04, 1.2060E-04, 1.2060E-04, 1.2059E-04, 1.2059E-04,
     &   1.2059E-04, 1.2058E-04, 1.2058E-04, 1.2058E-04, 1.2057E-04,
     &   1.2057E-04, 1.2056E-04, 1.2056E-04, 1.2055E-04, 1.2054E-04,
     &   1.2053E-04, 1.2052E-04, 1.2051E-04, 1.2049E-04, 1.2047E-04,
     &   1.2045E-04, 1.2044E-04, 1.2044E-04, 1.2044E-04, 1.2043E-04,
     &   1.2043E-04, 1.2043E-04, 1.2042E-04, 1.2042E-04, 1.2042E-04/
  
         DATA ((DAT  (I,J), I= 101, 200), J=2,2) /
     &   1.2041E-04, 1.2041E-04, 1.2041E-04, 1.2040E-04, 1.2040E-04,
     &   1.2039E-04, 1.2039E-04, 1.2038E-04, 1.2038E-04, 1.2037E-04,
     &   1.2037E-04, 1.2036E-04, 1.2036E-04, 1.2035E-04, 1.2035E-04,
     &   1.2034E-04, 1.2033E-04, 1.2033E-04, 1.2032E-04, 1.2031E-04,
     &   1.2031E-04, 1.2030E-04, 1.2029E-04, 1.2028E-04, 1.2027E-04,
     &   1.2027E-04, 1.2026E-04, 1.2025E-04, 1.2024E-04, 1.2023E-04,
     &   1.2021E-04, 1.2020E-04, 1.2019E-04, 1.2018E-04, 1.2016E-04,
     &   1.2015E-04, 1.2013E-04, 1.2012E-04, 1.2010E-04, 1.2008E-04,
     &   1.2007E-04, 1.2005E-04, 1.2003E-04, 1.2000E-04, 1.1998E-04,
     &   1.1996E-04, 1.1993E-04, 1.1990E-04, 1.1987E-04, 1.1984E-04,
     &   1.1980E-04, 1.1977E-04, 1.1973E-04, 1.1968E-04, 1.1964E-04,
     &   1.1959E-04, 1.1953E-04, 1.1947E-04, 1.1941E-04, 1.1934E-04,
     &   1.1926E-04, 1.1918E-04, 1.1909E-04, 1.1899E-04, 1.1888E-04,
     &   1.1875E-04, 1.1861E-04, 1.1846E-04, 1.1828E-04, 1.1809E-04,
     &   1.1786E-04, 1.1761E-04, 1.1732E-04, 1.1698E-04, 1.1659E-04,
     &   1.1613E-04, 1.1558E-04, 1.1493E-04, 1.1414E-04, 1.1317E-04,
     &   1.1195E-04, 1.1183E-04, 1.1170E-04, 1.1157E-04, 1.1144E-04,
     &   1.1131E-04, 1.1117E-04, 1.1103E-04, 1.1088E-04, 1.1074E-04,
     &   1.1059E-04, 1.1043E-04, 1.1027E-04, 1.1011E-04, 1.0995E-04,
     &   1.0978E-04, 1.0960E-04, 1.0942E-04, 1.0924E-04, 1.0905E-04/
  
         DATA ((DAT  (I,J), I= 201, 300), J=2,2) /
     &   1.0886E-04, 1.0867E-04, 1.0846E-04, 1.0826E-04, 1.0804E-04,
     &   1.0783E-04, 1.0760E-04, 1.0737E-04, 1.0714E-04, 1.0690E-04,
     &   1.0665E-04, 1.0639E-04, 1.0613E-04, 1.0586E-04, 1.0558E-04,
     &   1.0530E-04, 1.0500E-04, 1.0470E-04, 1.0439E-04, 1.0407E-04,
     &   1.0374E-04, 1.0340E-04, 1.0305E-04, 1.0269E-04, 1.0232E-04,
     &   1.0194E-04, 1.0154E-04, 1.0114E-04, 1.0072E-04, 1.0029E-04,
     &   9.9840E-05, 9.9379E-05, 9.8902E-05, 9.8411E-05, 9.7902E-05,
     &   9.7377E-05, 9.6834E-05, 9.6273E-05, 9.5692E-05, 9.5091E-05,
     &   9.4469E-05, 9.3825E-05, 9.3158E-05, 9.2467E-05, 9.1751E-05,
     &   9.1008E-05, 9.0238E-05, 8.9439E-05, 8.8610E-05, 8.7748E-05,
     &   8.6854E-05, 8.5924E-05, 8.4957E-05, 8.3952E-05, 8.2905E-05,
     &   8.1816E-05, 8.0680E-05, 7.9497E-05, 7.8262E-05, 7.6974E-05,
     &   7.5628E-05, 7.4222E-05, 7.2751E-05, 7.1212E-05, 6.9600E-05,
     &   6.7910E-05, 6.6139E-05, 6.4280E-05, 6.2329E-05, 6.0280E-05,
     &   5.8127E-05, 5.5865E-05, 5.3488E-05, 5.0993E-05, 4.8374E-05,
     &   4.5628E-05, 4.2755E-05, 3.9755E-05, 3.6631E-05, 3.3392E-05,
     &   3.0048E-05, 2.9709E-05, 2.9369E-05, 2.9028E-05, 2.8686E-05,
     &   2.8343E-05, 2.8000E-05, 2.7656E-05, 2.7311E-05, 2.6965E-05,
     &   2.6619E-05, 2.6273E-05, 2.5925E-05, 2.5577E-05, 2.5229E-05,
     &   2.4880E-05, 2.4531E-05, 2.4181E-05, 2.3831E-05, 2.3481E-05/
  
         DATA ((DAT  (I,J), I= 301, 400), J=2,2) /
     &   2.3130E-05, 2.2779E-05, 2.2428E-05, 2.2076E-05, 2.1725E-05,
     &   2.1373E-05, 2.1022E-05, 2.0670E-05, 2.0319E-05, 1.9967E-05,
     &   1.9616E-05, 1.9265E-05, 1.8914E-05, 1.8563E-05, 1.8213E-05,
     &   1.7864E-05, 1.7514E-05, 1.7166E-05, 1.6818E-05, 1.6470E-05,
     &   1.6124E-05, 1.5778E-05, 1.5433E-05, 1.5089E-05, 1.4747E-05,
     &   1.4405E-05, 1.4065E-05, 1.3725E-05, 1.3388E-05, 1.3051E-05,
     &   1.2717E-05, 1.2383E-05, 1.2052E-05, 1.1722E-05, 1.1395E-05,
     &   1.1069E-05, 1.0746E-05, 1.0424E-05, 1.0106E-05, 9.7891E-06,
     &   9.4752E-06, 9.1639E-06, 8.8555E-06, 8.5499E-06, 8.2474E-06,
     &   7.9480E-06, 7.6519E-06, 7.3592E-06, 7.0700E-06, 6.7845E-06,
     &   6.5028E-06, 6.2250E-06, 5.9513E-06, 5.6818E-06, 5.4167E-06,
     &   5.1561E-06, 4.9001E-06, 4.6489E-06, 4.4026E-06, 4.1614E-06,
     &   3.9255E-06, 3.6949E-06, 3.4699E-06, 3.2506E-06, 3.0371E-06,
     &   2.8297E-06, 2.6284E-06, 2.4334E-06, 2.2448E-06, 2.0629E-06,
     &   1.8877E-06, 1.7194E-06, 1.5582E-06, 1.4042E-06, 1.2575E-06,
     &   1.1183E-06, 9.8669E-07, 8.6282E-07, 7.4683E-07, 6.3882E-07,
     &   5.3891E-07, 5.2937E-07, 5.1991E-07, 5.1054E-07, 5.0124E-07,
     &   4.9203E-07, 4.8290E-07, 4.7386E-07, 4.6489E-07, 4.5601E-07,
     &   4.4722E-07, 4.3850E-07, 4.2987E-07, 4.2132E-07, 4.1286E-07,
     &   4.0448E-07, 3.9618E-07, 3.8797E-07, 3.7984E-07, 3.7179E-07/
  
         DATA ((DAT  (I,J), I= 401, 500), J=2,2) /
     &   3.6383E-07, 3.5595E-07, 3.4816E-07, 3.4045E-07, 3.3282E-07,
     &   3.2528E-07, 3.1783E-07, 3.1045E-07, 3.0317E-07, 2.9597E-07,
     &   2.8885E-07, 2.8182E-07, 2.7487E-07, 2.6801E-07, 2.6123E-07,
     &   2.5454E-07, 2.4793E-07, 2.4141E-07, 2.3497E-07, 2.2862E-07,
     &   2.2236E-07, 2.1618E-07, 2.1009E-07, 2.0408E-07, 1.9816E-07,
     &   1.9232E-07, 1.8657E-07, 1.8091E-07, 1.7533E-07, 1.6984E-07,
     &   1.6444E-07, 1.5912E-07, 1.5389E-07, 1.4875E-07, 1.4369E-07,
     &   1.3872E-07, 1.3383E-07, 1.2903E-07, 1.2432E-07, 1.1970E-07,
     &   1.1516E-07, 1.1071E-07, 1.0634E-07, 1.0207E-07, 9.7879E-08,
     &   9.3777E-08, 8.9762E-08, 8.5834E-08, 8.1994E-08, 7.8241E-08,
     &   7.4576E-08, 7.0998E-08, 6.7507E-08, 6.4105E-08, 6.0789E-08,
     &   5.7562E-08, 5.4422E-08, 5.1370E-08, 4.8405E-08, 4.5529E-08,
     &   4.2740E-08, 4.0039E-08, 3.7426E-08, 3.4901E-08, 3.2464E-08,
     &   3.0115E-08, 2.7854E-08, 2.5681E-08, 2.3596E-08, 2.1599E-08,
     &   1.9691E-08, 1.7870E-08, 1.6138E-08, 1.4494E-08, 1.2938E-08,
     &   1.1470E-08, 1.0091E-08, 8.7998E-09, 7.5970E-09, 6.4825E-09,
     &   5.4563E-09, 5.3586E-09, 5.2617E-09, 5.1657E-09, 5.0706E-09,
     &   4.9763E-09, 4.8830E-09, 4.7905E-09, 4.6990E-09, 4.6083E-09,
     &   4.5185E-09, 4.4295E-09, 4.3415E-09, 4.2543E-09, 4.1681E-09,
     &   4.0827E-09, 3.9982E-09, 3.9145E-09, 3.8318E-09, 3.7500E-09/
  
         DATA ((DAT  (I,J), I= 501, 600), J=2,2) /
     &   3.6690E-09, 3.5889E-09, 3.5097E-09, 3.4314E-09, 3.3539E-09,
     &   3.2774E-09, 3.2017E-09, 3.1269E-09, 3.0530E-09, 2.9800E-09,
     &   2.9078E-09, 2.8366E-09, 2.7662E-09, 2.6967E-09, 2.6281E-09,
     &   2.5604E-09, 2.4936E-09, 2.4276E-09, 2.3626E-09, 2.2984E-09,
     &   2.2351E-09, 2.1727E-09, 2.1111E-09, 2.0505E-09, 1.9907E-09,
     &   1.9318E-09, 1.8738E-09, 1.8167E-09, 1.7605E-09, 1.7051E-09,
     &   1.6507E-09, 1.5971E-09, 1.5444E-09, 1.4926E-09, 1.4417E-09,
     &   1.3916E-09, 1.3425E-09, 1.2942E-09, 1.2468E-09, 1.2003E-09,
     &   1.1547E-09, 1.1099E-09, 1.0661E-09, 1.0231E-09, 9.8102E-10,
     &   9.3981E-10, 8.9949E-10, 8.6006E-10, 8.2150E-10, 7.8384E-10,
     &   7.4705E-10, 7.1115E-10, 6.7613E-10, 6.4200E-10, 6.0875E-10,
     &   5.7639E-10, 5.4491E-10, 5.1431E-10, 4.8460E-10, 4.5577E-10,
     &   4.2783E-10, 4.0076E-10, 3.7459E-10, 3.4929E-10, 3.2489E-10,
     &   3.0136E-10, 2.7872E-10, 2.5696E-10, 2.3609E-10, 2.1610E-10,
     &   1.9700E-10, 1.7878E-10, 1.6144E-10, 1.4499E-10, 1.2942E-10,
     &   1.1473E-10, 1.0093E-10, 8.8016E-11, 7.5983E-11, 6.4835E-11,
     &   5.4570E-11, 5.3592E-11, 5.2623E-11, 5.1663E-11, 5.0712E-11,
     &   4.9769E-11, 4.8836E-11, 4.7911E-11, 4.6995E-11, 4.6088E-11,
     &   4.5189E-11, 4.4300E-11, 4.3419E-11, 4.2548E-11, 4.1685E-11,
     &   4.0831E-11, 3.9985E-11, 3.9149E-11, 3.8321E-11, 3.7503E-11/
  
         DATA ((DAT  (I,J), I= 601, 700), J=2,2) /
     &   3.6693E-11, 3.5892E-11, 3.5100E-11, 3.4316E-11, 3.3542E-11,
     &   3.2776E-11, 3.2019E-11, 3.1271E-11, 3.0532E-11, 2.9802E-11,
     &   2.9080E-11, 2.8368E-11, 2.7664E-11, 2.6969E-11, 2.6283E-11,
     &   2.5606E-11, 2.4937E-11, 2.4278E-11, 2.3627E-11, 2.2985E-11,
     &   2.2352E-11, 2.1728E-11, 2.1112E-11, 2.0506E-11, 1.9908E-11,
     &   1.9319E-11, 1.8739E-11, 1.8168E-11, 1.7606E-11, 1.7052E-11,
     &   1.6507E-11, 1.5972E-11, 1.5445E-11, 1.4927E-11, 1.4417E-11,
     &   1.3917E-11, 1.3425E-11, 1.2942E-11, 1.2468E-11, 1.2003E-11,
     &   1.1547E-11, 1.1100E-11, 1.0661E-11, 1.0231E-11, 9.8104E-12,
     &   9.3983E-12, 8.9951E-12, 8.6007E-12, 8.2152E-12, 7.8385E-12,
     &   7.4706E-12, 7.1116E-12, 6.7615E-12, 6.4201E-12, 6.0876E-12,
     &   5.7640E-12, 5.4492E-12, 5.1432E-12, 4.8460E-12, 4.5577E-12,
     &   4.2783E-12, 4.0077E-12, 3.7459E-12, 3.4930E-12, 3.2489E-12,
     &   3.0136E-12, 2.7872E-12, 2.5697E-12, 2.3609E-12, 2.1610E-12,
     &   1.9700E-12, 1.7878E-12, 1.6144E-12, 1.4499E-12, 1.2942E-12,
     &   1.1473E-12, 1.0093E-12, 8.8016E-13, 7.5983E-13, 6.4835E-13,
     &   5.4570E-13, 5.3592E-13, 5.2623E-13, 5.1663E-13, 5.0712E-13,
     &   4.9769E-13, 4.8836E-13, 4.7911E-13, 4.6995E-13, 4.6088E-13,
     &   4.5190E-13, 4.4300E-13, 4.3419E-13, 4.2548E-13, 4.1685E-13,
     &   4.0831E-13, 3.9985E-13, 3.9149E-13, 3.8322E-13, 3.7503E-13/
  
         DATA ((DAT  (I,J), I= 701, 800), J=2,2) /
     &   3.6693E-13, 3.5892E-13, 3.5100E-13, 3.4316E-13, 3.3542E-13,
     &   3.2776E-13, 3.2019E-13, 3.1271E-13, 3.0532E-13, 2.9802E-13,
     &   2.9080E-13, 2.8368E-13, 2.7664E-13, 2.6969E-13, 2.6283E-13,
     &   2.5606E-13, 2.4937E-13, 2.4278E-13, 2.3627E-13, 2.2985E-13,
     &   2.2352E-13, 2.1728E-13, 2.1112E-13, 2.0506E-13, 1.9908E-13,
     &   1.9319E-13, 1.8739E-13, 1.8168E-13, 1.7606E-13, 1.7052E-13,
     &   1.6507E-13, 1.5972E-13, 1.5445E-13, 1.4927E-13, 1.4417E-13,
     &   1.3917E-13, 1.3425E-13, 1.2942E-13, 1.2468E-13, 1.2003E-13,
     &   1.1547E-13, 1.1100E-13, 1.0661E-13, 1.0231E-13, 9.8104E-14,
     &   9.3983E-14, 8.9951E-14, 8.6007E-14, 8.2152E-14, 7.8385E-14,
     &   7.4706E-14, 7.1116E-14, 6.7615E-14, 6.4201E-14, 6.0876E-14,
     &   5.7640E-14, 5.4492E-14, 5.1432E-14, 4.8460E-14, 4.5577E-14,
     &   4.2783E-14, 4.0077E-14, 3.7459E-14, 3.4930E-14, 3.2489E-14,
     &   3.0136E-14, 2.7872E-14, 2.5697E-14, 2.3609E-14, 2.1610E-14,
     &   1.9700E-14, 1.7878E-14, 1.6144E-14, 1.4499E-14, 1.2942E-14,
     &   1.1473E-14, 1.0093E-14, 8.8016E-15, 7.5983E-15, 6.4835E-15,
     &   5.4570E-15, 5.3592E-15, 5.2623E-15, 5.1663E-15, 5.0712E-15,
     &   4.9769E-15, 4.8836E-15, 4.7911E-15, 4.6995E-15, 4.6088E-15,
     &   4.5190E-15, 4.4300E-15, 4.3419E-15, 4.2548E-15, 4.1685E-15,
     &   4.0831E-15, 3.9985E-15, 3.9149E-15, 3.8322E-15, 3.7503E-15/
  
         DATA ((DAT  (I,J), I= 801, 900), J=2,2) /
     &   3.6693E-15, 3.5892E-15, 3.5100E-15, 3.4316E-15, 3.3542E-15,
     &   3.2776E-15, 3.2019E-15, 3.1271E-15, 3.0532E-15, 2.9802E-15,
     &   2.9080E-15, 2.8368E-15, 2.7664E-15, 2.6969E-15, 2.6283E-15,
     &   2.5606E-15, 2.4937E-15, 2.4278E-15, 2.3627E-15, 2.2985E-15,
     &   2.2352E-15, 2.1728E-15, 2.1112E-15, 2.0506E-15, 1.9908E-15,
     &   1.9319E-15, 1.8739E-15, 1.8168E-15, 1.7606E-15, 1.7052E-15,
     &   1.6507E-15, 1.5972E-15, 1.5445E-15, 1.4927E-15, 1.4417E-15,
     &   1.3917E-15, 1.3425E-15, 1.2942E-15, 1.2468E-15, 1.2003E-15,
     &   1.1547E-15, 1.1100E-15, 1.0661E-15, 1.0231E-15, 9.8104E-16,
     &   9.3983E-16, 8.9951E-16, 8.6007E-16, 8.2152E-16, 7.8385E-16,
     &   7.4706E-16, 7.1116E-16, 6.7615E-16, 6.4201E-16, 6.0876E-16,
     &   5.7640E-16, 5.4492E-16, 5.1432E-16, 4.8460E-16, 4.5577E-16,
     &   4.2783E-16, 4.0077E-16, 3.7459E-16, 3.4930E-16, 3.2489E-16,
     &   3.0136E-16, 2.7872E-16, 2.5697E-16, 2.3609E-16, 2.1610E-16,
     &   1.9700E-16, 1.7878E-16, 1.6144E-16, 1.4499E-16, 1.2942E-16,
     &   1.1473E-16, 1.0093E-16, 8.8016E-17, 7.5983E-17, 6.4835E-17,
     &   5.4570E-17, 0.0000E+00, 5.4570E-17, 4.9146E-10, 1.9653E-09,
     &   4.4216E-09, 7.8595E-09, 1.2282E-08, 1.7688E-08, 2.4079E-08,
     &   3.1456E-08, 3.9819E-08, 4.9170E-08, 5.9510E-08, 7.0841E-08,
     &   8.3164E-08, 9.6481E-08, 1.1079E-07, 1.2610E-07, 1.4242E-07/
  
         DATA ((DAT  (I,J), I= 901, 979), J=2,2) /
     &   1.5973E-07, 1.7805E-07, 1.9737E-07, 2.1771E-07, 2.3906E-07,
     &   2.6142E-07, 2.8481E-07, 3.0922E-07, 3.3465E-07, 3.6112E-07,
     &   3.8862E-07, 4.1716E-07, 4.4675E-07, 4.7738E-07, 5.0906E-07,
     &   5.4181E-07, 5.7561E-07, 6.1049E-07, 6.4644E-07, 6.8347E-07,
     &   7.2159E-07, 7.6080E-07, 8.0111E-07, 8.4253E-07, 8.8506E-07,
     &   9.2872E-07, 9.7350E-07, 1.0194E-06, 1.0665E-06, 1.1147E-06,
     &   1.1641E-06, 1.2147E-06, 1.2664E-06, 1.3194E-06, 1.3735E-06,
     &   1.4289E-06, 1.4855E-06, 1.5434E-06, 1.6025E-06, 1.6629E-06,
     &   1.7246E-06, 1.7876E-06, 1.8519E-06, 1.9175E-06, 1.9845E-06,
     &   2.0529E-06, 2.1227E-06, 2.1939E-06, 2.2665E-06, 2.3406E-06,
     &   2.4163E-06, 2.4934E-06, 2.5721E-06, 2.6524E-06, 2.7343E-06,
     &   2.8180E-06, 2.9033E-06, 2.9904E-06, 3.0793E-06, 3.1702E-06,
     &   3.2629E-06, 3.3578E-06, 3.4547E-06, 3.5539E-06, 3.6555E-06,
     &   3.7595E-06, 3.8662E-06, 3.9759E-06, 4.0887E-06, 4.2051E-06,
     &   4.3254E-06, 4.4505E-06, 4.5814E-06, 4.6266E-06, 4.7199E-06,
     &   4.75366020E-06, 4.86994674E-06, 4.88591082E-06, 4.92415918E-06/


c      ++++ deghadt16 ++++  

c updated dec 2016
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 13:46:35 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (ETA  (I), I=   1, 100) /
     &  -1.0000E+03,-9.9000E+02,-9.8000E+02,-9.7000E+02,-9.6000E+02,
     &  -9.5000E+02,-9.4000E+02,-9.3000E+02,-9.2000E+02,-9.1000E+02,
     &  -9.0000E+02,-8.9000E+02,-8.8000E+02,-8.7000E+02,-8.6000E+02,
     &  -8.5000E+02,-8.4000E+02,-8.3000E+02,-8.2000E+02,-8.1000E+02,
     &  -8.0000E+02,-7.9000E+02,-7.8000E+02,-7.7000E+02,-7.6000E+02,
     &  -7.5000E+02,-7.4000E+02,-7.3000E+02,-7.2000E+02,-7.1000E+02,
     &  -7.0000E+02,-6.9000E+02,-6.8000E+02,-6.7000E+02,-6.6000E+02,
     &  -6.5000E+02,-6.4000E+02,-6.3000E+02,-6.2000E+02,-6.1000E+02,
     &  -6.0000E+02,-5.9000E+02,-5.8000E+02,-5.7000E+02,-5.6000E+02,
     &  -5.5000E+02,-5.4000E+02,-5.3000E+02,-5.2000E+02,-5.1000E+02,
     &  -5.0000E+02,-4.9000E+02,-4.8000E+02,-4.7000E+02,-4.6000E+02,
     &  -4.5000E+02,-4.4000E+02,-4.3000E+02,-4.2000E+02,-4.1000E+02,
     &  -4.0000E+02,-3.9000E+02,-3.8000E+02,-3.7000E+02,-3.6000E+02,
     &  -3.5000E+02,-3.4000E+02,-3.3000E+02,-3.2000E+02,-3.1000E+02,
     &  -3.0000E+02,-2.9000E+02,-2.8000E+02,-2.7000E+02,-2.6000E+02,
     &  -2.5000E+02,-2.4000E+02,-2.3000E+02,-2.2000E+02,-2.1000E+02,
     &  -2.0000E+02,-1.9000E+02,-1.8000E+02,-1.7000E+02,-1.6000E+02,
     &  -1.5000E+02,-1.4000E+02,-1.3000E+02,-1.2000E+02,-1.1000E+02,
     &  -1.0000E+02,-9.9000E+01,-9.8000E+01,-9.7000E+01,-9.6000E+01,
     &  -9.5000E+01,-9.4000E+01,-9.3000E+01,-9.2000E+01,-9.1000E+01/
  
       DATA  (ETA  (I), I= 101, 200) /
     &  -9.0000E+01,-8.9000E+01,-8.8000E+01,-8.7000E+01,-8.6000E+01,
     &  -8.5000E+01,-8.4000E+01,-8.3000E+01,-8.2000E+01,-8.1000E+01,
     &  -8.0000E+01,-7.9000E+01,-7.8000E+01,-7.7000E+01,-7.6000E+01,
     &  -7.5000E+01,-7.4000E+01,-7.3000E+01,-7.2000E+01,-7.1000E+01,
     &  -7.0000E+01,-6.9000E+01,-6.8000E+01,-6.7000E+01,-6.6000E+01,
     &  -6.5000E+01,-6.4000E+01,-6.3000E+01,-6.2000E+01,-6.1000E+01,
     &  -6.0000E+01,-5.9000E+01,-5.8000E+01,-5.7000E+01,-5.6000E+01,
     &  -5.5000E+01,-5.4000E+01,-5.3000E+01,-5.2000E+01,-5.1000E+01,
     &  -5.0000E+01,-4.9000E+01,-4.8000E+01,-4.7000E+01,-4.6000E+01,
     &  -4.5000E+01,-4.4000E+01,-4.3000E+01,-4.2000E+01,-4.1000E+01,
     &  -4.0000E+01,-3.9000E+01,-3.8000E+01,-3.7000E+01,-3.6000E+01,
     &  -3.5000E+01,-3.4000E+01,-3.3000E+01,-3.2000E+01,-3.1000E+01,
     &  -3.0000E+01,-2.9000E+01,-2.8000E+01,-2.7000E+01,-2.6000E+01,
     &  -2.5000E+01,-2.4000E+01,-2.3000E+01,-2.2000E+01,-2.1000E+01,
     &  -2.0000E+01,-1.9000E+01,-1.8000E+01,-1.7000E+01,-1.6000E+01,
     &  -1.5000E+01,-1.4000E+01,-1.3000E+01,-1.2000E+01,-1.1000E+01,
     &  -1.0000E+01,-9.9100E+00,-9.8200E+00,-9.7300E+00,-9.6400E+00,
     &  -9.5500E+00,-9.4600E+00,-9.3700E+00,-9.2800E+00,-9.1900E+00,
     &  -9.1000E+00,-9.0100E+00,-8.9200E+00,-8.8300E+00,-8.7400E+00,
     &  -8.6500E+00,-8.5600E+00,-8.4700E+00,-8.3800E+00,-8.2900E+00/
  
       DATA  (ETA  (I), I= 201, 300) /
     &  -8.2000E+00,-8.1100E+00,-8.0200E+00,-7.9300E+00,-7.8400E+00,
     &  -7.7500E+00,-7.6600E+00,-7.5700E+00,-7.4800E+00,-7.3900E+00,
     &  -7.3000E+00,-7.2100E+00,-7.1200E+00,-7.0300E+00,-6.9400E+00,
     &  -6.8500E+00,-6.7600E+00,-6.6700E+00,-6.5800E+00,-6.4900E+00,
     &  -6.4000E+00,-6.3100E+00,-6.2200E+00,-6.1300E+00,-6.0400E+00,
     &  -5.9500E+00,-5.8600E+00,-5.7700E+00,-5.6800E+00,-5.5900E+00,
     &  -5.5000E+00,-5.4100E+00,-5.3200E+00,-5.2300E+00,-5.1400E+00,
     &  -5.0500E+00,-4.9600E+00,-4.8700E+00,-4.7800E+00,-4.6900E+00,
     &  -4.6000E+00,-4.5100E+00,-4.4200E+00,-4.3300E+00,-4.2400E+00,
     &  -4.1500E+00,-4.0600E+00,-3.9700E+00,-3.8800E+00,-3.7900E+00,
     &  -3.7000E+00,-3.6100E+00,-3.5200E+00,-3.4300E+00,-3.3400E+00,
     &  -3.2500E+00,-3.1600E+00,-3.0700E+00,-2.9800E+00,-2.8900E+00,
     &  -2.8000E+00,-2.7100E+00,-2.6200E+00,-2.5300E+00,-2.4400E+00,
     &  -2.3500E+00,-2.2600E+00,-2.1700E+00,-2.0800E+00,-1.9900E+00,
     &  -1.9000E+00,-1.8100E+00,-1.7200E+00,-1.6300E+00,-1.5400E+00,
     &  -1.4500E+00,-1.3600E+00,-1.2700E+00,-1.1800E+00,-1.0900E+00,
     &  -1.0000E+00,-9.9100E-01,-9.8200E-01,-9.7300E-01,-9.6400E-01,
     &  -9.5500E-01,-9.4600E-01,-9.3700E-01,-9.2800E-01,-9.1900E-01,
     &  -9.1000E-01,-9.0100E-01,-8.9200E-01,-8.8300E-01,-8.7400E-01,
     &  -8.6500E-01,-8.5600E-01,-8.4700E-01,-8.3800E-01,-8.2900E-01/
  
       DATA  (ETA  (I), I= 301, 400) /
     &  -8.2000E-01,-8.1100E-01,-8.0200E-01,-7.9300E-01,-7.8400E-01,
     &  -7.7500E-01,-7.6600E-01,-7.5700E-01,-7.4800E-01,-7.3900E-01,
     &  -7.3000E-01,-7.2100E-01,-7.1200E-01,-7.0300E-01,-6.9400E-01,
     &  -6.8500E-01,-6.7600E-01,-6.6700E-01,-6.5800E-01,-6.4900E-01,
     &  -6.4000E-01,-6.3100E-01,-6.2200E-01,-6.1300E-01,-6.0400E-01,
     &  -5.9500E-01,-5.8600E-01,-5.7700E-01,-5.6800E-01,-5.5900E-01,
     &  -5.5000E-01,-5.4100E-01,-5.3200E-01,-5.2300E-01,-5.1400E-01,
     &  -5.0500E-01,-4.9600E-01,-4.8700E-01,-4.7800E-01,-4.6900E-01,
     &  -4.6000E-01,-4.5100E-01,-4.4200E-01,-4.3300E-01,-4.2400E-01,
     &  -4.1500E-01,-4.0600E-01,-3.9700E-01,-3.8800E-01,-3.7900E-01,
     &  -3.7000E-01,-3.6100E-01,-3.5200E-01,-3.4300E-01,-3.3400E-01,
     &  -3.2500E-01,-3.1600E-01,-3.0700E-01,-2.9800E-01,-2.8900E-01,
     &  -2.8000E-01,-2.7100E-01,-2.6200E-01,-2.5300E-01,-2.4400E-01,
     &  -2.3500E-01,-2.2600E-01,-2.1700E-01,-2.0800E-01,-1.9900E-01,
     &  -1.9000E-01,-1.8100E-01,-1.7200E-01,-1.6300E-01,-1.5400E-01,
     &  -1.4500E-01,-1.3600E-01,-1.2700E-01,-1.1800E-01,-1.0900E-01,
     &  -1.0000E-01,-9.9100E-02,-9.8200E-02,-9.7300E-02,-9.6400E-02,
     &  -9.5500E-02,-9.4600E-02,-9.3700E-02,-9.2800E-02,-9.1900E-02,
     &  -9.1000E-02,-9.0100E-02,-8.9200E-02,-8.8300E-02,-8.7400E-02,
     &  -8.6500E-02,-8.5600E-02,-8.4700E-02,-8.3800E-02,-8.2900E-02/
  
       DATA  (ETA  (I), I= 401, 500) /
     &  -8.2000E-02,-8.1100E-02,-8.0200E-02,-7.9300E-02,-7.8400E-02,
     &  -7.7500E-02,-7.6600E-02,-7.5700E-02,-7.4800E-02,-7.3900E-02,
     &  -7.3000E-02,-7.2100E-02,-7.1200E-02,-7.0300E-02,-6.9400E-02,
     &  -6.8500E-02,-6.7600E-02,-6.6700E-02,-6.5800E-02,-6.4900E-02,
     &  -6.4000E-02,-6.3100E-02,-6.2200E-02,-6.1300E-02,-6.0400E-02,
     &  -5.9500E-02,-5.8600E-02,-5.7700E-02,-5.6800E-02,-5.5900E-02,
     &  -5.5000E-02,-5.4100E-02,-5.3200E-02,-5.2300E-02,-5.1400E-02,
     &  -5.0500E-02,-4.9600E-02,-4.8700E-02,-4.7800E-02,-4.6900E-02,
     &  -4.6000E-02,-4.5100E-02,-4.4200E-02,-4.3300E-02,-4.2400E-02,
     &  -4.1500E-02,-4.0600E-02,-3.9700E-02,-3.8800E-02,-3.7900E-02,
     &  -3.7000E-02,-3.6100E-02,-3.5200E-02,-3.4300E-02,-3.3400E-02,
     &  -3.2500E-02,-3.1600E-02,-3.0700E-02,-2.9800E-02,-2.8900E-02,
     &  -2.8000E-02,-2.7100E-02,-2.6200E-02,-2.5300E-02,-2.4400E-02,
     &  -2.3500E-02,-2.2600E-02,-2.1700E-02,-2.0800E-02,-1.9900E-02,
     &  -1.9000E-02,-1.8100E-02,-1.7200E-02,-1.6300E-02,-1.5400E-02,
     &  -1.4500E-02,-1.3600E-02,-1.2700E-02,-1.1800E-02,-1.0900E-02,
     &  -1.0000E-02,-9.9100E-03,-9.8200E-03,-9.7300E-03,-9.6400E-03,
     &  -9.5500E-03,-9.4600E-03,-9.3700E-03,-9.2800E-03,-9.1900E-03,
     &  -9.1000E-03,-9.0100E-03,-8.9200E-03,-8.8300E-03,-8.7400E-03,
     &  -8.6500E-03,-8.5600E-03,-8.4700E-03,-8.3800E-03,-8.2900E-03/
  
       DATA  (ETA  (I), I= 501, 600) /
     &  -8.2000E-03,-8.1100E-03,-8.0200E-03,-7.9300E-03,-7.8400E-03,
     &  -7.7500E-03,-7.6600E-03,-7.5700E-03,-7.4800E-03,-7.3900E-03,
     &  -7.3000E-03,-7.2100E-03,-7.1200E-03,-7.0300E-03,-6.9400E-03,
     &  -6.8500E-03,-6.7600E-03,-6.6700E-03,-6.5800E-03,-6.4900E-03,
     &  -6.4000E-03,-6.3100E-03,-6.2200E-03,-6.1300E-03,-6.0400E-03,
     &  -5.9500E-03,-5.8600E-03,-5.7700E-03,-5.6800E-03,-5.5900E-03,
     &  -5.5000E-03,-5.4100E-03,-5.3200E-03,-5.2300E-03,-5.1400E-03,
     &  -5.0500E-03,-4.9600E-03,-4.8700E-03,-4.7800E-03,-4.6900E-03,
     &  -4.6000E-03,-4.5100E-03,-4.4200E-03,-4.3300E-03,-4.2400E-03,
     &  -4.1500E-03,-4.0600E-03,-3.9700E-03,-3.8800E-03,-3.7900E-03,
     &  -3.7000E-03,-3.6100E-03,-3.5200E-03,-3.4300E-03,-3.3400E-03,
     &  -3.2500E-03,-3.1600E-03,-3.0700E-03,-2.9800E-03,-2.8900E-03,
     &  -2.8000E-03,-2.7100E-03,-2.6200E-03,-2.5300E-03,-2.4400E-03,
     &  -2.3500E-03,-2.2600E-03,-2.1700E-03,-2.0800E-03,-1.9900E-03,
     &  -1.9000E-03,-1.8100E-03,-1.7200E-03,-1.6300E-03,-1.5400E-03,
     &  -1.4500E-03,-1.3600E-03,-1.2700E-03,-1.1800E-03,-1.0900E-03,
     &  -1.0000E-03,-9.9100E-04,-9.8200E-04,-9.7300E-04,-9.6400E-04,
     &  -9.5500E-04,-9.4600E-04,-9.3700E-04,-9.2800E-04,-9.1900E-04,
     &  -9.1000E-04,-9.0100E-04,-8.9200E-04,-8.8300E-04,-8.7400E-04,
     &  -8.6500E-04,-8.5600E-04,-8.4700E-04,-8.3800E-04,-8.2900E-04/
  
       DATA  (ETA  (I), I= 601, 700) /
     &  -8.2000E-04,-8.1100E-04,-8.0200E-04,-7.9300E-04,-7.8400E-04,
     &  -7.7500E-04,-7.6600E-04,-7.5700E-04,-7.4800E-04,-7.3900E-04,
     &  -7.3000E-04,-7.2100E-04,-7.1200E-04,-7.0300E-04,-6.9400E-04,
     &  -6.8500E-04,-6.7600E-04,-6.6700E-04,-6.5800E-04,-6.4900E-04,
     &  -6.4000E-04,-6.3100E-04,-6.2200E-04,-6.1300E-04,-6.0400E-04,
     &  -5.9500E-04,-5.8600E-04,-5.7700E-04,-5.6800E-04,-5.5900E-04,
     &  -5.5000E-04,-5.4100E-04,-5.3200E-04,-5.2300E-04,-5.1400E-04,
     &  -5.0500E-04,-4.9600E-04,-4.8700E-04,-4.7800E-04,-4.6900E-04,
     &  -4.6000E-04,-4.5100E-04,-4.4200E-04,-4.3300E-04,-4.2400E-04,
     &  -4.1500E-04,-4.0600E-04,-3.9700E-04,-3.8800E-04,-3.7900E-04,
     &  -3.7000E-04,-3.6100E-04,-3.5200E-04,-3.4300E-04,-3.3400E-04,
     &  -3.2500E-04,-3.1600E-04,-3.0700E-04,-2.9800E-04,-2.8900E-04,
     &  -2.8000E-04,-2.7100E-04,-2.6200E-04,-2.5300E-04,-2.4400E-04,
     &  -2.3500E-04,-2.2600E-04,-2.1700E-04,-2.0800E-04,-1.9900E-04,
     &  -1.9000E-04,-1.8100E-04,-1.7200E-04,-1.6300E-04,-1.5400E-04,
     &  -1.4500E-04,-1.3600E-04,-1.2700E-04,-1.1800E-04,-1.0900E-04,
     &  -1.0000E-04,-9.9100E-05,-9.8200E-05,-9.7300E-05,-9.6400E-05,
     &  -9.5500E-05,-9.4600E-05,-9.3700E-05,-9.2800E-05,-9.1900E-05,
     &  -9.1000E-05,-9.0100E-05,-8.9200E-05,-8.8300E-05,-8.7400E-05,
     &  -8.6500E-05,-8.5600E-05,-8.4700E-05,-8.3800E-05,-8.2900E-05/
  
       DATA  (ETA  (I), I= 701, 800) /
     &  -8.2000E-05,-8.1100E-05,-8.0200E-05,-7.9300E-05,-7.8400E-05,
     &  -7.7500E-05,-7.6600E-05,-7.5700E-05,-7.4800E-05,-7.3900E-05,
     &  -7.3000E-05,-7.2100E-05,-7.1200E-05,-7.0300E-05,-6.9400E-05,
     &  -6.8500E-05,-6.7600E-05,-6.6700E-05,-6.5800E-05,-6.4900E-05,
     &  -6.4000E-05,-6.3100E-05,-6.2200E-05,-6.1300E-05,-6.0400E-05,
     &  -5.9500E-05,-5.8600E-05,-5.7700E-05,-5.6800E-05,-5.5900E-05,
     &  -5.5000E-05,-5.4100E-05,-5.3200E-05,-5.2300E-05,-5.1400E-05,
     &  -5.0500E-05,-4.9600E-05,-4.8700E-05,-4.7800E-05,-4.6900E-05,
     &  -4.6000E-05,-4.5100E-05,-4.4200E-05,-4.3300E-05,-4.2400E-05,
     &  -4.1500E-05,-4.0600E-05,-3.9700E-05,-3.8800E-05,-3.7900E-05,
     &  -3.7000E-05,-3.6100E-05,-3.5200E-05,-3.4300E-05,-3.3400E-05,
     &  -3.2500E-05,-3.1600E-05,-3.0700E-05,-2.9800E-05,-2.8900E-05,
     &  -2.8000E-05,-2.7100E-05,-2.6200E-05,-2.5300E-05,-2.4400E-05,
     &  -2.3500E-05,-2.2600E-05,-2.1700E-05,-2.0800E-05,-1.9900E-05,
     &  -1.9000E-05,-1.8100E-05,-1.7200E-05,-1.6300E-05,-1.5400E-05,
     &  -1.4500E-05,-1.3600E-05,-1.2700E-05,-1.1800E-05,-1.0900E-05,
     &  -1.0000E-05,-9.9100E-06,-9.8200E-06,-9.7300E-06,-9.6400E-06,
     &  -9.5500E-06,-9.4600E-06,-9.3700E-06,-9.2800E-06,-9.1900E-06,
     &  -9.1000E-06,-9.0100E-06,-8.9200E-06,-8.8300E-06,-8.7400E-06,
     &  -8.6500E-06,-8.5600E-06,-8.4700E-06,-8.3800E-06,-8.2900E-06/
  
       DATA  (ETA  (I), I= 801, 900) /
     &  -8.2000E-06,-8.1100E-06,-8.0200E-06,-7.9300E-06,-7.8400E-06,
     &  -7.7500E-06,-7.6600E-06,-7.5700E-06,-7.4800E-06,-7.3900E-06,
     &  -7.3000E-06,-7.2100E-06,-7.1200E-06,-7.0300E-06,-6.9400E-06,
     &  -6.8500E-06,-6.7600E-06,-6.6700E-06,-6.5800E-06,-6.4900E-06,
     &  -6.4000E-06,-6.3100E-06,-6.2200E-06,-6.1300E-06,-6.0400E-06,
     &  -5.9500E-06,-5.8600E-06,-5.7700E-06,-5.6800E-06,-5.5900E-06,
     &  -5.5000E-06,-5.4100E-06,-5.3200E-06,-5.2300E-06,-5.1400E-06,
     &  -5.0500E-06,-4.9600E-06,-4.8700E-06,-4.7800E-06,-4.6900E-06,
     &  -4.6000E-06,-4.5100E-06,-4.4200E-06,-4.3300E-06,-4.2400E-06,
     &  -4.1500E-06,-4.0600E-06,-3.9700E-06,-3.8800E-06,-3.7900E-06,
     &  -3.7000E-06,-3.6100E-06,-3.5200E-06,-3.4300E-06,-3.3400E-06,
     &  -3.2500E-06,-3.1600E-06,-3.0700E-06,-2.9800E-06,-2.8900E-06,
     &  -2.8000E-06,-2.7100E-06,-2.6200E-06,-2.5300E-06,-2.4400E-06,
     &  -2.3500E-06,-2.2600E-06,-2.1700E-06,-2.0800E-06,-1.9900E-06,
     &  -1.9000E-06,-1.8100E-06,-1.7200E-06,-1.6300E-06,-1.5400E-06,
     &  -1.4500E-06,-1.3600E-06,-1.2700E-06,-1.1800E-06,-1.0900E-06,
     &  -1.0000E-06, 0.0000E+00, 1.0000E-06, 3.0010E-03, 6.0010E-03,
     &   9.0010E-03, 1.2000E-02, 1.5000E-02, 1.8000E-02, 2.1000E-02,
     &   2.4000E-02, 2.7000E-02, 3.0000E-02, 3.3000E-02, 3.6000E-02,
     &   3.9000E-02, 4.2000E-02, 4.5000E-02, 4.8000E-02, 5.1000E-02/
  
       DATA  (ETA  (I), I= 901, 979) /
     &   5.4000E-02, 5.7000E-02, 6.0000E-02, 6.3000E-02, 6.6000E-02,
     &   6.9000E-02, 7.2000E-02, 7.5000E-02, 7.8000E-02, 8.1000E-02,
     &   8.4000E-02, 8.7000E-02, 9.0000E-02, 9.3000E-02, 9.6000E-02,
     &   9.9000E-02, 1.0200E-01, 1.0500E-01, 1.0800E-01, 1.1100E-01,
     &   1.1400E-01, 1.1700E-01, 1.2000E-01, 1.2300E-01, 1.2600E-01,
     &   1.2900E-01, 1.3200E-01, 1.3500E-01, 1.3800E-01, 1.4100E-01,
     &   1.4400E-01, 1.4700E-01, 1.5000E-01, 1.5300E-01, 1.5600E-01,
     &   1.5900E-01, 1.6200E-01, 1.6500E-01, 1.6800E-01, 1.7100E-01,
     &   1.7400E-01, 1.7700E-01, 1.8000E-01, 1.8300E-01, 1.8600E-01,
     &   1.8900E-01, 1.9200E-01, 1.9500E-01, 1.9800E-01, 2.0100E-01,
     &   2.0400E-01, 2.0700E-01, 2.1000E-01, 2.1300E-01, 2.1600E-01,
     &   2.1900E-01, 2.2200E-01, 2.2500E-01, 2.2800E-01, 2.3100E-01,
     &   2.3400E-01, 2.3700E-01, 2.4000E-01, 2.4300E-01, 2.4600E-01,
     &   2.4900E-01, 2.5200E-01, 2.5500E-01, 2.5800E-01, 2.6100E-01,
     &   2.6400E-01, 2.6700E-01, 2.7000E-01, 2.7100E-01, 2.7300E-01,
     &   0.27370000D0, 0.27599999D0, 0.27630001D0, 0.27700001D0/
  
         DATA ((DGT  (I,J), I=   1, 100), J=1,1) /
     &   8.3755E-02, 8.3649E-02, 8.3541E-02, 8.3433E-02, 8.3323E-02,
     &   8.3212E-02, 8.3100E-02, 8.2986E-02, 8.2871E-02, 8.2755E-02,
     &   8.2637E-02, 8.2518E-02, 8.2397E-02, 8.2275E-02, 8.2151E-02,
     &   8.2025E-02, 8.1898E-02, 8.1769E-02, 8.1639E-02, 8.1506E-02,
     &   8.1372E-02, 8.1236E-02, 8.1098E-02, 8.0958E-02, 8.0816E-02,
     &   8.0671E-02, 8.0525E-02, 8.0377E-02, 8.0226E-02, 8.0072E-02,
     &   7.9917E-02, 7.9759E-02, 7.9598E-02, 7.9435E-02, 7.9268E-02,
     &   7.9099E-02, 7.8927E-02, 7.8753E-02, 7.8575E-02, 7.8393E-02,
     &   7.8209E-02, 7.8021E-02, 7.7829E-02, 7.7634E-02, 7.7435E-02,
     &   7.7232E-02, 7.7024E-02, 7.6813E-02, 7.6597E-02, 7.6377E-02,
     &   7.6151E-02, 7.5921E-02, 7.5686E-02, 7.5445E-02, 7.5198E-02,
     &   7.4946E-02, 7.4687E-02, 7.4422E-02, 7.4150E-02, 7.3872E-02,
     &   7.3585E-02, 7.3291E-02, 7.2989E-02, 7.2678E-02, 7.2358E-02,
     &   7.2029E-02, 7.1689E-02, 7.1339E-02, 7.0977E-02, 7.0603E-02,
     &   7.0216E-02, 6.9816E-02, 6.9400E-02, 6.8969E-02, 6.8521E-02,
     &   6.8055E-02, 6.7569E-02, 6.7061E-02, 6.6530E-02, 6.5974E-02,
     &   6.5389E-02, 6.4774E-02, 6.4125E-02, 6.3438E-02, 6.2708E-02,
     &   6.1930E-02, 6.1098E-02, 6.0202E-02, 5.9234E-02, 5.8181E-02,
     &   5.7026E-02, 5.6904E-02, 5.6781E-02, 5.6657E-02, 5.6531E-02,
     &   5.6404E-02, 5.6276E-02, 5.6146E-02, 5.6015E-02, 5.5882E-02/
  
         DATA ((DGT  (I,J), I= 101, 200), J=1,1) /
     &   5.5748E-02, 5.5612E-02, 5.5475E-02, 5.5336E-02, 5.5196E-02,
     &   5.5054E-02, 5.4910E-02, 5.4765E-02, 5.4618E-02, 5.4469E-02,
     &   5.4318E-02, 5.4165E-02, 5.4010E-02, 5.3853E-02, 5.3694E-02,
     &   5.3533E-02, 5.3370E-02, 5.3205E-02, 5.3037E-02, 5.2867E-02,
     &   5.2695E-02, 5.2520E-02, 5.2342E-02, 5.2162E-02, 5.1979E-02,
     &   5.1794E-02, 5.1605E-02, 5.1413E-02, 5.1219E-02, 5.1021E-02,
     &   5.0820E-02, 5.0615E-02, 5.0407E-02, 5.0196E-02, 4.9980E-02,
     &   4.9761E-02, 4.9538E-02, 4.9310E-02, 4.9078E-02, 4.8842E-02,
     &   4.8601E-02, 4.8355E-02, 4.8104E-02, 4.7848E-02, 4.7586E-02,
     &   4.7318E-02, 4.7045E-02, 4.6765E-02, 4.6478E-02, 4.6185E-02,
     &   4.5885E-02, 4.5577E-02, 4.5260E-02, 4.4936E-02, 4.4603E-02,
     &   4.4260E-02, 4.3908E-02, 4.3545E-02, 4.3171E-02, 4.2785E-02,
     &   4.2387E-02, 4.1975E-02, 4.1549E-02, 4.1108E-02, 4.0651E-02,
     &   4.0176E-02, 3.9682E-02, 3.9168E-02, 3.8631E-02, 3.8070E-02,
     &   3.7483E-02, 3.6866E-02, 3.6218E-02, 3.5534E-02, 3.4811E-02,
     &   3.4043E-02, 3.3226E-02, 3.2352E-02, 3.1414E-02, 3.0401E-02,
     &   2.9300E-02, 2.9196E-02, 2.9091E-02, 2.8986E-02, 2.8879E-02,
     &   2.8772E-02, 2.8663E-02, 2.8554E-02, 2.8444E-02, 2.8333E-02,
     &   2.8221E-02, 2.8107E-02, 2.7993E-02, 2.7878E-02, 2.7762E-02,
     &   2.7645E-02, 2.7526E-02, 2.7407E-02, 2.7286E-02, 2.7164E-02/
  
         DATA ((DGT  (I,J), I= 201, 300), J=1,1) /
     &   2.7041E-02, 2.6917E-02, 2.6792E-02, 2.6665E-02, 2.6537E-02,
     &   2.6408E-02, 2.6278E-02, 2.6146E-02, 2.6012E-02, 2.5878E-02,
     &   2.5742E-02, 2.5604E-02, 2.5465E-02, 2.5325E-02, 2.5182E-02,
     &   2.5039E-02, 2.4893E-02, 2.4746E-02, 2.4597E-02, 2.4447E-02,
     &   2.4294E-02, 2.4140E-02, 2.3984E-02, 2.3826E-02, 2.3664E-02,
     &   2.3502E-02, 2.3338E-02, 2.3171E-02, 2.3003E-02, 2.2832E-02,
     &   2.2659E-02, 2.2483E-02, 2.2305E-02, 2.2125E-02, 2.1942E-02,
     &   2.1756E-02, 2.1567E-02, 2.1376E-02, 2.1182E-02, 2.0984E-02,
     &   2.0784E-02, 2.0580E-02, 2.0373E-02, 2.0162E-02, 1.9948E-02,
     &   1.9731E-02, 1.9509E-02, 1.9283E-02, 1.9054E-02, 1.8820E-02,
     &   1.8582E-02, 1.8339E-02, 1.8091E-02, 1.7838E-02, 1.7580E-02,
     &   1.7317E-02, 1.7048E-02, 1.6773E-02, 1.6491E-02, 1.6203E-02,
     &   1.5908E-02, 1.5606E-02, 1.5296E-02, 1.4978E-02, 1.4653E-02,
     &   1.4317E-02, 1.3971E-02, 1.3615E-02, 1.3247E-02, 1.2866E-02,
     &   1.2473E-02, 1.2065E-02, 1.1640E-02, 1.1199E-02, 1.0738E-02,
     &   1.0255E-02, 9.7491E-03, 9.2165E-03, 8.6550E-03, 8.0611E-03,
     &   7.4317E-03, 7.3667E-03, 7.3012E-03, 7.2354E-03, 7.1692E-03,
     &   7.1026E-03, 7.0356E-03, 6.9683E-03, 6.9004E-03, 6.8322E-03,
     &   6.7636E-03, 6.6946E-03, 6.6252E-03, 6.5553E-03, 6.4850E-03,
     &   6.4144E-03, 6.3433E-03, 6.2717E-03, 6.1998E-03, 6.1274E-03/
  
         DATA ((DGT  (I,J), I= 301, 400), J=1,1) /
     &   6.0547E-03, 5.9815E-03, 5.9079E-03, 5.8339E-03, 5.7594E-03,
     &   5.6846E-03, 5.6093E-03, 5.5336E-03, 5.4576E-03, 5.3811E-03,
     &   5.3042E-03, 5.2269E-03, 5.1492E-03, 5.0711E-03, 4.9927E-03,
     &   4.9139E-03, 4.8347E-03, 4.7552E-03, 4.6753E-03, 4.5950E-03,
     &   4.5145E-03, 4.4336E-03, 4.3524E-03, 4.2709E-03, 4.1891E-03,
     &   4.1071E-03, 4.0248E-03, 3.9423E-03, 3.8595E-03, 3.7766E-03,
     &   3.6934E-03, 3.6102E-03, 3.5267E-03, 3.4432E-03, 3.3595E-03,
     &   3.2758E-03, 3.1921E-03, 3.1084E-03, 3.0247E-03, 2.9410E-03,
     &   2.8574E-03, 2.7740E-03, 2.6907E-03, 2.6076E-03, 2.5247E-03,
     &   2.4422E-03, 2.3599E-03, 2.2781E-03, 2.1966E-03, 2.1156E-03,
     &   2.0352E-03, 1.9553E-03, 1.8760E-03, 1.7975E-03, 1.7196E-03,
     &   1.6426E-03, 1.5664E-03, 1.4912E-03, 1.4170E-03, 1.3438E-03,
     &   1.2717E-03, 1.2009E-03, 1.1313E-03, 1.0631E-03, 9.9630E-04,
     &   9.3100E-04, 8.6727E-04, 8.0519E-04, 7.4484E-04, 6.8629E-04,
     &   6.2963E-04, 5.7493E-04, 5.2227E-04, 4.7172E-04, 4.2337E-04,
     &   3.7729E-04, 3.3355E-04, 2.9223E-04, 2.5339E-04, 2.1710E-04,
     &   1.8342E-04, 1.8020E-04, 1.7701E-04, 1.7384E-04, 1.7070E-04,
     &   1.6759E-04, 1.6450E-04, 1.6144E-04, 1.5841E-04, 1.5541E-04,
     &   1.5243E-04, 1.4948E-04, 1.4656E-04, 1.4366E-04, 1.4079E-04,
     &   1.3795E-04, 1.3514E-04, 1.3235E-04, 1.2960E-04, 1.2687E-04/
  
         DATA ((DGT  (I,J), I= 401, 500), J=1,1) /
     &   1.2417E-04, 1.2149E-04, 1.1885E-04, 1.1623E-04, 1.1364E-04,
     &   1.1108E-04, 1.0854E-04, 1.0604E-04, 1.0356E-04, 1.0111E-04,
     &   9.8690E-05, 9.6298E-05, 9.3934E-05, 9.1599E-05, 8.9292E-05,
     &   8.7013E-05, 8.4763E-05, 8.2542E-05, 8.0350E-05, 7.8186E-05,
     &   7.6051E-05, 7.3945E-05, 7.1867E-05, 6.9819E-05, 6.7799E-05,
     &   6.5809E-05, 6.3847E-05, 6.1915E-05, 6.0011E-05, 5.8137E-05,
     &   5.6292E-05, 5.4476E-05, 5.2689E-05, 5.0931E-05, 4.9203E-05,
     &   4.7505E-05, 4.5835E-05, 4.4195E-05, 4.2584E-05, 4.1003E-05,
     &   3.9452E-05, 3.7930E-05, 3.6437E-05, 3.4974E-05, 3.3541E-05,
     &   3.2137E-05, 3.0763E-05, 2.9419E-05, 2.8104E-05, 2.6820E-05,
     &   2.5565E-05, 2.4339E-05, 2.3144E-05, 2.1979E-05, 2.0843E-05,
     &   1.9737E-05, 1.8662E-05, 1.7616E-05, 1.6600E-05, 1.5614E-05,
     &   1.4659E-05, 1.3733E-05, 1.2837E-05, 1.1971E-05, 1.1136E-05,
     &   1.0331E-05, 9.5553E-06, 8.8101E-06, 8.0951E-06, 7.4103E-06,
     &   6.7557E-06, 6.1313E-06, 5.5371E-06, 4.9731E-06, 4.4394E-06,
     &   3.9359E-06, 3.4626E-06, 3.0196E-06, 2.6070E-06, 2.2245E-06,
     &   1.8724E-06, 1.8389E-06, 1.8056E-06, 1.7727E-06, 1.7401E-06,
     &   1.7077E-06, 1.6757E-06, 1.6440E-06, 1.6126E-06, 1.5814E-06,
     &   1.5506E-06, 1.5201E-06, 1.4899E-06, 1.4600E-06, 1.4304E-06,
     &   1.4011E-06, 1.3721E-06, 1.3434E-06, 1.3150E-06, 1.2869E-06/
  
         DATA ((DGT  (I,J), I= 501, 600), J=1,1) /
     &   1.2591E-06, 1.2316E-06, 1.2044E-06, 1.1776E-06, 1.1510E-06,
     &   1.1247E-06, 1.0988E-06, 1.0731E-06, 1.0477E-06, 1.0227E-06,
     &   9.9792E-07, 9.7346E-07, 9.4932E-07, 9.2547E-07, 9.0193E-07,
     &   8.7869E-07, 8.5575E-07, 8.3312E-07, 8.1079E-07, 7.8877E-07,
     &   7.6704E-07, 7.4562E-07, 7.2451E-07, 7.0369E-07, 6.8318E-07,
     &   6.6298E-07, 6.4307E-07, 6.2347E-07, 6.0418E-07, 5.8518E-07,
     &   5.6649E-07, 5.4811E-07, 5.3002E-07, 5.1224E-07, 4.9477E-07,
     &   4.7759E-07, 4.6072E-07, 4.4415E-07, 4.2789E-07, 4.1193E-07,
     &   3.9627E-07, 3.8092E-07, 3.6587E-07, 3.5112E-07, 3.3668E-07,
     &   3.2254E-07, 3.0870E-07, 2.9516E-07, 2.8193E-07, 2.6901E-07,
     &   2.5638E-07, 2.4406E-07, 2.3204E-07, 2.2033E-07, 2.0892E-07,
     &   1.9781E-07, 1.8701E-07, 1.7651E-07, 1.6631E-07, 1.5642E-07,
     &   1.4683E-07, 1.3754E-07, 1.2856E-07, 1.1988E-07, 1.1150E-07,
     &   1.0343E-07, 9.5655E-08, 8.8189E-08, 8.1025E-08, 7.4165E-08,
     &   6.7609E-08, 6.1355E-08, 5.5405E-08, 4.9759E-08, 4.4416E-08,
     &   3.9376E-08, 3.4640E-08, 3.0207E-08, 2.6077E-08, 2.2251E-08,
     &   1.8728E-08, 1.8393E-08, 1.8060E-08, 1.7731E-08, 1.7404E-08,
     &   1.7081E-08, 1.6760E-08, 1.6443E-08, 1.6128E-08, 1.5817E-08,
     &   1.5509E-08, 1.5204E-08, 1.4901E-08, 1.4602E-08, 1.4306E-08,
     &   1.4013E-08, 1.3723E-08, 1.3436E-08, 1.3152E-08, 1.2871E-08/
  
         DATA ((DGT  (I,J), I= 601, 700), J=1,1) /
     &   1.2593E-08, 1.2318E-08, 1.2046E-08, 1.1777E-08, 1.1511E-08,
     &   1.1249E-08, 1.0989E-08, 1.0732E-08, 1.0479E-08, 1.0228E-08,
     &   9.9803E-09, 9.7357E-09, 9.4942E-09, 9.2557E-09, 9.0202E-09,
     &   8.7878E-09, 8.5584E-09, 8.3320E-09, 8.1087E-09, 7.8884E-09,
     &   7.6711E-09, 7.4569E-09, 7.2457E-09, 7.0375E-09, 6.8324E-09,
     &   6.6303E-09, 6.4312E-09, 6.2352E-09, 6.0422E-09, 5.8522E-09,
     &   5.6653E-09, 5.4814E-09, 5.3005E-09, 5.1227E-09, 4.9479E-09,
     &   4.7762E-09, 4.6075E-09, 4.4418E-09, 4.2791E-09, 4.1195E-09,
     &   3.9629E-09, 3.8093E-09, 3.6588E-09, 3.5113E-09, 3.3669E-09,
     &   3.2255E-09, 3.0871E-09, 2.9517E-09, 2.8194E-09, 2.6901E-09,
     &   2.5639E-09, 2.4407E-09, 2.3205E-09, 2.2034E-09, 2.0893E-09,
     &   1.9782E-09, 1.8701E-09, 1.7651E-09, 1.6631E-09, 1.5642E-09,
     &   1.4683E-09, 1.3754E-09, 1.2856E-09, 1.1988E-09, 1.1150E-09,
     &   1.0343E-09, 9.5656E-10, 8.8190E-10, 8.1026E-10, 7.4166E-10,
     &   6.7609E-10, 6.1356E-10, 5.5406E-10, 4.9759E-10, 4.4416E-10,
     &   3.9376E-10, 3.4640E-10, 3.0207E-10, 2.6077E-10, 2.2251E-10,
     &   1.8728E-10, 1.8393E-10, 1.8060E-10, 1.7731E-10, 1.7404E-10,
     &   1.7081E-10, 1.6760E-10, 1.6443E-10, 1.6128E-10, 1.5817E-10,
     &   1.5509E-10, 1.5204E-10, 1.4901E-10, 1.4602E-10, 1.4306E-10,
     &   1.4013E-10, 1.3723E-10, 1.3436E-10, 1.3152E-10, 1.2871E-10/
  
         DATA ((DGT  (I,J), I= 701, 800), J=1,1) /
     &   1.2593E-10, 1.2318E-10, 1.2046E-10, 1.1777E-10, 1.1511E-10,
     &   1.1249E-10, 1.0989E-10, 1.0732E-10, 1.0479E-10, 1.0228E-10,
     &   9.9803E-11, 9.7357E-11, 9.4942E-11, 9.2557E-11, 9.0202E-11,
     &   8.7878E-11, 8.5584E-11, 8.3320E-11, 8.1087E-11, 7.8884E-11,
     &   7.6711E-11, 7.4569E-11, 7.2457E-11, 7.0375E-11, 6.8324E-11,
     &   6.6303E-11, 6.4312E-11, 6.2352E-11, 6.0422E-11, 5.8522E-11,
     &   5.6653E-11, 5.4814E-11, 5.3005E-11, 5.1227E-11, 4.9479E-11,
     &   4.7762E-11, 4.6075E-11, 4.4418E-11, 4.2791E-11, 4.1195E-11,
     &   3.9629E-11, 3.8093E-11, 3.6588E-11, 3.5113E-11, 3.3669E-11,
     &   3.2255E-11, 3.0871E-11, 2.9517E-11, 2.8194E-11, 2.6901E-11,
     &   2.5639E-11, 2.4407E-11, 2.3205E-11, 2.2034E-11, 2.0893E-11,
     &   1.9782E-11, 1.8701E-11, 1.7651E-11, 1.6631E-11, 1.5642E-11,
     &   1.4683E-11, 1.3754E-11, 1.2856E-11, 1.1988E-11, 1.1150E-11,
     &   1.0343E-11, 9.5656E-12, 8.8190E-12, 8.1026E-12, 7.4166E-12,
     &   6.7609E-12, 6.1356E-12, 5.5406E-12, 4.9759E-12, 4.4416E-12,
     &   3.9376E-12, 3.4640E-12, 3.0207E-12, 2.6077E-12, 2.2251E-12,
     &   1.8728E-12, 1.8393E-12, 1.8060E-12, 1.7731E-12, 1.7404E-12,
     &   1.7081E-12, 1.6760E-12, 1.6443E-12, 1.6128E-12, 1.5817E-12,
     &   1.5509E-12, 1.5204E-12, 1.4901E-12, 1.4602E-12, 1.4306E-12,
     &   1.4013E-12, 1.3723E-12, 1.3436E-12, 1.3152E-12, 1.2871E-12/
  
         DATA ((DGT  (I,J), I= 801, 900), J=1,1) /
     &   1.2593E-12, 1.2318E-12, 1.2046E-12, 1.1777E-12, 1.1511E-12,
     &   1.1249E-12, 1.0989E-12, 1.0732E-12, 1.0479E-12, 1.0228E-12,
     &   9.9803E-13, 9.7357E-13, 9.4942E-13, 9.2557E-13, 9.0202E-13,
     &   8.7878E-13, 8.5584E-13, 8.3320E-13, 8.1087E-13, 7.8884E-13,
     &   7.6711E-13, 7.4569E-13, 7.2457E-13, 7.0375E-13, 6.8324E-13,
     &   6.6303E-13, 6.4312E-13, 6.2352E-13, 6.0422E-13, 5.8522E-13,
     &   5.6653E-13, 5.4814E-13, 5.3005E-13, 5.1227E-13, 4.9479E-13,
     &   4.7762E-13, 4.6075E-13, 4.4418E-13, 4.2791E-13, 4.1195E-13,
     &   3.9629E-13, 3.8093E-13, 3.6588E-13, 3.5113E-13, 3.3669E-13,
     &   3.2255E-13, 3.0871E-13, 2.9517E-13, 2.8194E-13, 2.6901E-13,
     &   2.5639E-13, 2.4407E-13, 2.3205E-13, 2.2034E-13, 2.0893E-13,
     &   1.9782E-13, 1.8701E-13, 1.7651E-13, 1.6631E-13, 1.5642E-13,
     &   1.4683E-13, 1.3754E-13, 1.2856E-13, 1.1988E-13, 1.1150E-13,
     &   1.0343E-13, 9.5656E-14, 8.8190E-14, 8.1026E-14, 7.4166E-14,
     &   6.7609E-14, 6.1356E-14, 5.5406E-14, 4.9759E-14, 4.4416E-14,
     &   3.9376E-14, 3.4640E-14, 3.0207E-14, 2.6077E-14, 2.2251E-14,
     &   1.8728E-14, 0.0000E+00,-1.8728E-14,-1.6867E-07,-6.7449E-07,
     &  -1.5176E-06,-2.6977E-06,-4.2159E-06,-6.0722E-06,-8.2669E-06,
     &  -1.0801E-05,-1.3674E-05,-1.6888E-05,-2.0443E-05,-2.4339E-05,
     &  -2.8579E-05,-3.3162E-05,-3.8090E-05,-4.3363E-05,-4.8985E-05/
  
         DATA ((DGT  (I,J), I= 901, 979), J=1,1) /
     &  -5.4954E-05,-6.1274E-05,-6.7946E-05,-7.4970E-05,-8.2349E-05,
     &  -9.0085E-05,-9.8180E-05,-1.0664E-04,-1.1545E-04,-1.2464E-04,
     &  -1.3419E-04,-1.4410E-04,-1.5440E-04,-1.6506E-04,-1.7610E-04,
     &  -1.8753E-04,-1.9934E-04,-2.1153E-04,-2.2411E-04,-2.3709E-04,
     &  -2.5046E-04,-2.6424E-04,-2.7841E-04,-2.9300E-04,-3.0800E-04,
     &  -3.2341E-04,-3.3925E-04,-3.5551E-04,-3.7221E-04,-3.8934E-04,
     &  -4.0691E-04,-4.2493E-04,-4.4340E-04,-4.6233E-04,-4.8172E-04,
     &  -5.0159E-04,-5.2193E-04,-5.4277E-04,-5.6409E-04,-5.8591E-04,
     &  -6.0825E-04,-6.3110E-04,-6.5448E-04,-6.7839E-04,-7.0285E-04,
     &  -7.2787E-04,-7.5345E-04,-7.7962E-04,-8.0638E-04,-8.3374E-04,
     &  -8.6172E-04,-8.9033E-04,-9.1959E-04,-9.4952E-04,-9.8013E-04,
     &  -1.0114E-03,-1.0435E-03,-1.0763E-03,-1.1098E-03,-1.1442E-03,
     &  -1.1794E-03,-1.2154E-03,-1.2524E-03,-1.2902E-03,-1.3291E-03,
     &  -1.3690E-03,-1.4100E-03,-1.4522E-03,-1.4956E-03,-1.5405E-03,
     &  -1.5868E-03,-1.6349E-03,-1.6850E-03,-1.7022E-03,-1.7376E-03,
     &  -1.75030722E-03,-1.79360606E-03,-1.79947037E-03,-1.81340962E-03/
  
         DATA ((DGT  (I,J), I=   1, 100), J=2,2) /
     &   3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04,
     &   3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2754E-04,
     &   3.2754E-04, 3.2754E-04, 3.2754E-04, 3.2753E-04, 3.2753E-04,
     &   3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04,
     &   3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2753E-04, 3.2752E-04,
     &   3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2752E-04,
     &   3.2752E-04, 3.2752E-04, 3.2752E-04, 3.2751E-04, 3.2751E-04,
     &   3.2751E-04, 3.2751E-04, 3.2751E-04, 3.2751E-04, 3.2751E-04,
     &   3.2751E-04, 3.2750E-04, 3.2750E-04, 3.2750E-04, 3.2750E-04,
     &   3.2750E-04, 3.2750E-04, 3.2749E-04, 3.2749E-04, 3.2749E-04,
     &   3.2749E-04, 3.2749E-04, 3.2749E-04, 3.2748E-04, 3.2748E-04,
     &   3.2748E-04, 3.2748E-04, 3.2747E-04, 3.2747E-04, 3.2747E-04,
     &   3.2747E-04, 3.2746E-04, 3.2746E-04, 3.2746E-04, 3.2745E-04,
     &   3.2745E-04, 3.2745E-04, 3.2744E-04, 3.2744E-04, 3.2743E-04,
     &   3.2743E-04, 3.2742E-04, 3.2742E-04, 3.2741E-04, 3.2741E-04,
     &   3.2740E-04, 3.2739E-04, 3.2739E-04, 3.2738E-04, 3.2737E-04,
     &   3.2736E-04, 3.2734E-04, 3.2733E-04, 3.2732E-04, 3.2730E-04,
     &   3.2728E-04, 3.2725E-04, 3.2722E-04, 3.2718E-04, 3.2714E-04,
     &   3.2708E-04, 3.2707E-04, 3.2707E-04, 3.2706E-04, 3.2705E-04,
     &   3.2705E-04, 3.2704E-04, 3.2703E-04, 3.2702E-04, 3.2701E-04/
  
         DATA ((DGT  (I,J), I= 101, 200), J=2,2) /
     &   3.2700E-04, 3.2700E-04, 3.2699E-04, 3.2698E-04, 3.2697E-04,
     &   3.2696E-04, 3.2695E-04, 3.2694E-04, 3.2692E-04, 3.2691E-04,
     &   3.2690E-04, 3.2689E-04, 3.2688E-04, 3.2686E-04, 3.2685E-04,
     &   3.2683E-04, 3.2682E-04, 3.2680E-04, 3.2679E-04, 3.2677E-04,
     &   3.2675E-04, 3.2674E-04, 3.2672E-04, 3.2670E-04, 3.2668E-04,
     &   3.2666E-04, 3.2663E-04, 3.2661E-04, 3.2659E-04, 3.2656E-04,
     &   3.2653E-04, 3.2651E-04, 3.2648E-04, 3.2645E-04, 3.2641E-04,
     &   3.2638E-04, 3.2634E-04, 3.2631E-04, 3.2627E-04, 3.2623E-04,
     &   3.2618E-04, 3.2614E-04, 3.2609E-04, 3.2603E-04, 3.2598E-04,
     &   3.2592E-04, 3.2586E-04, 3.2579E-04, 3.2572E-04, 3.2564E-04,
     &   3.2556E-04, 3.2547E-04, 3.2538E-04, 3.2528E-04, 3.2517E-04,
     &   3.2505E-04, 3.2493E-04, 3.2479E-04, 3.2464E-04, 3.2448E-04,
     &   3.2430E-04, 3.2411E-04, 3.2390E-04, 3.2366E-04, 3.2341E-04,
     &   3.2312E-04, 3.2281E-04, 3.2246E-04, 3.2207E-04, 3.2163E-04,
     &   3.2113E-04, 3.2057E-04, 3.1993E-04, 3.1920E-04, 3.1835E-04,
     &   3.1737E-04, 3.1622E-04, 3.1485E-04, 3.1320E-04, 3.1119E-04,
     &   3.0869E-04, 3.0844E-04, 3.0818E-04, 3.0791E-04, 3.0764E-04,
     &   3.0736E-04, 3.0708E-04, 3.0679E-04, 3.0649E-04, 3.0619E-04,
     &   3.0587E-04, 3.0556E-04, 3.0523E-04, 3.0489E-04, 3.0455E-04,
     &   3.0420E-04, 3.0384E-04, 3.0347E-04, 3.0309E-04, 3.0270E-04/
  
         DATA ((DGT  (I,J), I= 201, 300), J=2,2) /
     &   3.0230E-04, 3.0189E-04, 3.0147E-04, 3.0104E-04, 3.0059E-04,
     &   3.0014E-04, 2.9967E-04, 2.9919E-04, 2.9869E-04, 2.9818E-04,
     &   2.9765E-04, 2.9711E-04, 2.9655E-04, 2.9598E-04, 2.9539E-04,
     &   2.9477E-04, 2.9414E-04, 2.9349E-04, 2.9282E-04, 2.9213E-04,
     &   2.9141E-04, 2.9067E-04, 2.8991E-04, 2.8912E-04, 2.8830E-04,
     &   2.8745E-04, 2.8658E-04, 2.8567E-04, 2.8473E-04, 2.8375E-04,
     &   2.8274E-04, 2.8169E-04, 2.8059E-04, 2.7946E-04, 2.7828E-04,
     &   2.7706E-04, 2.7578E-04, 2.7446E-04, 2.7308E-04, 2.7164E-04,
     &   2.7014E-04, 2.6857E-04, 2.6694E-04, 2.6523E-04, 2.6345E-04,
     &   2.6159E-04, 2.5964E-04, 2.5760E-04, 2.5547E-04, 2.5323E-04,
     &   2.5088E-04, 2.4842E-04, 2.4584E-04, 2.4312E-04, 2.4027E-04,
     &   2.3727E-04, 2.3411E-04, 2.3079E-04, 2.2728E-04, 2.2359E-04,
     &   2.1970E-04, 2.1559E-04, 2.1126E-04, 2.0668E-04, 2.0185E-04,
     &   1.9675E-04, 1.9136E-04, 1.8566E-04, 1.7966E-04, 1.7332E-04,
     &   1.6663E-04, 1.5959E-04, 1.5219E-04, 1.4441E-04, 1.3627E-04,
     &   1.2776E-04, 1.1890E-04, 1.0971E-04, 1.0022E-04, 9.0493E-05,
     &   8.0581E-05, 7.9583E-05, 7.8584E-05, 7.7584E-05, 7.6584E-05,
     &   7.5582E-05, 7.4581E-05, 7.3578E-05, 7.2576E-05, 7.1573E-05,
     &   7.0570E-05, 6.9568E-05, 6.8565E-05, 6.7562E-05, 6.6560E-05,
     &   6.5559E-05, 6.4558E-05, 6.3557E-05, 6.2558E-05, 6.1560E-05/
  
         DATA ((DGT  (I,J), I= 301, 400), J=2,2) /
     &   6.0562E-05, 5.9566E-05, 5.8572E-05, 5.7579E-05, 5.6587E-05,
     &   5.5598E-05, 5.4610E-05, 5.3625E-05, 5.2642E-05, 5.1661E-05,
     &   5.0683E-05, 4.9708E-05, 4.8735E-05, 4.7766E-05, 4.6800E-05,
     &   4.5837E-05, 4.4878E-05, 4.3923E-05, 4.2972E-05, 4.2025E-05,
     &   4.1082E-05, 4.0144E-05, 3.9211E-05, 3.8282E-05, 3.7359E-05,
     &   3.6441E-05, 3.5529E-05, 3.4622E-05, 3.3721E-05, 3.2827E-05,
     &   3.1939E-05, 3.1057E-05, 3.0182E-05, 2.9315E-05, 2.8454E-05,
     &   2.7602E-05, 2.6757E-05, 2.5920E-05, 2.5091E-05, 2.4271E-05,
     &   2.3459E-05, 2.2656E-05, 2.1863E-05, 2.1079E-05, 2.0305E-05,
     &   1.9541E-05, 1.8787E-05, 1.8044E-05, 1.7312E-05, 1.6591E-05,
     &   1.5881E-05, 1.5183E-05, 1.4496E-05, 1.3822E-05, 1.3161E-05,
     &   1.2512E-05, 1.1876E-05, 1.1254E-05, 1.0645E-05, 1.0050E-05,
     &   9.4694E-06, 8.9033E-06, 8.3520E-06, 7.8157E-06, 7.2948E-06,
     &   6.7896E-06, 6.3003E-06, 5.8273E-06, 5.3707E-06, 4.9310E-06,
     &   4.5083E-06, 4.1030E-06, 3.7153E-06, 3.3454E-06, 2.9937E-06,
     &   2.6605E-06, 2.3458E-06, 2.0501E-06, 1.7734E-06, 1.5161E-06,
     &   1.2783E-06, 1.2556E-06, 1.2332E-06, 1.2109E-06, 1.1888E-06,
     &   1.1669E-06, 1.1452E-06, 1.1236E-06, 1.1023E-06, 1.0812E-06,
     &   1.0603E-06, 1.0396E-06, 1.0191E-06, 9.9881E-07, 9.7870E-07,
     &   9.5879E-07, 9.3908E-07, 9.1958E-07, 9.0027E-07, 8.8116E-07/
  
         DATA ((DGT  (I,J), I= 401, 500), J=2,2) /
     &   8.6226E-07, 8.4355E-07, 8.2505E-07, 8.0675E-07, 7.8865E-07,
     &   7.7075E-07, 7.5305E-07, 7.3556E-07, 7.1827E-07, 7.0118E-07,
     &   6.8429E-07, 6.6761E-07, 6.5113E-07, 6.3485E-07, 6.1877E-07,
     &   6.0290E-07, 5.8723E-07, 5.7177E-07, 5.5651E-07, 5.4145E-07,
     &   5.2660E-07, 5.1195E-07, 4.9750E-07, 4.8326E-07, 4.6923E-07,
     &   4.5540E-07, 4.4177E-07, 4.2835E-07, 4.1513E-07, 4.0212E-07,
     &   3.8932E-07, 3.7671E-07, 3.6432E-07, 3.5213E-07, 3.4015E-07,
     &   3.2837E-07, 3.1680E-07, 3.0543E-07, 2.9427E-07, 2.8332E-07,
     &   2.7257E-07, 2.6203E-07, 2.5170E-07, 2.4157E-07, 2.3165E-07,
     &   2.2194E-07, 2.1243E-07, 2.0313E-07, 1.9404E-07, 1.8516E-07,
     &   1.7648E-07, 1.6801E-07, 1.5975E-07, 1.5169E-07, 1.4384E-07,
     &   1.3620E-07, 1.2877E-07, 1.2155E-07, 1.1453E-07, 1.0772E-07,
     &   1.0112E-07, 9.4733E-08, 8.8550E-08, 8.2574E-08, 7.6807E-08,
     &   7.1249E-08, 6.5899E-08, 6.0757E-08, 5.5824E-08, 5.1099E-08,
     &   4.6584E-08, 4.2276E-08, 3.8178E-08, 3.4288E-08, 3.0607E-08,
     &   2.7135E-08, 2.3871E-08, 2.0817E-08, 1.7972E-08, 1.5335E-08,
     &   1.2907E-08, 1.2676E-08, 1.2447E-08, 1.2220E-08, 1.1995E-08,
     &   1.1772E-08, 1.1551E-08, 1.1332E-08, 1.1116E-08, 1.0901E-08,
     &   1.0689E-08, 1.0478E-08, 1.0270E-08, 1.0064E-08, 9.8599E-09,
     &   9.6579E-09, 9.4580E-09, 9.2601E-09, 9.0644E-09, 8.8708E-09/
  
         DATA ((DGT  (I,J), I= 501, 600), J=2,2) /
     &   8.6792E-09, 8.4898E-09, 8.3024E-09, 8.1171E-09, 7.9339E-09,
     &   7.7528E-09, 7.5738E-09, 7.3969E-09, 7.2221E-09, 7.0493E-09,
     &   6.8787E-09, 6.7101E-09, 6.5437E-09, 6.3793E-09, 6.2170E-09,
     &   6.0568E-09, 5.8987E-09, 5.7427E-09, 5.5888E-09, 5.4369E-09,
     &   5.2872E-09, 5.1395E-09, 4.9940E-09, 4.8505E-09, 4.7091E-09,
     &   4.5698E-09, 4.4326E-09, 4.2975E-09, 4.1645E-09, 4.0336E-09,
     &   3.9048E-09, 3.7780E-09, 3.6534E-09, 3.5308E-09, 3.4103E-09,
     &   3.2920E-09, 3.1757E-09, 3.0615E-09, 2.9494E-09, 2.8393E-09,
     &   2.7314E-09, 2.6256E-09, 2.5218E-09, 2.4202E-09, 2.3206E-09,
     &   2.2232E-09, 2.1278E-09, 2.0345E-09, 1.9433E-09, 1.8542E-09,
     &   1.7672E-09, 1.6823E-09, 1.5994E-09, 1.5187E-09, 1.4400E-09,
     &   1.3635E-09, 1.2890E-09, 1.2166E-09, 1.1463E-09, 1.0781E-09,
     &   1.0120E-09, 9.4802E-10, 8.8610E-10, 8.2627E-10, 7.6853E-10,
     &   7.1288E-10, 6.5932E-10, 6.0785E-10, 5.5848E-10, 5.1120E-10,
     &   4.6600E-10, 4.2290E-10, 3.8189E-10, 3.4297E-10, 3.0614E-10,
     &   2.7140E-10, 2.3876E-10, 2.0820E-10, 1.7974E-10, 1.5337E-10,
     &   1.2909E-10, 1.2677E-10, 1.2448E-10, 1.2221E-10, 1.1996E-10,
     &   1.1773E-10, 1.1552E-10, 1.1333E-10, 1.1117E-10, 1.0902E-10,
     &   1.0690E-10, 1.0479E-10, 1.0271E-10, 1.0065E-10, 9.8606E-11,
     &   9.6586E-11, 9.4587E-11, 9.2608E-11, 9.0650E-11, 8.8714E-11/
  
         DATA ((DGT  (I,J), I= 601, 700), J=2,2) /
     &   8.6798E-11, 8.4903E-11, 8.3029E-11, 8.1176E-11, 7.9344E-11,
     &   7.7533E-11, 7.5742E-11, 7.3973E-11, 7.2225E-11, 7.0497E-11,
     &   6.8790E-11, 6.7105E-11, 6.5440E-11, 6.3796E-11, 6.2173E-11,
     &   6.0571E-11, 5.8990E-11, 5.7429E-11, 5.5890E-11, 5.4372E-11,
     &   5.2874E-11, 5.1397E-11, 4.9942E-11, 4.8507E-11, 4.7093E-11,
     &   4.5700E-11, 4.4328E-11, 4.2977E-11, 4.1647E-11, 4.0337E-11,
     &   3.9049E-11, 3.7781E-11, 3.6535E-11, 3.5309E-11, 3.4104E-11,
     &   3.2920E-11, 3.1757E-11, 3.0615E-11, 2.9494E-11, 2.8394E-11,
     &   2.7315E-11, 2.6256E-11, 2.5219E-11, 2.4202E-11, 2.3207E-11,
     &   2.2232E-11, 2.1278E-11, 2.0345E-11, 1.9433E-11, 1.8542E-11,
     &   1.7672E-11, 1.6823E-11, 1.5994E-11, 1.5187E-11, 1.4400E-11,
     &   1.3635E-11, 1.2890E-11, 1.2166E-11, 1.1463E-11, 1.0781E-11,
     &   1.0120E-11, 9.4803E-12, 8.8610E-12, 8.2627E-12, 7.6853E-12,
     &   7.1288E-12, 6.5932E-12, 6.0786E-12, 5.5848E-12, 5.1120E-12,
     &   4.6600E-12, 4.2290E-12, 3.8189E-12, 3.4297E-12, 3.0614E-12,
     &   2.7141E-12, 2.3876E-12, 2.0820E-12, 1.7974E-12, 1.5337E-12,
     &   1.2909E-12, 1.2677E-12, 1.2448E-12, 1.2221E-12, 1.1996E-12,
     &   1.1773E-12, 1.1552E-12, 1.1333E-12, 1.1117E-12, 1.0902E-12,
     &   1.0690E-12, 1.0479E-12, 1.0271E-12, 1.0065E-12, 9.8606E-13,
     &   9.6586E-13, 9.4587E-13, 9.2608E-13, 9.0651E-13, 8.8714E-13/
  
         DATA ((DGT  (I,J), I= 701, 800), J=2,2) /
     &   8.6798E-13, 8.4903E-13, 8.3029E-13, 8.1176E-13, 7.9344E-13,
     &   7.7533E-13, 7.5743E-13, 7.3973E-13, 7.2225E-13, 7.0497E-13,
     &   6.8790E-13, 6.7105E-13, 6.5440E-13, 6.3796E-13, 6.2173E-13,
     &   6.0571E-13, 5.8990E-13, 5.7429E-13, 5.5890E-13, 5.4372E-13,
     &   5.2874E-13, 5.1397E-13, 4.9942E-13, 4.8507E-13, 4.7093E-13,
     &   4.5700E-13, 4.4328E-13, 4.2977E-13, 4.1647E-13, 4.0337E-13,
     &   3.9049E-13, 3.7781E-13, 3.6535E-13, 3.5309E-13, 3.4104E-13,
     &   3.2920E-13, 3.1757E-13, 3.0615E-13, 2.9494E-13, 2.8394E-13,
     &   2.7315E-13, 2.6256E-13, 2.5219E-13, 2.4202E-13, 2.3207E-13,
     &   2.2232E-13, 2.1278E-13, 2.0345E-13, 1.9433E-13, 1.8542E-13,
     &   1.7672E-13, 1.6823E-13, 1.5994E-13, 1.5187E-13, 1.4400E-13,
     &   1.3635E-13, 1.2890E-13, 1.2166E-13, 1.1463E-13, 1.0781E-13,
     &   1.0120E-13, 9.4803E-14, 8.8610E-14, 8.2627E-14, 7.6853E-14,
     &   7.1288E-14, 6.5932E-14, 6.0786E-14, 5.5848E-14, 5.1120E-14,
     &   4.6600E-14, 4.2290E-14, 3.8189E-14, 3.4297E-14, 3.0614E-14,
     &   2.7141E-14, 2.3876E-14, 2.0820E-14, 1.7974E-14, 1.5337E-14,
     &   1.2909E-14, 1.2677E-14, 1.2448E-14, 1.2221E-14, 1.1996E-14,
     &   1.1773E-14, 1.1552E-14, 1.1333E-14, 1.1117E-14, 1.0902E-14,
     &   1.0690E-14, 1.0479E-14, 1.0271E-14, 1.0065E-14, 9.8606E-15,
     &   9.6586E-15, 9.4587E-15, 9.2608E-15, 9.0650E-15, 8.8714E-15/
  
         DATA ((DGT  (I,J), I= 801, 900), J=2,2) /
     &   8.6798E-15, 8.4903E-15, 8.3029E-15, 8.1176E-15, 7.9344E-15,
     &   7.7533E-15, 7.5743E-15, 7.3973E-15, 7.2225E-15, 7.0497E-15,
     &   6.8790E-15, 6.7105E-15, 6.5440E-15, 6.3796E-15, 6.2173E-15,
     &   6.0571E-15, 5.8990E-15, 5.7429E-15, 5.5890E-15, 5.4372E-15,
     &   5.2874E-15, 5.1397E-15, 4.9942E-15, 4.8507E-15, 4.7093E-15,
     &   4.5700E-15, 4.4328E-15, 4.2977E-15, 4.1647E-15, 4.0337E-15,
     &   3.9049E-15, 3.7781E-15, 3.6535E-15, 3.5309E-15, 3.4104E-15,
     &   3.2920E-15, 3.1757E-15, 3.0615E-15, 2.9494E-15, 2.8394E-15,
     &   2.7315E-15, 2.6256E-15, 2.5219E-15, 2.4202E-15, 2.3207E-15,
     &   2.2232E-15, 2.1278E-15, 2.0345E-15, 1.9433E-15, 1.8542E-15,
     &   1.7672E-15, 1.6823E-15, 1.5994E-15, 1.5187E-15, 1.4400E-15,
     &   1.3635E-15, 1.2890E-15, 1.2166E-15, 1.1463E-15, 1.0781E-15,
     &   1.0120E-15, 9.4803E-16, 8.8610E-16, 8.2627E-16, 7.6853E-16,
     &   7.1288E-16, 6.5932E-16, 6.0786E-16, 5.5848E-16, 5.1120E-16,
     &   4.6600E-16, 4.2290E-16, 3.8189E-16, 3.4297E-16, 3.0614E-16,
     &   2.7141E-16, 2.3876E-16, 2.0820E-16, 1.7974E-16, 1.5337E-16,
     &   1.2909E-16, 0.0000E+00, 1.2909E-16, 1.1626E-09, 4.6488E-09,
     &   1.0459E-08, 1.8591E-08, 2.9051E-08, 4.1838E-08, 5.6953E-08,
     &   7.4397E-08, 9.4173E-08, 1.1628E-07, 1.4073E-07, 1.6752E-07,
     &   1.9664E-07, 2.2811E-07, 2.6194E-07, 2.9811E-07, 3.3664E-07/
  
         DATA ((DGT  (I,J), I= 901, 979), J=2,2) /
     &   3.7753E-07, 4.2079E-07, 4.6641E-07, 5.1441E-07, 5.6480E-07,
     &   6.1757E-07, 6.7273E-07, 7.3029E-07, 7.9026E-07, 8.5264E-07,
     &   9.1745E-07, 9.8468E-07, 1.0543E-06, 1.1265E-06, 1.2010E-06,
     &   1.2781E-06, 1.3576E-06, 1.4396E-06, 1.5240E-06, 1.6110E-06,
     &   1.7005E-06, 1.7926E-06, 1.8872E-06, 1.9843E-06, 2.0840E-06,
     &   2.1863E-06, 2.2912E-06, 2.3987E-06, 2.5088E-06, 2.6216E-06,
     &   2.7370E-06, 2.8552E-06, 2.9760E-06, 3.0996E-06, 3.2259E-06,
     &   3.3549E-06, 3.4868E-06, 3.6215E-06, 3.7590E-06, 3.8994E-06,
     &   4.0427E-06, 4.1889E-06, 4.3380E-06, 4.4902E-06, 4.6454E-06,
     &   4.8037E-06, 4.9651E-06, 5.1296E-06, 5.2973E-06, 5.4683E-06,
     &   5.6426E-06, 5.8202E-06, 6.0013E-06, 6.1859E-06, 6.3740E-06,
     &   6.5658E-06, 6.7613E-06, 6.9606E-06, 7.1639E-06, 7.3713E-06,
     &   7.5829E-06, 7.7989E-06, 8.0194E-06, 8.2447E-06, 8.4750E-06,
     &   8.7106E-06, 8.9519E-06, 9.1993E-06, 9.4533E-06, 9.7148E-06,
     &   9.9846E-06, 1.0264E-05, 1.0556E-05, 1.0656E-05, 1.0863E-05,
     &   1.09378163E-05, 1.11941661E-05, 1.12292334E-05, 1.13130985E-05/


c      ++++ dalhadthigh16 ++++  

c updated dec 2016
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 12:52:52 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (XXX  (I), I=   1, 100) /
     &  -2.0000E+04,-1.9701E+04,-1.9407E+04,-1.9117E+04,-1.8831E+04,
     &  -1.8550E+04,-1.8273E+04,-1.8000E+04,-1.7731E+04,-1.7466E+04,
     &  -1.7205E+04,-1.6948E+04,-1.6695E+04,-1.6445E+04,-1.6199E+04,
     &  -1.5957E+04,-1.5719E+04,-1.5484E+04,-1.5253E+04,-1.5025E+04,
     &  -1.4800E+04,-1.4579E+04,-1.4361E+04,-1.4147E+04,-1.3935E+04,
     &  -1.3727E+04,-1.3522E+04,-1.3320E+04,-1.3121E+04,-1.2925E+04,
     &  -1.2732E+04,-1.2542E+04,-1.2354E+04,-1.2170E+04,-1.1988E+04,
     &  -1.1809E+04,-1.1632E+04,-1.1459E+04,-1.1287E+04,-1.1119E+04,
     &  -1.0953E+04,-1.0789E+04,-1.0628E+04,-1.0469E+04,-1.0313E+04,
     &  -1.0158E+04,-1.0007E+04,-9.8572E+03,-9.7099E+03,-9.5648E+03,
     &  -9.4219E+03,-9.2811E+03,-9.1424E+03,-9.0058E+03,-8.8713E+03,
     &  -8.7387E+03,-8.6082E+03,-8.4796E+03,-8.3529E+03,-8.2281E+03,
     &  -8.1051E+03,-7.9840E+03,-7.8647E+03,-7.7472E+03,-7.6315E+03,
     &  -7.5174E+03,-7.4051E+03,-7.2945E+03,-7.1855E+03,-7.0781E+03,
     &  -6.9724E+03,-6.8682E+03,-6.7656E+03,-6.6645E+03,-6.5649E+03,
     &  -6.4668E+03,-6.3702E+03,-6.2750E+03,-6.1813E+03,-6.0889E+03,
     &  -5.9980E+03,-5.9083E+03,-5.8201E+03,-5.7331E+03,-5.6474E+03,
     &  -5.5631E+03,-5.4799E+03,-5.3981E+03,-5.3174E+03,-5.2380E+03,
     &  -5.1597E+03,-5.0826E+03,-5.0067E+03,-4.9319E+03,-4.8582E+03,
     &  -4.7856E+03,-4.7141E+03,-4.6437E+03,-4.5743E+03,-4.5059E+03/
  
       DATA  (XXX  (I), I= 101, 200) /
     &  -4.4386E+03,-4.3723E+03,-4.3070E+03,-4.2426E+03,-4.1792E+03,
     &  -4.1168E+03,-4.0553E+03,-3.9947E+03,-3.9350E+03,-3.8762E+03,
     &  -3.8183E+03,-3.7612E+03,-3.7050E+03,-3.6497E+03,-3.5951E+03,
     &  -3.5414E+03,-3.4885E+03,-3.4364E+03,-3.3850E+03,-3.3345E+03,
     &  -3.2847E+03,-3.2356E+03,-3.1872E+03,-3.1396E+03,-3.0927E+03,
     &  -3.0465E+03,-3.0010E+03,-2.9561E+03,-2.9120E+03,-2.8685E+03,
     &  -2.8256E+03,-2.7834E+03,-2.7418E+03,-2.7008E+03,-2.6605E+03,
     &  -2.6207E+03,-2.5816E+03,-2.5430E+03,-2.5050E+03,-2.4676E+03,
     &  -2.4307E+03,-2.3944E+03,-2.3586E+03,-2.3234E+03,-2.2887E+03,
     &  -2.2545E+03,-2.2208E+03,-2.1876E+03,-2.1549E+03,-2.1227E+03,
     &  -2.0910E+03,-2.0598E+03,-2.0290E+03,-1.9987E+03,-1.9688E+03,
     &  -1.9394E+03,-1.9104E+03,-1.8819E+03,-1.8538E+03,-1.8261E+03,
     &  -1.7988E+03,-1.7719E+03,-1.7454E+03,-1.7193E+03,-1.6937E+03,
     &  -1.6683E+03,-1.6434E+03,-1.6189E+03,-1.5947E+03,-1.5709E+03,
     &  -1.5474E+03,-1.5243E+03,-1.5015E+03,-1.4791E+03,-1.4570E+03,
     &  -1.4352E+03,-1.4137E+03,-1.3926E+03,-1.3718E+03,-1.3513E+03,
     &  -1.3311E+03,-1.3112E+03,-1.2916E+03,-1.2723E+03,-1.2533E+03,
     &  -1.2346E+03,-1.2162E+03,-1.1980E+03,-1.1801E+03,-1.1625E+03,
     &  -1.1451E+03,-1.1280E+03,-1.1111E+03,-1.0945E+03,-1.0782E+03,
     &  -1.0621E+03,-1.0462E+03,-1.0306E+03,-1.0152E+03,-1.0000E+03/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=1,1) /
     &   5.7078E-02, 5.6991E-02, 5.6905E-02, 5.6818E-02, 5.6732E-02,
     &   5.6645E-02, 5.6559E-02, 5.6473E-02, 5.6386E-02, 5.6300E-02,
     &   5.6214E-02, 5.6127E-02, 5.6041E-02, 5.5955E-02, 5.5869E-02,
     &   5.5782E-02, 5.5696E-02, 5.5610E-02, 5.5524E-02, 5.5438E-02,
     &   5.5352E-02, 5.5266E-02, 5.5180E-02, 5.5094E-02, 5.5008E-02,
     &   5.4923E-02, 5.4837E-02, 5.4751E-02, 5.4665E-02, 5.4579E-02,
     &   5.4494E-02, 5.4408E-02, 5.4323E-02, 5.4237E-02, 5.4151E-02,
     &   5.4066E-02, 5.3981E-02, 5.3895E-02, 5.3810E-02, 5.3725E-02,
     &   5.3639E-02, 5.3554E-02, 5.3469E-02, 5.3384E-02, 5.3299E-02,
     &   5.3214E-02, 5.3129E-02, 5.3044E-02, 5.2959E-02, 5.2874E-02,
     &   5.2790E-02, 5.2705E-02, 5.2620E-02, 5.2536E-02, 5.2451E-02,
     &   5.2367E-02, 5.2282E-02, 5.2198E-02, 5.2114E-02, 5.2029E-02,
     &   5.1945E-02, 5.1861E-02, 5.1777E-02, 5.1693E-02, 5.1609E-02,
     &   5.1526E-02, 5.1442E-02, 5.1358E-02, 5.1275E-02, 5.1191E-02,
     &   5.1108E-02, 5.1024E-02, 5.0941E-02, 5.0858E-02, 5.0775E-02,
     &   5.0692E-02, 5.0609E-02, 5.0526E-02, 5.0443E-02, 5.0361E-02,
     &   5.0278E-02, 5.0195E-02, 5.0113E-02, 5.0031E-02, 4.9948E-02,
     &   4.9866E-02, 4.9784E-02, 4.9702E-02, 4.9620E-02, 4.9539E-02,
     &   4.9457E-02, 4.9375E-02, 4.9294E-02, 4.9212E-02, 4.9131E-02,
     &   4.9050E-02, 4.8969E-02, 4.8888E-02, 4.8807E-02, 4.8726E-02/
  
         DATA ((YGG  (I,J), I= 101, 200), J=1,1) /
     &   4.8646E-02, 4.8565E-02, 4.8485E-02, 4.8404E-02, 4.8324E-02,
     &   4.8244E-02, 4.8164E-02, 4.8084E-02, 4.8004E-02, 4.7924E-02,
     &   4.7845E-02, 4.7765E-02, 4.7686E-02, 4.7607E-02, 4.7527E-02,
     &   4.7448E-02, 4.7370E-02, 4.7291E-02, 4.7212E-02, 4.7133E-02,
     &   4.7055E-02, 4.6977E-02, 4.6898E-02, 4.6820E-02, 4.6742E-02,
     &   4.6664E-02, 4.6586E-02, 4.6508E-02, 4.6431E-02, 4.6353E-02,
     &   4.6276E-02, 4.6199E-02, 4.6121E-02, 4.6044E-02, 4.5967E-02,
     &   4.5890E-02, 4.5813E-02, 4.5737E-02, 4.5660E-02, 4.5583E-02,
     &   4.5507E-02, 4.5431E-02, 4.5354E-02, 4.5278E-02, 4.5202E-02,
     &   4.5126E-02, 4.5050E-02, 4.4974E-02, 4.4898E-02, 4.4822E-02,
     &   4.4747E-02, 4.4671E-02, 4.4595E-02, 4.4520E-02, 4.4444E-02,
     &   4.4369E-02, 4.4293E-02, 4.4218E-02, 4.4143E-02, 4.4068E-02,
     &   4.3992E-02, 4.3917E-02, 4.3842E-02, 4.3767E-02, 4.3692E-02,
     &   4.3616E-02, 4.3541E-02, 4.3466E-02, 4.3391E-02, 4.3316E-02,
     &   4.3241E-02, 4.3166E-02, 4.3090E-02, 4.3015E-02, 4.2940E-02,
     &   4.2865E-02, 4.2790E-02, 4.2714E-02, 4.2639E-02, 4.2564E-02,
     &   4.2488E-02, 4.2413E-02, 4.2337E-02, 4.2262E-02, 4.2186E-02,
     &   4.2110E-02, 4.2034E-02, 4.1959E-02, 4.1883E-02, 4.1807E-02,
     &   4.1730E-02, 4.1654E-02, 4.1578E-02, 4.1502E-02, 4.1425E-02,
     &   4.1349E-02, 4.1272E-02, 4.1195E-02, 4.1118E-02, 4.1041E-02/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=2,2) /
     &   1.2076E-04, 1.2076E-04, 1.2076E-04, 1.2076E-04, 1.2075E-04,
     &   1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04,
     &   1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04,
     &   1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04,
     &   1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04, 1.2075E-04,
     &   1.2075E-04, 1.2075E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04,
     &   1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04,
     &   1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04,
     &   1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04,
     &   1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04, 1.2074E-04,
     &   1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04,
     &   1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04,
     &   1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04,
     &   1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04, 1.2073E-04,
     &   1.2073E-04, 1.2073E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04,
     &   1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04,
     &   1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04,
     &   1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2072E-04,
     &   1.2072E-04, 1.2072E-04, 1.2072E-04, 1.2071E-04, 1.2071E-04,
     &   1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04/
  
         DATA ((YGG  (I,J), I= 101, 200), J=2,2) /
     &   1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04,
     &   1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04,
     &   1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04, 1.2071E-04,
     &   1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04,
     &   1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04,
     &   1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04,
     &   1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04, 1.2070E-04,
     &   1.2070E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04,
     &   1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04,
     &   1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04,
     &   1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04, 1.2069E-04,
     &   1.2069E-04, 1.2069E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04, 1.2068E-04,
     &   1.2068E-04, 1.2068E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04, 1.2067E-04,
     &   1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04, 1.2066E-04/
  

c      ++++ deghadthigh16 ++++  

c updated dec 2016
c 
c******************************************************************************
c*                                                                            *
c*    --- intRdat1 ---                              Tue Dec 27 16:23:16 2016  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
c 
c  "Delta alpha"               Update version (29/09/2015) 
c 
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    173.20
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail:  0, sin2W:   0.23153
c CHPTCUT,EC,ECUT: 0.3180,     5.20,    11.50
c 
  
       DATA  (XXX  (I), I=   1, 100) /
     &  -2.0000E+04,-1.9701E+04,-1.9407E+04,-1.9117E+04,-1.8831E+04,
     &  -1.8550E+04,-1.8273E+04,-1.8000E+04,-1.7731E+04,-1.7466E+04,
     &  -1.7205E+04,-1.6948E+04,-1.6695E+04,-1.6445E+04,-1.6199E+04,
     &  -1.5957E+04,-1.5719E+04,-1.5484E+04,-1.5253E+04,-1.5025E+04,
     &  -1.4800E+04,-1.4579E+04,-1.4361E+04,-1.4147E+04,-1.3935E+04,
     &  -1.3727E+04,-1.3522E+04,-1.3320E+04,-1.3121E+04,-1.2925E+04,
     &  -1.2732E+04,-1.2542E+04,-1.2354E+04,-1.2170E+04,-1.1988E+04,
     &  -1.1809E+04,-1.1632E+04,-1.1459E+04,-1.1287E+04,-1.1119E+04,
     &  -1.0953E+04,-1.0789E+04,-1.0628E+04,-1.0469E+04,-1.0313E+04,
     &  -1.0158E+04,-1.0007E+04,-9.8572E+03,-9.7099E+03,-9.5648E+03,
     &  -9.4219E+03,-9.2811E+03,-9.1424E+03,-9.0058E+03,-8.8713E+03,
     &  -8.7387E+03,-8.6082E+03,-8.4796E+03,-8.3529E+03,-8.2281E+03,
     &  -8.1051E+03,-7.9840E+03,-7.8647E+03,-7.7472E+03,-7.6315E+03,
     &  -7.5174E+03,-7.4051E+03,-7.2945E+03,-7.1855E+03,-7.0781E+03,
     &  -6.9724E+03,-6.8682E+03,-6.7656E+03,-6.6645E+03,-6.5649E+03,
     &  -6.4668E+03,-6.3702E+03,-6.2750E+03,-6.1813E+03,-6.0889E+03,
     &  -5.9980E+03,-5.9083E+03,-5.8201E+03,-5.7331E+03,-5.6474E+03,
     &  -5.5631E+03,-5.4799E+03,-5.3981E+03,-5.3174E+03,-5.2380E+03,
     &  -5.1597E+03,-5.0826E+03,-5.0067E+03,-4.9319E+03,-4.8582E+03,
     &  -4.7856E+03,-4.7141E+03,-4.6437E+03,-4.5743E+03,-4.5059E+03/
  
       DATA  (XXX  (I), I= 101, 200) /
     &  -4.4386E+03,-4.3723E+03,-4.3070E+03,-4.2426E+03,-4.1792E+03,
     &  -4.1168E+03,-4.0553E+03,-3.9947E+03,-3.9350E+03,-3.8762E+03,
     &  -3.8183E+03,-3.7612E+03,-3.7050E+03,-3.6497E+03,-3.5951E+03,
     &  -3.5414E+03,-3.4885E+03,-3.4364E+03,-3.3850E+03,-3.3345E+03,
     &  -3.2847E+03,-3.2356E+03,-3.1872E+03,-3.1396E+03,-3.0927E+03,
     &  -3.0465E+03,-3.0010E+03,-2.9561E+03,-2.9120E+03,-2.8685E+03,
     &  -2.8256E+03,-2.7834E+03,-2.7418E+03,-2.7008E+03,-2.6605E+03,
     &  -2.6207E+03,-2.5816E+03,-2.5430E+03,-2.5050E+03,-2.4676E+03,
     &  -2.4307E+03,-2.3944E+03,-2.3586E+03,-2.3234E+03,-2.2887E+03,
     &  -2.2545E+03,-2.2208E+03,-2.1876E+03,-2.1549E+03,-2.1227E+03,
     &  -2.0910E+03,-2.0598E+03,-2.0290E+03,-1.9987E+03,-1.9688E+03,
     &  -1.9394E+03,-1.9104E+03,-1.8819E+03,-1.8538E+03,-1.8261E+03,
     &  -1.7988E+03,-1.7719E+03,-1.7454E+03,-1.7193E+03,-1.6937E+03,
     &  -1.6683E+03,-1.6434E+03,-1.6189E+03,-1.5947E+03,-1.5709E+03,
     &  -1.5474E+03,-1.5243E+03,-1.5015E+03,-1.4791E+03,-1.4570E+03,
     &  -1.4352E+03,-1.4137E+03,-1.3926E+03,-1.3718E+03,-1.3513E+03,
     &  -1.3311E+03,-1.3112E+03,-1.2916E+03,-1.2723E+03,-1.2533E+03,
     &  -1.2346E+03,-1.2162E+03,-1.1980E+03,-1.1801E+03,-1.1625E+03,
     &  -1.1451E+03,-1.1280E+03,-1.1111E+03,-1.0945E+03,-1.0782E+03,
     &  -1.0621E+03,-1.0462E+03,-1.0306E+03,-1.0152E+03,-1.0000E+03/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=1,1) /
     &   1.1681E-01, 1.1663E-01, 1.1646E-01, 1.1628E-01, 1.1610E-01,
     &   1.1592E-01, 1.1574E-01, 1.1557E-01, 1.1539E-01, 1.1521E-01,
     &   1.1503E-01, 1.1485E-01, 1.1468E-01, 1.1450E-01, 1.1432E-01,
     &   1.1414E-01, 1.1397E-01, 1.1379E-01, 1.1361E-01, 1.1343E-01,
     &   1.1326E-01, 1.1308E-01, 1.1290E-01, 1.1272E-01, 1.1255E-01,
     &   1.1237E-01, 1.1219E-01, 1.1202E-01, 1.1184E-01, 1.1166E-01,
     &   1.1149E-01, 1.1131E-01, 1.1113E-01, 1.1096E-01, 1.1078E-01,
     &   1.1060E-01, 1.1043E-01, 1.1025E-01, 1.1008E-01, 1.0990E-01,
     &   1.0973E-01, 1.0955E-01, 1.0937E-01, 1.0920E-01, 1.0902E-01,
     &   1.0885E-01, 1.0867E-01, 1.0850E-01, 1.0832E-01, 1.0815E-01,
     &   1.0797E-01, 1.0780E-01, 1.0762E-01, 1.0745E-01, 1.0728E-01,
     &   1.0710E-01, 1.0693E-01, 1.0675E-01, 1.0658E-01, 1.0641E-01,
     &   1.0623E-01, 1.0606E-01, 1.0589E-01, 1.0571E-01, 1.0554E-01,
     &   1.0537E-01, 1.0520E-01, 1.0502E-01, 1.0485E-01, 1.0468E-01,
     &   1.0451E-01, 1.0433E-01, 1.0416E-01, 1.0399E-01, 1.0382E-01,
     &   1.0365E-01, 1.0348E-01, 1.0331E-01, 1.0314E-01, 1.0297E-01,
     &   1.0280E-01, 1.0263E-01, 1.0246E-01, 1.0229E-01, 1.0212E-01,
     &   1.0195E-01, 1.0178E-01, 1.0161E-01, 1.0144E-01, 1.0127E-01,
     &   1.0110E-01, 1.0094E-01, 1.0077E-01, 1.0060E-01, 1.0043E-01,
     &   1.0026E-01, 1.0010E-01, 9.9930E-02, 9.9763E-02, 9.9597E-02/
  
         DATA ((YGG  (I,J), I= 101, 200), J=1,1) /
     &   9.9431E-02, 9.9265E-02, 9.9099E-02, 9.8933E-02, 9.8768E-02,
     &   9.8602E-02, 9.8438E-02, 9.8273E-02, 9.8108E-02, 9.7944E-02,
     &   9.7780E-02, 9.7616E-02, 9.7452E-02, 9.7289E-02, 9.7126E-02,
     &   9.6963E-02, 9.6800E-02, 9.6638E-02, 9.6475E-02, 9.6313E-02,
     &   9.6152E-02, 9.5990E-02, 9.5829E-02, 9.5668E-02, 9.5507E-02,
     &   9.5346E-02, 9.5185E-02, 9.5025E-02, 9.4865E-02, 9.4705E-02,
     &   9.4546E-02, 9.4386E-02, 9.4227E-02, 9.4068E-02, 9.3909E-02,
     &   9.3751E-02, 9.3592E-02, 9.3434E-02, 9.3276E-02, 9.3118E-02,
     &   9.2961E-02, 9.2803E-02, 9.2646E-02, 9.2489E-02, 9.2332E-02,
     &   9.2175E-02, 9.2018E-02, 9.1862E-02, 9.1705E-02, 9.1549E-02,
     &   9.1393E-02, 9.1237E-02, 9.1081E-02, 9.0926E-02, 9.0770E-02,
     &   9.0614E-02, 9.0459E-02, 9.0304E-02, 9.0148E-02, 8.9993E-02,
     &   8.9838E-02, 8.9683E-02, 8.9528E-02, 8.9373E-02, 8.9218E-02,
     &   8.9063E-02, 8.8908E-02, 8.8753E-02, 8.8599E-02, 8.8444E-02,
     &   8.8289E-02, 8.8134E-02, 8.7979E-02, 8.7824E-02, 8.7669E-02,
     &   8.7514E-02, 8.7359E-02, 8.7203E-02, 8.7048E-02, 8.6893E-02,
     &   8.6737E-02, 8.6582E-02, 8.6426E-02, 8.6270E-02, 8.6114E-02,
     &   8.5958E-02, 8.5802E-02, 8.5646E-02, 8.5489E-02, 8.5332E-02,
     &   8.5176E-02, 8.5018E-02, 8.4861E-02, 8.4704E-02, 8.4546E-02,
     &   8.4388E-02, 8.4230E-02, 8.4072E-02, 8.3913E-02, 8.3755E-02/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=2,2) /
     &   3.2771E-04, 3.2771E-04, 3.2771E-04, 3.2771E-04, 3.2770E-04,
     &   3.2770E-04, 3.2770E-04, 3.2770E-04, 3.2770E-04, 3.2770E-04,
     &   3.2770E-04, 3.2770E-04, 3.2770E-04, 3.2770E-04, 3.2770E-04,
     &   3.2770E-04, 3.2770E-04, 3.2769E-04, 3.2769E-04, 3.2769E-04,
     &   3.2769E-04, 3.2769E-04, 3.2769E-04, 3.2769E-04, 3.2769E-04,
     &   3.2769E-04, 3.2769E-04, 3.2769E-04, 3.2769E-04, 3.2769E-04,
     &   3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2768E-04,
     &   3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2768E-04,
     &   3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2768E-04, 3.2767E-04,
     &   3.2767E-04, 3.2767E-04, 3.2767E-04, 3.2767E-04, 3.2767E-04,
     &   3.2767E-04, 3.2767E-04, 3.2767E-04, 3.2767E-04, 3.2767E-04,
     &   3.2767E-04, 3.2767E-04, 3.2766E-04, 3.2766E-04, 3.2766E-04,
     &   3.2766E-04, 3.2766E-04, 3.2766E-04, 3.2766E-04, 3.2766E-04,
     &   3.2766E-04, 3.2766E-04, 3.2766E-04, 3.2766E-04, 3.2765E-04,
     &   3.2765E-04, 3.2765E-04, 3.2765E-04, 3.2765E-04, 3.2765E-04,
     &   3.2765E-04, 3.2765E-04, 3.2765E-04, 3.2765E-04, 3.2765E-04,
     &   3.2765E-04, 3.2765E-04, 3.2764E-04, 3.2764E-04, 3.2764E-04,
     &   3.2764E-04, 3.2764E-04, 3.2764E-04, 3.2764E-04, 3.2764E-04,
     &   3.2764E-04, 3.2764E-04, 3.2764E-04, 3.2764E-04, 3.2764E-04,
     &   3.2763E-04, 3.2763E-04, 3.2763E-04, 3.2763E-04, 3.2763E-04/
  
         DATA ((YGG  (I,J), I= 101, 200), J=2,2) /
     &   3.2763E-04, 3.2763E-04, 3.2763E-04, 3.2763E-04, 3.2763E-04,
     &   3.2763E-04, 3.2763E-04, 3.2762E-04, 3.2762E-04, 3.2762E-04,
     &   3.2762E-04, 3.2762E-04, 3.2762E-04, 3.2762E-04, 3.2762E-04,
     &   3.2762E-04, 3.2762E-04, 3.2762E-04, 3.2762E-04, 3.2761E-04,
     &   3.2761E-04, 3.2761E-04, 3.2761E-04, 3.2761E-04, 3.2761E-04,
     &   3.2761E-04, 3.2761E-04, 3.2761E-04, 3.2761E-04, 3.2761E-04,
     &   3.2761E-04, 3.2761E-04, 3.2760E-04, 3.2760E-04, 3.2760E-04,
     &   3.2760E-04, 3.2760E-04, 3.2760E-04, 3.2760E-04, 3.2760E-04,
     &   3.2760E-04, 3.2760E-04, 3.2760E-04, 3.2760E-04, 3.2759E-04,
     &   3.2759E-04, 3.2759E-04, 3.2759E-04, 3.2759E-04, 3.2759E-04,
     &   3.2759E-04, 3.2759E-04, 3.2759E-04, 3.2759E-04, 3.2759E-04,
     &   3.2759E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04,
     &   3.2758E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04, 3.2758E-04,
     &   3.2758E-04, 3.2758E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04,
     &   3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2757E-04,
     &   3.2757E-04, 3.2757E-04, 3.2757E-04, 3.2756E-04, 3.2756E-04,
     &   3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04,
     &   3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2756E-04, 3.2755E-04,
     &   3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04,
     &   3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2755E-04, 3.2754E-04/
  
      save
      RETURN
      END
