*
* Bardin-Chizov QCD-library
* 
      FUNCTION RXQCDS(ALST,AMZ2,AMW2,AMT2)
* 
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
      DATA D2/1.6449340668482D0/
*
* WITHOUT FACTOR ALPI/4/PI
*
      QTM =2D0/3D0
      CW2 =AMW2/AMZ2
      SW2 =1D0-CW2
      VT2 =(1D0-4*QTM*SW2)**2
      ALTW=-AMT2/AMW2
      ALTZ=-AMT2/AMZ2
      PVFBW=ALTW*DREAL(XPVF0(ALTW))
      PVFBZ=ALTZ*DREAL(XPVF0(ALTZ))
      PVFTW=ALTW*DREAL(XPVFI(ALTW))
      PVFTZ=ALTZ*DREAL(XPVFI(ALTZ))
      PAFTZ=ALTZ*DREAL(XPAFI(ALTZ))
      PWFTW=ALTW*DREAL(XPWFI(ALTW))
      PWF0  =-3D0*D2-105D0/8D0
*
      RXQCDT=ALST/3D0/PI/SW2*(4D0*SW2*QTM**2*(PVFTZ-PVFBZ)
     &      -1D0/4D0/SW2*(VT2*(PVFTZ-PVFBZ)+PAFTZ-PVFBZ)
     &      +(CW2-SW2)/SW2*(PWFTW-PVFBW)-AMT2/AMW2*PWF0)
      RXQCDB=ALST/PI/SW2**2*(CW2-SW2)*LOG(AMZ2/AMW2)
      RXQCDS=RXQCDT+RXQCDB
*
      END
 
      FUNCTION RXQCD(ALST,AMZ2,AMW2,AMT2)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
      DATA D2/1.6449340668482D0/
      DATA EPS/1D-4/
*
* WITHOUT FACTOR ALPI/4/PI
*
      QTM =2D0/3D0
      CW2 =AMW2/AMZ2
      SW2 =1D0-CW2
      VT2 =(1D0-4*QTM*SW2)**2
      ALTW=-AMT2/AMW2
      ALTZ=-AMT2/AMZ2
      PVFBW=ALTW*DREAL(XPVF0(ALTW))
      PVFBZ=ALTZ*DREAL(XPVF0(ALTZ))
      PVFTW=ALTW*DREAL(XPVF (ALTW))
      PVFTZ=ALTZ*DREAL(XPVF (ALTZ))
      PAFTZ=ALTZ*DREAL(XPAF (ALTZ))
      PWFTW=ALTW*DREAL(XPWF (ALTW))
      PWF0  =-3D0*D2-105D0/8D0
*
      RXQCDT=ALST/3D0/PI/SW2*(4D0*SW2*QTM**2*(PVFTZ-PVFBZ)
     &      -1D0/4D0/SW2*(VT2*(PVFTZ-PVFBZ)+PAFTZ-PVFBZ)
     &      +(CW2-SW2)/SW2*(PWFTW-PVFBW)-AMT2/AMW2*PWF0)
      RXQCDB=ALST/PI/SW2**2*(CW2-SW2)*LOG(AMZ2/AMW2)
      RXQCD =RXQCDT+RXQCDB
*
      END
 
      FUNCTION ALQCDS(ALST,AMZ2,AMW2,AMT2)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
*
* WITHOUT FACTOR ALPI/4/PI
*
      QTM =2D0/3D0
      CW2 =AMW2/AMZ2
      SW2 =1D0-CW2
      ALTZ=-AMT2/AMZ2
      PVFTZ=ALTZ*DREAL(XPVFI(ALTZ))
      ALQCDS=-ALST/3D0/PI/SW2*(4D0*SW2*QTM**2*(PVFTZ-45D0/4D0))
*
      END
 
      FUNCTION ALQCD(ALST,AMZ2,AMW2,AMT2)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
*
* WITHOUT FACTOR ALPI/4/PI
*
      QTM =2D0/3D0
      CW2 =AMW2/AMZ2
      SW2 =1D0-CW2
      ALTZ=-AMT2/AMZ2
      PVFTZ=ALTZ*DREAL(XPVF(ALTZ))
      ALQCD=-ALST/3D0/PI/SW2*(4D0*SW2*QTM**2*(PVFTZ-45D0/4D0))
*
      END
 
      FUNCTION XKQCDS(ALST,AMZ2,AMW2,AMT2,S)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
*
* CALPI/4 IS OMITTED
*
      QTM=2D0/3D0
      QBM=1D0/3D0
      CW2=AMW2/AMZ2
      SW2=1D0-CW2
      VT =1D0-4D0*QTM*SW2
      VB =1D0-4D0*QBM*SW2
*
      ALTW=-AMT2/AMW2
      ALTZ=-AMT2/AMZ2
      ALTS=-AMT2/S
      XPVFBS=ALTS*XPVF0(ALTS)
      XPVFTS=ALTS*XPVFI(ALTS)
      XPVFBZ=ALTZ*XPVF0(ALTZ)
      XPVFTZ=ALTZ*XPVFI(ALTZ)
      XPAFTZ=ALTZ*XPAFI(ALTZ)
      XPWFW =ALTW*XPWF (ALTW)
*
      XKQCDS=ALST/(3D0*PI*SW2)*(1D0/4D0/SW2*((VB**2+1D0)*XPVFBZ
     *      +VT**2*XPVFTZ+XPAFTZ)-CW2/SW2*XPWFW+VB*QBM*XPVFBS
     *      +VT*QTM*XPVFTS)
*
      END
 
      FUNCTION XKAQCD(ALST,AMZ2,AMW2,AMT2,S)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
*
* CALPI/4 IS OMITTED
*
      QTM=2D0/3D0
      QBM=1D0/3D0
      CW2=AMW2/AMZ2
      SW2=1D0-CW2
      VT =1D0-4D0*QTM*SW2
      VB =1D0-4D0*QBM*SW2
*
      ALTW=-AMT2/AMW2
      ALTZ=-AMT2/AMZ2
      ALTS=-AMT2/S
      XPVFBS=ALTS*XPVF0(ALTS)
      XPVFTS=ALTS*XPVF (ALTS)
      XPVFBZ=ALTZ*XPVF0(ALTZ)
      XPVFTZ=ALTZ*XPVF (ALTZ)
      XPAFTZ=ALTZ*XPAF (ALTZ)
      XPWFW =ALTW*XPWF (ALTW)
*
      XKAQCD=ALST/(3D0*PI*SW2)*(1D0/4D0/SW2*((VB**2+1D0)*XPVFBZ
     *      +VT**2*XPVFTZ+XPAFTZ)-CW2/SW2*XPWFW+VB*QBM*XPVFBS
     *      +VT*QTM*XPVFTS)
*
      END
*
      FUNCTION XRQCDS(ALSZ,ALST,AMZ2,AMW2,AMT2,S)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
      DATA D2/1.6449340668482D0/
      DATA EPS/1D-3/
*
* CALPI/4 IS OMITTED
*
      QTM=2D0/3D0
      QBM=1D0/3D0
      CW2=AMW2/AMZ2
      SW2=1D0-CW2
      VT =1D0-4D0*QTM*SW2
      VB =1D0-4D0*QBM*SW2
      VT2=VT**2
      VB2=VB**2
*
      ALTZ=-AMT2/AMZ2
      ALTS=-AMT2/S
      SMZ2=S/AMZ2
      DMZ2=1.D0-SMZ2
      XPVFTS=XPVFI(ALTS)
      XPVFTZ=XPVFI(ALTZ)
      XPAFTS=XPAFI(ALTS)
      XPAFTZ=XPAFI(ALTZ)
*
      IF(ABS(DMZ2).LT.EPS) THEN
        XDVFTZ=XDPVFI(ALTZ)
        XDAFTZ=XDPAFI(ALTZ)                                                   
        XRQCDS=ALSZ/(3D0*PI*SW2)*(3D0/2D0/CW2*(2D0+VT2+VB2))
     *                   +ALST/(3D0*PI*SW2)*(3D0/4D0/CW2*(1D0+VB2)
     *                   +AMT2/4D0/AMW2*(VT2*(XDVFTZ/ALTZ-XPVFTZ)
     *                   +XDAFTZ/ALTZ-XPAFTZ)
     *                   -AMT2/AMW2*(3D0*D2+105D0/8D0))
      ELSE
        XRQCDS=
     *    +ALSZ/(3D0*PI*SW2)*(-S*3D0/2D0/AMW2*(VT2+VB2+2D0)*RFL(SMZ2))      
     *    +ALST/(3D0*PI*SW2)*(-S*3D0/4D0/AMW2*(VB2+1D0)*RFL(SMZ2)
     *                   +AMT2/4D0/AMW2*(1D0/DMZ2*(VT2*(XPVFTZ-XPVFTS)
     *                   +XPAFTZ-XPAFTS)-(VT2*XPVFTZ+XPAFTZ))
     *                   -AMT2/AMW2*(3D0*D2+105D0/8D0))
      ENDIF
*
      END
 
      FUNCTION XROQCD(ALSZ,ALST,AMZ2,AMW2,AMT2,S)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA PI/3.1415926535898D0/
      DATA D2/1.6449340668482D0/
      DATA EPS/1D-3/
*
* CALPI/4 IS OMITTED
*
      QTM=2D0/3D0
      QBM=1D0/3D0
      CW2=AMW2/AMZ2
      SW2=1D0-CW2
      VT =1D0-4D0*QTM*SW2
      VB =1D0-4D0*QBM*SW2
      VT2=VT**2
      VB2=VB**2
*
      ALTZ=-AMT2/AMZ2
      ALTS=-AMT2/S
      SMZ2=S/AMZ2
      DMZ2=1.D0-SMZ2
      XPVFTS=XPVF(ALTS)
      XPVFTZ=XPVF(ALTZ)
      XPAFTS=XPAF(ALTS)
      XPAFTZ=XPAF(ALTZ)
*
      IF(ABS(DMZ2).LT.EPS) THEN
        XDVFTZ=XDPVF(ALTZ)
        XDAFTZ=XDPAF(ALTZ)
        XROQCD=ALSZ/(3D0*PI*SW2)*(3D0/2D0/CW2*(VT2+VB2+2D0))
     *        +ALST/(3D0*PI*SW2)*(3D0/4D0/CW2*(VB2+1D0)
     *                   +AMT2/4D0/AMW2*(VT2*(XDVFTZ/ALTZ-XPVFTZ)
     *                   +XDAFTZ/ALTZ-XPAFTZ)
     *                   -AMT2/AMW2*(3D0*D2+105D0/8D0))
      ELSE
        XROQCD=
     *    +ALSZ/(3D0*PI*SW2)*(-S*3D0/2D0/AMW2*(VT2+VB2+2D0)*RFL(SMZ2))
     *    +ALST/(3D0*PI*SW2)*(-S*3D0/4D0/AMW2*(VB2+1D0)*RFL(SMZ2)
     *                   +AMT2/4D0/AMW2*(1D0/DMZ2*(VT2*(XPVFTZ-XPVFTS)
     *                   +XPAFTZ-XPAFTS)-(VT2*XPVFTZ+XPAFTZ))
     *                   -AMT2/AMW2*(3D0*D2+105D0/8D0))
      ENDIF
*
      END
*
* Library of polarization operators and their auxiliary functions 
*
      FUNCTION XPVF0(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D3/1.2020569031596D0/
*
      XPVF0=(55.D0/4.D0-12.D0*D3+3.D0*DCMPLX(LOG(ABS(AL)),0.D0))/AL
*
      END
 
      FUNCTION PVF0G(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D3/1.2020569031596D0/
*
      PVF0G=(55D0/4D0-12D0*D3)/AL
*
      END
 
      FUNCTION XPVFI(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      RPVFI=45.D0/4.D0/AL-82.D0/27.D0/AL**2+449.D0/900.D0/AL**3
     *     -62479.D0/661500.D0/AL**4
      XPVFI=DCMPLX(RPVFI,.0D0)
*
      END
 
      FUNCTION XPVF(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*  
      DATA EPS/2.D-3/
      DATA D3/1.2020569031596D0/
*
      F1=6.*D3
      ASQ=1.D0+4.D0*AL
      IF(ASQ.GE.0.D0) XSQ=DCMPLX(SQRT(ASQ),0.D0)
      IF(ASQ.LT.0.D0) XSQ=DCMPLX(0.D0,SQRT(ABS(ASQ)))
      XD=1.D0+2.D0*AL+XSQ
      XA=2.D0*AL/XD
      XFLXA=XFL(XA)
      XA2=XA**2
      ALI=ABS(1.D0/AL)
      IF(ALI.GT.EPS) GO TO 2
1     XGIN1=XGS1(XA)
      XGIN2=XGS1(XA2)
      XFIN1=XFS1(XA)
      XFIN2=XFS1(XA2)
      GO TO 3
2     XGIN1=XGIN(XA)
      XGIN2=XGIN(XA2)
      XFIN1=XFIN(XA)
      XFIN2=XFIN(XA2)
3     XIA=F1+XFIN2-2.D0*XFIN1
      IF(ASQ.EQ.0.D0) XJA=0.D0
      IF(ASQ.NE.0.D0) XJA=(1.D0-XA)/(1.D0+XA)/AL*(XGIN2-XGIN1)
      XPV=55.D0/4.D0-26.D0*AL+3.D0*(1.D0+XA)*((1.D0-6.D0*AL)*XFLXA)
      XPV=XPV
     *   -2.D0*(AL*(2.D0*XA2-3.D0*XA+2.D0)+2.D0*XA)*(XFLXA*XFLXA)
      XPV=XPV
     *   +2.D0*(4.D0*AL**2-1.D0)*XIA+4.D0*AL*(2.D0*AL-1.D0)
     *   *(4.D0*AL+1.D0)*XJA
      XPVF=XPV/AL
*   
      END
 
      FUNCTION XDPVFI(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      RDPVFI=45.D0/4.D0-164.D0/27.D0/AL+449.D0/300.D0/AL**2
     *      -62479.D0/165375.D0/AL**3+9.55063D-2/AL**4
      XDPVFI=DCMPLX(RDPVFI,.0D0)
*
      END
 
      FUNCTION XDPVF(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D3/1.2020569031596D0/
      DATA EPS/2.D-3/
*
      F1=6.D0*D3
      ASQ=1.D0+4.D0*AL
      IF(ASQ.GE.0.D0) XSQ=DCMPLX(SQRT(ASQ),0.D0)
      IF(ASQ.LT.0.D0) XSQ=DCMPLX(0.D0,SQRT(ABS(ASQ)))
      XD=1.D0+2.D0*AL+XSQ
      XA=2.D0*AL/XD
      XFLXA=XFL(XA)
      XA2=XA**2
      XFLXA2=(XFL(XA2))**2
      ALI=ABS(1.D0/AL)
      IF(ALI-EPS)1,1,2
1     XGIN1=XGS1(XA)
      XGIN2=XGS1(XA2)
      XFIN1=XFS1(XA)
      XFIN2=XFS1(XA2)
      GO TO 3
2     XGIN1=XGIN(XA)
      XGIN2=XGIN(XA2)
      XFIN1=XFIN(XA)
      XFIN2=XFIN(XA2)
3     XIA=F1+XFIN2-2.D0*XFIN1
      IF(ASQ.EQ.0.D0) XJA=0.D0
      IF(ASQ.NE.0.D0) XJA=(1.D0-XA)/(1.D0+XA)/AL*(XGIN2-XGIN1)
      XDPVF=43.D0/4.D0+18.D0*AL+(1.D0+XA)*(3.D0+10.D0*AL)*XFLXA
     *     -2.D0*XA*(2.D0-5.D0*AL)*XFLXA**2
     *     +8.D0*XA2*(1.D0-2.D0*AL)*XFLXA2
      XDPVF=XDPVF
     *     -2.D0*(4.D0*AL**2+1.D0)*XIA-8.D0*AL**2*(4.D0*AL+1.D0)*XJA
*  
      END
 
      FUNCTION XPAFI(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      RPAFI=-93.D0/2.D0+67.D0/12.D0/AL-689.D0/540.D0/AL**2
     *     +1691.D0/12600.D0/AL**3-1.8599D-2/AL**4
      XPAFI=DCMPLX(RPAFI,.0D0)
*
      END
 
      FUNCTION XPAF(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D3/1.2020569031596D0/
      DATA EPS/2.D-3/
*
      F1=6.D0*D3
      ASQ=1.D0+4.D0*AL
      IF(ASQ.GE.0.D0) XSQ=DCMPLX(SQRT(ASQ),0.D0)
      IF(ASQ.LT.0.D0) XSQ=DCMPLX(0.D0,SQRT(ABS(ASQ)))
      XD=1.D0+2.D0*AL+XSQ
      XA=2.D0*AL/XD
      XFLXA=XFL(XA)
      XA2=XA**2
      ALI=ABS(1.D0/AL)
      IF(ALI-EPS)1,1,2
1     XGIN1=XGS1(XA)
      XGIN2=XGS1(XA2)
      XFIN1=XFS1(XA)
      XFIN2=XFS1(XA2)
      GO TO 3
2     XGIN1=XGIN(XA)
      XGIN2=XGIN(XA2)
      XFIN1=XFIN(XA)
      XFIN2=XFIN(XA2)
3     XIA=F1+XFIN2-2.D0*XFIN1
      IF(ASQ.EQ.0.D0) XJA=0.D0
      IF(ASQ.NE.0.D0) XJA=(1.D0-XA)/(1.D0+XA)/AL*(XGIN2-XGIN1)
      XPA=55.D0/4.D0-19.D0/2.D0*AL+12.D0*AL**2
     *   +3.D0*(1.D0+XA)*(1.D0+12.D0*AL+4.D0*AL**2)*XFLXA
     *   +2.D0*(2.D0*XA*(3.D0*AL**2-1.D0)
     *   +AL*(7.D0*XA2-3.D0*XA+7.D0))*XFLXA**2
      XPA=XPA
     *   -2.D0*(1.D0+2.D0*AL)*(1.D0+4.D0*AL)*XIA
     *   -4.D0*AL*(4.D0*AL+1.D0)**2*XJA
      XPAF=XPA/AL
*
      END
 
      FUNCTION XDPAFI(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      RDPAFI=67.D0/12.D0-689.D0/270.D0/AL+1691.D0/4200.D0/AL**2
     *      -7.43961D-2/AL**3+275205680132.D0/18606865047887.D0/AL**4
      XDPAFI=DCMPLX(RDPAFI,.0D0)
*
      END
 
      FUNCTION XDPAF(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D3/1.2020569031596D0/
      DATA EPS/2.D-3/
*
      F1=6.D0*D3
      ASQ=1.D0+4.D0*AL
      IF(ASQ.GE.0.D0) XSQ=DCMPLX(SQRT(ASQ),0.D0)
      IF(ASQ.LT.0.D0) XSQ=DCMPLX(0.D0,SQRT(ABS(ASQ)))
      XD=1.D0+2.D0*AL+XSQ
      XA=2.D0*AL/XD
      XFLXA=XFL(XA)
      XA2=XA**2
      XFLXA2=(XFL(XA2))**2
      ALI=ABS(1.D0/AL)
      IF(ALI-EPS)1,1,2
1     XGIN1=XGS1(XA)
      XGIN2=XGS1(XA2)
      XFIN1=XFS1(XA)
      XFIN2=XFS1(XA2)
      GO TO 3
2     XGIN1=XGIN(XA)
      XGIN2=XGIN(XA2)
      XFIN1=XFIN(XA)
      XFIN2=XFIN(XA2)
3     XIA=F1+XFIN2-2.D0*XFIN1
      IF(ASQ.EQ.0.D0) XJA=0.D0
      IF(ASQ.NE.0.D0) XJA=(1.D0-XA)/(1.D0+XA)/AL*(XGIN2-XGIN1)
      XDPAF=43.D0/4.D0-12.D0*AL*(3.D0+2.D0*AL)
     *     +(1.D0+XA)*(3.D0-26.D0*AL-24.D0*AL**2)*XFLXA
      XDPAF=XDPAF
     *     -2.D0*XA*(2.D0+19.D0*AL+12.D0*AL**2)*XFLXA**2
     *     +8.D0*XA2*(1.D0+4.D0*AL)*XFLXA2
     *     -2.D0*(1.D0-8.D0*AL**2)*XIA+16.D0*AL**2*(4.D0*AL+1.D0)*XJA
*
      END
 
      FUNCTION XPWFI(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D2/1.6449340668482D0/
      DATA D3/1.2020569031596D0/
*
      F1=6.D0*D3
      G1=2.D0*D2
      RPWFI=-105.D0/8.D0-3.D0/2.D0*G1+(115.D0/12.D0-2.D0/3.D0*G1)/AL
     *     +(-25.D0/16.D0-3.D0/4.D0)/AL**2
      XPWFI=DCMPLX(RPWFI,.0D0)
*
      END
 
      FUNCTION XPWF(AL)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D2/1.6449340668482D0/
      DATA D3/1.2020569031596D0/
      DATA EPS/2.D-3/
*
      F1=6.D0*D3
      G1=2.D0*D2
      IF(AL.EQ.-1.D0) GO TO 10
      XB=DCMPLX(AL/(1.D0+AL),.0D0)
      IF(AL.GE.-1.D0) XB=DCMPLX(AL/(1.D0+AL),EPS**2)
      XFLXB=XFL(XB)
      ALI=ABS(1.D0/AL)
      IF(ALI-EPS)1,1,2
1     XGIN1=XGS1(XB)
      XFIN1=XFS1(XB)
      GO TO 3
2     XGIN1=XGIN(XB)
      XFIN1=XFIN(XB)
3     XIB=F1-XFIN1
      XJB=-1.D0/2.D0/AL*XGIN1
      XPW=55.D0/4.D0-71.D0/8.D0*AL-5.D0/2.D0*AL**2-2.D0*AL*XGIN1
     *   +0.5D0*(6.D0+9.D0*AL-5.D0*AL**2)*XFLXB
     *   +0.5D0*(4.D0*XB*(AL**2-AL-1.D0)+AL*(5.D0-4.D0*AL))*XFLXB**2
      XPW=XPW
     *   +(AL-2.D0)*(AL+1.D0)**2*XIB+2.D0*AL*(AL-2.D0)*(AL+1.D0)*XJB
      XPWF=XPW/AL
      GOTO 99
10    XPWF=DCMPLX(-161.D0/8.D0-4.D0*G1,.0D0)
 99   CONTINUE
*
      END
 
      FUNCTION XFL(X)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
      DATA EPS/1.D-3/
*
      X1=1.D0-X
      AB=CDABS(X1)
      IF(AB.LT.EPS) GO TO 1
      XFL=LOG(X)/X1
      RETURN
1     XFL=-(1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)
*
      END
 
      FUNCTION RFL(X)
*
      IMPLICIT REAL*8(A-H,O-X)
*
      DATA EPS/1.D-3/
*
      X1=1.D0-X
      AB=ABS(X1)
      IF(AB.LT.EPS) GO TO 1
      RFL=LOG(X)/X1
      RETURN
1     RFL=-(1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)
*
      END
 
      FUNCTION XGS1(X)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D2/1.6449340668482D0/
*
      X1=X-1.D0
      G1=2.D0*D2
      XGS1=G1+X1-1.D0/2.D0*X1**2+11.D0/36.D0*X1**3
     *    -5.D0/24.D0*X1**4+137.D0/900.D0*X1**5-7.D0/60.D0*X1**6
*
      END
 
      FUNCTION XGIN(X)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      EXTERNAL RGIN,AGIN
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1D-4/
      DATA EPSL/1D-14/
*
      XC=X
      CALL SIMPU(EPSL,1D0,.25D0,EPS,1D-30,RGIN,AR,RG,R2,R3)
      CALL SIMPU(EPSL,1D0,.25D0,EPS,1D-30,AGIN,AR,AG,R2,R3)
      XGIN=X*DCMPLX(RG,AG)
*
      END
 
      FUNCTION RGIN(T)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1.D-3/
*
      X=XC
      X1=1.D0-T*X
      AB=CDABS(X1)
      IF(AB.LT.EPS) GO TO 1
      RGIN=DREAL((LOG(T*X)/X1)**2)
      RETURN
1     RGIN=DREAL((1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)**2)
*
      END
 
      FUNCTION AGIN(T)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1.D-3/
*
      X=XC
      X1=1.D0-T*X
      AB=CDABS(X1)
      IF(AB.LT.EPS) GO TO 1
      AGIN=DIMAG((LOG(T*X)/X1)**2)
      RETURN
1     AGIN=DIMAG((1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)**2)
*
      END
 
      FUNCTION XFS1(X)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      DATA D2/1.6449340668482D0/
      DATA D3/1.2020569031596D0/
*
      F1=6.D0*D3
      G1=2.D0*D2
      X1=X-1.D0
      XFS1=F1+G1*X1+(1.D0-G1)/2.D0*X1**2+(2.D0*G1-3.D0)/6.D0*X1**3
     *    +(65.D0-36.D0*G1)/144.D0*X1**4+(G1/5.D0-29.D0/72.D0)*X1**5
     *    +(3899.D0/1800.D0/6.D0-G1/6.D0)*X1**6
*
      END
 
      FUNCTION XFIN(X)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      EXTERNAL RFIN,AFIN
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1D-4/
      DATA EPSL/1D-14/
*
      XC=X
      CALL SIMPU(EPSL,1D0,.25D0,EPS,1D-30,RFIN,AR,RF,R2,R3)
      CALL SIMPU(EPSL,1D0,.25D0,EPS,1D-30,AFIN,AR,AF,R2,R3)
      XFIN=X*DCMPLX(RF,AF)
*
      END
 
      FUNCTION RFIN(T)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1.D-3/
*
      X=XC
      X1=1.D0-T*X
      AB=CDABS(X1)
      IF(AB.LT.EPS) GO TO 1
      RFIN=-DREAL((LOG(T*X)/X1)**2)*LOG(T)
      RETURN
1     RFIN=-DREAL((1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)**2)
     *    *LOG(T)
*
      END
 
      FUNCTION AFIN(T)
*
      IMPLICIT REAL*8(A-H,O-W,Y-Z)
      IMPLICIT COMPLEX*16(X)
*
      COMMON/CDZTMP/CDZT(5),ICDZ
      EQUIVALENCE (CDZT(1),XC)
*
      DATA EPS/1.D-3/
*
      X=XC
      X1=1.D0-T*X
      AB=CDABS(X1)
      IF(AB.LT.EPS) GO TO 1
      AFIN=-DIMAG((LOG(T*X)/X1)**2)*LOG(T)
      RETURN
1     AFIN=-DIMAG((1.D0+X1/2.D0+X1**2/3.D0+X1**3/4.D0+X1**4/5.D0)**2)
     *    *LOG(T)
*
      END
